/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.MethodSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.CallinCalloutScope;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.RoleTypeCreator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class FieldAccessSpec
extends MethodSpec
implements InvocationSite {
    public int calloutModifier;
    public FieldBinding resolvedField;
    private TypeBinding fieldType;

    public FieldAccessSpec(char[] name, long nameSourcePositions, boolean isSetter) {
        super(name, nameSourcePositions);
        this.calloutModifier = isSetter ? 123 : 122;
    }

    public FieldAccessSpec(MethodSpec other, int calloutModifier) {
        super(other.selector, other.sourceStart, other.sourceEnd);
        this.returnType = other.returnType;
        this.calloutModifier = calloutModifier;
    }

    public FieldAccessSpec(char[] name, TypeReference type, long nameSourcePositions, int calloutModifier) {
        super(name, nameSourcePositions);
        this.calloutModifier = calloutModifier;
        if (calloutModifier == 123) {
            this.arguments = new Argument[]{new Argument(name, nameSourcePositions, type, 0)};
            this.returnType = TypeReference.baseTypeReference(6, 0);
            this.returnType.sourceStart = this.sourceStart;
            this.returnType.sourceEnd = this.sourceEnd;
        } else {
            this.returnType = type;
        }
    }

    public FieldAccessSpec(char[] name, TypeReference type, long nameSourcePositions, boolean isSetter) {
        this(name, type, nameSourcePositions, isSetter ? 123 : 122);
    }

    public void resolveFeature(ReferenceBinding baseType, BlockScope scope, boolean callinExpected, boolean isBaseSide, boolean allowEnclosing) {
        this.resolvedField = TypeAnalyzer.findField(baseType, this.selector, false, false);
        if (this.resolvedField == null) {
            this.resolvedField = new ProblemFieldBinding(baseType, this.selector, 1);
        }
        if (!this.resolvedField.isValidBinding()) {
            return;
        }
        this.fieldType = this.resolvedType();
        TypeBinding fieldLeafType = this.fieldType.leafComponentType();
        if (fieldLeafType instanceof ReferenceBinding && ((ReferenceBinding)fieldLeafType).isRole()) {
            ITeamAnchor newAnchor = null;
            if (baseType instanceof RoleTypeBinding) {
                RoleTypeBinding fieldRole;
                RoleTypeBinding baseRole = (RoleTypeBinding)baseType;
                newAnchor = fieldLeafType instanceof RoleTypeBinding ? ((fieldRole = (RoleTypeBinding)fieldLeafType).hasExplicitAnchor() ? fieldRole._teamAnchor.setPathPrefix(baseRole._teamAnchor) : baseRole._teamAnchor) : baseRole._teamAnchor;
            } else if (baseType.isTeam()) {
                SourceTypeBinding enclRole = scope.enclosingSourceType();
                newAnchor = TypeAnalyzer.findField(enclRole, IOTConstants._OT_BASE, false, false);
            }
            if (newAnchor != null && newAnchor.isValidBinding()) {
                this.fieldType = newAnchor.getRoleTypeBinding((ReferenceBinding)fieldLeafType, this.resolvedType().dimensions());
            }
        }
        char[] accessorSelector = this.getSelector();
        MethodBinding result = null;
        if (!this.resolvedField.isPrivate()) {
            result = baseType.getMethod(scope, accessorSelector);
        }
        if (result == null || !this.isMethodCompatible(result)) {
            RoleModel roleModel = scope.enclosingSourceType().roleModel;
            ReferenceBinding targetClass = roleModel.addAccessedBaseField(this.resolvedField, this.calloutModifier);
            result = this.createMethod(targetClass, accessorSelector);
            baseType.addMethod(result);
        }
        this.selector = accessorSelector;
        this.resolvedMethod = result;
        this.parameters = this.resolvedMethod.getSourceParameters();
    }

    private boolean isMethodCompatible(MethodBinding result) {
        TypeBinding methodType = null;
        switch (this.calloutModifier) {
            case 122: {
                methodType = result.returnType;
                break;
            }
            case 123: {
                int valueArgPosition;
                int n = valueArgPosition = this.resolvedField.isStatic() ? 0 : 1;
                if (result.parameters.length <= valueArgPosition) {
                    return false;
                }
                methodType = result.parameters[valueArgPosition];
            }
        }
        return this.fieldType.isCompatibleWith(methodType);
    }

    private char[] getSelector() {
        if (this.calloutModifier == 122) {
            return CharOperation.concat(IOTConstants.OT_GETFIELD, this.selector);
        }
        return CharOperation.concat(IOTConstants.OT_SETFIELD, this.selector);
    }

    private MethodBinding createMethod(ReferenceBinding baseType, char[] accessorSelector) {
        TypeBinding[] typeBindingArray;
        TypeBinding declaredFieldType;
        if (baseType instanceof RoleTypeBinding) {
            baseType = baseType.getRealClass();
        }
        if (this.calloutModifier == 122) {
            return FieldAccessSpec.createGetAccessorBinding(baseType, this.resolvedField);
        }
        TypeBinding typeBinding = declaredFieldType = this.hasSignature ? this.parameters[0] : this.fieldType;
        if (this.resolvedField.isStatic()) {
            TypeBinding[] typeBindingArray2 = new TypeBinding[1];
            typeBindingArray = typeBindingArray2;
            typeBindingArray2[0] = declaredFieldType;
        } else {
            TypeBinding[] typeBindingArray3 = new TypeBinding[2];
            typeBindingArray3[0] = baseType;
            typeBindingArray = typeBindingArray3;
            typeBindingArray3[1] = declaredFieldType;
        }
        TypeBinding[] argTypes = typeBindingArray;
        return new MethodBinding(9, accessorSelector, TypeBinding.VOID, argTypes, Binding.NO_EXCEPTIONS, baseType);
    }

    public static MethodBinding createGetAccessorBinding(ReferenceBinding baseType, FieldBinding resolvedField) {
        TypeBinding[] typeBindingArray;
        if (resolvedField.isStatic()) {
            typeBindingArray = new TypeBinding[]{};
        } else {
            TypeBinding[] typeBindingArray2 = new TypeBinding[1];
            typeBindingArray = typeBindingArray2;
            typeBindingArray2[0] = baseType;
        }
        TypeBinding[] argTypes = typeBindingArray;
        MethodBinding result = new MethodBinding(9, CharOperation.concat(IOTConstants.OT_GETFIELD, resolvedField.name), resolvedField.type, argTypes, Binding.NO_EXCEPTIONS, baseType);
        MethodModel.getModel((MethodBinding)result)._fakeKind = MethodModel.FakeKind.BASE_FIELD_ACCESSOR;
        return result;
    }

    public TypeBinding resolvedType() {
        if (this.fieldType != null) {
            return this.fieldType;
        }
        return this.resolvedField.type;
    }

    public TypeReference declaredType() {
        if (!this.hasSignature) {
            return null;
        }
        if (this.isSetter()) {
            return this.arguments[0].type;
        }
        return this.returnType;
    }

    public TypeBinding[] resolvedParameters() {
        TypeBinding[] methodParams = super.resolvedParameters();
        if (this.resolvedField.isStatic()) {
            return methodParams;
        }
        TypeBinding[] result = new TypeBinding[methodParams.length - 1];
        System.arraycopy(methodParams, 1, result, 0, result.length);
        return result;
    }

    public ReferenceBinding getDeclaringClass() {
        if (this.resolvedField != null) {
            return this.resolvedField.declaringClass;
        }
        return null;
    }

    public void checkResolutionSuccess(ReferenceBinding type, CallinCalloutScope scope) {
        if (this.resolvedField == null) {
            this.resolvedField = new ProblemFieldBinding(type, this.selector, 1);
        } else if (this.resolvedField.isValidBinding()) {
            return;
        }
        scope.problemReporter().boundMethodProblem(this, type, true);
    }

    void checkDecapsulation(ReferenceBinding baseClass, Scope scope) {
        if (!this.resolvedField.canBeSeenBy(baseClass = baseClass.getRealClass(), this, scope)) {
            scope.problemReporter().decapsulation(this, baseClass, scope);
        }
    }

    public boolean checkBaseReturnType(CallinCalloutScope scope, int bindDir) {
        TypeBinding accessorReturnType;
        TypeBinding typeBinding = accessorReturnType = this.calloutModifier == 122 ? this.resolvedType() : TypeBinding.VOID;
        if (!TypeAnalyzer.isSameType(scope.enclosingSourceType(), accessorReturnType, this.resolvedMethod.returnType)) {
            if (RoleTypeCreator.isCompatibleViaBaseAnchor(scope, accessorReturnType, this.returnType.resolvedType, bindDir)) {
                return true;
            }
            scope.problemReporter().differentTypeInFieldSpec(this);
            return false;
        }
        return true;
    }

    public boolean checkParameterTypes(CallinCalloutScope scope, boolean isBase) {
        if (this.calloutModifier == 122) {
            return true;
        }
        int argumentPosition = 0;
        if (this.resolvedField != null && !this.resolvedField.isStatic()) {
            argumentPosition = 1;
        }
        TypeBinding accessorParamType = this.resolvedMethod.parameters[argumentPosition];
        ReferenceBinding baseclass = scope.enclosingReceiverType().baseclass();
        if (baseclass != null && baseclass.isTeam() && accessorParamType.isRole()) {
            accessorParamType = TeamModel.strengthenRoleType(baseclass, accessorParamType);
        }
        if (!TypeAnalyzer.isSameType(scope.enclosingSourceType(), this.resolvedType(), accessorParamType)) {
            scope.problemReporter().differentTypeInFieldSpec(this);
            return false;
        }
        return true;
    }

    public char[] getFieldName() {
        return this.resolvedField.name;
    }

    public boolean isSetter() {
        return this.calloutModifier == 123;
    }

    public boolean isPrivate() {
        return this.resolvedField != null && this.resolvedField.isPrivate();
    }

    public boolean isStatic() {
        return this.resolvedField != null && this.resolvedField.isStatic();
    }

    public boolean isValid() {
        return this.resolvedField.isValidBinding();
    }

    public int problemId() {
        return this.resolvedField.problemId();
    }

    public char[] readableName() {
        return this.resolvedField.readableName();
    }

    public StringBuffer print(int indent, StringBuffer output) {
        FieldAccessSpec.printIndent(indent, output);
        output.append(this.calloutModifier == 122 ? "get " : "set ");
        if (this.hasSignature) {
            this.printReturnType(0, output);
        }
        output.append(new String(this.selector));
        return output;
    }

    public TypeBinding[] genericTypeArguments() {
        return null;
    }

    public boolean isSuperAccess() {
        return false;
    }

    public boolean isTypeAccess() {
        return this.resolvedField != null && this.resolvedField.isStatic();
    }

    public void setActualReceiverType(ReferenceBinding receiverType) {
    }

    public void setDepth(int depth) {
    }

    public void setFieldIndex(int depth) {
    }
}

