/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.ast;

import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.PotentialTranslationExpression;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.Lowering;

public class PotentialLowerExpression
extends PotentialTranslationExpression {
    public PotentialLowerExpression(Expression expression, TypeBinding expectedType) {
        super(expression, expectedType);
        this.operator = "lower";
    }

    public TypeBinding resolveType(BlockScope scope) {
        TypeBinding baseType;
        TypeBinding roleSideType;
        TypeBinding rawType = this.expression.resolveType(scope);
        if (rawType == null) {
            return null;
        }
        this.resolvedType = this.expectedType;
        this.checked = true;
        if ((rawType.isBaseType() || this.expectedType.isBaseType()) && scope.isBoxingCompatibleWith(rawType, this.expectedType)) {
            return rawType;
        }
        TypeBinding compatibleType = this.compatibleType(scope, rawType);
        if (compatibleType != null) {
            return compatibleType;
        }
        if (rawType.isArrayType()) {
            if (!(this.expectedType instanceof ArrayBinding)) {
                throw new InternalCompilerError("mapping array to scalar");
            }
            roleSideType = rawType.leafComponentType();
            baseType = this.expectedType.leafComponentType();
        } else {
            roleSideType = rawType;
            baseType = this.expectedType;
        }
        boolean incompatibilityFound = false;
        ReferenceBinding roleType = null;
        if (!(roleSideType instanceof ReferenceBinding)) {
            incompatibilityFound = true;
        } else {
            roleType = (ReferenceBinding)roleSideType;
            if (!roleType.isDirectRole() || !(baseType instanceof ReferenceBinding)) {
                incompatibilityFound = true;
            }
        }
        if (incompatibilityFound) {
            return this.reportIncompatibility(scope, rawType);
        }
        boolean oldLower = Config.getLoweringRequired();
        try {
            Config.setLoweringRequired(false);
            if (!roleType.baseclass().isCompatibleWith(baseType)) {
                scope.problemReporter().typeMismatchErrorPotentialLower(this.expression, rawType, this.expectedType, baseType);
                this.resolvedType = null;
                return null;
            }
            if (Config.getLoweringRequired()) {
                throw new InternalCompilerError("Compiler incomplete: unexpected base: is a role, too");
            }
        }
        finally {
            Config.setLoweringRequired(oldLower);
        }
        this.rawExpression = this.expression;
        this.operator = "lower";
        this.expression = new Lowering().lowerExpression(scope, this.expression, rawType, this.expectedType, true);
        this.resolvedType = this.expression.resolvedType = this.expectedType;
        return this.expression.resolvedType;
    }

    public void computeConversion(Scope scope, TypeBinding runtimeType, TypeBinding compileTimeType) {
        this.expression.computeConversion(scope, runtimeType, compileTimeType);
    }
}

