/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.TsuperReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Dependencies;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.AnchorMapping;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TSuperHelper;

public class TSuperMessageSend
extends MessageSend {
    public TsuperReference tsuperReference;
    private MethodBinding tsuperMethod;
    private boolean needReturnConversion = false;

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        flowInfo = super.analyseCode(currentScope, flowContext, flowInfo);
        if (this.binding.isCallin() && !MethodModel.hasCallinFlag(this.tsuperMethod, 8)) {
            MethodDeclaration callinMethod = (MethodDeclaration)currentScope.methodScope().referenceContext;
            LocalVariableBinding trackingVariable = callinMethod.baseCallTrackingVariable.binding;
            if (MethodModel.hasCallinFlag(this.tsuperMethod, 16)) {
                if (flowInfo.isDefinitelyAssigned(trackingVariable) || flowInfo.isPotentiallyAssigned(trackingVariable)) {
                    currentScope.problemReporter().potentiallyDuplicateBasecall(this);
                } else {
                    FlowInfo potential = flowInfo.copy();
                    potential.markAsDefinitelyAssigned(trackingVariable);
                    flowInfo = FlowInfo.conditional(flowInfo.initsWhenTrue(), potential.initsWhenTrue());
                }
            } else {
                if (flowInfo.isDefinitelyAssigned(trackingVariable)) {
                    currentScope.problemReporter().definitelyDuplicateBasecall(this);
                } else if (flowInfo.isPotentiallyAssigned(trackingVariable)) {
                    currentScope.problemReporter().potentiallyDuplicateBasecall(this);
                }
                if (!flowInfo.isDefinitelyAssigned(trackingVariable)) {
                    flowInfo.markAsDefinitelyAssigned(trackingVariable);
                }
            }
        }
        return flowInfo;
    }

    public TypeBinding resolveType(BlockScope scope) {
        AbstractMethodDeclaration context = scope.methodScope().referenceMethod();
        if (context != null && CharOperation.equals(this.selector, context.selector)) {
            ReferenceBinding tsuperType;
            ReferenceBinding qualType = null;
            if (this.tsuperReference.qualification != null && (tsuperType = (ReferenceBinding)this.tsuperReference.resolveType(scope)) != null) {
                qualType = tsuperType.enclosingType();
            }
            this.arguments = TSuperHelper.addMarkerArgument(qualType, this, this.arguments, scope);
            if (this.arguments == null && scope.methodScope().referenceMethod().ignoreFurtherInvestigation) {
                return null;
            }
            super.resolveType(scope);
            if (this.binding != null && this.binding.isValidBinding()) {
                this.tsuperMethod = this.binding.copyInheritanceSrc;
                if (this.binding.isCallin()) {
                    this.resolvedType = MethodModel.getReturnType(this.tsuperMethod);
                    this.needReturnConversion = true;
                }
            }
            return this.resolvedType;
        }
        scope.problemReporter().tsuperCallsWrongMethod(this);
        return null;
    }

    protected TypeBinding afterMethodLookup(Scope scope, AnchorMapping mapping, TypeBinding[] argumentTypes, TypeBinding returnType) {
        ReferenceBinding superRole;
        if (this.binding.problemId() == 1 && (superRole = ((ReferenceBinding)this.receiver.resolvedType).superclass()).isRole()) {
            Dependencies.ensureBindingState(superRole, 20);
            int len = argumentTypes.length;
            boolean stripMarker = false;
            MethodBinding alternateMethod = this.getAlternateMethod(scope, superRole, argumentTypes);
            if (alternateMethod == null) {
                TypeBinding[] strippedArgs = new TypeBinding[len - 1];
                System.arraycopy(argumentTypes, 0, strippedArgs, 0, len - 1);
                alternateMethod = this.getAlternateMethod(scope, superRole, strippedArgs);
                stripMarker = true;
            }
            if (alternateMethod != null) {
                this.binding = alternateMethod;
                if (stripMarker) {
                    this.arguments = new Expression[len - 1];
                    System.arraycopy(this.arguments, 0, this.arguments, 0, len - 1);
                }
                this.receiver = new SuperReference(this.receiver.sourceStart, this.receiver.sourceEnd);
                this.receiver.resolvedType = superRole;
                this.receiver.constant = Constant.NotAConstant;
                this.actualReceiverType = superRole;
                return this.binding.returnType;
            }
        }
        return returnType;
    }

    public boolean checkInvocationArguments(BlockScope scope, Expression receiver, TypeBinding receiverType, MethodBinding method, Expression[] arguments, TypeBinding[] argumentTypes, boolean argsContainCast, InvocationSite invocationSite) {
        if (arguments != null && argumentTypes.length == arguments.length + 1) {
            int len = arguments.length;
            TypeBinding[] typeBindingArray = argumentTypes;
            argumentTypes = new TypeBinding[len];
            System.arraycopy(typeBindingArray, 0, argumentTypes, 0, len);
        }
        return super.checkInvocationArguments(scope, receiver, receiverType, method, arguments, argumentTypes, argsContainCast, invocationSite);
    }

    private MethodBinding getAlternateMethod(Scope scope, ReferenceBinding superRole, TypeBinding[] argumentTypes) {
        MethodBinding alternateMethod = scope.getMethod(superRole, this.selector, argumentTypes, this);
        if (alternateMethod.problemId() == 2) {
            return alternateMethod;
        }
        MethodBinding alternateSrc = alternateMethod.copyInheritanceSrc;
        if (alternateSrc != null && this.isRoleOfSuperTeam(alternateSrc.declaringClass, scope)) {
            return alternateMethod;
        }
        return null;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        super.generateCode(currentScope, codeStream, valueRequired);
        if (valueRequired && this.needReturnConversion && this.resolvedType != null && this.resolvedType.isValidBinding()) {
            if (this.resolvedType.isBaseType()) {
                char[][] boxtypeName = AstGenerator.boxTypeName((BaseTypeBinding)this.resolvedType);
                codeStream.checkcast(currentScope.getType(boxtypeName, 3));
                codeStream.generateUnboxingConversion(this.resolvedType.id);
            } else {
                codeStream.checkcast(this.resolvedType);
            }
        }
    }

    private boolean isRoleOfSuperTeam(ReferenceBinding roleClass, Scope scope) {
        SourceTypeBinding site = scope.enclosingSourceType();
        if (!site.isRole()) {
            return false;
        }
        return site.enclosingType().superclass().isCompatibleWith(roleClass.enclosingType());
    }

    protected boolean isAnySuperAccess() {
        return true;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (this.tsuperReference != null && this.tsuperReference.qualification != null) {
            this.tsuperReference.qualification.printExpression(indent, output);
            output.append(".");
        }
        output.append("tsuper.");
        return super.printExpression(indent, output);
    }
}

