/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.bytecode;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.classfmt.MethodInfo;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.AbstractAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Dependencies;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TypeModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.MethodSignatureEnhancer;

public class CopyInheritanceSourceAttribute
extends AbstractAttribute {
    public char[] sourceMethodDesignator;
    public int lineOffset;
    private MethodBinding method;
    private LookupEnvironment environment;

    public CopyInheritanceSourceAttribute(char[] sourceMethodDesignator, int lineOffset) {
        super(COPY_INHERITANCE_SOURCE_NAME);
        this.sourceMethodDesignator = sourceMethodDesignator;
        this.lineOffset = lineOffset;
    }

    public static AbstractAttribute copyInherSrcAttribute(MethodBinding srcMethod, MethodModel destModel) {
        if (srcMethod.declaringClass instanceof LocalTypeBinding) {
            ((LocalTypeBinding)srcMethod.declaringClass).computeConstantPoolName();
        }
        char[] name = srcMethod.declaringClass.constantPoolName();
        name = CharOperation.append(name, '.');
        name = CharOperation.concat(name, srcMethod.selector);
        name = CharOperation.concat(name, srcMethod.signature());
        int offset = 0;
        MethodModel model = srcMethod.model;
        if (model != null) {
            offset = model._lineOffset;
        }
        return new CopyInheritanceSourceAttribute(name, offset);
    }

    int size() {
        return 12;
    }

    public void write(ClassFile classFile) {
        super.write(classFile);
        this.writeName(this._name);
        this.writeInt(6);
        this.writeName(this.sourceMethodDesignator);
        this.writeInt(this.lineOffset);
        this.writeBack(classFile);
    }

    public static AbstractAttribute readcopyInherSrc(MethodInfo info, int readOffset, int structOffset, int[] constantPoolOffsets) {
        int idx = info.u2At(readOffset);
        int utf8Offset = constantPoolOffsets[idx] - structOffset;
        char[] value = info.utf8At(utf8Offset + 3, info.u2At(utf8Offset + 1));
        int lineOffset = 0;
        if (info.u2At(readOffset - 2) > 2) {
            lineOffset = (int)info.u4At(readOffset + 2);
        }
        CopyInheritanceSourceAttribute result = new CopyInheritanceSourceAttribute(value, lineOffset);
        result._methodInfo = info;
        return result;
    }

    public void evaluate(Binding binding, LookupEnvironment environment, char[][][] missingTypeNames) {
    }

    public boolean evaluate(MethodInfo info, MethodBinding method, LookupEnvironment environment) {
        if (this._methodInfo != info) {
            return false;
        }
        MethodModel.getModel((MethodBinding)method)._lineOffset = this.lineOffset;
        TypeModel model = null;
        ReferenceBinding declaringClass = method.declaringClass;
        if (declaringClass.isRole()) {
            if (declaringClass.roleModel == null && declaringClass.enclosingType() instanceof MissingTypeBinding) {
                return false;
            }
            model = declaringClass.roleModel;
        } else if (declaringClass.isTeam()) {
            model = declaringClass.getTeamModel();
        } else {
            throw new InternalCompilerError("copied method in regular class?");
        }
        model.addAttribute(this);
        this.method = method;
        this.environment = environment;
        return true;
    }

    public void evaluateLateAttribute(ReferenceBinding roleBinding, int state) {
        switch (state) {
            case 11: {
                break;
            }
            case 20: {
                if (this.method == null) {
                    return;
                }
                if (this.method.copyInheritanceSrc == null) break;
                return;
            }
            default: {
                return;
            }
        }
        ReferenceBinding teamBinding = this.method.declaringClass.enclosingType();
        if (teamBinding != null && teamBinding.superclass() != null) {
            Dependencies.ensureBindingState(teamBinding.superclass(), 7);
        } else assert (this.method.declaringClass.isLocalType());
        int dotPos = CharOperation.indexOf('.', this.sourceMethodDesignator);
        int lparPos = CharOperation.indexOf('(', this.sourceMethodDesignator);
        char[] selector = CharOperation.subarray(this.sourceMethodDesignator, dotPos + 1, lparPos);
        char[] signature = CharOperation.subarray(this.sourceMethodDesignator, lparPos, -1);
        ReferenceBinding type = this.environment.getTypeFromConstantPoolName(this.sourceMethodDesignator, 0, dotPos, false, null);
        if (type == null) {
            return;
        }
        if (type instanceof UnresolvedReferenceBinding) {
            type = this.resolveReferenceType(this.environment, (UnresolvedReferenceBinding)type);
        }
        if (type instanceof MissingTypeBinding) {
            ClassScope scope;
            ProblemReporter problemReporter = this.environment.problemReporter;
            ReferenceBinding current = roleBinding;
            while (current != null && current.isBinaryBinding()) {
                current = current.enclosingType();
            }
            if (current != null && (scope = ((SourceTypeBinding)current).scope) != null) {
                problemReporter = ((Scope)scope).problemReporter();
            }
            problemReporter.staleTSuperRole(roleBinding, type, new String(CharOperation.concat(selector, signature)));
            return;
        }
        if (roleBinding.roleModel.hasTSuperRole(type)) {
            Dependencies.ensureBindingState(type, 20);
            if (this.method.isAnyCallin()) {
                signature = MethodSignatureEnhancer.generalizeReturnInSignature(signature);
            }
            MethodBinding[] methods = type.getMethods(selector);
            int i = 0;
            while (i < methods.length) {
                if (CharOperation.equals(methods[i].signature(), signature)) {
                    MethodBinding origin = methods[i].copyInheritanceSrc;
                    if (origin == null) {
                        origin = methods[i];
                    }
                    this.method.setCopyInheritanceSrc(origin);
                    return;
                }
                ++i;
            }
        } else if (roleBinding.isBinaryBinding()) {
            return;
        }
        this.environment.problemReporter.staleTSuperRole(roleBinding, type, new String(CharOperation.concat(selector, signature)));
    }
}

