/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.lifting;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.objectteams.otdt.core.compiler.Pair;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.RoleModelList;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.TreeNode;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleHierarchieAnalyzer {
    private ProblemReporter _problemReporter;
    private TypeDeclaration _teamTypeDeclaration;

    public RoleHierarchieAnalyzer(TypeDeclaration teamTypeDeclaration, ProblemReporter problemReporter) {
        this._teamTypeDeclaration = teamTypeDeclaration;
        this._problemReporter = problemReporter;
    }

    public RoleModel[] analyze(TreeNode role) {
        RoleModelList relevantRoles = this.getRelevantRoles(role);
        this.checkInstantiability(relevantRoles);
        RoleModelList result = this.foldBaseClasses(relevantRoles);
        RoleModel[] resultArray = result.toArray();
        role.getTreeObject().setSubRoles(resultArray);
        return resultArray;
    }

    private RoleModelList getRelevantRoles(TreeNode role) {
        RoleModelList result = new RoleModelList();
        TreeNode[] children = role.getChildren();
        RoleModel parent = role.getTreeObject();
        if (children == null) {
            if (!parent.hasBaseclassProblem()) {
                result.add(parent);
            }
            return result;
        }
        result.add(this.analyzeBaseTypeBindingOfChildren(children, parent));
        int idx = 0;
        while (idx < children.length) {
            RoleModelList relevantChildren = this.getRelevantRoles(children[idx]);
            if (!relevantChildren.isEmpty()) {
                result.addList(relevantChildren);
            }
            ++idx;
        }
        return result;
    }

    public void checkInstantiability(RoleModelList relevantRoles) {
        TeamModel teamModel = null;
        int i = 0;
        while (i < relevantRoles.getSize()) {
            RoleModel role = relevantRoles.get(i);
            if (teamModel == null) {
                teamModel = role.getTeamModel();
            }
            if (role.getBinding().isAbstract()) {
                if (!teamModel.getBinding().isAbstract()) {
                    if (role.getBinding().isPublic() && !role.getBinding().isInterface()) {
                        this._problemReporter.abstractRelevantRole(role.getAst(), teamModel.getBinding());
                    } else if (role.getBaseTypeBinding().isAbstract()) {
                        this._problemReporter.abstractPotentiallyRelevantRole(role.getAst(), teamModel.getBinding());
                    } else {
                        this._problemReporter.abstractRelevantRole(role.getAst(), teamModel.getBinding());
                    }
                }
                relevantRoles.remove(i);
                continue;
            }
            ++i;
        }
    }

    private RoleModel analyzeBaseTypeBindingOfChildren(TreeNode[] children, RoleModel parent) {
        ReferenceBinding parentBaseType = parent.getBaseTypeBinding();
        int idx = 0;
        while (idx < children.length) {
            RoleModel child = children[idx].getTreeObject();
            if (!child.hasBaseclassProblem() && child.getBaseTypeBinding() == parentBaseType) {
                return null;
            }
            ++idx;
        }
        return parent;
    }

    private RoleModelList foldBaseClasses(RoleModelList roles) {
        if (roles == null || roles.isEmpty()) {
            return new RoleModelList();
        }
        return this.filterAmbiguousBaseRoleBindings(roles);
    }

    private RoleModelList filterAmbiguousBaseRoleBindings(RoleModelList roles) {
        RoleModelList result = new RoleModelList();
        RoleModelList rolesToAnalyze = new RoleModelList();
        HashSet<RoleModel> ambiguitySet = new HashSet<RoleModel>();
        RoleModel role = roles.get(0);
        ReferenceBinding baseBinding = role.getBaseTypeBinding();
        ambiguitySet.add(role);
        int idx = 1;
        while (idx < roles.getSize()) {
            RoleModel otherRole = roles.get(idx);
            ReferenceBinding otherBase = otherRole.getBaseTypeBinding();
            if (baseBinding == otherBase) {
                ambiguitySet.add(roles.get(idx));
            } else {
                rolesToAnalyze.add(roles.get(idx));
            }
            ++idx;
        }
        if (ambiguitySet.size() == 1) {
            result.add(role);
            role.getTeamModel().addKnownBase(baseBinding);
        } else {
            ReferenceBinding[] commonSupers = this.getCommonBoundSuperRoles(ambiguitySet.iterator());
            if (commonSupers.length > 0) {
                this._problemReporter.potentiallyAmbiguousRoleBinding(this._teamTypeDeclaration, ambiguitySet);
                ReferenceBinding[] referenceBindingArray = commonSupers;
                int n = commonSupers.length;
                int n2 = 0;
                while (n2 < n) {
                    ReferenceBinding commonSuper = referenceBindingArray[n2];
                    this._teamTypeDeclaration.getTeamModel().ambigousLifting.add(new Pair<ReferenceBinding, ReferenceBinding>(baseBinding, commonSuper));
                    ++n2;
                }
                int i = 0;
                while (i < commonSupers.length) {
                    commonSupers[i].roleModel._hasBindingAmbiguity = true;
                    ++i;
                }
            }
        }
        if (!rolesToAnalyze.isEmpty()) {
            result.addList(this.filterAmbiguousBaseRoleBindings(rolesToAnalyze));
        }
        return result;
    }

    private ReferenceBinding[] getCommonBoundSuperRoles(Iterator<RoleModel> roles) {
        HashSet<ReferenceBinding> allBoundSupers = new HashSet<ReferenceBinding>();
        LinkedList<ReferenceBinding> commonBoundSupers = new LinkedList<ReferenceBinding>();
        while (roles.hasNext()) {
            RoleModel role = roles.next();
            ReferenceBinding currentRole = role.getBinding();
            while ((currentRole = currentRole.superclass()) != null && currentRole.isRole()) {
                if (currentRole.baseclass() == null) continue;
                if (allBoundSupers.contains(currentRole)) {
                    commonBoundSupers.add(currentRole);
                    continue;
                }
                allBoundSupers.add(currentRole);
            }
        }
        ReferenceBinding[] result = new ReferenceBinding[commonBoundSupers.size()];
        commonBoundSupers.toArray(result);
        return result;
    }
}

