/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.mappings;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.compiler.Pair;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.AbstractMethodMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CallinMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.MethodSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.PotentialLiftExpression;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.OTDynCallinBindingsAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.Lifting;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.mappings.MethodMappingImplementor;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.AbstractStatementsGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.MethodSignatureEnhancer;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstClone;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstEdit;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallinImplementorDyn
extends MethodMappingImplementor {
    public static boolean DYNAMIC_WEAVING = "dynamic".equals(System.getProperty("ot.weaving"));
    static final char[] ROLE_VAR_NAME = CharOperation.concat(IOTConstants.OT_DOLLAR_NAME, IOTConstants.ROLE);
    private static final char[] OT_CALL_BEFORE = "_OT$callBefore".toCharArray();
    private static final char[] OT_CALL_AFTER = "_OT$callAfter".toCharArray();
    private static final char[] OT_CALL_REPLACE = "_OT$callReplace".toCharArray();
    public static final char[] OT_CALL_NEXT = "_OT$callNext".toCharArray();
    private static final char[] TEAMS = "teams".toCharArray();
    private static final char[] INDEX = "index".toCharArray();
    private static final char[] CALLIN_ID = "callinID".toCharArray();
    private static final char[] BOUND_METHOD_ID = "boundMethodID".toCharArray();
    private static final char[] ARGUMENTS = "arguments".toCharArray();
    private static final char[] _OT_RESULT = "_OT$result".toCharArray();
    private static final char[] RESULT = "result".toCharArray();
    private static final String LOCAL_ROLE = "local$";
    private static final char[] BASE_CALL_ARGS = "baseCallArguments".toCharArray();
    private RoleModel _role;
    private ClassScope _roleScope;

    public void transformRole(RoleModel role) {
        this._role = role;
        this._roleScope = role.getAst().scope;
        this.bindingDirection = 79;
        AbstractMethodMappingDeclaration[] methodMappings = this._role.getAst().callinCallouts;
        if (methodMappings == null || methodMappings.length == 0) {
            return;
        }
        if (this._role._hasBindingAmbiguity) {
            int i = 0;
            while (i < methodMappings.length) {
                this._roleScope.problemReporter().callinDespiteBindingAmbiguity(this._role.getBinding(), methodMappings[i]);
                methodMappings[i].tagAsHavingErrors();
                ++i;
            }
            return;
        }
        CallinMappingDeclaration[] callinMappings = new CallinMappingDeclaration[methodMappings.length];
        int num = 0;
        int idx = 0;
        while (idx < methodMappings.length) {
            AbstractMethodMappingDeclaration methodMapping = methodMappings[idx];
            if (!methodMapping.ignoreFurtherInvestigation && methodMapping.isCallin()) {
                callinMappings[num++] = (CallinMappingDeclaration)methodMapping;
            }
            ++idx;
        }
        CallinMappingDeclaration[] callinMappingDeclarationArray = callinMappings;
        callinMappings = new CallinMappingDeclaration[num];
        System.arraycopy(callinMappingDeclarationArray, 0, callinMappings, 0, num);
        OTDynCallinBindingsAttribute.createOrMerge(this._role.getTeamModel(), this._role.getBaseTypeBinding().constantPoolName(), callinMappings);
    }

    Expression getArgument(AbstractMethodMappingDeclaration methodMapping, MethodDeclaration wrapperDeclaration, TypeBinding[] implParameters, int idx, final MethodSpec sourceMethodSpec) {
        final MethodSpec implementationMethodSpec = methodMapping.getImplementationMethodSpec();
        Expression mappedArgExpr = null;
        int pos = -1;
        char[] targetArgName = null;
        int generatedArgsLen = methodMapping.isReplaceCallin() ? MethodSignatureEnhancer.ENHANCING_ARG_LEN : 0;
        final int srcIdx = idx - generatedArgsLen;
        targetArgName = implementationMethodSpec.arguments[srcIdx].name;
        Pair<Expression, Integer> mapper = methodMapping.mappingExpressions[srcIdx];
        mappedArgExpr = (Expression)mapper.first;
        if (mapper.second != null) {
            pos = (Integer)mapper.second;
        }
        if (mappedArgExpr != null) {
            SourceTypeBinding roleType = methodMapping.scope.enclosingSourceType();
            if (idx >= implParameters.length) {
                return mappedArgExpr;
            }
            TypeBinding expectedType = implParameters[idx];
            if (expectedType.isRole() && expectedType.enclosingType() != roleType.enclosingType()) {
                expectedType = TeamModel.strengthenRoleType(roleType, expectedType);
            }
            AstGenerator gen = new AstGenerator(mappedArgExpr.sourceStart, mappedArgExpr.sourceEnd);
            SingleNameReference receiver = null;
            if (RoleTypeBinding.isRoleWithoutExplicitAnchor(expectedType) && roleType.getRealClass() == ((ReferenceBinding)expectedType).enclosingType()) {
                receiver = gen.singleNameReference(ROLE_VAR_NAME);
            }
            if (sourceMethodSpec.hasSignature) {
                if (sourceMethodSpec.argNeedsTranslation(srcIdx)) {
                    return Lifting.liftCall(methodMapping.scope, receiver != null ? receiver : ThisReference.implicitThis(), mappedArgExpr, sourceMethodSpec.resolvedParameters()[srcIdx], expectedType, methodMapping.isReplaceCallin());
                }
                if (methodMapping.mappings == null) {
                    return mappedArgExpr;
                }
            }
            Expression liftExpr = gen.potentialLift(receiver, mappedArgExpr, expectedType, methodMapping.isReplaceCallin());
            if (methodMapping.mappings != null && pos != -1 && liftExpr instanceof PotentialLiftExpression) {
                final int srcPos = pos;
                ((PotentialLiftExpression)liftExpr).onLiftingRequired(new Runnable(){

                    public void run() {
                        sourceMethodSpec.argNeedsTranslation[srcPos] = true;
                        implementationMethodSpec.argNeedsTranslation[srcIdx] = true;
                    }
                });
            }
            return liftExpr;
        }
        wrapperDeclaration.scope.problemReporter().unmappedParameter(targetArgName, implementationMethodSpec, methodMapping.isCallout());
        return null;
    }

    public void transformTeam(TeamModel aTeam) {
        ArrayList<CallinMappingDeclaration> beforeMappings = new ArrayList<CallinMappingDeclaration>();
        ArrayList<CallinMappingDeclaration> replaceMappings = new ArrayList<CallinMappingDeclaration>();
        ArrayList<CallinMappingDeclaration> afterMappings = new ArrayList<CallinMappingDeclaration>();
        RoleModel[] roleModelArray = aTeam.getRoles(false);
        int n = roleModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            RoleModel role = roleModelArray[n2];
            TypeDeclaration roleDecl = role.getAst();
            if (roleDecl != null && roleDecl.callinCallouts != null) {
                AbstractMethodMappingDeclaration[] abstractMethodMappingDeclarationArray = roleDecl.callinCallouts;
                int n3 = roleDecl.callinCallouts.length;
                int n4 = 0;
                while (n4 < n3) {
                    AbstractMethodMappingDeclaration mappingDecl = abstractMethodMappingDeclarationArray[n4];
                    if (mappingDecl.isCallin()) {
                        CallinMappingDeclaration callinDecl = (CallinMappingDeclaration)mappingDecl;
                        switch (callinDecl.callinModifier) {
                            case 121: {
                                beforeMappings.add(callinDecl);
                                break;
                            }
                            case 120: {
                                replaceMappings.add(callinDecl);
                                break;
                            }
                            case 119: {
                                afterMappings.add(callinDecl);
                            }
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (beforeMappings.size() > 0) {
            this.generateDispatchMethod(OT_CALL_BEFORE, false, false, beforeMappings, aTeam);
        }
        if (afterMappings.size() > 0) {
            this.generateDispatchMethod(OT_CALL_AFTER, false, true, afterMappings, aTeam);
        }
        if (replaceMappings.size() > 0) {
            this.generateDispatchMethod(OT_CALL_REPLACE, true, false, replaceMappings, aTeam);
            this.generateCallNext(replaceMappings, aTeam);
        }
    }

    private void generateDispatchMethod(char[] methodName, final boolean isReplace, boolean isAfter, final List<CallinMappingDeclaration> callinDecls, final TeamModel aTeam) {
        TypeDeclaration teamDecl = aTeam.getAst();
        if (teamDecl == null) {
            return;
        }
        final AstGenerator gen = new AstGenerator(teamDecl);
        int length = 4;
        if (isReplace) {
            length = 6;
        } else if (isAfter) {
            length = 5;
        }
        Argument[] arguments = new Argument[length];
        int a = 0;
        arguments[a++] = gen.argument(IOTConstants.BASE, gen.qualifiedTypeReference(IOTConstants.ORG_OBJECTTEAMS_IBOUNDBASE));
        if (isReplace) {
            arguments[a++] = gen.argument(TEAMS, gen.qualifiedArrayTypeReference(IOTConstants.ORG_OBJECTTEAMS_ITEAM, 1));
        }
        if (isReplace) {
            arguments[a++] = gen.argument(INDEX, gen.typeReference(TypeBinding.INT));
        }
        arguments[a++] = isReplace ? gen.argument(CALLIN_ID, gen.createArrayTypeReference(TypeBinding.INT, 1)) : gen.argument(CALLIN_ID, gen.typeReference(TypeBinding.INT));
        arguments[a++] = gen.argument(BOUND_METHOD_ID, gen.typeReference(TypeBinding.INT));
        arguments[a++] = gen.argument(ARGUMENTS, gen.qualifiedArrayTypeReference(TypeConstants.JAVA_LANG_OBJECT, 1));
        if (isAfter) {
            arguments[a++] = gen.argument(_OT_RESULT, gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT));
        }
        TypeReference returnTypeRef = isReplace ? gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT) : gen.typeReference(TypeBinding.VOID);
        final MethodDeclaration callMethod = gen.method(teamDecl.compilationResult, 1, returnTypeRef, methodName, arguments);
        callMethod.isMappingWrapper = AbstractMethodDeclaration.WrapperKind.CALLIN;
        AstEdit.addMethod(teamDecl, callMethod);
        MethodModel.getModel(callMethod).setStatementsGenerator(new AbstractStatementsGenerator(){
            final char[][] ARG_NAMES = new char[][]{IOTConstants.BASE, CallinImplementorDyn.access$0(), CallinImplementorDyn.access$1(), CallinImplementorDyn.access$2(), CallinImplementorDyn.access$3(), CallinImplementorDyn.access$4()};

            protected boolean generateStatements(AbstractMethodDeclaration methodDecl) {
                ArrayList<Statement> statements = new ArrayList<Statement>();
                SwitchStatement switchStat = new SwitchStatement();
                switchStat.expression = isReplace ? gen.arrayReference((Expression)gen.singleNameReference(CALLIN_ID), gen.singleNameReference(INDEX)) : gen.singleNameReference(CALLIN_ID);
                for (CallinMappingDeclaration callinDecl : callinDecls) {
                    Expression receiver;
                    int nStats;
                    if (callinDecl.ignoreFurtherInvestigation) continue;
                    MethodSpec[] methodSpecArray = callinDecl.baseMethodSpecs;
                    int n = callinDecl.baseMethodSpecs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MethodSpec baseMethodSpec = methodSpecArray[n2];
                        statements.add(gen.caseStatement(gen.intLiteral(baseMethodSpec.callinID)));
                        ++n2;
                    }
                    MethodSpec baseSpec = callinDecl.baseMethodSpecs[0];
                    TypeBinding baseReturn = baseSpec.resolvedType();
                    boolean mayUseResultArgument = callinDecl.callinModifier == 119 && callinDecl.mappings != null && baseReturn != TypeBinding.VOID;
                    boolean isStaticRoleMethod = callinDecl.getRoleMethod().isStatic();
                    ReferenceBinding roleType = callinDecl.scope.enclosingReceiverType();
                    int n3 = nStats = isReplace ? 1 : 2;
                    if (!isStaticRoleMethod) {
                        ++nStats;
                    }
                    if (callinDecl.mappings != null) {
                        nStats += baseSpec.arguments.length;
                    }
                    if (mayUseResultArgument) {
                        ++nStats;
                    }
                    Statement[] blockStatements = new Statement[nStats];
                    int statIdx = 0;
                    if (mayUseResultArgument) {
                        blockStatements[statIdx++] = gen.localVariable(RESULT, baseReturn, (Expression)gen.castExpression(gen.singleNameReference(_OT_RESULT), gen.typeReference(baseReturn), 2));
                    }
                    if (!isStaticRoleMethod) {
                        char[] roleVar = (CallinImplementorDyn.LOCAL_ROLE + statements.size()).toCharArray();
                        blockStatements[statIdx++] = gen.localVariable(roleVar, roleType.sourceName(), (Expression)Lifting.liftCall(callMethod.scope, gen.thisReference(), gen.castExpression(gen.singleNameReference(IOTConstants.BASE), gen.typeReference(roleType.baseclass()), 2), callMethod.scope.getType(IOTConstants.ORG_OBJECTTEAMS_IBOUNDBASE, 3), roleType, false, gen));
                        receiver = gen.singleNameReference(roleVar);
                        if (callinDecl.getRoleMethod().isPrivate()) {
                            receiver = gen.castExpression(receiver, gen.typeReference(roleType.getRealClass()), 2);
                        }
                    } else {
                        receiver = gen.singleNameReference(callinDecl.getRoleMethod().declaringClass.sourceName());
                    }
                    if (callinDecl.mappings != null) {
                        TypeBinding[] baseParams = baseSpec.resolvedParameters();
                        int i = 0;
                        while (i < baseSpec.arguments.length) {
                            Argument baseArg = baseSpec.arguments[i];
                            ArrayReference rawArg = gen.arrayReference((Expression)gen.singleNameReference(ARGUMENTS), i);
                            Expression init = baseParams[i].isBaseType() ? gen.createUnboxing(rawArg, (BaseTypeBinding)baseParams[i]) : gen.castExpression(rawArg, gen.typeReference(baseParams[i]), 2);
                            blockStatements[statIdx++] = gen.localVariable(baseArg.name, AstClone.copyTypeReference(baseArg.type), init);
                            ++i;
                        }
                    }
                    TypeBinding[] roleParams = callinDecl.roleMethodSpec.resolvedParameters();
                    Expression[] callArgs = new Expression[roleParams.length + (isReplace ? MethodSignatureEnhancer.ENHANCING_ARG_LEN : 0)];
                    int idx = 0;
                    if (isReplace) {
                        char[][] cArray = this.ARG_NAMES;
                        int n4 = this.ARG_NAMES.length;
                        int init = 0;
                        while (init < n4) {
                            char[] argName = cArray[init];
                            callArgs[idx++] = gen.singleNameReference(argName);
                            ++init;
                        }
                    }
                    int i = 0;
                    while (i < roleParams.length) {
                        if (callinDecl.mappings == null) {
                            Expression arg = gen.arrayReference((Expression)gen.singleNameReference(ARGUMENTS), i);
                            if (roleParams[i].isBaseType()) {
                                arg = gen.createUnboxing(arg, (BaseTypeBinding)roleParams[i]);
                            } else {
                                arg = gen.castExpression(arg, gen.typeReference(baseSpec.resolvedParameters()[i]), 0);
                                arg = gen.potentialLift(gen.thisReference(), arg, roleParams[i], isReplace);
                            }
                            callArgs[i + idx] = arg;
                        } else {
                            callArgs[i + idx] = CallinImplementorDyn.this.getArgument(callinDecl, (MethodDeclaration)methodDecl, callinDecl.getRoleMethod().parameters, i + idx, baseSpec);
                        }
                        ++i;
                    }
                    MessageSend roleMethodCall = gen.messageSend(receiver, callinDecl.roleMethodSpec.selector, callArgs);
                    roleMethodCall.isCallinRoleMethodCall = true;
                    if (isReplace) {
                        blockStatements[statIdx] = gen.returnStatement(roleMethodCall);
                    } else {
                        blockStatements[statIdx++] = roleMethodCall;
                        blockStatements[statIdx] = gen.breakStatement();
                    }
                    statements.add(gen.block(blockStatements));
                }
                if (isReplace) {
                    Expression[] callArgs = new Expression[this.ARG_NAMES.length + 1];
                    int idx = 0;
                    while (idx < this.ARG_NAMES.length) {
                        callArgs[idx] = gen.singleNameReference(this.ARG_NAMES[idx]);
                        ++idx;
                    }
                    callArgs[callArgs.length - 1] = gen.nullLiteral();
                    statements.add(gen.caseStatement(null));
                    statements.add(gen.returnStatement(gen.messageSend(gen.qualifiedThisReference(aTeam.getBinding()), OT_CALL_NEXT, callArgs)));
                }
                switchStat.statements = statements.toArray(new Statement[statements.size()]);
                methodDecl.statements = new Statement[]{switchStat};
                methodDecl.hasParsedStatements = true;
                System.out.println("Method added: " + callMethod);
                return true;
            }
        });
    }

    private void generateCallNext(List<CallinMappingDeclaration> callinDecls, TeamModel aTeam) {
        TypeDeclaration teamDecl = aTeam.getAst();
        if (teamDecl == null) {
            return;
        }
        AstGenerator gen = new AstGenerator(teamDecl);
        Argument[] args = new Argument[]{gen.argument(IOTConstants.BASE, gen.qualifiedTypeReference(IOTConstants.ORG_OBJECTTEAMS_IBOUNDBASE)), gen.argument(TEAMS, gen.qualifiedArrayTypeReference(IOTConstants.ORG_OBJECTTEAMS_ITEAM, 1)), gen.argument(INDEX, gen.typeReference(TypeBinding.INT)), gen.argument(CALLIN_ID, gen.createArrayTypeReference(TypeBinding.INT, 1)), gen.argument(BOUND_METHOD_ID, gen.typeReference(TypeBinding.INT)), gen.argument(ARGUMENTS, gen.qualifiedArrayTypeReference(TypeConstants.JAVA_LANG_OBJECT, 1)), gen.argument(BASE_CALL_ARGS, gen.qualifiedArrayTypeReference(TypeConstants.JAVA_LANG_OBJECT, 1))};
        Expression[] superArgs = new Expression[args.length];
        int i = 0;
        while (i < args.length) {
            superArgs[i] = gen.singleNameReference(args[i].name);
            ++i;
        }
        MethodDeclaration decl = gen.method(teamDecl.compilationResult, 1, gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT), OT_CALL_NEXT, args);
        SwitchStatement swStat = new SwitchStatement();
        swStat.expression = gen.arrayReference((Expression)gen.singleNameReference(CALLIN_ID), gen.singleNameReference(INDEX));
        ArrayList swStatements = new ArrayList();
        for (CallinMappingDeclaration mapping : callinDecls) {
            ArrayList<Statement> caseBlockStats = new ArrayList<Statement>();
            int nLabels = 0;
            MethodSpec[] methodSpecArray = mapping.baseMethodSpecs;
            int n = mapping.baseMethodSpecs.length;
            int n2 = 0;
            while (n2 < n) {
                MethodSpec baseSpec = methodSpecArray[n2];
                caseBlockStats.add(gen.caseStatement(gen.intLiteral(baseSpec.getCallinId(aTeam))));
                ++n2;
            }
            int nRoleArgs = mapping.getRoleMethod().getSourceParamLength();
            if (mapping.positions != null) {
                int[] poss = mapping.positions;
                nLabels = caseBlockStats.size();
                int i2 = 0;
                while (i2 < poss.length) {
                    if (poss[i2] > 0) {
                        caseBlockStats.add(gen.assignment(gen.arrayReference((Expression)gen.singleNameReference(ARGUMENTS), poss[i2] - 1), gen.arrayReference((Expression)gen.singleNameReference(BASE_CALL_ARGS), i2)));
                    }
                    ++i2;
                }
            } else if (nRoleArgs > 0) {
                int i3 = 0;
                while (i3 < nRoleArgs) {
                    caseBlockStats.add(gen.assignment(gen.arrayReference((Expression)gen.singleNameReference(ARGUMENTS), i3), gen.arrayReference((Expression)gen.singleNameReference(BASE_CALL_ARGS), i3)));
                    ++i3;
                }
            }
            if (caseBlockStats.size() <= nLabels) continue;
            swStatements.addAll(caseBlockStats);
            swStatements.add(gen.breakStatement());
        }
        if (swStatements.size() == 0) {
            return;
        }
        swStat.statements = swStatements.toArray(new Statement[swStatements.size()]);
        decl.statements = new Statement[]{swStat, gen.returnStatement(gen.messageSend(gen.superReference(), OT_CALL_NEXT, superArgs))};
        decl.hasParsedStatements = true;
        AstEdit.addMethod(teamDecl, decl);
    }

    static /* synthetic */ char[] access$0() {
        return TEAMS;
    }

    static /* synthetic */ char[] access$3() {
        return BOUND_METHOD_ID;
    }
}

