/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.mappings;

import java.util.ArrayList;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.compiler.InferenceKind;
import org.eclipse.objectteams.otdt.core.compiler.OTNameUtils;
import org.eclipse.objectteams.otdt.core.compiler.Pair;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.AbstractMethodMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CalloutMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.FieldAccessSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.MethodSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.ParameterMapping;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.PotentialLowerExpression;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.ResultReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.TypeAnchorReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Dependencies;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.CallinCalloutBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.CallinCalloutScope;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.DependentTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.TThisBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.WeakenedTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.mappings.MethodMappingImplementor;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.FieldModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.AbstractStatementsGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstClone;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstConverter;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstEdit;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TSuperHelper;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalloutImplementor
extends MethodMappingImplementor {
    private static final int INTERFACE = 0;
    private static final int CLASS = 1;
    private RoleModel _role;

    public CalloutImplementor(RoleModel role) {
        this._role = role;
        this.bindingDirection = 75;
    }

    public boolean transform(boolean needMethodBodies) {
        AbstractMethodMappingDeclaration[] methodMappings = this._role.getAst().callinCallouts;
        boolean result = true;
        if (methodMappings != null && methodMappings.length > 0) {
            int idx = 0;
            while (idx < methodMappings.length) {
                AbstractMethodMappingDeclaration methodMapping = methodMappings[idx];
                if (methodMapping.isCallout()) {
                    boolean createStatements = needMethodBodies && !methodMapping.hasErrors();
                    result &= this.createCallout((CalloutMappingDeclaration)methodMapping, createStatements, false);
                }
                ++idx;
            }
        }
        return result;
    }

    private boolean createCallout(CalloutMappingDeclaration calloutMappingDeclaration, boolean needBody, boolean isInferred) {
        Argument[] args;
        CallinCalloutScope calloutScope = calloutMappingDeclaration.scope;
        calloutMappingDeclaration.updateTSuperMethods();
        MethodBinding roleMethodBinding = calloutMappingDeclaration.getRoleMethod();
        if (roleMethodBinding == null) {
            assert (calloutMappingDeclaration.ignoreFurtherInvestigation);
            return false;
        }
        if (!roleMethodBinding.isValidBinding()) {
            if (roleMethodBinding.problemId() != 1) {
                calloutMappingDeclaration.tagAsHavingErrors();
                return false;
            }
            MethodBinding existingMethod = calloutScope.enclosingSourceType().getExactMethod(roleMethodBinding.selector, roleMethodBinding.parameters, calloutScope.compilationUnitScope());
            if (existingMethod != null) {
                roleMethodBinding = existingMethod;
            }
        }
        MethodDeclaration roleMethodDeclaration = null;
        if (roleMethodBinding.declaringClass == calloutScope.enclosingSourceType()) {
            roleMethodDeclaration = (MethodDeclaration)roleMethodBinding.sourceMethod();
        }
        boolean foundRoleDecl = roleMethodDeclaration != null;
        MethodBinding overriddenTSuper = null;
        if (foundRoleDecl && roleMethodDeclaration.isCopied && (roleMethodDeclaration.modifiers & 0x400) == 0 && !TSuperHelper.isTSuper(roleMethodDeclaration.binding)) {
            overriddenTSuper = roleMethodBinding;
            roleMethodBinding = new MethodBinding(roleMethodBinding, roleMethodBinding.declaringClass);
            TSuperHelper.addMarkerArg(roleMethodDeclaration, roleMethodDeclaration.binding.copyInheritanceSrc.declaringClass.enclosingType());
            foundRoleDecl = false;
        }
        if (!foundRoleDecl) {
            roleMethodDeclaration = this.createAbstractRoleMethodDeclaration(roleMethodBinding, calloutMappingDeclaration);
            if (overriddenTSuper != null) {
                roleMethodDeclaration.binding.addOverriddenTSuper(overriddenTSuper);
            }
        } else {
            roleMethodDeclaration.isReusingSourceMethod = true;
            roleMethodDeclaration.isMappingWrapper = AbstractMethodDeclaration.WrapperKind.CALLOUT;
            if (roleMethodDeclaration.interfacePartMethod != null) {
                roleMethodDeclaration.interfacePartMethod.isReusingSourceMethod = true;
                roleMethodDeclaration.interfacePartMethod.isMappingWrapper = AbstractMethodDeclaration.WrapperKind.CALLOUT;
            }
        }
        if (calloutMappingDeclaration.hasSignature && (args = calloutMappingDeclaration.roleMethodSpec.arguments) != null) {
            int i = 0;
            while (i < args.length) {
                if (foundRoleDecl) {
                    roleMethodDeclaration.arguments[i].updateName(args[i].name);
                }
                roleMethodDeclaration.arguments[i].bind(roleMethodDeclaration.scope, args[i].binding.type, false);
                args[i].binding.setBestNameFromStat(roleMethodDeclaration.arguments[i]);
                ++i;
            }
        }
        if (roleMethodDeclaration != null) {
            if (!roleMethodDeclaration.isCopied && !roleMethodDeclaration.isGenerated && (roleMethodDeclaration.modifiers & 0x400) == 0) {
                roleMethodDeclaration.ignoreFurtherInvestigation = true;
                calloutScope.problemReporter().calloutOverridesLocal(this._role.getAst(), calloutMappingDeclaration, roleMethodDeclaration.binding);
                return false;
            }
            roleMethodDeclaration.isCopied = false;
            int flagsToRemove = 0x1000500;
            roleMethodDeclaration.modifiers &= ~flagsToRemove;
            roleMethodDeclaration.binding.modifiers &= ~flagsToRemove;
            roleMethodDeclaration.isGenerated = true;
            if (needBody && calloutMappingDeclaration.binding.isValidBinding()) {
                final CalloutMappingDeclaration mappingDeclaration = calloutMappingDeclaration;
                MethodModel methodModel = MethodModel.getModel(roleMethodDeclaration);
                if (isInferred) {
                    methodModel._inferredCallout = mappingDeclaration;
                }
                methodModel.setStatementsGenerator(new AbstractStatementsGenerator(){

                    public boolean generateStatements(AbstractMethodDeclaration methodDecl) {
                        CalloutImplementor.this.createCalloutMethodBody((MethodDeclaration)methodDecl, mappingDeclaration);
                        return true;
                    }
                });
            } else if (calloutMappingDeclaration.ignoreFurtherInvestigation) {
                roleMethodDeclaration.binding.bytecodeMissing = true;
            }
        } else {
            throw new InternalCompilerError("OT-Compiler Error: couldn't create method declaration for callout! " + calloutMappingDeclaration.toString());
        }
        return true;
    }

    private MethodDeclaration createAbstractRoleMethodDeclaration(MethodBinding templateBinding, CalloutMappingDeclaration calloutBindingDeclaration) {
        MethodBinding superMethod;
        MethodBinding ifcMethod;
        ReferenceBinding ifcPart;
        boolean isOverridingVisibility;
        int modifiers;
        Binding baseFeature = null;
        MethodSpec baseMethodSpec = calloutBindingDeclaration.baseMethodSpec;
        if (baseMethodSpec != null) {
            Binding binding = baseFeature = calloutBindingDeclaration.isCalloutToField() ? ((FieldAccessSpec)baseMethodSpec).resolvedField : baseMethodSpec.resolvedMethod;
        }
        if ((modifiers = calloutBindingDeclaration.declaredModifiers) == 0) {
            modifiers = baseFeature != null && templateBinding.modifiers == 0 ? baseFeature.modifiers() : templateBinding.modifiers;
            modifiers &= 0xF;
        }
        boolean bl = isOverridingVisibility = calloutBindingDeclaration.isCalloutOverride() && calloutBindingDeclaration.declaredModifiers != 0;
        if (templateBinding.isValidBinding() && templateBinding.declaringClass.isRole() && (ifcPart = templateBinding.declaringClass.roleModel.getInterfacePartBinding()) != null && (ifcMethod = TypeAnalyzer.findMethod(calloutBindingDeclaration.scope, ifcPart, templateBinding.selector, templateBinding.parameters)) != null && ifcMethod.isValidBinding() && !isOverridingVisibility) {
            modifiers &= 0xFFFFFFF8;
            modifiers |= ifcMethod.modifiers & 7;
        }
        boolean overridesExplicitNonRole = false;
        ReferenceBinding superRole = null;
        ReferenceBinding roleClass = this._role.getClassPartBinding();
        if (roleClass != null) {
            superRole = roleClass.superclass();
        }
        if (superRole != null && superRole.enclosingType() != roleClass.enclosingType() && (superMethod = TypeAnalyzer.findMethod(calloutBindingDeclaration.scope, superRole, templateBinding.selector, templateBinding.parameters)) != null && superMethod.isValidBinding()) {
            overridesExplicitNonRole = true;
        }
        if (calloutBindingDeclaration.binding.inferred == InferenceKind.NONE) {
            if (templateBinding.isStatic()) {
                this.createInterfaceFakeStatic(templateBinding, calloutBindingDeclaration);
            } else if (!overridesExplicitNonRole) {
                this.createAbstractRoleMethodDeclarationPart(templateBinding, calloutBindingDeclaration, modifiers, 0);
            }
        }
        return this.createAbstractRoleMethodDeclarationPart(templateBinding, calloutBindingDeclaration, modifiers, 1);
    }

    private void createInterfaceFakeStatic(MethodBinding template, CalloutMappingDeclaration calloutDecl) {
        MethodBinding newMethod = new MethodBinding(template, this._role.getInterfacePartBinding());
        this._role.getInterfacePartBinding().addMethod(newMethod);
    }

    private MethodDeclaration createAbstractRoleMethodDeclarationPart(MethodBinding templateBinding, CalloutMappingDeclaration calloutBindingDeclaration, int modifiers, int part) {
        assert (templateBinding != null);
        AstGenerator gen = new AstGenerator(calloutBindingDeclaration.sourceStart, calloutBindingDeclaration.sourceEnd);
        TypeBinding returnType = calloutBindingDeclaration.roleMethodSpec.returnType != null ? calloutBindingDeclaration.roleMethodSpec.returnType.resolvedType : calloutBindingDeclaration.roleMethodSpec.resolvedMethod.returnType;
        MethodDeclaration newMethod = gen.method(calloutBindingDeclaration.compilationResult, modifiers, returnType, templateBinding.selector, this.copyArguments(gen, calloutBindingDeclaration.scope, templateBinding.parameters, calloutBindingDeclaration.roleMethodSpec));
        newMethod.typeParameters = this.getTypeParameters(calloutBindingDeclaration.hasSignature, templateBinding, calloutBindingDeclaration.roleMethodSpec, gen);
        if (templateBinding.problemId() == 1) {
            MethodSpec baseMethodSpec = calloutBindingDeclaration.baseMethodSpec;
            if (baseMethodSpec != null) {
                if (baseMethodSpec.isStatic()) {
                    newMethod.modifiers |= 8;
                }
                if (baseMethodSpec.resolvedMethod != null) {
                    newMethod.thrownExceptions = AstClone.copyExceptions(baseMethodSpec.resolvedMethod, gen);
                }
            }
        } else {
            newMethod.thrownExceptions = AstClone.copyExceptions(templateBinding, gen);
        }
        newMethod.isMappingWrapper = AbstractMethodDeclaration.WrapperKind.CALLOUT;
        if (part == 0) {
            newMethod.modifiers |= 0x1000400;
            AstEdit.addMethod(this._role.getInterfaceAst(), newMethod);
        } else {
            if (calloutBindingDeclaration.binding.inferred == InferenceKind.NONE) {
                newMethod.modifiers &= 0xFFFFFFF9;
                newMethod.modifiers |= 1;
            }
            AstEdit.addMethod(this._role.getAst(), newMethod);
        }
        calloutBindingDeclaration.updateRoleMethod(newMethod.binding);
        return newMethod;
    }

    void createCalloutMethodBody(MethodDeclaration roleMethodDeclaration, CalloutMappingDeclaration calloutBindingDeclaration) {
        if (!this.transformCalloutMethodBody(roleMethodDeclaration, calloutBindingDeclaration)) {
            roleMethodDeclaration.tagAsHavingErrors();
        }
    }

    private boolean transformCalloutMethodBody(MethodDeclaration roleMethodDeclaration, CalloutMappingDeclaration calloutDecl) {
        Expression[] arguments;
        TypeBinding returnType = calloutDecl.roleMethodSpec.returnType.resolvedType;
        int sStart = calloutDecl.sourceStart;
        int sEnd = calloutDecl.sourceEnd;
        roleMethodDeclaration.bodyStart = sStart;
        roleMethodDeclaration.bodyEnd = sEnd;
        if (!roleMethodDeclaration.isReusingSourceMethod) {
            roleMethodDeclaration.sourceStart = sStart;
            roleMethodDeclaration.sourceEnd = sEnd;
            roleMethodDeclaration.declarationSourceStart = sStart;
            roleMethodDeclaration.declarationSourceEnd = sEnd;
        }
        if (calloutDecl.hasSignature) {
            arguments = this.makeWrapperCallArguments(calloutDecl, roleMethodDeclaration, calloutDecl.roleMethodSpec, calloutDecl.baseMethodSpec instanceof FieldAccessSpec, false);
            if (arguments == null || CalloutImplementor.hasParamMappingProblems(calloutDecl, returnType, roleMethodDeclaration.scope.problemReporter())) {
                return false;
            }
        } else {
            arguments = this.makeArguments(calloutDecl, roleMethodDeclaration, calloutDecl.baseMethodSpec);
        }
        sStart = calloutDecl.baseMethodSpec.sourceStart;
        sEnd = calloutDecl.baseMethodSpec.sourceEnd;
        AstGenerator gen = new AstGenerator(sStart, sEnd);
        char[] selector = calloutDecl.baseMethodSpec.selector;
        ReferenceBinding baseType = this._role.getBaseTypeBinding();
        Expression receiver = calloutDecl.baseMethodSpec.isStatic() || calloutDecl.isCalloutToField() ? gen.baseNameReference(baseType.getRealClass()) : new CastExpression(gen.baseNameReference(IOTConstants._OT_BASE), gen.baseclassReference(baseType), 0);
        if (calloutDecl.baseMethodSpec.isPrivate() && baseType.isRole()) {
            if (baseType instanceof WeakenedTypeBinding) {
                baseType = ((WeakenedTypeBinding)baseType).getStrongType();
            }
            calloutDecl.scope.problemReporter().decapsulation(calloutDecl.baseMethodSpec, baseType, (Scope)calloutDecl.scope);
            receiver = gen.typeAnchorReference(((RoleTypeBinding)baseType)._teamAnchor);
            ((TypeAnchorReference)receiver).isExpression = true;
            selector = AstConverter.getPrivateBridgeSelector(selector, baseType.sourceName());
            if (!(calloutDecl.baseMethodSpec instanceof FieldAccessSpec)) {
                int len = arguments.length;
                Expression[] expressionArray = arguments;
                arguments = new Expression[len + 1];
                System.arraycopy(expressionArray, 0, arguments, 1, len);
            }
            arguments[0] = gen.baseNameReference(IOTConstants._OT_BASE);
        }
        MessageSend messageSend = gen.messageSend(receiver, selector, arguments);
        messageSend.receiver.sourceStart = sStart;
        messageSend.receiver.sourceEnd = sEnd;
        boolean success = true;
        ArrayList<Statement> statements = new ArrayList<Statement>(3);
        if (returnType == TypeBinding.VOID) {
            statements.add(messageSend);
            statements.add(gen.returnStatement(null));
        } else if (calloutDecl.mappings == null) {
            statements.add(gen.returnStatement(gen.potentialLift(null, messageSend, returnType, false)));
        } else {
            success = this.transformCalloutMethodBodyResultMapping(statements, messageSend, calloutDecl, roleMethodDeclaration);
        }
        if (success) {
            roleMethodDeclaration.setStatements(statements.toArray(new Statement[statements.size()]));
        } else {
            roleMethodDeclaration.statements = new Statement[0];
        }
        return success;
    }

    private Expression[] makeArguments(CalloutMappingDeclaration methodMapping, AbstractMethodDeclaration roleMethodDecl, MethodSpec baseMethodSpec) {
        int minArguments;
        assert (!methodMapping.hasSignature);
        TypeBinding[] baseParams = baseMethodSpec.resolvedMethod.parameters;
        Argument[] roleArgs = roleMethodDecl.arguments;
        MethodSpec roleMethodSpec = methodMapping.roleMethodSpec;
        AstGenerator gen = new AstGenerator(roleMethodSpec.sourceStart, roleMethodSpec.sourceEnd);
        Expression[] arguments = null;
        int offset = 0;
        if (baseMethodSpec instanceof FieldAccessSpec) {
            int valueArgCount;
            minArguments = baseParams.length;
            arguments = new Expression[minArguments];
            int n = valueArgCount = ((FieldAccessSpec)baseMethodSpec).isSetter() ? 1 : 0;
            if (minArguments > valueArgCount) {
                gen.retargetFrom(baseMethodSpec);
                arguments[0] = gen.castExpression(gen.singleNameReference(IOTConstants._OT_BASE), gen.baseclassReference(this._role.getBaseTypeBinding().getRealClass()), this._role.getBaseTypeBinding().isRole() ? 1 : 2);
                gen.retargetFrom(roleMethodSpec);
                --minArguments;
                offset = 1;
            }
        } else {
            minArguments = Math.min(baseParams.length, roleArgs != null ? roleArgs.length : 0);
            assert (minArguments == baseParams.length);
            arguments = new Expression[minArguments];
        }
        int i = 0;
        while (i < minArguments) {
            arguments[i + offset] = new PotentialLowerExpression(gen.singleNameReference(roleArgs[i].name), this.adjustBaseSideType(baseParams[i + offset]));
            ++i;
        }
        return arguments;
    }

    private boolean transformCalloutMethodBodyResultMapping(ArrayList<Statement> statements, Expression resultExpr, CalloutMappingDeclaration calloutDecl, MethodDeclaration roleMethodDeclaration) {
        FieldBinding baseField;
        Expression resultMapper = null;
        ParameterMapping[] mappings = calloutDecl.mappings;
        boolean resultFound = false;
        int sStart = 0;
        int sEnd = 0;
        int resultStart = 0;
        int resultEnd = 0;
        int i = 0;
        while (i < mappings.length) {
            if (!mappings[i].isUsedFor(calloutDecl.roleMethodSpec) && CharOperation.equals(mappings[i].ident.token, IOTConstants.RESULT)) {
                if (resultFound) {
                    roleMethodDeclaration.scope.problemReporter().duplicateParamMapping(mappings[i], IOTConstants.RESULT, true);
                    return false;
                }
                resultMapper = mappings[i].expression;
                sStart = mappings[i].sourceStart;
                sEnd = mappings[i].sourceEnd;
                resultStart = mappings[i].ident.sourceStart;
                resultEnd = mappings[i].ident.sourceEnd;
                resultFound = true;
            }
            ++i;
        }
        if (!resultFound) {
            roleMethodDeclaration.scope.problemReporter().unmappedParameter(IOTConstants.RESULT, calloutDecl.roleMethodSpec, true);
            return false;
        }
        assert (resultMapper != null);
        assert (calloutDecl.baseMethodSpec.hasSignature);
        AstGenerator gen = new AstGenerator(resultStart, resultEnd);
        Statement callStatement = resultExpr;
        TypeBinding baseReturnType = calloutDecl.baseMethodSpec.returnType.resolvedType;
        if (baseReturnType != TypeBinding.VOID) {
            char[] localName = IOTConstants.RESULT;
            if (calloutDecl.baseMethodSpec instanceof FieldAccessSpec) {
                localName = ((FieldAccessSpec)calloutDecl.baseMethodSpec).getFieldName();
            }
            calloutDecl.resultVar = gen.localVariable(localName, calloutDecl.baseMethodSpec.returnType.resolvedType, resultExpr);
            calloutDecl.resultVar.type.setBaseclassDecapsulation(Expression.DecapsulationState.REPORTED);
            callStatement = calloutDecl.resultVar;
        }
        gen.sourceStart = sStart;
        gen.sourceEnd = sEnd;
        statements.add(callStatement);
        if (!roleMethodDeclaration.isStatic() && (baseField = TypeAnalyzer.findField(this._role.getBinding(), IOTConstants._OT_BASE, false, false)) != null) {
            statements.add(gen.localVariable(IOTConstants.BASE, gen.baseclassReference(baseField.type), (Expression)gen.singleNameReference(IOTConstants._OT_BASE)));
        }
        statements.add(gen.returnStatement(gen.potentialLift(null, resultMapper, calloutDecl.roleMethodSpec.returnType.resolvedType, false)));
        return true;
    }

    private static boolean hasParamMappingProblems(CalloutMappingDeclaration calloutMappingDeclaration, TypeBinding returnType, ProblemReporter problemReporter) {
        boolean hasArgError = false;
        ParameterMapping[] mappings = calloutMappingDeclaration.mappings;
        if (mappings != null) {
            int i = 0;
            while (i < mappings.length) {
                if (CharOperation.equals(mappings[i].ident.token, IOTConstants.RESULT)) {
                    if (mappings[i].direction == 75) {
                        problemReporter.wrongBindingDirection(calloutMappingDeclaration, mappings[i]);
                        hasArgError = true;
                    } else if (returnType == TypeBinding.VOID) {
                        problemReporter.resultMappingForVoidMethod(calloutMappingDeclaration, calloutMappingDeclaration.roleMethodSpec, mappings[i]);
                        hasArgError = true;
                    }
                } else if (mappings[i].expression instanceof ResultReference) {
                    problemReporter.mappingResultToOther(calloutMappingDeclaration, mappings[i]);
                } else if (!mappings[i].isUsedFor(calloutMappingDeclaration.roleMethodSpec)) {
                    if (mappings[i].direction == 75) {
                        problemReporter.unusedParamMap(calloutMappingDeclaration, mappings[i]);
                    } else {
                        problemReporter.wrongBindingDirection(calloutMappingDeclaration, mappings[i]);
                        hasArgError = true;
                    }
                }
                ++i;
            }
        }
        return hasArgError;
    }

    @Override
    Expression getArgument(AbstractMethodMappingDeclaration methodMapping, MethodDeclaration wrapperDeclaration, TypeBinding[] implParameters, int idx, boolean hasResultArgument, MethodSpec sourceMethodSpec) {
        MethodSpec implementationMethodSpec = methodMapping.getImplementationMethodSpec();
        Argument[] specifiedArgs = implementationMethodSpec.arguments;
        ParameterMapping[] parameterMappings = methodMapping.mappings;
        Expression mappedArgExpr = null;
        char[] targetArgName = null;
        if (parameterMappings == null) {
            targetArgName = wrapperDeclaration.arguments[idx].name;
            mappedArgExpr = this.genSimpleArgExpr(targetArgName, ((CalloutMappingDeclaration)methodMapping).baseMethodSpec);
            if (idx < specifiedArgs.length) {
                specifiedArgs[idx].binding.setBestNameFromStat(wrapperDeclaration.arguments[idx]);
            }
        } else {
            if (methodMapping.mappingExpressions == null) {
                assert (!methodMapping.hasParsedParamMappings) : "expect lack of parsing as cause for missing expressions";
                return null;
            }
            targetArgName = implementationMethodSpec.arguments[idx].name;
            Pair<Expression, Integer> mapper = methodMapping.mappingExpressions[idx];
            mappedArgExpr = (Expression)mapper.first;
        }
        if (mappedArgExpr != null) {
            if (idx >= implParameters.length) {
                return mappedArgExpr;
            }
            TypeBinding expectedType = implParameters[idx];
            if (expectedType.leafComponentType() instanceof DependentTypeBinding) {
                DependentTypeBinding dependentExpectedLeaf = (DependentTypeBinding)expectedType.leafComponentType();
                int anchorArgPos = dependentExpectedLeaf._argumentPosition;
                if (anchorArgPos != -1) {
                    if (methodMapping.positions != null) {
                        anchorArgPos = methodMapping.positions[anchorArgPos] - 1;
                    }
                    LocalVariableBinding mappedAnchor = sourceMethodSpec.arguments[anchorArgPos].binding;
                    expectedType = mappedAnchor.getRoleTypeBinding(dependentExpectedLeaf, expectedType.dimensions());
                }
            }
            return new PotentialLowerExpression(mappedArgExpr, this.adjustBaseSideType(expectedType));
        }
        wrapperDeclaration.scope.problemReporter().unmappedParameter(targetArgName, implementationMethodSpec, methodMapping.isCallout());
        return null;
    }

    TypeBinding adjustBaseSideType(TypeBinding givenType) {
        ITeamAnchor anchor;
        ReferenceBinding baseBinding = this._role.getBaseTypeBinding();
        if (baseBinding == null) {
            return givenType;
        }
        if (givenType.leafComponentType().isBaseType()) {
            return givenType;
        }
        ReferenceBinding givenLeaf = (ReferenceBinding)givenType.leafComponentType();
        int dimensions = givenType.dimensions();
        TypeBinding[] arguments = null;
        if (givenType.isParameterizedType()) {
            arguments = ((ParameterizedTypeBinding)givenType).typeVariables();
        }
        if (DependentTypeBinding.isDependentType(baseBinding) && (anchor = ((DependentTypeBinding)baseBinding).getAnchor()).isTeamContainingRole(givenLeaf)) {
            if (anchor.getResolvedType() != givenLeaf.enclosingType()) {
                givenLeaf = (ReferenceBinding)TeamModel.strengthenRoleType((ReferenceBinding)anchor.getResolvedType(), givenLeaf);
            }
            return anchor.getDependentTypeBinding(givenLeaf, -1, arguments, dimensions);
        }
        return givenType;
    }

    @Override
    TypeBinding[] getImplementationParamters(AbstractMethodMappingDeclaration methodMapping, MethodDeclaration wrapperMethod) {
        TypeBinding[] result = super.getImplementationParamters(methodMapping, wrapperMethod);
        int l = result.length;
        if (result == Binding.NO_PARAMETERS || l == 0) {
            return result;
        }
        TypeBinding[] typeBindingArray = result;
        result = new TypeBinding[l];
        System.arraycopy(typeBindingArray, 0, result, 0, l);
        TypeVariableBinding[] variables = wrapperMethod.binding.typeVariables();
        int i = 0;
        while (i < result.length) {
            result[i] = this.substituteVariables(result[i], variables);
            ++i;
        }
        return result;
    }

    public void generateFromBinding(CallinCalloutBinding mapping) {
        TypeDeclaration roleClass = this._role.getClassPartAst();
        boolean needBody = Dependencies.needMethodBodies(roleClass);
        AstGenerator gen = new AstGenerator(roleClass.sourceStart, roleClass.sourceEnd);
        CalloutMappingDeclaration callout = gen.calloutMappingDeclaration(roleClass.compilationResult);
        callout.roleMethodSpec = this.fromMethodBinding(mapping._roleMethodBinding, gen);
        if (mapping._baseMethods.length > 0) {
            callout.baseMethodSpec = this.fromMethodBinding(mapping._baseMethods[0], gen);
        } else assert (!needBody) : "Role needing method bodies should have base method set";
        callout.scope = new CallinCalloutScope(roleClass.scope, callout);
        callout.scope.createBinding(callout);
        callout.checkReturnCompatibility(callout.roleMethodSpec);
        if (callout.baseMethodSpec != null) {
            callout.checkReturnCompatibility(callout.baseMethodSpec);
        }
        this.createCallout(callout, needBody, MethodModel.getImplementingInferredCallout(mapping._roleMethodBinding) != null);
    }

    public boolean generateInferredCallout(TypeDeclaration roleClass, MethodBinding abstractMethod) {
        ReferenceBinding baseType = this._role.getBaseTypeBinding();
        if (baseType == null || !baseType.isValidBinding()) {
            return false;
        }
        AstGenerator gen = new AstGenerator(roleClass.sourceStart, roleClass.sourceEnd);
        MethodSpec roleMethod = this.fromMethodBinding(abstractMethod, gen);
        TypeBinding[] roleParams = abstractMethod.parameters;
        return this.internalGenerateInferredCallout(roleClass, baseType, roleMethod, roleParams, InferenceKind.INTERFACE, gen);
    }

    public static boolean inferMappingFromCall(TypeDeclaration roleClass, MessageSend messageSend, TypeBinding[] roleParams) {
        if (roleClass == null || !roleClass.isRole()) {
            return false;
        }
        if (!messageSend.receiver.isThis()) {
            return false;
        }
        ReferenceBinding baseType = roleClass.binding.baseclass();
        if (baseType == null) {
            return false;
        }
        AstGenerator gen = new AstGenerator(messageSend.sourceStart, messageSend.sourceEnd);
        MethodSpec roleMethod = CalloutImplementor.fromMessageSend(roleClass, messageSend, roleParams, gen);
        CalloutImplementor coi = new CalloutImplementor(roleClass.getRoleModel());
        if (coi.internalGenerateInferredCallout(roleClass, baseType, roleMethod, roleParams, InferenceKind.SELFCALL, gen)) {
            messageSend.binding = roleMethod.resolvedMethod;
            return true;
        }
        return false;
    }

    private boolean internalGenerateInferredCallout(TypeDeclaration roleClass, ReferenceBinding baseType, MethodSpec roleMethodSpec, TypeBinding[] roleParams, InferenceKind kind, AstGenerator gen) {
        DependentTypeBinding roleBinding;
        TypeBinding expectedType;
        CalloutMappingDeclaration callout = gen.calloutMappingDeclaration(roleClass.compilationResult);
        callout.roleMethodSpec = roleMethodSpec;
        callout.scope = new CallinCalloutScope(roleClass.scope, callout);
        MethodBinding candidate = this.inferBaseMethod(callout, baseType, roleMethodSpec.selector, roleParams);
        if (candidate == null) {
            return false;
        }
        if (kind == InferenceKind.SELFCALL && candidate.isStatic()) {
            roleMethodSpec.resolvedMethod.modifiers |= 8;
        }
        if (DependentTypeBinding.isDependentType(expectedType = roleMethodSpec.resolvedType()) && (roleBinding = (DependentTypeBinding)expectedType).getAnchor() instanceof TThisBinding) {
            expectedType = roleBinding.baseclass();
        }
        if (expectedType != null && !candidate.returnType.isCompatibleWith(expectedType)) {
            roleMethodSpec.returnType.resolvedType = candidate.returnType;
            roleMethodSpec.resolvedMethod.returnType = candidate.returnType;
        }
        roleMethodSpec.resolvedMethod.thrownExceptions = candidate.thrownExceptions;
        if (kind == InferenceKind.SELFCALL) {
            int i = 0;
            while (i < roleParams.length) {
                if (roleParams[i] != candidate.parameters[i]) {
                    Config.requireTypeAdjustment();
                    if (roleParams[i].isCompatibleWith(candidate.parameters[i]) && !Config.getLoweringRequired()) {
                        roleMethodSpec.resolvedMethod.parameters[i] = candidate.parameters[i];
                    }
                }
                ++i;
            }
        }
        callout.baseMethodSpec = this.fromMethodBinding(candidate, gen);
        if (!callout.checkVisibility(callout.scope, callout.baseMethodSpec, baseType)) {
            return false;
        }
        CallinCalloutBinding calloutBinding = callout.scope.createBinding(callout);
        calloutBinding.inferred = kind;
        calloutBinding._baseMethods = new MethodBinding[]{candidate};
        roleClass.binding.addCallinCallouts(new CallinCalloutBinding[]{calloutBinding});
        callout.checkReturnCompatibility(callout.roleMethodSpec);
        callout.checkReturnCompatibility(callout.baseMethodSpec);
        this.createCallout(callout, true, true);
        return true;
    }

    private MethodBinding inferBaseMethod(CalloutMappingDeclaration callout, ReferenceBinding baseType, char[] selector, TypeBinding[] roleParams) {
        ArrayList<MethodBinding> candidates = new ArrayList<MethodBinding>();
        while (baseType != null) {
            try {
                MethodBinding[] methodBindingArray = baseType.methods();
                int n = methodBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MethodBinding method = methodBindingArray[n2];
                    if (CharOperation.equals(method.selector, selector) && method.parameters.length == roleParams.length) {
                        candidates.add(method);
                    }
                    ++n2;
                }
            }
            catch (AbortCompilation ac) {
                if (baseType.isBinaryBinding() && ac.problem.getID() == 0x1000144) {
                    return null;
                }
                throw ac;
            }
            for (MethodBinding candidate : candidates) {
                if (!callout.internalCheckParametersCompatibility(null, roleParams, candidate.parameters)) continue;
                return candidate;
            }
            baseType = baseType.superclass();
        }
        return null;
    }

    private MethodSpec fromMethodBinding(MethodBinding method, AstGenerator gen) {
        MethodSpec result = gen.methodSpec(method.selector);
        result.resolvedMethod = method;
        CalloutImplementor.setInferredReturnType(result, method.returnType, gen);
        result.initTranslationBits();
        return result;
    }

    private static MethodSpec fromMessageSend(TypeDeclaration roleClass, MessageSend send, TypeBinding[] roleParams, AstGenerator gen) {
        MethodSpec result = gen.methodSpec(send.selector);
        TypeBinding expectedType = send.expectedType;
        result.resolvedMethod = new MethodBinding(2, send.selector, expectedType, roleParams, null, roleClass.binding);
        CalloutImplementor.setInferredReturnType(result, expectedType, gen);
        result.initTranslationBits();
        return result;
    }

    private static void setInferredReturnType(MethodSpec methodSpec, TypeBinding expectedType, AstGenerator gen) {
        methodSpec.returnType = gen.singleTypeReference("<inferredType>".toCharArray());
        methodSpec.returnType.resolvedType = expectedType != null ? expectedType : TypeBinding.VOID;
    }

    public static CalloutMappingDeclaration inferCalloutAccess(Scope scope, Expression receiver, Expression location, char[] fieldName, boolean isSetter, TypeBinding expectedType) {
        if (receiver != null && !(receiver instanceof ThisReference)) {
            return null;
        }
        TypeDeclaration type = scope.referenceType();
        if (!type.isRole() || !type.getRoleModel().isBound()) {
            return null;
        }
        char[] accessorName = OTNameUtils.accessorName(isSetter, fieldName);
        CalloutMappingDeclaration callout = null;
        if (type.callinCallouts != null) {
            AbstractMethodMappingDeclaration[] abstractMethodMappingDeclarationArray = type.callinCallouts;
            int n = type.callinCallouts.length;
            int n2 = 0;
            while (n2 < n) {
                FieldBinding baseField;
                FieldAccessSpec fieldAccessSpec;
                CalloutMappingDeclaration candidate;
                AbstractMethodMappingDeclaration mapping = abstractMethodMappingDeclarationArray[n2];
                if (mapping.isCallout() && (candidate = (CalloutMappingDeclaration)mapping).isCalloutToField() && (fieldAccessSpec = (FieldAccessSpec)candidate.baseMethodSpec).isSetter() == isSetter && (baseField = fieldAccessSpec.resolvedField) != null && baseField.isValidBinding() && CharOperation.equals(baseField.name, fieldName) && CharOperation.equals(candidate.roleMethodSpec.selector, accessorName)) {
                    callout = candidate;
                    break;
                }
                ++n2;
            }
        }
        if (callout == null) {
            AstGenerator gen = new AstGenerator(location.sourceStart, location.sourceEnd);
            callout = CalloutImplementor.inferCalloutToField(type, fieldName, accessorName, isSetter, expectedType, gen);
        }
        if (callout != null) {
            if ((location.bits & 0x10000) != 0) {
                scope.problemReporter().inferredCalloutInCompoundAssignment(location, fieldName);
                return null;
            }
            scope.problemReporter().inferredUseOfCalloutToField(isSetter, location, fieldName, ((FieldAccessSpec)callout.baseMethodSpec).resolvedField);
        }
        return callout;
    }

    private static CalloutMappingDeclaration inferCalloutToField(TypeDeclaration roleClass, char[] fieldName, char[] accessorName, boolean isSetter, TypeBinding expectedType, AstGenerator gen) {
        CalloutMappingDeclaration callout;
        ReferenceBinding baseclass = roleClass.binding.baseclass();
        if (baseclass == null || !baseclass.isValidBinding()) {
            return null;
        }
        FieldBinding baseField = TypeAnalyzer.findField(baseclass, fieldName, false, false);
        if (baseField == null) {
            return null;
        }
        FieldModel fieldModel = FieldModel.getModel(baseField);
        CalloutMappingDeclaration calloutMappingDeclaration = callout = isSetter ? fieldModel._setterCallout : fieldModel._getterCallout;
        if (callout != null) {
            return callout;
        }
        callout = gen.calloutMappingDeclaration(roleClass.compilationResult);
        callout.hasSignature = true;
        if (isSetter) {
            fieldModel._setterCallout = callout;
            CalloutImplementor.fillInferredCalloutSetToField(callout, accessorName, baseField, gen);
        } else {
            fieldModel._getterCallout = callout;
            CalloutImplementor.fillInferredCalloutGetToField(callout, accessorName, baseField, expectedType, gen);
        }
        callout.scope = new CallinCalloutScope(roleClass.scope, callout);
        CallinCalloutBinding calloutBinding = callout.scope.createBinding(callout);
        callout.resolveMethodSpecs(roleClass.getRoleModel(), baseclass, true);
        calloutBinding.inferred = isSetter ? InferenceKind.FIELDSET : InferenceKind.FIELDGET;
        calloutBinding._baseMethods = new MethodBinding[]{callout.baseMethodSpec.resolvedMethod};
        roleClass.binding.addCallinCallouts(new CallinCalloutBinding[]{calloutBinding});
        new CalloutImplementor(roleClass.getRoleModel()).createCallout(callout, true, true);
        return callout;
    }

    private static void fillInferredCalloutGetToField(CalloutMappingDeclaration callout, char[] accessorName, FieldBinding baseField, TypeBinding expectedType, AstGenerator gen) {
        MethodSpec roleMethodSpec = gen.methodSpec(accessorName);
        roleMethodSpec.hasSignature = true;
        callout.roleMethodSpec = roleMethodSpec;
        roleMethodSpec.returnType = gen.typeReference(expectedType != null ? expectedType : baseField.type);
        roleMethodSpec.arguments = new Argument[0];
        FieldAccessSpec fieldAccessSpec = gen.fieldAccessSpec(baseField.name, baseField.type, false);
        fieldAccessSpec.hasSignature = true;
        callout.baseMethodSpec = fieldAccessSpec;
    }

    private static void fillInferredCalloutSetToField(CalloutMappingDeclaration callout, char[] accessorName, FieldBinding baseField, AstGenerator gen) {
        MethodSpec roleMethodSpec = gen.methodSpec(accessorName);
        roleMethodSpec.hasSignature = true;
        callout.roleMethodSpec = roleMethodSpec;
        roleMethodSpec.returnType = gen.singleTypeReference(TypeConstants.VOID);
        roleMethodSpec.arguments = new Argument[]{gen.argument(baseField.name, gen.typeReference(baseField.type))};
        FieldAccessSpec fieldAccessSpec = gen.fieldAccessSpec(baseField.name, baseField.type, true);
        fieldAccessSpec.hasSignature = true;
        callout.baseMethodSpec = fieldAccessSpec;
    }
}

