/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.codeassist.select.SelectionNodeFound;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TSuperHelper;

public abstract class TypeReference
extends Expression {
    private Expression.DecapsulationState baseclassDecapsulation = Expression.DecapsulationState.NONE;
    public int deprecationProblemId = 0x1000005;

    public void setBaseclassDecapsulation(Expression.DecapsulationState state) {
        this.baseclassDecapsulation = state;
    }

    public Expression.DecapsulationState getBaseclassDecapsulation() {
        return this.baseclassDecapsulation;
    }

    public void tagReportedBaseclassDecapsulation() {
        this.setBaseclassDecapsulation(Expression.DecapsulationState.REPORTED);
    }

    public static final TypeReference baseTypeReference(int baseType, int dim) {
        if (dim == 0) {
            switch (baseType) {
                case 6: {
                    return new SingleTypeReference(TypeBinding.VOID.simpleName, 0L);
                }
                case 5: {
                    return new SingleTypeReference(TypeBinding.BOOLEAN.simpleName, 0L);
                }
                case 2: {
                    return new SingleTypeReference(TypeBinding.CHAR.simpleName, 0L);
                }
                case 9: {
                    return new SingleTypeReference(TypeBinding.FLOAT.simpleName, 0L);
                }
                case 8: {
                    return new SingleTypeReference(TypeBinding.DOUBLE.simpleName, 0L);
                }
                case 3: {
                    return new SingleTypeReference(TypeBinding.BYTE.simpleName, 0L);
                }
                case 4: {
                    return new SingleTypeReference(TypeBinding.SHORT.simpleName, 0L);
                }
                case 10: {
                    return new SingleTypeReference(TypeBinding.INT.simpleName, 0L);
                }
            }
            return new SingleTypeReference(TypeBinding.LONG.simpleName, 0L);
        }
        switch (baseType) {
            case 6: {
                return new ArrayTypeReference(TypeBinding.VOID.simpleName, dim, 0L);
            }
            case 5: {
                return new ArrayTypeReference(TypeBinding.BOOLEAN.simpleName, dim, 0L);
            }
            case 2: {
                return new ArrayTypeReference(TypeBinding.CHAR.simpleName, dim, 0L);
            }
            case 9: {
                return new ArrayTypeReference(TypeBinding.FLOAT.simpleName, dim, 0L);
            }
            case 8: {
                return new ArrayTypeReference(TypeBinding.DOUBLE.simpleName, dim, 0L);
            }
            case 3: {
                return new ArrayTypeReference(TypeBinding.BYTE.simpleName, dim, 0L);
            }
            case 4: {
                return new ArrayTypeReference(TypeBinding.SHORT.simpleName, dim, 0L);
            }
            case 10: {
                return new ArrayTypeReference(TypeBinding.INT.simpleName, dim, 0L);
            }
        }
        return new ArrayTypeReference(TypeBinding.LONG.simpleName, dim, 0L);
    }

    public void aboutToResolve(Scope scope) {
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return flowInfo;
    }

    public void checkBounds(Scope scope) {
    }

    public abstract TypeReference copyDims(int var1);

    public int dimensions() {
        return 0;
    }

    public abstract char[] getLastToken();

    public char[][] getParameterizedTypeName() {
        return this.getTypeName();
    }

    protected abstract TypeBinding getTypeBinding(Scope var1);

    public abstract char[][] getTypeName();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected TypeBinding internalResolveType(Scope scope) {
        TypeBinding type;
        block30: {
            this.constant = Constant.NotAConstant;
            if (this.resolvedType != null) {
                if (this.resolvedType.isValidBinding()) {
                    return this.resolvedType;
                }
                switch (this.resolvedType.problemId()) {
                    case 1: 
                    case 2: 
                    case 5: {
                        TypeBinding type2 = this.resolvedType.closestMatch();
                        if (type2 != null) return scope.environment().convertToRawType(type2, false);
                        return null;
                    }
                }
                return null;
            }
            SelectionNodeFound caughtException = null;
            type = null;
            try {
                CompilationResult compilationResult = scope.referenceCompilationUnit().compilationResult();
                CompilationResult.CheckPoint cp = compilationResult.getCheckPoint(scope.referenceContext());
                try {
                    type = this.checkResolveUsingBaseImportScope(scope);
                    if (type != null && type.isValidBinding()) {
                        type = scope.environment().convertToRawType(type, false);
                        if (type.leafComponentType().isRawType() && (this.bits & 0x40000000) == 0 && scope.compilerOptions().getSeverity(0x20010000) != 256) {
                            scope.problemReporter().rawTypeReference(this, type);
                        }
                        TypeBinding typeBinding = type;
                        return typeBinding;
                    }
                }
                catch (SelectionNodeFound snf) {
                    if (snf.binding != null) {
                        throw snf;
                    }
                    caughtException = snf;
                }
                finally {
                    if (caughtException != null || type == null || !type.isValidBinding()) {
                        compilationResult.rollBack(cp);
                    }
                }
                type = this.resolvedType = this.getTypeBinding(scope);
                if (type == null) {
                    return null;
                }
            }
            catch (SelectionNodeFound snf) {
                if (snf.binding != null) {
                    throw snf;
                }
                caughtException = snf;
            }
            try {
                try {
                    TypeBinding result;
                    if ((caughtException != null || this.resolvedType.problemId() == 1) && (result = this.resolveAnchoredType(scope)) != null) {
                        type = this.resolvedType = result;
                    }
                }
                catch (SelectionNodeFound snf2) {
                    caughtException = snf2;
                    if (caughtException != null) {
                        throw caughtException;
                    }
                    break block30;
                }
            }
            catch (Throwable throwable) {
                if (caughtException == null) throw throwable;
                throw caughtException;
            }
            if (caughtException != null) {
                throw caughtException;
            }
        }
        boolean hasError = !type.isValidBinding();
        if (!hasError) return this.checkResolvedType(type, scope, hasError);
        this.reportInvalidType(scope);
        switch (type.problemId()) {
            case 1: 
            case 2: 
            case 5: {
                type = type.closestMatch();
                if (type != null) return this.checkResolvedType(type, scope, hasError);
                return null;
            }
        }
        return null;
    }

    public TypeBinding checkResolvedType(TypeBinding type, Scope scope, boolean hasError) {
        if (type.isArrayType() && ((ArrayBinding)type).leafComponentType == TypeBinding.VOID) {
            scope.problemReporter().cannotAllocateVoidArray(this);
            return null;
        }
        if (!(this instanceof QualifiedTypeReference) && this.isTypeUseDeprecated(type, scope)) {
            this.reportDeprecatedType(type, scope);
        }
        if ((type = scope.environment().convertToRawType(type, false)).leafComponentType().isRawType() && (this.bits & 0x40000000) == 0 && scope.compilerOptions().getSeverity(0x20010000) != 256) {
            scope.problemReporter().rawTypeReference(this, type);
        }
        if (hasError) {
            return type;
        }
        this.resolvedType = type;
        return this.resolvedType;
    }

    public TypeBinding checkResolveUsingBaseImportScope(Scope scope) {
        return null;
    }

    TypeBinding resolveAnchoredType(Scope scope) {
        return null;
    }

    protected boolean shouldAnalyzeRoleReference() {
        if ((this.bits & 0x8000) != 0) {
            return false;
        }
        return this.resolvedType.isRole() && !TSuperHelper.isMarkerInterface(this.resolvedType);
    }

    protected boolean isIllegalQualifiedUseOfProtectedRole(Scope scope) {
        if (((ReferenceBinding)this.resolvedType).isProtected() && !this.getBaseclassDecapsulation().isAllowed()) {
            scope.problemReporter().qualifiedProtectedRole(this, (ReferenceBinding)this.resolvedType);
            this.resolvedType = new ProblemReferenceBinding(((ReferenceBinding)this.resolvedType).compoundName, (ReferenceBinding)this.resolvedType, 2);
            return true;
        }
        return false;
    }

    public boolean isTypeReference() {
        return true;
    }

    public boolean isDeclaredLifting() {
        return false;
    }

    protected void reportDeprecatedType(TypeBinding type, Scope scope, int index) {
        scope.problemReporter().deprecatedType(type, this, index);
    }

    protected void reportDeprecatedType(TypeBinding type, Scope scope) {
        if (this.deprecationProblemId == 0) {
            return;
        }
        if (this.deprecationProblemId == 1201299) {
            scope.problemReporter().deprecatedBaseclass(this, type);
        } else {
            scope.problemReporter().deprecatedType(type, this, Integer.MAX_VALUE);
        }
    }

    protected void reportInvalidType(Scope scope) {
        if (scope.isFakeMethod(MethodModel.FakeKind.ROLE_FEATURE_BRIDGE)) {
            scope.referenceContext().tagAsHavingErrors();
            return;
        }
        scope.problemReporter().invalidType(this, this.resolvedType);
    }

    public TypeBinding resolveSuperType(ClassScope scope) {
        TypeBinding superType = this.resolveType(scope);
        if (superType == null) {
            return null;
        }
        if (superType.isTypeVariable()) {
            if (this.resolvedType.isValidBinding()) {
                this.resolvedType = new ProblemReferenceBinding(this.getTypeName(), (ReferenceBinding)this.resolvedType, 9);
                this.reportInvalidType(scope);
            }
            return null;
        }
        return superType;
    }

    public final TypeBinding resolveType(BlockScope blockScope) {
        return this.resolveType(blockScope, true);
    }

    public TypeBinding resolveType(BlockScope scope, boolean checkBounds) {
        return this.internalResolveType(scope);
    }

    public TypeBinding resolveType(ClassScope scope) {
        return this.internalResolveType(scope);
    }

    public TypeBinding resolveTypeArgument(BlockScope blockScope, ReferenceBinding genericType, int rank) {
        return this.resolveType(blockScope, true);
    }

    public TypeBinding resolveTypeArgument(ClassScope classScope, ReferenceBinding genericType, int rank) {
        SourceTypeBinding ref = classScope.referenceContext.binding;
        boolean pauseHierarchyCheck = false;
        try {
            if (ref.isHierarchyBeingConnected()) {
                ref.tagBits |= 0x80000L;
                pauseHierarchyCheck = true;
            }
            TypeBinding typeBinding = this.resolveType(classScope);
            return typeBinding;
        }
        finally {
            if (pauseHierarchyCheck) {
                ref.tagBits &= 0xFFFFFFFFFFF7FFFFL;
            }
        }
    }

    public abstract void traverse(ASTVisitor var1, BlockScope var2);

    public abstract void traverse(ASTVisitor var1, ClassScope var2);
}

