/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class SyntheticMethodBinding
extends MethodBinding {
    public FieldBinding targetReadField;
    public FieldBinding targetWriteField;
    public MethodBinding targetMethod;
    public TypeBinding targetEnumType;
    public int purpose;
    public static final int FieldReadAccess = 1;
    public static final int FieldWriteAccess = 2;
    public static final int SuperFieldReadAccess = 3;
    public static final int SuperFieldWriteAccess = 4;
    public static final int MethodAccess = 5;
    public static final int ConstructorAccess = 6;
    public static final int SuperMethodAccess = 7;
    public static final int BridgeMethod = 8;
    public static final int EnumValues = 9;
    public static final int EnumValueOf = 10;
    public static final int SwitchTable = 11;
    public static final int InferredCalloutToField = 12;
    public static final int RoleMethodBridgeOuter = 13;
    public static final int RoleMethodBridgeInner = 14;
    public int sourceStart = 0;
    public int index;

    public SyntheticMethodBinding(MethodBinding fakedMethod, int purpose) {
        this(fakedMethod.declaringClass, fakedMethod.modifiers, fakedMethod.selector, fakedMethod.parameters, fakedMethod.returnType);
        this.targetMethod = fakedMethod;
        this.purpose = purpose;
    }

    protected SyntheticMethodBinding(ReferenceBinding declaringClass, int modifiers, char[] selector, TypeBinding[] parameters, TypeBinding returnType) {
        this.declaringClass = declaringClass;
        this.modifiers = modifiers;
        this.selector = selector;
        this.parameters = parameters;
        this.returnType = returnType;
        this.thrownExceptions = NO_EXCEPTIONS;
    }

    public static boolean isCalloutToStaticField(MethodBinding methodBinding) {
        if (!(methodBinding instanceof SyntheticMethodBinding)) {
            return false;
        }
        SyntheticMethodBinding synthMeth = (SyntheticMethodBinding)methodBinding;
        return synthMeth.purpose == 12 && synthMeth.targetMethod.isStatic();
    }

    public void generateStaticCTFArgs(CodeStream codeStream, BlockScope scope, ASTNode node, int depth) {
        codeStream.iconst_0();
        ReferenceBinding targetType = scope.enclosingSourceType().enclosingTypeAt(depth);
        Object[] emulationPath = scope.getEmulationPath(targetType, true, false);
        codeStream.generateOuterAccess(emulationPath, node, targetType, scope);
    }

    public SyntheticMethodBinding(FieldBinding targetField, boolean isReadAccess, boolean isSuperAccess, ReferenceBinding declaringClass) {
        boolean needRename;
        int methodId;
        this.modifiers = 4104;
        if (declaringClass.isTeam()) {
            this.modifiers |= 1;
        }
        this.tagBits |= 0x600000000L;
        SourceTypeBinding declaringSourceType = (SourceTypeBinding)declaringClass;
        SyntheticMethodBinding[] knownAccessMethods = declaringSourceType.syntheticMethods();
        this.index = methodId = knownAccessMethods == null ? 0 : knownAccessMethods.length;
        this.selector = CharOperation.concat(TypeConstants.SYNTHETIC_ACCESS_METHOD_PREFIX, String.valueOf(methodId).toCharArray());
        TypeBinding receiverParameterType = this.getReceiverParameterType(targetField, declaringSourceType);
        if (isReadAccess) {
            this.returnType = targetField.type;
            if (targetField.isStatic()) {
                this.parameters = Binding.NO_PARAMETERS;
            } else {
                this.parameters = new TypeBinding[1];
                this.parameters[0] = receiverParameterType;
            }
            this.targetReadField = targetField;
            this.purpose = isSuperAccess ? 3 : 1;
        } else {
            this.returnType = TypeBinding.VOID;
            if (targetField.isStatic()) {
                this.parameters = new TypeBinding[1];
                this.parameters[0] = targetField.type;
            } else {
                this.parameters = new TypeBinding[2];
                this.parameters[0] = receiverParameterType;
                this.parameters[1] = targetField.type;
            }
            this.targetWriteField = targetField;
            this.purpose = isSuperAccess ? 4 : 2;
        }
        this.thrownExceptions = Binding.NO_EXCEPTIONS;
        this.declaringClass = declaringSourceType;
        do {
            block20: {
                needRename = false;
                MethodBinding[] methods = declaringSourceType.methods();
                long range = ReferenceBinding.binarySearch(this.selector, methods);
                if (range >= 0L) {
                    int paramCount = this.parameters.length;
                    int imethod = (int)range;
                    int end = (int)(range >> 32);
                    while (imethod <= end) {
                        block19: {
                            MethodBinding method = methods[imethod];
                            if (method.parameters.length == paramCount) {
                                TypeBinding[] toMatch = method.parameters;
                                int i = 0;
                                while (i < paramCount) {
                                    if (toMatch[i] == this.parameters[i]) {
                                        ++i;
                                        continue;
                                    }
                                    break block19;
                                }
                                needRename = true;
                                break block20;
                            }
                        }
                        ++imethod;
                    }
                }
                if (knownAccessMethods != null) {
                    int i = 0;
                    int length = knownAccessMethods.length;
                    while (i < length) {
                        if (knownAccessMethods[i] != null && CharOperation.equals(this.selector, knownAccessMethods[i].selector) && this.areParametersEqual(methods[i])) {
                            needRename = true;
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (!needRename) continue;
            this.setSelector(CharOperation.concat(TypeConstants.SYNTHETIC_ACCESS_METHOD_PREFIX, String.valueOf(++methodId).toCharArray()));
        } while (needRename);
        FieldDeclaration[] fieldDecls = declaringSourceType.scope.referenceContext.fields;
        if (fieldDecls != null) {
            int i = 0;
            int max = fieldDecls.length;
            while (i < max) {
                if (fieldDecls[i].binding == targetField) {
                    this.sourceStart = fieldDecls[i].sourceStart;
                    return;
                }
                ++i;
            }
        }
        this.sourceStart = declaringSourceType.scope.referenceContext.sourceStart;
    }

    protected TypeBinding getReceiverParameterType(FieldBinding targetField, ReferenceBinding declaringSourceType) {
        return declaringSourceType;
    }

    public SyntheticMethodBinding(FieldBinding targetField, ReferenceBinding declaringClass, TypeBinding enumBinding, char[] selector) {
        boolean needRename;
        int methodId;
        this.modifiers = 4104;
        if (declaringClass.isTeam()) {
            this.modifiers |= 1;
        }
        this.tagBits |= 0x600000000L;
        SourceTypeBinding declaringSourceType = (SourceTypeBinding)declaringClass;
        SyntheticMethodBinding[] knownAccessMethods = declaringSourceType.syntheticMethods();
        this.index = methodId = knownAccessMethods == null ? 0 : knownAccessMethods.length;
        this.selector = selector;
        this.returnType = declaringSourceType.scope.createArrayType(TypeBinding.INT, 1);
        this.parameters = Binding.NO_PARAMETERS;
        this.targetReadField = targetField;
        this.targetEnumType = enumBinding;
        this.purpose = 11;
        this.thrownExceptions = Binding.NO_EXCEPTIONS;
        this.declaringClass = declaringSourceType;
        if (declaringSourceType.isStrictfp()) {
            this.modifiers |= 0x800;
        }
        do {
            block12: {
                needRename = false;
                MethodBinding[] methods = declaringSourceType.methods();
                long range = ReferenceBinding.binarySearch(this.selector, methods);
                if (range >= 0L) {
                    int paramCount = this.parameters.length;
                    int imethod = (int)range;
                    int end = (int)(range >> 32);
                    while (imethod <= end) {
                        block11: {
                            MethodBinding method = methods[imethod];
                            if (method.parameters.length == paramCount) {
                                TypeBinding[] toMatch = method.parameters;
                                int i = 0;
                                while (i < paramCount) {
                                    if (toMatch[i] == this.parameters[i]) {
                                        ++i;
                                        continue;
                                    }
                                    break block11;
                                }
                                needRename = true;
                                break block12;
                            }
                        }
                        ++imethod;
                    }
                }
                if (knownAccessMethods != null) {
                    int i = 0;
                    int length = knownAccessMethods.length;
                    while (i < length) {
                        if (knownAccessMethods[i] != null && CharOperation.equals(this.selector, knownAccessMethods[i].selector) && this.areParametersEqual(methods[i])) {
                            needRename = true;
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (!needRename) continue;
            this.setSelector(CharOperation.concat(selector, String.valueOf(++methodId).toCharArray()));
        } while (needRename);
        this.sourceStart = declaringSourceType.scope.referenceContext.sourceStart;
    }

    public SyntheticMethodBinding(MethodBinding targetMethod, boolean isSuperAccess, ReferenceBinding declaringClass) {
        if (targetMethod.isConstructor()) {
            this.initializeConstructorAccessor(targetMethod);
        } else {
            this.initializeMethodAccessor(targetMethod, isSuperAccess, declaringClass);
        }
    }

    public SyntheticMethodBinding(MethodBinding overridenMethodToBridge, MethodBinding targetMethod, SourceTypeBinding declaringClass) {
        int methodId;
        this.declaringClass = declaringClass;
        this.selector = overridenMethodToBridge.selector;
        this.modifiers = (targetMethod.modifiers | 0x40 | 0x1000) & 0xBFFFFAEF;
        if (targetMethod.declaringClass.isRole()) {
            this.modifiers = this.modifiers & 0xFFFFFFF8 | 1;
        }
        this.tagBits |= 0x600000000L;
        this.returnType = overridenMethodToBridge.returnType;
        this.parameters = overridenMethodToBridge.parameters;
        this.thrownExceptions = overridenMethodToBridge.thrownExceptions;
        this.targetMethod = targetMethod;
        this.purpose = 8;
        SyntheticMethodBinding[] knownAccessMethods = declaringClass.syntheticMethods();
        this.index = methodId = knownAccessMethods == null ? 0 : knownAccessMethods.length;
    }

    public SyntheticMethodBinding(SourceTypeBinding declaringEnum, char[] selector) {
        int methodId;
        this.declaringClass = declaringEnum;
        this.selector = selector;
        this.modifiers = 9;
        this.tagBits |= 0x600000000L;
        LookupEnvironment environment = declaringEnum.scope.environment();
        this.thrownExceptions = Binding.NO_EXCEPTIONS;
        if (selector == TypeConstants.VALUES) {
            this.returnType = environment.createArrayType(environment.convertToParameterizedType(declaringEnum), 1);
            this.parameters = Binding.NO_PARAMETERS;
            this.purpose = 9;
        } else if (selector == TypeConstants.VALUEOF) {
            this.returnType = environment.convertToParameterizedType(declaringEnum);
            this.parameters = new TypeBinding[]{declaringEnum.scope.getJavaLangString()};
            this.purpose = 10;
        }
        SyntheticMethodBinding[] knownAccessMethods = ((SourceTypeBinding)this.declaringClass).syntheticMethods();
        this.index = methodId = knownAccessMethods == null ? 0 : knownAccessMethods.length;
        if (declaringEnum.isStrictfp()) {
            this.modifiers |= 0x800;
        }
    }

    public SyntheticMethodBinding(MethodBinding overridenMethodToBridge, SourceTypeBinding declaringClass) {
        int methodId;
        this.declaringClass = declaringClass;
        this.selector = overridenMethodToBridge.selector;
        this.modifiers = (overridenMethodToBridge.modifiers | 0x40 | 0x1000) & 0xBFFFFAEF;
        this.tagBits |= 0x600000000L;
        this.returnType = overridenMethodToBridge.returnType;
        this.parameters = overridenMethodToBridge.parameters;
        this.thrownExceptions = overridenMethodToBridge.thrownExceptions;
        this.targetMethod = overridenMethodToBridge;
        this.purpose = 7;
        SyntheticMethodBinding[] knownAccessMethods = declaringClass.syntheticMethods();
        this.index = methodId = knownAccessMethods == null ? 0 : knownAccessMethods.length;
    }

    public void initializeConstructorAccessor(MethodBinding accessedConstructor) {
        int length;
        int i;
        boolean needRename;
        this.targetMethod = accessedConstructor;
        this.modifiers = 4096;
        this.tagBits |= 0x600000000L;
        SourceTypeBinding sourceType = (SourceTypeBinding)accessedConstructor.declaringClass;
        SyntheticMethodBinding[] knownSyntheticMethods = sourceType.syntheticMethods();
        this.index = knownSyntheticMethods == null ? 0 : knownSyntheticMethods.length;
        this.selector = accessedConstructor.selector;
        this.returnType = accessedConstructor.returnType;
        this.purpose = 6;
        this.parameters = new TypeBinding[accessedConstructor.parameters.length + 1];
        System.arraycopy(accessedConstructor.parameters, 0, this.parameters, 0, accessedConstructor.parameters.length);
        this.parameters[accessedConstructor.parameters.length] = accessedConstructor.declaringClass;
        this.thrownExceptions = accessedConstructor.thrownExceptions;
        this.declaringClass = sourceType;
        do {
            block9: {
                needRename = false;
                MethodBinding[] methods = sourceType.methods();
                i = 0;
                length = methods.length;
                while (i < length) {
                    if (CharOperation.equals(this.selector, methods[i].selector) && this.areParameterErasuresEqual(methods[i])) {
                        needRename = true;
                        break block9;
                    }
                    ++i;
                }
                if (knownSyntheticMethods != null) {
                    i = 0;
                    length = knownSyntheticMethods.length;
                    while (i < length) {
                        if (knownSyntheticMethods[i] != null && CharOperation.equals(this.selector, knownSyntheticMethods[i].selector) && this.areParameterErasuresEqual(knownSyntheticMethods[i])) {
                            needRename = true;
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (!needRename) continue;
            int length2 = this.parameters.length;
            this.parameters = new TypeBinding[length2 + 1];
            System.arraycopy(this.parameters, 0, this.parameters, 0, length2);
            this.parameters[length2] = this.declaringClass;
        } while (needRename);
        AbstractMethodDeclaration[] methodDecls = sourceType.scope.referenceContext.methods;
        if (methodDecls != null) {
            i = 0;
            length = methodDecls.length;
            while (i < length) {
                if (methodDecls[i].binding == accessedConstructor) {
                    this.sourceStart = methodDecls[i].sourceStart;
                    return;
                }
                ++i;
            }
        }
    }

    public void initializeMethodAccessor(MethodBinding accessedMethod, boolean isSuperAccess, ReferenceBinding receiverType) {
        int length;
        int i;
        boolean needRename;
        int methodId;
        this.targetMethod = accessedMethod;
        this.modifiers = 4104;
        if (receiverType.isTeam()) {
            this.modifiers |= 1;
        }
        this.tagBits |= 0x600000000L;
        SourceTypeBinding declaringSourceType = (SourceTypeBinding)receiverType;
        SyntheticMethodBinding[] knownAccessMethods = declaringSourceType.syntheticMethods();
        this.index = methodId = knownAccessMethods == null ? 0 : knownAccessMethods.length;
        this.selector = CharOperation.concat(TypeConstants.SYNTHETIC_ACCESS_METHOD_PREFIX, String.valueOf(methodId).toCharArray());
        this.returnType = accessedMethod.returnType;
        int n = this.purpose = isSuperAccess ? 7 : 5;
        if (accessedMethod.needsSyntheticEnclosingTeamInstance()) {
            this.parameters = new TypeBinding[accessedMethod.parameters.length + 2];
            this.parameters[0] = TypeBinding.INT;
            this.parameters[1] = declaringSourceType.enclosingType();
            System.arraycopy(accessedMethod.parameters, 0, this.parameters, 2, accessedMethod.parameters.length);
        } else if (accessedMethod.isStatic()) {
            this.parameters = accessedMethod.parameters;
        } else {
            this.parameters = new TypeBinding[accessedMethod.parameters.length + 1];
            this.parameters[0] = declaringSourceType;
            System.arraycopy(accessedMethod.parameters, 0, this.parameters, 1, accessedMethod.parameters.length);
        }
        this.thrownExceptions = accessedMethod.thrownExceptions;
        this.declaringClass = declaringSourceType;
        do {
            block14: {
                needRename = false;
                MethodBinding[] methods = declaringSourceType.methods();
                i = 0;
                length = methods.length;
                while (i < length) {
                    if (CharOperation.equals(this.selector, methods[i].selector) && this.areParameterErasuresEqual(methods[i])) {
                        needRename = true;
                        break block14;
                    }
                    ++i;
                }
                if (knownAccessMethods != null) {
                    i = 0;
                    length = knownAccessMethods.length;
                    while (i < length) {
                        if (knownAccessMethods[i] != null && CharOperation.equals(this.selector, knownAccessMethods[i].selector) && this.areParameterErasuresEqual(knownAccessMethods[i])) {
                            needRename = true;
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (!needRename) continue;
            this.setSelector(CharOperation.concat(TypeConstants.SYNTHETIC_ACCESS_METHOD_PREFIX, String.valueOf(++methodId).toCharArray()));
        } while (needRename);
        AbstractMethodDeclaration[] methodDecls = declaringSourceType.scope.referenceContext.methods;
        if (methodDecls != null) {
            i = 0;
            length = methodDecls.length;
            while (i < length) {
                if (methodDecls[i].binding == accessedMethod) {
                    this.sourceStart = methodDecls[i].sourceStart;
                    return;
                }
                ++i;
            }
        }
    }

    protected boolean isConstructorRelated() {
        return this.purpose == 6;
    }
}

