/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.internal.core.OTType;

public class OTModelReconcileListener
implements IElementChangedListener {
    public void elementChanged(ElementChangedEvent event) {
        this.removeAffectedModelElements(new IJavaElementDelta[]{event.getDelta()});
    }

    private void removeAffectedModelElements(IJavaElementDelta[] deltas) {
        assert (deltas != null);
        int idx = 0;
        while (idx < deltas.length) {
            IJavaElementDelta delta = deltas[idx];
            IJavaElement elem = delta.getElement();
            if (elem instanceof IParent) {
                this.removeAffectedModelElements(delta.getAffectedChildren());
            }
            if (elem instanceof IType) {
                if (delta.getKind() == 4 && (delta.getFlags() & 2) != 0) {
                    OTModelManager.removeOTElement((IType)elem, true);
                } else if (delta.getKind() == 2) {
                    OTModelManager.removeOTElement((IType)elem);
                }
            }
            ++idx;
        }
    }

    private void checkWorkingCopies(IJavaElementDelta delta, IJavaElement elem) {
        if (elem instanceof ICompilationUnit) {
            ICompilationUnit unit = (ICompilationUnit)elem;
            if ((delta.getFlags() & 2) != 0 && unit.exists()) {
                try {
                    IType[] types = unit.getTypes();
                    System.out.println(types);
                }
                catch (JavaModelException ex) {
                    ex.printStackTrace();
                }
            }
            if ((delta.getFlags() & 0x10000) != 0 && !unit.isWorkingCopy() && unit.exists()) {
                try {
                    ICompilationUnit wc = unit.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                    IType[] wcTypes = wc.getTypes();
                    IType[] types = unit.getAllTypes();
                    int i = 0;
                    while (i < types.length) {
                        ICompilationUnit otUnit;
                        IOTType wcOTType;
                        IType wcType = wcTypes[i];
                        IType currentType = types[i];
                        OTType otType = (OTType)OTModelManager.getOTElement(currentType);
                        if (otType == (wcOTType = OTModelManager.getOTElement(wcType))) {
                            OTModelManager.getOTElement(currentType);
                            OTModelManager.getOTElement(wcType);
                            System.out.println("OTModelReconcileListener.removeAffectedModelElements()");
                        }
                        if (otType != null && (otUnit = otType.getCompilationUnit()).isWorkingCopy()) {
                            otType.setCorrespondingJavaElement(currentType);
                            System.out.println("Updated: " + otType.toString());
                        }
                        ++i;
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
        }
    }
}

