/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.core.exceptions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class ExceptionHandler {
    private String _pluginId;

    public ExceptionHandler(String pluginId) {
        this._pluginId = pluginId;
    }

    public static ExceptionHandler getOTDTCoreExceptionHandler() {
        return new ExceptionHandler("org.eclipse.jdt.core");
    }

    public void logException(Throwable ex) {
        this.logException(null, ex);
    }

    public void logException(String msg, Throwable ex) {
        this.logErrorLog(this._pluginId, ex);
    }

    public void logCoreException(String msg, CoreException ex) {
        this.logErrorLog(msg, ex);
    }

    private void logErrorLog(String msg, Throwable ex) {
        Bundle bundle = Platform.getBundle((String)this._pluginId);
        if (bundle == null) {
            System.err.println("Warning: " + this._pluginId + " is not a valid Plugin identifier!");
            ex.printStackTrace(System.err);
        } else {
            Platform.getLog((Bundle)bundle).log((IStatus)new Status(4, this._pluginId, 0, msg, ex));
        }
    }
}

