/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core;

import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.objectteams.otdt.core.ICalloutMapping;
import org.eclipse.objectteams.otdt.core.IMethodMapping;
import org.eclipse.objectteams.otdt.core.IRoleType;
import org.eclipse.objectteams.otdt.core.TypeHelper;
import org.eclipse.objectteams.otdt.core.util.MethodData;
import org.eclipse.objectteams.otdt.internal.core.AbstractCalloutMapping;
import org.eclipse.objectteams.otdt.internal.core.OTJavaElement;
import org.eclipse.objectteams.otdt.internal.core.ResolvedCalloutMapping;

public class CalloutMapping
extends AbstractCalloutMapping
implements ICalloutMapping {
    private boolean _isOverride;
    private IMethod _baseMethod;
    private MethodData _baseMethodHandle;
    private int _declaredModifiers;

    public CalloutMapping(int declarationSourceStart, int sourceStart, int sourceEnd, int declarationSourceEnd, IRoleType role, IMethod corrJavaMethod, MethodData roleMethodHandle, MethodData baseMethodHandle, boolean hasSignature, boolean isOverride, int declaredModifiers) {
        this(declarationSourceStart, sourceStart, sourceEnd, declarationSourceEnd, 103, role, corrJavaMethod, roleMethodHandle, baseMethodHandle, hasSignature, isOverride, declaredModifiers);
    }

    protected CalloutMapping(int declarationSourceStart, int sourceStart, int sourceEnd, int declarationSourceEnd, int elementType, IType parentRole, IMethod corrJavaMethod, MethodData roleMethodHandle, MethodData baseMethodHandle, boolean hasSignature, boolean isOverride, int declaredModifiers) {
        super(declarationSourceStart, sourceStart, sourceEnd, declarationSourceEnd, elementType, corrJavaMethod, parentRole, roleMethodHandle, hasSignature);
        this._isOverride = isOverride;
        this._baseMethodHandle = baseMethodHandle;
        this._declaredModifiers = declaredModifiers;
    }

    protected CalloutMapping(int declarationSourceStart, int sourceStart, int sourceEnd, int declarationSourceEnd, int elementType, IType parentRole, IMethod corrJavaMethod, MethodData roleMethodHandle, MethodData baseMethodHandle, boolean hasSignature, boolean isOverride, int declaredModifiers, boolean addAsChild) {
        super(declarationSourceStart, sourceStart, sourceEnd, declarationSourceEnd, elementType, corrJavaMethod, parentRole, roleMethodHandle, hasSignature, addAsChild);
        this._isOverride = isOverride;
        this._baseMethodHandle = baseMethodHandle;
        this._declaredModifiers = declarationSourceEnd;
    }

    public IMethodMapping createStealthMethodMapping() {
        CalloutMapping result = new CalloutMapping(this.getDeclarationSourceStart(), this.getSourceStart(), this.getSourceEnd(), this.getDeclarationSourceEnd(), 9, (IType)this.getCorrespondingJavaElement().getParent(), this.getIMethod(), this.getRoleMethodHandle(), this.getBaseMethodHandle(), this.hasSignature(), this.isOverride(), this.getDeclaredModifiers(), false);
        result._mimicMethodDecl = true;
        result._originalMethodMapping = this;
        return result;
    }

    public boolean isOverride() {
        return this._isOverride;
    }

    public String getElementName() {
        if (this._mimicMethodDecl) {
            MethodData roleMethodHandle = this.getRoleMethodHandle();
            if (roleMethodHandle != null) {
                return roleMethodHandle.getSelector();
            }
            return "(unknown role method)";
        }
        StringBuffer name = new StringBuffer(super.getElementName());
        name.append(" -> ");
        if (this._baseMethodHandle == null) {
            name.append("(unknown)");
        } else if (this.hasSignature()) {
            name.append(this._baseMethodHandle.toString());
        } else {
            name.append(this._baseMethodHandle.getSelector());
        }
        return name.toString();
    }

    public int getMappingKind() {
        return 103;
    }

    public int getDeclaredModifiers() {
        return this._declaredModifiers;
    }

    public IMethod getBoundBaseMethod() throws JavaModelException {
        if (this._baseMethod == null) {
            this._baseMethod = this.findBaseMethod();
        }
        return this._baseMethod;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CalloutMapping)) {
            return false;
        }
        return super.equals(obj);
    }

    public String toString() {
        return "callout " + super.toString();
    }

    private IMethod findBaseMethod() throws JavaModelException {
        if (this._baseMethodHandle == null) {
            return null;
        }
        IType baseClass = ((IRoleType)this.getParent()).getBaseClass();
        IType[] typeParents = TypeHelper.getSuperTypes(baseClass);
        return this.findMethod(typeParents, this._baseMethodHandle);
    }

    public MethodData getBaseMethodHandle() {
        return this._baseMethodHandle;
    }

    protected char getMappingKindChar() {
        if (this._isOverride) {
            return 'O';
        }
        return 'o';
    }

    protected void getBaseMethodsForHandle(StringBuffer buff) {
        if (this._baseMethodHandle != null) {
            this.getMethodForHandle(this._baseMethodHandle, buff);
        }
    }

    public OTJavaElement resolved(char[] uniqueKey) {
        ResolvedCalloutMapping resolvedHandle = new ResolvedCalloutMapping(this.getDeclarationSourceStart(), this.getSourceStart(), this.getSourceEnd(), this.getDeclarationSourceEnd(), this.getElementType(), (IType)this.getParent(), this.getIMethod(), this.getRoleMethodHandle(), this._baseMethodHandle, this.hasSignature(), this.isOverride(), this.getDeclaredModifiers(), new String(uniqueKey));
        if (this.isStealthMethodMapping()) {
            resolvedHandle._originalMethodMapping = this._originalMethodMapping;
        }
        return resolvedHandle;
    }

    public String[] getExceptionTypes() throws JavaModelException {
        MethodData roleMethodHandle = this.getRoleMethodHandle();
        if (roleMethodHandle != null && !roleMethodHandle.isIncomplete()) {
            try {
                return this.getIMethod().getExceptionTypes();
            }
            catch (JavaModelException javaModelException) {
                return new String[0];
            }
        }
        return this.getIMethod().getExceptionTypes();
    }
}

