/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.TypeParameter;
import org.eclipse.jdt.internal.core.util.MementoTokenizer;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.objectteams.otdt.core.IMethodMapping;
import org.eclipse.objectteams.otdt.core.IOTJavaElement;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.IRoleType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.core.TypeHelper;
import org.eclipse.objectteams.otdt.core.exceptions.ExceptionHandler;
import org.eclipse.objectteams.otdt.core.util.MethodData;
import org.eclipse.objectteams.otdt.internal.core.AbstractCalloutMapping;
import org.eclipse.objectteams.otdt.internal.core.OTJavaElement;

public abstract class MethodMapping
extends OTJavaElement
implements IMethodMapping {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static final ITypeParameter[] NO_TYPE_PARAMETERS = new ITypeParameter[0];
    private int _declarationSourceStart;
    private int _sourceStart;
    private int _sourceEnd;
    private int _declarationSourceEnd;
    private IMethod _roleMethod;
    private MethodData _roleMethodHandle;
    private boolean _hasSignature;

    public MethodMapping(int declarationSourceStart, int sourceStart, int sourceEnd, int declarationSourceEnd, int type, IMethod correspondingJavaElem, IType parent, MethodData roleMethodHandle, boolean hasSignature) {
        super(type, correspondingJavaElem, parent);
        this._roleMethodHandle = roleMethodHandle;
        this._declarationSourceStart = declarationSourceStart;
        this._sourceStart = sourceStart;
        this._sourceEnd = sourceEnd;
        this._declarationSourceEnd = declarationSourceEnd;
        this._hasSignature = hasSignature;
    }

    public MethodMapping(int declarationSourceStart, int sourceStart, int sourceEnd, int declarationSourceEnd, int type, IMethod correspondingJavaElem, IType parent, MethodData roleMethodHandle, boolean hasSignature, boolean addAsChild) {
        super(type, correspondingJavaElem, parent, addAsChild);
        this._roleMethodHandle = roleMethodHandle;
        this._declarationSourceStart = declarationSourceStart;
        this._sourceStart = sourceStart;
        this._sourceEnd = sourceEnd;
        this._declarationSourceEnd = declarationSourceEnd;
        this._hasSignature = hasSignature;
    }

    public String getHandleIdentifier() {
        StringBuffer buff = new StringBuffer();
        IJavaElement parent = this.getParent();
        if (parent instanceof IOTJavaElement) {
            parent = ((IOTJavaElement)parent).getCorrespondingJavaElement();
        }
        buff.append(((JavaElement)parent).getHandleMemento());
        char delimiter = '`';
        buff.append(delimiter);
        buff.append(this.getMappingKindChar());
        buff.append(this._hasSignature ? (char)'l' : 's');
        buff.append(delimiter);
        this.getNameForHandle(buff);
        this.getMethodForHandle(this._roleMethodHandle, buff);
        this.getBaseMethodsForHandle(buff);
        buff.append(delimiter);
        return buff.toString();
    }

    protected void getNameForHandle(StringBuffer buff) {
    }

    protected abstract char getMappingKindChar();

    protected abstract void getBaseMethodsForHandle(StringBuffer var1);

    protected void getMethodForHandle(MethodData method, StringBuffer buff) {
        JavaElement.escapeMementoName(buff, method.getSelector());
        if (this._hasSignature) {
            String[] stringArray = method.getArgumentTypes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String argType = stringArray[n2];
                buff.append('~');
                JavaElement.escapeMementoName(buff, argType);
                ++n2;
            }
            buff.append('~');
            JavaElement.escapeMementoName(buff, method.getReturnType());
        }
        buff.append('`');
    }

    public static MethodData createMethodData(MementoTokenizer memento, String selector) {
        String cur = memento.nextToken();
        if (cur.charAt(0) == '~') {
            cur = memento.nextToken();
        }
        ArrayList<String> argTypes = new ArrayList<String>();
        while (cur.charAt(0) != '`') {
            StringBuffer buffer = new StringBuffer();
            while (cur.length() == 1 && '[' == cur.charAt(0)) {
                buffer.append('[');
                if (!memento.hasMoreTokens()) break;
                cur = memento.nextToken();
            }
            buffer.append(cur);
            argTypes.add(buffer.toString());
            if (memento.nextToken().charAt(0) != '~') break;
            cur = memento.nextToken();
        }
        String returnType = null;
        if (argTypes.size() > 0) {
            returnType = (String)argTypes.remove(argTypes.size() - 1);
        }
        return new MethodData(selector, argTypes.toArray(new String[argTypes.size()]), null, returnType, false);
    }

    public IMethod getRoleMethod() {
        if (this._roleMethod == null) {
            try {
                this._roleMethod = this.findRoleMethod();
                assert (this._roleMethod != null);
            }
            catch (JavaModelException ex) {
                this.log("Failed to lookup original role method element!", ex);
            }
        }
        return this._roleMethod;
    }

    public MethodData getRoleMethodHandle() {
        return this._roleMethodHandle;
    }

    public IMethod getRoleMethodThrowingException() throws JavaModelException {
        if (this._roleMethod == null) {
            this._roleMethod = this.findRoleMethod();
        }
        return this._roleMethod;
    }

    public void setRoleMethod(IMethod meth) {
        this._roleMethod = meth;
    }

    public IType getRoleClass() {
        IOTType owningType = (IOTType)this.getParent();
        return (IType)owningType.getCorrespondingJavaElement();
    }

    public String getElementName() {
        if (this._hasSignature) {
            return this._roleMethodHandle.toString();
        }
        return this._roleMethodHandle.getSelector();
    }

    public int getDeclarationSourceStart() {
        return this._declarationSourceStart;
    }

    public int getSourceStart() {
        return this._sourceStart;
    }

    public int getSourceEnd() {
        return this._sourceEnd;
    }

    public int getDeclarationSourceEnd() {
        return this._declarationSourceEnd;
    }

    public boolean equals(Object obj) {
        MethodMapping other = (MethodMapping)obj;
        return super.equals(other) && this.getElementName().equals(other.getElementName());
    }

    public String toString() {
        return "methodmapping: " + this.getElementName();
    }

    protected IMethod findRoleMethod() throws JavaModelException {
        IType[] implicitParents = TypeHelper.getImplicitSuperTypes((IRoleType)this.getParent());
        HashSet<IType> allParents = new HashSet<IType>();
        int idx = 0;
        while (idx < implicitParents.length) {
            IType elem = implicitParents[idx];
            ITypeHierarchy hierarchy = elem.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            IType[] superTypes = hierarchy.getAllSuperclasses(elem);
            allParents.add(elem);
            if (superTypes.length > 0) {
                allParents.addAll(Arrays.asList(superTypes));
            }
            ++idx;
        }
        return this.findMethod(allParents.toArray(new IType[allParents.size()]), this._roleMethodHandle);
    }

    protected IMethod findMethod(IType[] types, MethodData methodHandle) throws JavaModelException {
        int parIdx = 0;
        while (parIdx < types.length) {
            IMethod[] methods = types[parIdx].getMethods();
            int methIdx = 0;
            while (methIdx < methods.length) {
                IMethod tmpMethod = methods[methIdx];
                String selector = tmpMethod.getElementName();
                if (this.isEqualMethod(methodHandle, tmpMethod, selector)) {
                    return tmpMethod;
                }
                ++methIdx;
            }
            IOTType otType = OTModelManager.getOTElement(types[parIdx]);
            if (otType != null && otType.isRole()) {
                IMethodMapping[] iMethodMappingArray = ((IRoleType)otType).getMethodMappings(2);
                int n = iMethodMappingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethodMapping mapping = iMethodMappingArray[n2];
                    AbstractCalloutMapping tmpMethod = (AbstractCalloutMapping)mapping;
                    String selector = tmpMethod.getCorrespondingJavaElement().getElementName();
                    if (this.isEqualMethod(methodHandle, tmpMethod, selector)) {
                        return tmpMethod;
                    }
                    ++n2;
                }
            }
            ++parIdx;
        }
        IMethod methodReference = SourceMethod.createHandle((JavaElement)((Object)types[0]), methodHandle);
        int parIdx2 = 0;
        while (parIdx2 < types.length) {
            IMethod[] methods = types[parIdx2].findMethods(methodReference);
            if (methods != null && methods.length == 1) {
                return methods[0];
            }
            ++parIdx2;
        }
        return null;
    }

    private boolean isEqualMethod(MethodData baseMethodHandle, IMethod foundMethodOrCallout, String foundSelector) {
        if (!foundSelector.equals(baseMethodHandle.getSelector())) {
            return false;
        }
        if (baseMethodHandle.isIncomplete()) {
            return true;
        }
        return Util.equalArraysOrNull(foundMethodOrCallout.getParameterTypes(), baseMethodHandle.getArgumentTypes());
    }

    protected void log(String msg, JavaModelException ex) {
        ExceptionHandler.getOTDTCoreExceptionHandler().logException(msg, (Throwable)((Object)ex));
    }

    public IOpenable getOpenableParent() {
        IJavaElement current = this.getParent();
        while (current != null) {
            if (current instanceof IOpenable) {
                return (IOpenable)((Object)current);
            }
            if (current.getElementType() == 100) {
                IOTType otElement = (IOTType)current;
                current = otElement.getCorrespondingJavaElement();
            }
            current = current.getParent();
        }
        return null;
    }

    public String getSource() throws JavaModelException {
        IOpenable openable = this.getOpenableParent();
        IBuffer buffer = openable.getBuffer();
        if (buffer == null) {
            return null;
        }
        ISourceRange range = this.getSourceRange();
        int offset = range.getOffset();
        int length = range.getLength();
        if (offset == -1 || length == 0) {
            return null;
        }
        try {
            return buffer.getText(offset, length);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public ISourceRange getSourceRange() throws JavaModelException {
        return new SourceRange(this._declarationSourceStart, this._declarationSourceEnd - this._declarationSourceStart + 1);
    }

    public ISourceRange getNameRange() throws JavaModelException {
        SourceRange range = new SourceRange(this._sourceStart, this._sourceEnd - this._sourceStart + 1);
        return range;
    }

    protected String getSourceName() {
        return super.getElementName();
    }

    IMethod getIMethod() {
        return (IMethod)this.getCorrespondingJavaElement();
    }

    public String[] getExceptionTypes() throws JavaModelException {
        return this.getIMethod().getExceptionTypes();
    }

    public String[] getTypeParameterSignatures() throws JavaModelException {
        return this.getIMethod().getTypeParameterSignatures();
    }

    public int getNumberOfParameters() {
        return this.getIMethod().getNumberOfParameters();
    }

    public String[] getParameterNames() throws JavaModelException {
        if (this._roleMethodHandle != null && !this._roleMethodHandle.isIncomplete()) {
            return this._roleMethodHandle.getArgumentNames();
        }
        return this.getIMethod().getParameterNames();
    }

    public String[] getParameterTypes() {
        return this.getIMethod().getParameterTypes();
    }

    public String getReturnType() throws JavaModelException {
        if (this._roleMethodHandle != null && !this._roleMethodHandle.isIncomplete()) {
            return this._roleMethodHandle.getReturnType();
        }
        return this.getIMethod().getReturnType();
    }

    public String getSignature() throws JavaModelException {
        return this.getIMethod().getSignature();
    }

    public boolean isConstructor() throws JavaModelException {
        return this.getIMethod().isConstructor();
    }

    public boolean isMainMethod() throws JavaModelException {
        return this.getIMethod().isMainMethod();
    }

    public boolean isSimilar(IMethod method) {
        return this.getIMethod().isSimilar(method);
    }

    public IClassFile getClassFile() {
        return this.getIMethod().getClassFile();
    }

    public ICompilationUnit getCompilationUnit() {
        return this.getIMethod().getCompilationUnit();
    }

    public IType getDeclaringType() {
        return this.getIMethod().getDeclaringType();
    }

    public int getFlags() throws JavaModelException {
        return 0;
    }

    public IType getType(String name, int occurrenceCount) {
        return this.getIMethod().getType(name, occurrenceCount);
    }

    public boolean isBinary() {
        return this.getIMethod().isBinary();
    }

    public void copy(IJavaElement container, IJavaElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws JavaModelException {
        this.getIMethod().copy(container, sibling, rename, replace, monitor);
    }

    public void delete(boolean force, IProgressMonitor monitor) throws JavaModelException {
        this.getIMethod().delete(force, monitor);
    }

    public void move(IJavaElement container, IJavaElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws JavaModelException {
        this.getIMethod().move(container, sibling, rename, replace, monitor);
    }

    public void rename(String name, boolean replace, IProgressMonitor monitor) throws JavaModelException {
        this.getIMethod().rename(name, replace, monitor);
    }

    public boolean hasSignature() {
        return this._hasSignature;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exists() {
        IJavaElement parent = this.getParent();
        if (!parent.exists()) {
            return false;
        }
        try {
            IJavaElement[] iJavaElementArray = ((IType)parent).getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IJavaElement child = iJavaElementArray[n2];
                if (this.equals(child)) {
                    if (this == child) return true;
                    if (this._declarationSourceStart != 0) return true;
                    MethodMapping other = (MethodMapping)child;
                    this._declarationSourceStart = other._declarationSourceStart;
                    this._declarationSourceEnd = other._declarationSourceEnd;
                    this._sourceStart = other._sourceStart;
                    this._sourceEnd = other._sourceEnd;
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    public boolean isStructureKnown() throws JavaModelException {
        return this.getParent().isStructureKnown();
    }

    public String getKey() {
        return this.getIMethod().getKey();
    }

    public ITypeParameter[] getTypeParameters() throws JavaModelException {
        return NO_TYPE_PARAMETERS;
    }

    public String[] getRawParameterNames() throws JavaModelException {
        return EMPTY_STRING_ARRAY;
    }

    public ITypeParameter getTypeParameter(String name) {
        return new TypeParameter((JavaElement)this.getCorrespondingJavaElement(), name);
    }

    public boolean isResolved() {
        return false;
    }

    public String getAttachedJavadoc(IProgressMonitor monitor) throws JavaModelException {
        return null;
    }

    public String[] getCategories() throws JavaModelException {
        IType type = (IType)this.getAncestor(7);
        if (type == null) {
            return CharOperation.NO_STRINGS;
        }
        if (type.isBinary()) {
            return CharOperation.NO_STRINGS;
        }
        SourceTypeElementInfo info = (SourceTypeElementInfo)((SourceType)type).getElementInfo();
        HashMap map = info.getCategories();
        if (map == null) {
            return CharOperation.NO_STRINGS;
        }
        String[] categories = (String[])map.get(this);
        if (categories == null) {
            return CharOperation.NO_STRINGS;
        }
        return categories;
    }

    public ISourceRange getJavadocRange() throws JavaModelException {
        ISourceRange range = this.getSourceRange();
        if (range == null) {
            return null;
        }
        IBuffer buf = null;
        if (this.isBinary()) {
            buf = this.getClassFile().getBuffer();
        } else {
            ICompilationUnit compilationUnit = this.getCompilationUnit();
            if (!compilationUnit.isConsistent()) {
                return null;
            }
            buf = compilationUnit.getBuffer();
        }
        int start = range.getOffset();
        int length = range.getLength();
        if (length > 0 && buf.getChar(start) == '/') {
            IScanner scanner = ToolFactory.createScanner(true, false, false, false);
            scanner.setSource(buf.getText(start, length).toCharArray());
            try {
                int docOffset = -1;
                int docEnd = -1;
                int terminal = scanner.getNextToken();
                block6: while (true) {
                    switch (terminal) {
                        case 1003: {
                            docOffset = scanner.getCurrentTokenStartPosition();
                            docEnd = scanner.getCurrentTokenEndPosition() + 1;
                            terminal = scanner.getNextToken();
                            continue block6;
                        }
                        case 1001: 
                        case 1002: {
                            terminal = scanner.getNextToken();
                            continue block6;
                        }
                    }
                    break;
                }
                if (docOffset != -1) {
                    return new SourceRange(docOffset + start, docEnd - docOffset + 1);
                }
            }
            catch (InvalidInputException invalidInputException) {}
        }
        return null;
    }

    public int getOccurrenceCount() {
        return 0;
    }

    public IJavaElement getParent() {
        IJavaElement parent = super.getParent();
        if (parent instanceof IRoleType) {
            return parent;
        }
        return OTModelManager.getOTElement((IType)parent);
    }

    public ITypeRoot getTypeRoot() {
        IJavaElement element = this.getParent();
        while (element instanceof IMember) {
            element = element.getParent();
        }
        return (ITypeRoot)element;
    }

    public OTJavaElement resolved(Binding binding) {
        char[] uniqueKey = binding.computeUniqueKey();
        if (uniqueKey == null) {
            throw new AbortCompilation();
        }
        return this.resolved(uniqueKey);
    }

    public abstract OTJavaElement resolved(char[] var1);

    protected char getHandleMementoDelimiter() {
        return '`';
    }
}

