/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.smap;

import java.util.List;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.FileInfo;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.LineInfo;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.LineInfoReminder;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.LineNumberProvider;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.SmapStratum;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.TeamSmapGenerator;

public class RoleSmapGenerator
extends TeamSmapGenerator {
    public RoleSmapGenerator(TypeDeclaration type) {
        super(type);
    }

    public char[] generate() {
        for (SmapStratum stratum : this._strata) {
            if (!stratum.getStratumName().equals("OTJ")) continue;
            return this.generateOTJSmap(stratum);
        }
        return null;
    }

    private char[] generateOTJSmap(SmapStratum stratum) {
        LineInfoReminder lineInfoReminder = new LineInfoReminder();
        if (this.generatePartialOTJSmap(stratum, lineInfoReminder)) {
            return this.getSMAP().toCharArray();
        }
        this.fillSmap(stratum, lineInfoReminder);
        return this.getSMAP().toCharArray();
    }

    public boolean generatePartialOTJSmap(SmapStratum stratum, LineInfoReminder lineInfoReminder) {
        LineNumberProvider provider = this._type.getRoleModel().getLineNumberProvider();
        String sourceName = new String();
        String absoluteSourceName = new String();
        boolean isCompleted = false;
        if (!provider.containsLineInfos() && this._type.isRoleFile()) {
            sourceName = String.valueOf(this.getSourceNameFromRoleTypeDecl(this._type)) + ".java";
            absoluteSourceName = this.getAbsoluteSourcePath(this.getPackagePathFromRoleTypeDecl(this._type), sourceName);
            int maxLineNumber = this._type.getRoleModel()._maxLineNumber;
            FileInfo fileInfo = stratum.getOrCreateFileInfo(sourceName, absoluteSourceName);
            LineInfo lineInfo = new LineInfo(1, 1);
            lineInfo.setRepeatCount(maxLineNumber);
            fileInfo.addLineInfo(lineInfo);
            LineInfo stepOverLineInfo = new LineInfo(65534, 65534);
            fileInfo.addLineInfo(stepOverLineInfo);
            lineInfoReminder.storeLineInfo(stepOverLineInfo);
            LineInfo stepIntoLineInfo = new LineInfo(65533, 65533);
            fileInfo.addLineInfo(stepIntoLineInfo);
            lineInfoReminder.storeLineInfo(stepIntoLineInfo);
            isCompleted = true;
            return isCompleted;
        }
        for (ReferenceBinding copySrc : provider.getLineInfos().keySet()) {
            List<LineInfo> lineInfos = provider.getLineInfosForType(copySrc);
            if (this.isCopySrcRoleFile(copySrc)) {
                TypeDeclaration superrole = copySrc.roleModel.getClassPartAst();
                sourceName = String.valueOf(this.getSourceNameFromRoleTypeDecl(superrole)) + ".java";
                absoluteSourceName = this.getAbsoluteSourcePath(this.getPackagePathFromRoleTypeDecl(superrole), sourceName);
            } else {
                ReferenceBinding outerTypebinding = copySrc.enclosingType();
                sourceName = String.valueOf(this.getSourceNameFromRefBinding(outerTypebinding)) + ".java";
                absoluteSourceName = this.getAbsoluteSourcePath(this.getPackagePathFromRefBinding(outerTypebinding), sourceName);
            }
            FileInfo fileInfo = stratum.getOrCreateFileInfo(sourceName, absoluteSourceName);
            fileInfo.addLineInfo(lineInfos);
            lineInfoReminder.storeLineInfos(lineInfos);
        }
        return isCompleted;
    }

    private void fillSmap(SmapStratum stratum, LineInfoReminder lineInfoReminder) {
        String absoluteSourceName;
        String sourceName;
        LineNumberProvider provider = this._type.getRoleModel().getLineNumberProvider();
        if (this._type.isRoleFile()) {
            sourceName = String.valueOf(this.getSourceNameFromRoleTypeDecl(this._type)) + ".java";
            absoluteSourceName = this.getAbsoluteSourcePath(this.getPackagePathFromRoleTypeDecl(this._type), sourceName);
        } else {
            sourceName = String.valueOf(this.getRootEnclosingTypeNameFromTypeDecl(this._type)) + ".java";
            absoluteSourceName = this.getAbsoluteSourcePath(this.getPackagePathFromTypeDecl(this._type), sourceName);
        }
        FileInfo fileInfo = stratum.getOrCreateFileInfo(sourceName, absoluteSourceName);
        int idx = 1;
        while (idx <= provider.getSourceEndLineNumber()) {
            if (!lineInfoReminder.existsLineInfoFor(idx)) {
                LineInfo newLineInfo = new LineInfo(idx, idx);
                fileInfo.addLineInfo(newLineInfo);
                lineInfoReminder.storeLineInfo(newLineInfo);
            }
            ++idx;
        }
        if (!lineInfoReminder.existsLineInfoFor(65534)) {
            LineInfo stepOverLineInfo = new LineInfo(65534, 65534);
            fileInfo.addLineInfo(stepOverLineInfo);
            lineInfoReminder.storeLineInfo(stepOverLineInfo);
        }
        if (!lineInfoReminder.existsLineInfoFor(65533)) {
            LineInfo stepIntoLineInfo = new LineInfo(65533, 65533);
            fileInfo.addLineInfo(stepIntoLineInfo);
            lineInfoReminder.storeLineInfo(stepIntoLineInfo);
        }
    }

    private boolean isCopySrcRoleFile(ReferenceBinding copySrc) {
        TypeDeclaration typeDecl = copySrc.roleModel.getClassPartAst();
        if (typeDecl != null) {
            return typeDecl.isRoleFile();
        }
        return false;
    }

    protected String getSourceNameFromRefBinding(ReferenceBinding binding) {
        return String.valueOf(binding.sourceName);
    }

    protected String getRootEnclosingTypeNameFromTypeDecl(TypeDeclaration type) {
        TypeDeclaration enclosingTypeDecl = type.enclosingType;
        if (enclosingTypeDecl != null) {
            return this.getRootEnclosingTypeNameFromTypeDecl(enclosingTypeDecl);
        }
        return String.valueOf(type.name);
    }

    protected String getPackagePathFromTypeDecl(TypeDeclaration type) {
        TypeDeclaration enclosingTypeDecl = type.enclosingType;
        if (enclosingTypeDecl != null) {
            return this.getPackagePathFromTypeDecl(enclosingTypeDecl);
        }
        return this.getPackagePathFromRefBinding(type.binding);
    }

    protected String getSourceNameFromRoleTypeDecl(TypeDeclaration type) {
        return String.valueOf(type.getRoleModel().getInterfacePartBinding().sourceName);
    }

    protected String getPackagePathFromRoleTypeDecl(TypeDeclaration type) {
        CompilationUnitDeclaration cuDecl = type.compilationUnit;
        if (cuDecl == null) {
            cuDecl = type.getModel().getAst().compilationUnit;
        }
        ImportReference ref = cuDecl.currentPackage;
        char[][] packageParts = ref.getImportName();
        StringBuffer packageName = new StringBuffer();
        int idx = 0;
        while (idx < packageParts.length) {
            packageName.append(String.valueOf(String.valueOf(packageParts[idx])) + "/");
            ++idx;
        }
        if (packageName.length() > 0) {
            return packageName.toString();
        }
        return null;
    }
}

