/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer;

import java.util.Stack;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.BaseReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.StateHelper;
import org.eclipse.objectteams.otdt.internal.core.compiler.mappings.CallinImplementorDyn;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.SourcePosition;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.MethodSignatureEnhancer;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.StackTransformStatementsVisitor;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TSuperHelper;

public class TransformStatementsVisitor
extends StackTransformStatementsVisitor
implements IOTConstants {
    private Stack<MethodDeclaration> _methodDeclarationStack = new Stack();

    public void checkPushCallinMethod(AbstractMethodDeclaration methodDeclaration) {
        if (this.isGoodCallin(methodDeclaration)) {
            this._methodDeclarationStack.push((MethodDeclaration)methodDeclaration);
        }
    }

    private boolean isGoodCallin(AbstractMethodDeclaration methodDeclaration) {
        return methodDeclaration != null && !methodDeclaration.ignoreFurtherInvestigation && methodDeclaration.isCallin() && methodDeclaration.binding != null && methodDeclaration.binding.isCallin();
    }

    protected boolean checkPopCallinMethod(AbstractMethodDeclaration currentMethod) {
        if (!this._methodDeclarationStack.isEmpty() && this._methodDeclarationStack.peek() == currentMethod) {
            assert (currentMethod.isCallin());
            this._methodDeclarationStack.pop();
            return true;
        }
        return false;
    }

    public boolean visit(TypeDeclaration type, ClassScope scope) {
        return !type.isTeam() || !StateHelper.hasState(type.binding, 17);
    }

    public boolean visit(ExplicitConstructorCall call, BlockScope scope) {
        if (call.isTsuperAccess()) {
            call.arguments = TSuperHelper.addMarkerArgument(null, call, call.arguments, scope);
        }
        return true;
    }

    public boolean visit(MessageSend messageSend, BlockScope scope) {
        if (this._methodDeclarationStack.isEmpty()) {
            return true;
        }
        MethodDeclaration methodDecl = this._methodDeclarationStack.peek();
        boolean isBaseCall = messageSend.receiver instanceof BaseReference;
        if (methodDecl.isCallin() && this.isRecursiveCall(methodDecl, messageSend, isBaseCall)) {
            Expression[] args = messageSend.arguments;
            if (CallinImplementorDyn.DYNAMIC_WEAVING) {
                if (isBaseCall) {
                    AstGenerator gen = new AstGenerator(messageSend);
                    args = new Expression[]{args != null && args.length > 0 ? gen.arrayAllocation(gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT), 1, args) : gen.nullLiteral()};
                }
            } else if (args != null) {
                int len = args.length;
                if (methodDecl.isStatic()) {
                    Expression[] expressionArray = args;
                    args = new Expression[len - 1];
                    System.arraycopy(expressionArray, 1, args, 0, len - 1);
                }
            }
            messageSend.arguments = MethodSignatureEnhancer.enhanceArguments(args, messageSend.sourceEnd + 1);
            messageSend.bits |= 4;
        }
        return true;
    }

    private boolean isRecursiveCall(MethodDeclaration callinMethod, MessageSend messageSend, boolean isBaseCall) {
        if (!(messageSend.receiver instanceof ThisReference)) {
            return false;
        }
        if (messageSend.receiver instanceof QualifiedThisReference) {
            return false;
        }
        if (!CharOperation.equals(callinMethod.selector, messageSend.selector) && !CharOperation.equals(CallinImplementorDyn.OT_CALL_NEXT, messageSend.selector)) {
            return false;
        }
        if (callinMethod.arguments == null) {
            return false;
        }
        int sendArgs = messageSend.arguments == null ? 0 : messageSend.arguments.length;
        sendArgs += MethodSignatureEnhancer.ENHANCING_ARG_LEN;
        if (isBaseCall && !CallinImplementorDyn.DYNAMIC_WEAVING) {
            --sendArgs;
        }
        return sendArgs == callinMethod.arguments.length;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean visit(ReturnStatement returnStatement, BlockScope scope) {
        if (this._methodDeclarationStack.isEmpty()) {
            return true;
        }
        MethodDeclaration methodDecl = this._methodDeclarationStack.peek();
        if (!this.isGoodCallin(methodDecl)) {
            return true;
        }
        if (scope != null && scope.methodScope() != methodDecl.scope) {
            return true;
        }
        TypeBinding returnType = MethodModel.getReturnType(methodDecl.binding);
        if (!returnType.isBaseType()) {
            return true;
        }
        AstGenerator gen = new AstGenerator(returnStatement.sourceStart, returnStatement.sourceEnd);
        if (returnType != TypeBinding.VOID) return true;
        if (returnStatement.expression != null) {
            if (scope == null && !this._methodDeclarationStack.isEmpty()) {
                scope = this._methodDeclarationStack.peek().scope;
            }
            if (scope == null) throw new InternalCompilerError("Missing scope for error reporting");
            scope.problemReporter().attemptToReturnNonVoidExpression(returnStatement, returnType);
            return true;
        } else {
            returnStatement.expression = gen.singleNameReference(OT_RESULT);
        }
        return true;
    }

    public boolean visit(MethodDeclaration methodDeclaration, ClassScope scope) {
        methodDeclaration.bits |= 4;
        this.checkPushCallinMethod(methodDeclaration);
        return true;
    }

    public void endVisit(MethodDeclaration methodDecl, ClassScope scope) {
        TypeBinding returnType;
        if (this.checkPopCallinMethod(methodDecl) && (returnType = MethodModel.getReturnType(methodDecl.binding)) == TypeBinding.VOID && !methodDecl.isGenerated && !methodDecl.isCopied && !methodDecl.isAbstract()) {
            AstGenerator gen = new AstGenerator(methodDecl.bodyEnd, methodDecl.bodyEnd);
            if (methodDecl.statements == null) {
                methodDecl.setStatements(new Statement[]{gen.returnStatement(gen.nullLiteral(), true)});
            } else {
                int len = methodDecl.statements.length;
                Statement[] newStatements = new Statement[len + 2];
                System.arraycopy(methodDecl.statements, 0, newStatements, 1, len);
                SourcePosition savePos = gen.getSourcePosition();
                try {
                    if (len > 0) {
                        gen.setSourcePosition(((long)methodDecl.statements[0].sourceStart << 32) + (long)methodDecl.statements[0].sourceEnd);
                    }
                    newStatements[0] = gen.localVariable(OT_RESULT, scope.getJavaLangObject(), (Expression)gen.nullLiteral());
                }
                finally {
                    gen.setSourcePosition(savePos);
                }
                newStatements[len + 1] = gen.returnStatement(gen.singleNameReference(OT_RESULT), true);
                methodDecl.setStatements(newStatements);
            }
        }
        super.endVisit(methodDecl, scope);
    }

    public boolean visit(TypeDeclaration td, BlockScope scope) {
        return (td.bits & 0x100) == 0 || td.scope != null;
    }

    public static void checkTransformStatements(AbstractMethodDeclaration method) {
        ClassScope scope = method.scope.classScope();
        if (scope.referenceContext.ignoreFurtherInvestigation && method instanceof MethodDeclaration && method.isCallin() && (method.bits & 4) == 0) {
            method.traverse((ASTVisitor)new TransformStatementsVisitor(), scope);
        }
    }
}

