/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.util;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.TypeContainerMethod;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.FieldModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstClone;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstConverter;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;

public class AstEdit {
    public static void addField(TypeDeclaration decl, FieldDeclaration field, boolean createBinding, boolean hasTypeProblem) {
        int length;
        if (field.declarationSourceStart > 0 && field.declarationSourceEnd > 0 && field.declarationEnd > 0 && field.sourceStart > 0) {
            int cfr_ignored_0 = field.sourceEnd;
        }
        FieldDeclaration[] fields = decl.fields;
        if (decl.fields == null) {
            length = 0;
            fields = new FieldDeclaration[1];
        } else {
            length = fields.length;
            FieldDeclaration[] fieldDeclarationArray = fields;
            fields = new FieldDeclaration[length + 1];
            System.arraycopy(fieldDeclarationArray, 0, fields, 0, length);
        }
        fields[length] = field;
        decl.fields = fields;
        boolean modifiersAdjusted = FieldModel.checkCreateModifiersAttribute(decl, field);
        if (decl.binding != null && createBinding) {
            FieldBinding binding = decl.scope.addGeneratedField(field, hasTypeProblem);
            if (modifiersAdjusted) {
                binding.tagBits |= 0x200L;
            }
        }
    }

    public static void removeField(TypeDeclaration decl, FieldDeclaration field) {
        int pos = -1;
        int length = decl.fields.length;
        FieldDeclaration[] fields = new FieldDeclaration[length - 1];
        if (decl.fields != null) {
            int i = 0;
            while (i < decl.fields.length) {
                if (field.equals(decl.fields[i])) {
                    pos = i;
                }
                ++i;
            }
        }
        if (pos >= 0) {
            System.arraycopy(decl.fields, 0, fields, 0, pos);
            System.arraycopy(decl.fields, pos + 1, fields, pos, length - (pos + 1));
            decl.fields = fields;
        }
    }

    public static void addMethod(TypeDeclaration classTypeDeclaration, AbstractMethodDeclaration methodDeclaration) {
        AstEdit.addMethod(classTypeDeclaration, methodDeclaration, false, false);
    }

    public static void addGeneratedMethod(TypeDeclaration classTypeDeclaration, MethodDeclaration methodDeclaration) {
        RoleModel roleModel;
        if (classTypeDeclaration.isRole() && (methodDeclaration.modifiers & 1) != 0 && (roleModel = classTypeDeclaration.getRoleModel()) != null && roleModel.getClassPartAst() != null) {
            TypeDeclaration ifcPart = roleModel.getInterfaceAst();
            if (ifcPart != null) {
                AbstractMethodDeclaration ifcMethod = null;
                if (ifcPart.methods != null) {
                    AbstractMethodDeclaration[] abstractMethodDeclarationArray = ifcPart.methods;
                    int n = ifcPart.methods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractMethodDeclaration method = abstractMethodDeclarationArray[n2];
                        if (CharOperation.equals(method.selector, methodDeclaration.selector)) {
                            ifcMethod = method;
                            break;
                        }
                        ++n2;
                    }
                }
                if (ifcMethod == null) {
                    ifcMethod = AstConverter.genRoleIfcMethod(ifcPart, methodDeclaration);
                    AstEdit.addMethod(ifcPart, ifcMethod);
                }
            }
            classTypeDeclaration = roleModel.getClassPartAst();
        }
        AstEdit.addMethod(classTypeDeclaration, methodDeclaration);
    }

    public static void addMethod(TypeDeclaration classTypeDeclaration, AbstractMethodDeclaration methodDeclaration, boolean wasSynthetic, boolean addToFront) {
        boolean modifiersAdjusted = AstEdit.addMethodDeclOnly(classTypeDeclaration, methodDeclaration, addToFront);
        if (classTypeDeclaration.binding != null) {
            classTypeDeclaration.binding.resolveGeneratedMethod(methodDeclaration, wasSynthetic);
            if (modifiersAdjusted) {
                methodDeclaration.binding.tagBits |= 0x200L;
            }
        }
    }

    public static boolean addMethodDeclOnly(TypeDeclaration classTypeDeclaration, AbstractMethodDeclaration methodDeclaration, boolean addToFront) {
        int length;
        if (methodDeclaration.declarationSourceStart > 0 && methodDeclaration.declarationSourceEnd > 0 && methodDeclaration.sourceStart > 0 && methodDeclaration.sourceEnd > 0) {
            int cfr_ignored_0 = methodDeclaration.bodyEnd;
        }
        AbstractMethodDeclaration[] methods = classTypeDeclaration.methods;
        if (classTypeDeclaration.methods == null) {
            length = 0;
            methods = new AbstractMethodDeclaration[1];
        } else {
            length = methods.length;
            AbstractMethodDeclaration[] abstractMethodDeclarationArray = methods;
            methods = new AbstractMethodDeclaration[length + 1];
            System.arraycopy(abstractMethodDeclarationArray, 0, methods, addToFront ? 1 : 0, length);
        }
        if (addToFront) {
            methods[0] = methodDeclaration;
        } else {
            methods[length] = methodDeclaration;
        }
        classTypeDeclaration.methods = methods;
        boolean modifiersAdjusted = MethodModel.checkCreateModifiersAttribute(classTypeDeclaration, methodDeclaration);
        return modifiersAdjusted;
    }

    public static void removeMethod(TypeDeclaration decl, MethodBinding method) {
        int pos = -1;
        int length = decl.methods.length;
        AbstractMethodDeclaration[] methods = new AbstractMethodDeclaration[length - 1];
        if (decl.methods != null) {
            int i = 0;
            while (i < decl.methods.length) {
                if (method == decl.methods[i].binding) {
                    pos = i;
                    break;
                }
                ++i;
            }
        }
        if (pos >= 0) {
            System.arraycopy(decl.methods, 0, methods, 0, pos);
            System.arraycopy(decl.methods, pos + 1, methods, pos, length - (pos + 1));
            decl.methods = methods;
        }
        decl.binding.removeMethod(method);
    }

    public static void removeDefaultConstructor(TypeDeclaration roleType) {
        AbstractMethodDeclaration[] methods = roleType.methods;
        if (methods != null) {
            int i = 0;
            while (i < methods.length) {
                if (methods[i] instanceof ConstructorDeclaration && ((ConstructorDeclaration)methods[i]).isDefaultConstructor()) {
                    AstEdit.removeMethod(roleType, methods[i].binding);
                }
                ++i;
            }
        }
    }

    public static void addMemberTypeDeclaration(TypeDeclaration typeDeclaration, TypeDeclaration memberTypeDeclaration) {
        boolean found = false;
        if (typeDeclaration.isConverted && typeDeclaration.memberTypes != null && memberTypeDeclaration.isRoleFile()) {
            int i = 0;
            while (i < typeDeclaration.memberTypes.length) {
                if (CharOperation.equals(typeDeclaration.memberTypes[i].name, memberTypeDeclaration.name)) {
                    typeDeclaration.memberTypes[i] = memberTypeDeclaration;
                    found = true;
                    break;
                }
                ++i;
            }
        }
        if (!found) {
            int length = 0;
            if (typeDeclaration.memberTypes != null) {
                length = typeDeclaration.memberTypes.length;
                typeDeclaration.memberTypes = new TypeDeclaration[length + 1];
                System.arraycopy(typeDeclaration.memberTypes, 0, typeDeclaration.memberTypes, 0, length);
            } else {
                typeDeclaration.memberTypes = new TypeDeclaration[1];
            }
            typeDeclaration.memberTypes[length] = memberTypeDeclaration;
        }
        assert (memberTypeDeclaration.enclosingType == null);
        memberTypeDeclaration.enclosingType = typeDeclaration;
        memberTypeDeclaration.bits |= 0x400;
    }

    public static void addTypeDeclaration(CompilationUnitDeclaration unitDeclaration, TypeDeclaration typeDeclaration) {
        if (unitDeclaration.types != null) {
            int length = unitDeclaration.types.length;
            unitDeclaration.types = new TypeDeclaration[length + 1];
            System.arraycopy(unitDeclaration.types, 0, unitDeclaration.types, 1, length);
        } else {
            unitDeclaration.types = new TypeDeclaration[1];
        }
        unitDeclaration.types[0] = typeDeclaration;
        assert (typeDeclaration.compilationUnit == null);
        typeDeclaration.compilationUnit = unitDeclaration;
    }

    public static void addLocalTypeDeclaration(TypeDeclaration enclosingTypeDecl, TypeDeclaration nestedType) {
        TypeContainerMethod wrapper = new TypeContainerMethod(enclosingTypeDecl.compilationResult, nestedType);
        nestedType.enclosingType = enclosingTypeDecl;
        AstEdit.addMethod(enclosingTypeDecl, wrapper, false, true);
    }

    public static void addImplementsBinding(TypeDeclaration typeDeclaration, ReferenceBinding resolvedSuper) {
        boolean bindingPresent;
        boolean bl = bindingPresent = typeDeclaration.binding != null && (typeDeclaration.binding.tagBits & 0x100L) != 0L;
        assert (resolvedSuper != null && bindingPresent);
        SourceTypeBinding typeBinding = typeDeclaration.binding;
        ReferenceBinding[] superInterfaces = typeBinding.superInterfaces;
        int length = 0;
        if (superInterfaces == null) {
            superInterfaces = new ReferenceBinding[1];
        } else {
            ReferenceBinding[] referenceBindingArray = superInterfaces;
            int n = superInterfaces.length;
            int n2 = 0;
            while (n2 < n) {
                ReferenceBinding superIfc = referenceBindingArray[n2];
                if (superIfc == resolvedSuper) {
                    return;
                }
                ++n2;
            }
            length = superInterfaces.length;
            ReferenceBinding[] referenceBindingArray2 = superInterfaces;
            superInterfaces = new ReferenceBinding[length + 1];
            System.arraycopy(referenceBindingArray2, 0, superInterfaces, 1, length);
        }
        superInterfaces[0] = resolvedSuper;
        typeBinding.superInterfaces = superInterfaces;
        typeBinding.resetIncompatibleTypes();
    }

    public static void addImplementsReference(TypeDeclaration typeDeclaration, TypeReference reference) {
        if ((reference = AstClone.copyTypeReference(reference)) != null) {
            int length = 0;
            TypeReference[] superInterfaces = typeDeclaration.superInterfaces;
            if (superInterfaces == null) {
                superInterfaces = new TypeReference[1];
            } else {
                length = superInterfaces.length;
                TypeReference[] typeReferenceArray = superInterfaces;
                superInterfaces = new TypeReference[length + 1];
                System.arraycopy(typeReferenceArray, 0, superInterfaces, 1, length);
            }
            superInterfaces[0] = reference;
            typeDeclaration.superInterfaces = superInterfaces;
        }
    }

    public static Expression[] extendExpressionArray(Expression[] exprs, Expression lastExpr) {
        if (exprs == null) {
            return new Expression[]{lastExpr};
        }
        int len = exprs.length;
        Expression[] expressionArray = exprs;
        exprs = new Expression[len + 1];
        System.arraycopy(expressionArray, 0, exprs, 0, len);
        exprs[len] = lastExpr;
        return exprs;
    }

    public static TypeBinding[] extendTypeArray(TypeBinding[] types, TypeBinding lastType) {
        int len = types.length;
        TypeBinding[] typeBindingArray = types;
        types = new TypeBinding[len + 1];
        System.arraycopy(typeBindingArray, 0, types, 0, len);
        types[len] = lastType;
        return types;
    }

    public static void addImplementsInterfaceReference(char[] interfaceName, TypeDeclaration roleClassDecl) {
        long pos = ((long)roleClassDecl.sourceStart << 32) + (long)roleClassDecl.sourceEnd;
        AstGenerator gen = new AstGenerator(pos);
        SingleTypeReference implementsRef = null;
        if (roleClassDecl.typeParameters == null) {
            implementsRef = gen.singleTypeReference(interfaceName);
        } else {
            int len = roleClassDecl.typeParameters.length;
            TypeReference[] args = new TypeReference[len];
            int i = 0;
            while (i < len) {
                args[i] = gen.singleTypeReference(roleClassDecl.typeParameters[i].name);
                args[i].bits |= 0x100000;
                ++i;
            }
            implementsRef = new ParameterizedSingleTypeReference(interfaceName, args, 0, pos);
        }
        implementsRef.bits |= 0x100000;
        AstEdit.addImplementsReference(roleClassDecl, implementsRef);
    }
}

