/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.core.search;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.OTModelManager;

public class OTSearchRequestor
extends SearchRequestor {
    private ArrayList<IOTType> _otTypes = new ArrayList();

    public void acceptSearchMatch(SearchMatch match) throws CoreException {
        IJavaElement jel;
        IType javaType = null;
        Object element = match.getElement();
        if (element instanceof IType) {
            javaType = (IType)element;
        } else if (match.getResource() != null && (jel = JavaCore.create(match.getResource())).getElementType() == 7) {
            javaType = (IType)jel;
        }
        if (javaType != null) {
            IOTType otType = OTModelManager.getOTElement(javaType);
            if (otType == null) {
                try {
                    int modifiers = javaType.getFlags();
                    if (Flags.isTeam(modifiers) || Flags.isRole(modifiers)) {
                        javaType.getOpenable().open(null);
                        otType = OTModelManager.getOTElement(javaType);
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            if (otType != null) {
                this._otTypes.add(otType);
            }
        }
    }

    public IOTType[] getOTTypes() {
        return this._otTypes.toArray(new IOTType[this._otTypes.size()]);
    }
}

