/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.core.util;

import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.TypeParameterElementInfo;

public class MethodData {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private String _selector;
    private String[] _argumentsTypes;
    private String[] _argumentsNames;
    private String _returnType;
    static final ITypeParameter[] NO_TYPE_PARAMETERS = new ITypeParameter[0];
    public ITypeParameter[] typeParameters = NO_TYPE_PARAMETERS;
    private boolean _isDeclaration = false;
    private boolean _covariantReturn = false;
    private int sourceStart;
    private int sourceEnd;

    public MethodData(String selector, String[] types, String[] names, String returnType, boolean isDeclaration) {
        this._selector = selector;
        if (this._selector == null) {
            this._selector = "";
        }
        this._argumentsTypes = types;
        this._argumentsNames = names;
        this._returnType = returnType;
        assert (types != null) : "Long method spec must have types";
        if (names == null) {
            this._argumentsNames = EMPTY_STRING_ARRAY;
        }
        this._isDeclaration = isDeclaration;
    }

    public MethodData(String selector, String[] types, String[] names, String returnType, boolean isDeclaration, boolean covariantReturn) {
        this(selector, types, names, returnType, isDeclaration);
        this._covariantReturn = covariantReturn;
    }

    public MethodData(String selector, boolean isDeclaration) {
        this._selector = selector;
        this._returnType = null;
        this._argumentsTypes = EMPTY_STRING_ARRAY;
        this._argumentsNames = EMPTY_STRING_ARRAY;
        this._isDeclaration = isDeclaration;
    }

    public MethodData(String selector, String signature) {
        signature = signature.replace('/', '.');
        this._selector = selector;
        this._argumentsTypes = Signature.getParameterTypes(signature);
        this._returnType = Signature.getReturnType(signature);
        this._argumentsNames = EMPTY_STRING_ARRAY;
    }

    public MethodData(String selector, String signature, boolean covariantReturn) {
        this(selector, signature);
        this._covariantReturn = covariantReturn;
    }

    public boolean isIncomplete() {
        return this._argumentsTypes == EMPTY_STRING_ARRAY;
    }

    public String[] getArgumentTypes() {
        return this._argumentsTypes;
    }

    public String[] getArgumentNames() {
        return this._argumentsNames;
    }

    public String getSelector() {
        return this._selector;
    }

    public String getReturnType() {
        return this._returnType;
    }

    public String getSignature() {
        return Signature.createMethodSignature(this._argumentsTypes, this._returnType);
    }

    public boolean isDeclaration() {
        return this._isDeclaration;
    }

    public boolean hasCovariantReturn() {
        return this._covariantReturn;
    }

    public char[][][] getTypeParameterBounds() {
        int length = this.typeParameters.length;
        char[][][] typeParameterBounds = new char[length][][];
        int i = 0;
        while (i < length) {
            try {
                TypeParameterElementInfo info = (TypeParameterElementInfo)((JavaElement)((Object)this.typeParameters[i])).getElementInfo();
                typeParameterBounds[i] = info.bounds;
            }
            catch (JavaModelException javaModelException) {}
            ++i;
        }
        return typeParameterBounds;
    }

    public char[][] getTypeParameterNames() {
        int length = this.typeParameters.length;
        if (length == 0) {
            return CharOperation.NO_CHAR_CHAR;
        }
        char[][] typeParameterNames = new char[length][];
        int i = 0;
        while (i < length) {
            typeParameterNames[i] = this.typeParameters[i].getElementName().toCharArray();
            ++i;
        }
        return typeParameterNames;
    }

    public String toString() {
        String signature = String.valueOf(this._selector) + "(";
        if (this._argumentsTypes != null) {
            int idx = 0;
            while (idx < this._argumentsTypes.length) {
                signature = String.valueOf(signature) + (idx == 0 ? "" : ", ") + Signature.getSimpleName(Signature.toString(this._argumentsTypes[idx]));
                ++idx;
            }
        }
        signature = String.valueOf(signature) + ")";
        return signature;
    }

    public int getSourceStart() {
        return this.sourceStart;
    }

    public int getSourceEnd() {
        return this.sourceEnd;
    }
}

