/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.ast;

import java.util.HashSet;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.eclipse.jdt.internal.compiler.ast.DoubleLiteral;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.jdt.internal.compiler.ast.FloatLiteral;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.Literal;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LongLiteral;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Dependencies;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.RoleTypeCreator;

public class LiftingTypeReference
extends TypeReference {
    public char[] roleToken;
    public char[][] baseTokens;
    public TypeReference baseReference;
    public TypeReference roleReference;
    public LocalDeclaration fakedArgument = null;
    public boolean hasIncompatibleArrayDimensions = false;

    public boolean isDeclaredLifting() {
        return true;
    }

    public void setReferences(TypeReference baseReference, TypeReference roleReference) {
        this.baseReference = baseReference;
        this.roleReference = roleReference;
        this.baseReference.setBaseclassDecapsulation(Expression.DecapsulationState.ALLOWED);
        this.baseTokens = baseReference.getTypeName();
        this.roleToken = roleReference.getTypeName()[0];
        this.sourceStart = baseReference.sourceStart;
        this.sourceEnd = roleReference.sourceEnd;
    }

    public TypeReference copyDims(int dim) {
        return new ArrayTypeReference(this.roleToken, dim, ((long)this.sourceStart << 32) + (long)this.sourceEnd);
    }

    public TypeBinding getTypeBinding(Scope scope) {
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        throw new InternalCompilerError("Unexpected control flow, method not intended to do work.");
    }

    public TypeBinding resolveType(BlockScope scope, boolean checkBounds) {
        TypeBinding baseType = this.resolvedType = this.baseReference.resolveType(scope);
        if (this.roleReference.getTypeName().length > 1) {
            scope.problemReporter().qualifiedLiftingType(this.roleReference, scope.enclosingSourceType());
            return this.invalidate(baseType);
        }
        TypeBinding roleType = this.roleReference.resolveType(scope);
        if (scope.kind != 1 && !TeamModel.isAnyTeam(scope.enclosingSourceType())) {
            scope.problemReporter().liftingTypeNotAllowedHere(scope.methodScope().referenceContext, this);
            return this.invalidate(roleType);
        }
        if (baseType == null || baseType instanceof MissingTypeBinding) {
            return this.invalidate(roleType);
        }
        if (roleType == null || roleType instanceof MissingTypeBinding) {
            return this.invalidate(baseType);
        }
        if (roleType.isArrayType()) {
            baseType = baseType.leafComponentType();
            roleType = roleType.leafComponentType();
        }
        if (roleType.isBaseType()) {
            scope.problemReporter().primitiveTypeNotAllowedForLifting(scope.referenceType(), this.roleReference, roleType);
            return this.invalidate(roleType);
        }
        if (baseType.isBaseType()) {
            scope.problemReporter().primitiveTypeNotAllowedForLifting(scope.referenceType(), this.baseReference, baseType);
            return this.invalidate(roleType);
        }
        ReferenceBinding roleRefType = (ReferenceBinding)roleType;
        if (!roleRefType.isValidBinding()) {
            return this.invalidate(roleType);
        }
        if (!roleRefType.isDirectRole()) {
            scope.problemReporter().needRoleInLiftingType(scope.referenceType(), this.roleReference, roleType);
            return this.invalidate(roleType);
        }
        if (roleRefType.isSynthInterface()) {
            roleRefType = roleRefType.getRealClass();
        }
        if (roleRefType.roleModel.hasBaseclassProblem()) {
            scope.referenceContext().tagAsHavingErrors();
            return this.invalidate(roleType);
        }
        Dependencies.ensureBindingState(roleRefType, 7);
        if (baseType.isTypeVariable() && ((TypeVariableBinding)baseType).roletype != null) {
            roleRefType = ((TypeVariableBinding)baseType).roletype;
            HashSet<ReferenceBinding> mappedBases = new HashSet<ReferenceBinding>();
            ReferenceBinding[] referenceBindingArray = roleRefType.roleModel.getBoundDescendants();
            int n = referenceBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ReferenceBinding boundRole = referenceBindingArray[n2];
                if (mappedBases.contains(boundRole.baseclass())) {
                    scope.problemReporter().definiteLiftingAmbiguity(baseType, roleRefType, this);
                } else {
                    mappedBases.add(boundRole.baseclass());
                }
                ++n2;
            }
        } else if ((baseType.tagBits & 0x20000L) == 0L) {
            if ((roleRefType = (ReferenceBinding)TeamModel.getRoleToLiftTo(scope, baseType, roleRefType, true, this)) == null) {
                roleRefType = (ReferenceBinding)roleType;
            }
            if (roleRefType.baseclass() == null || (roleRefType.tagBits & 0x800000000000000L) != 0L) {
                scope.problemReporter().roleNotBoundCantLift(scope.referenceType(), this.roleReference, roleType);
                return this.invalidate(roleType);
            }
            if (baseType.isRole()) {
                baseType = RoleTypeCreator.maybeWrapUnqualifiedRoleType(baseType, scope.enclosingReceiverType());
            }
            if (baseType == null) {
                return this.invalidate(roleType);
            }
            Config oldConfig = Config.createOrResetConfig(this);
            try {
                ReferenceBinding roleBase = roleRefType.baseclass();
                if (roleType.isParameterizedType()) {
                    ParameterizedTypeBinding parameterizedRole = (ParameterizedTypeBinding)roleType;
                    TypeBinding[] typeArgs = parameterizedRole.arguments;
                    ITeamAnchor anchor = null;
                    if (roleRefType.baseclass() instanceof RoleTypeBinding) {
                        anchor = ((RoleTypeBinding)roleRefType.baseclass())._teamAnchor;
                    }
                    roleBase = parameterizedRole.environment.createParameterizedType((ReferenceBinding)roleBase.original(), typeArgs, anchor, -1, roleBase.enclosingType());
                }
                if (!baseType.isCompatibleWith(roleBase) || Config.getLoweringRequired()) {
                    scope.problemReporter().incompatibleBaseForRole(scope.referenceType(), this, roleType, baseType);
                    TypeBinding typeBinding = this.invalidate(roleType);
                    return typeBinding;
                }
            }
            finally {
                Config.removeOrRestore(oldConfig, this);
            }
        }
        return this.resolvedType;
    }

    public TypeBinding resolveType(ClassScope scope) {
        throw new InternalCompilerError("LiftingTypeReference cannot be used in a ClassScope!");
    }

    private TypeBinding invalidate(TypeBinding variableType) {
        if (this.fakedArgument != null) {
            int start = this.roleReference.sourceStart;
            int end = this.roleReference.sourceEnd;
            Literal nullValue = null;
            if (variableType.isBaseType()) {
                char[] tok = new char[]{'0'};
                switch (variableType.id) {
                    case 5: {
                        nullValue = new FalseLiteral(start, end);
                        break;
                    }
                    case 2: {
                        nullValue = new CharLiteral(tok, start, end);
                        break;
                    }
                    case 8: {
                        nullValue = new DoubleLiteral(tok, start, end);
                        break;
                    }
                    case 9: {
                        nullValue = new FloatLiteral(tok, start, end);
                        break;
                    }
                    case 10: {
                        nullValue = new IntLiteral(tok, start, end);
                        break;
                    }
                    case 7: {
                        nullValue = new LongLiteral(tok, start, end);
                    }
                }
            } else {
                nullValue = new NullLiteral(start, end);
            }
            this.fakedArgument.initialization = nullValue;
            if (variableType.isValidBinding()) {
                this.fakedArgument.type = new AstGenerator(this).typeReference(variableType);
            }
        }
        return null;
    }

    public char[][] getTypeName() {
        return this.baseTokens;
    }

    public char[] getLastToken() {
        return this.baseReference.getLastToken();
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        output = this.baseReference.printExpression(indent, output);
        output.append(" as ");
        output = this.roleReference.printExpression(indent, output);
        return output;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }

    public void traverse(ASTVisitor visitor, ClassScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }
}

