/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.lookup;

import java.util.WeakHashMap;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.TThisBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.ReflectionGenerator;

public class DependentTypeBinding
extends ParameterizedTypeBinding {
    public ITeamAnchor _teamAnchor;
    public int _argumentPosition = -1;
    public IMethodProvider _declaringMethod = null;
    public VariableBinding _matchingVariable;
    public int _valueParamPosition = -1;
    private WeakHashMap<ITeamAnchor, DependentTypeBinding> _instantiatedTypes = new WeakHashMap();
    private ArrayBinding[] _arrayBindings = null;

    public DependentTypeBinding(ReferenceBinding type, TypeBinding[] typeArguments, ITeamAnchor teamAnchor, int paramPosition, ReferenceBinding enclosingType, LookupEnvironment lookupEnvironment) {
        super(type, typeArguments, enclosingType, lookupEnvironment);
        this.initializeFromType(type);
        this.initializeDependentType(teamAnchor, paramPosition);
    }

    DependentTypeBinding(ReferenceBinding type, TypeBinding[] arguments, ReferenceBinding enclosingType, LookupEnvironment environment) {
        super(type, arguments, enclosingType, environment);
        this.initializeFromType(type);
    }

    private void initializeFromType(ReferenceBinding givenType) {
        ITeamAnchor[] anchors;
        this.model = givenType.model;
        this.modifiers = givenType.modifiers;
        this.tagBits = givenType.tagBits | 0x400000000000000L;
        this.tagBits &= 0xFFFFFFFFFFFF3FFFL;
        this.compoundName = givenType.compoundName;
        this.sourceName = givenType.sourceName;
        this.constantPoolName = givenType.constantPoolName;
        this.callinCallouts = givenType.callinCallouts;
        this.precedences = givenType.precedences;
        this.fileName = givenType.fileName;
        this.fPackage = givenType.fPackage;
        this.teamPackage = givenType.teamPackage;
        if (givenType.isTypeVariable() && (anchors = ((TypeVariableBinding)givenType).anchors) != null && anchors[0] instanceof LocalVariableBinding) {
            final LocalVariableBinding anchor = (LocalVariableBinding)anchors[0];
            if ((anchor.tagBits & 0x400L) != 0L) {
                this._argumentPosition = anchor.resolvedPosition;
                this._declaringMethod = new IMethodProvider(){

                    public MethodBinding getMethod() {
                        return ((MethodScope)anchor.declaringScope).referenceMethodBinding();
                    }
                };
            }
        }
    }

    void initializeDependentType(ITeamAnchor anchor, int valueParamPosition) {
        this._valueParamPosition = valueParamPosition;
        SyntheticArgumentBinding[] valParams = this.type.valueParamSynthArgs();
        if (valueParamPosition > -1 && valueParamPosition < valParams.length) {
            this._matchingVariable = valParams[valueParamPosition].matchingField;
        }
        this._teamAnchor = anchor;
        if (anchor instanceof LocalVariableBinding) {
            ((LocalVariableBinding)anchor).useFlag = 1;
        } else if (anchor instanceof FieldBinding) {
            ((FieldBinding)anchor).modifiers |= 0x8000000;
        }
    }

    public ITeamAnchor getAnchor() {
        return this._teamAnchor;
    }

    public ArrayBinding getArrayType(int dims) {
        if (this._arrayBindings == null || this._arrayBindings.length < dims) {
            ArrayBinding[] oldArrays = this._arrayBindings;
            this._arrayBindings = new ArrayBinding[dims];
            if (oldArrays != null) {
                System.arraycopy(oldArrays, 0, this._arrayBindings, 0, oldArrays.length);
            }
        }
        if (this._arrayBindings[dims - 1] == null) {
            this._arrayBindings[dims - 1] = new ArrayBinding(this, dims, this.environment);
        }
        return this._arrayBindings[dims - 1];
    }

    protected void registerAnchor() {
        this._instantiatedTypes.put(this._teamAnchor, this);
    }

    public boolean hasExplicitAnchor() {
        return this._teamAnchor != null && this._teamAnchor.isValidBinding() && !(this._teamAnchor instanceof TThisBinding);
    }

    public boolean hasAnchorWithinThisMethodsSignature(MethodBinding method) {
        if (method != null) {
            if (this._declaringMethod == null) {
                return false;
            }
            if (method != this._declaringMethod.getMethod()) {
                return false;
            }
        }
        return this._argumentPosition > -1;
    }

    public TypeBinding maybeInstantiate(ITeamAnchor anchor, int dimensions) {
        RoleTypeBinding cached = (RoleTypeBinding)this._instantiatedTypes.get(anchor);
        if (cached != null) {
            return cached;
        }
        if (anchor == null || anchor == this._teamAnchor) {
            if (dimensions > 0) {
                return this.getArrayType(dimensions);
            }
            return this;
        }
        if (anchor instanceof TThisBinding && (!(this._teamAnchor instanceof TThisBinding) || this._teamAnchor.isTypeCompatibleWithTypeOf(anchor))) {
            if (dimensions > 0) {
                return this.getArrayType(dimensions);
            }
            return this;
        }
        if (!anchor.isTypeCompatibleWithTypeOf(this._teamAnchor)) {
            return this;
        }
        return this.forAnchor(anchor, dimensions);
    }

    TypeBinding forAnchor(ITeamAnchor anchor, int dimensions) {
        return anchor.getRoleTypeBinding(this, dimensions);
    }

    public void collectSubstitutes(Scope scope, TypeBinding actualType, InferenceContext inferenceContext, int constraint) {
        this.transferTypeArguments(this.type).collectSubstitutes(scope, actualType, inferenceContext, constraint);
    }

    public ReferenceBinding transferTypeArguments(ReferenceBinding other) {
        if (this.arguments == null) {
            return other;
        }
        return super.transferTypeArguments(other);
    }

    public static boolean mayTakeValueParam(TypeBinding binding) {
        if (binding.isRole()) {
            return true;
        }
        if (binding.isTypeVariable()) {
            return true;
        }
        return binding.valueParamSynthArgs() != NO_SYNTH_ARGUMENTS;
    }

    public static boolean isDependentType(TypeBinding binding) {
        if (binding == null) {
            return false;
        }
        return (binding.tagBits & 0x400000000000000L) != 0L;
    }

    public static boolean isPlainDependentType(TypeBinding binding) {
        if (binding == null) {
            return false;
        }
        return (binding.tagBits & 0x600000000000000L) == 0x400000000000000L;
    }

    public DependentTypeBinding asPlainDependentType() {
        if ((this.tagBits & 0x200000000000000L) == 0L) {
            return this;
        }
        return null;
    }

    public static boolean isDependentTypeOf(TypeBinding type, ITeamAnchor declaredAnchor) {
        if (!DependentTypeBinding.isPlainDependentType(type)) {
            return false;
        }
        DependentTypeBinding depType = (DependentTypeBinding)type;
        return depType._matchingVariable == declaredAnchor;
    }

    public static boolean isDependentTypeVariable(TypeBinding binding) {
        if ((binding.tagBits & 0x600000000000000L) == 0L) {
            return false;
        }
        return ((DependentTypeBinding)binding).type.kind() == 4100;
    }

    public boolean isEquivalentTo(TypeBinding otherType) {
        if (!(otherType instanceof DependentTypeBinding)) {
            return this.type.isEquivalentTo(otherType);
        }
        DependentTypeBinding otherDep = (DependentTypeBinding)otherType;
        return otherDep._teamAnchor.hasSameBestNameAs(this._teamAnchor) && CharOperation.equals(otherDep.internalName(), this.internalName());
    }

    public boolean isProvablyDistinct(TypeBinding otherType) {
        if (DependentTypeBinding.isDependentType(otherType)) {
            otherType = ((DependentTypeBinding)otherType).getRealType();
        }
        return this.getRealType().isProvablyDistinct(otherType);
    }

    public int kind() {
        return this.arguments != null ? 260 : this.type.kind();
    }

    public void recheckAmbiguousLowering(TypeBinding otherType, ASTNode location, Scope scope, MethodBinding resolvedMethod) {
        if (scope.isGeneratedScope()) {
            return;
        }
        if (otherType instanceof ReferenceBinding && ((ReferenceBinding)otherType).id == 1 && this.baseclass() != null) {
            if (resolvedMethod != null && resolvedMethod.declaringClass.isTeam() && CharOperation.equals(resolvedMethod.selector, ReflectionGenerator.UNREGISTER_ROLE) && (resolvedMethod.parameters.length == 1 || resolvedMethod.parameters.length == 2)) {
                return;
            }
            scope.problemReporter().ambiguousUpcastOrLowering(location, otherType, this);
        }
    }

    public FieldBinding[] fields() {
        return this.type.fields();
    }

    public FieldBinding getField(char[] fieldName, boolean needResolve) {
        return this.type.getField(fieldName, needResolve);
    }

    public MethodBinding getExactConstructor(TypeBinding[] argumentTypes) {
        return this.type.getExactConstructor(argumentTypes);
    }

    public ReferenceBinding getMemberType(char[] typeName) {
        return this.type.getMemberType(typeName);
    }

    public SyntheticArgumentBinding[] valueParamSynthArgs() {
        return this.type.valueParamSynthArgs();
    }

    public TeamModel getTeamModel() {
        if (this._teamModel == null && this.type != null) {
            this._teamModel = this.type.getTeamModel();
        }
        return this._teamModel;
    }

    public ReferenceBinding getRealType() {
        return this.type.getRealType();
    }

    public ReferenceBinding getRealClass() {
        return this.type.getRealClass();
    }

    public ReferenceBinding rawBaseclass() {
        return this.type.rawBaseclass();
    }

    public void setIsBoundBase(ReferenceBinding roleType) {
        super.setIsBoundBase(roleType);
        this.type.setIsBoundBase(roleType);
    }

    public String toString() {
        String anchorStr = "";
        ITeamAnchor[] bestNamePath = this._teamAnchor.getBestNamePath(false);
        int i = 0;
        while (i < bestNamePath.length) {
            if (i > 0) {
                anchorStr = String.valueOf(anchorStr) + ".";
            }
            anchorStr = String.valueOf(anchorStr) + new String(bestNamePath[i].readableName());
            ++i;
        }
        return String.valueOf(new String(this.sourceName())) + "<@" + anchorStr + ">";
    }

    public boolean appendReadableValueParameterNames(StringBuffer buf) {
        buf.append('@');
        buf.append(this.anchorName());
        return true;
    }

    private char[] anchorName() {
        char[] anchorName = new char[]{};
        ITeamAnchor[] bestNamePath = this._teamAnchor.getBestNamePath(false);
        int i = 0;
        while (i < bestNamePath.length) {
            char[] segment = bestNamePath[i].readableName();
            if (CharOperation.equals(segment, IOTConstants._OT_BASE)) {
                segment = "base".toCharArray();
            }
            anchorName = CharOperation.concatWith(new char[][]{anchorName, segment}, '.');
            ++i;
        }
        return anchorName;
    }

    public static interface IMethodProvider {
        public MethodBinding getMethod();
    }
}

