/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.model;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CalloutMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.AnchorUsageRanksAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.WordValueAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.ModelElement;

public class FieldModel
extends ModelElement {
    private FieldDeclaration _decl = null;
    private FieldBinding _binding = null;
    public char[] typeAnchor = null;
    public boolean hasResolveAnchorStarted = false;
    public boolean _clearPrivateModifier = false;
    public ReferenceBinding actualDeclaringClass;
    public CalloutMappingDeclaration _setterCallout = null;
    public CalloutMappingDeclaration _getterCallout = null;
    private MethodBinding _decapsulatingGetter = null;
    private MethodBinding _decapsulatingSetter = null;

    public static FieldModel getModel(FieldDeclaration decl) {
        FieldModel model = decl.model;
        if (model == null) {
            model = decl.binding != null && decl.binding.model != null ? decl.binding.model : new FieldModel(decl);
        }
        return model;
    }

    public static FieldModel getModel(FieldBinding binding) {
        FieldModel model = binding.model;
        if (model == null) {
            model = new FieldModel(binding);
        }
        return model;
    }

    private FieldModel(FieldDeclaration decl) {
        this._decl = decl;
        decl.model = this;
    }

    private FieldModel(FieldBinding binding) {
        this._binding = binding;
        binding.model = this;
    }

    public void setBinding(FieldBinding fieldBinding) {
        if (this._binding != null) assert (this._binding == fieldBinding);
        this._binding = fieldBinding;
        fieldBinding.model = this;
        if (this._clearPrivateModifier) {
            fieldBinding.tagBits |= 0x200L;
        }
    }

    public FieldDeclaration getAST() {
        return this._decl;
    }

    public static ReferenceBinding getActualDeclaringClass(FieldBinding f) {
        if ((f.tagBits & 0x2000000000000000L) != 0L && f.model != null) {
            return f.model.actualDeclaringClass;
        }
        return f.declaringClass;
    }

    public FieldBinding getOriginalFromFake() {
        ReferenceBinding superRole = this.actualDeclaringClass;
        FieldBinding fieldBinding = superRole.getField(this._binding.name, true);
        if (fieldBinding == null) {
            throw new InternalCompilerError("Expected base field not found in super Role " + new String(superRole.readableName()));
        }
        return fieldBinding;
    }

    public static boolean checkCreateModifiersAttribute(TypeDeclaration type, FieldDeclaration field) {
        if ((type.modifiers & 0x1200) != 0 && (field.modifiers & 1) == 0) {
            FieldModel model = FieldModel.getModel(field);
            model.addAttribute(WordValueAttribute.modifiersAttribute(field.modifiers));
            model._clearPrivateModifier = true;
            return true;
        }
        return false;
    }

    public void addUsageRank(int rank) {
        AnchorUsageRanksAttribute attr = (AnchorUsageRanksAttribute)this.getAttribute(IOTConstants.ANCHOR_USAGE_RANKS);
        attr.addUsageRank(rank);
    }

    public static MethodBinding getDecapsulatingFieldAccessor(ReferenceBinding baseType, FieldBinding resolvedField, boolean isGetter) {
        TypeBinding[] typeBindingArray;
        MethodBinding accessor;
        FieldModel model = FieldModel.getModel(resolvedField);
        MethodBinding methodBinding = accessor = isGetter ? model._decapsulatingGetter : model._decapsulatingSetter;
        if (accessor != null) {
            return accessor;
        }
        if (resolvedField.isStatic()) {
            if (isGetter) {
                typeBindingArray = new TypeBinding[]{};
            } else {
                TypeBinding[] typeBindingArray2 = new TypeBinding[1];
                typeBindingArray = typeBindingArray2;
                typeBindingArray2[0] = resolvedField.type;
            }
        } else if (isGetter) {
            TypeBinding[] typeBindingArray3 = new TypeBinding[1];
            typeBindingArray = typeBindingArray3;
            typeBindingArray3[0] = baseType;
        } else {
            TypeBinding[] typeBindingArray4 = new TypeBinding[2];
            typeBindingArray4[0] = baseType;
            typeBindingArray = typeBindingArray4;
            typeBindingArray4[1] = resolvedField.type;
        }
        TypeBinding[] argTypes = typeBindingArray;
        accessor = new MethodBinding(9, CharOperation.concat(isGetter ? IOTConstants.OT_GETFIELD : IOTConstants.OT_SETFIELD, resolvedField.name), isGetter ? resolvedField.type : TypeBinding.VOID, argTypes, Binding.NO_EXCEPTIONS, baseType);
        MethodModel.getModel((MethodBinding)accessor)._fakeKind = MethodModel.FakeKind.BASE_FIELD_ACCESSOR;
        if (isGetter) {
            model._decapsulatingGetter = accessor;
        } else {
            model._decapsulatingSetter = accessor;
        }
        return accessor;
    }

    public static int[] getAnchorUsageRanks(FieldBinding field) {
        if (field.model == null) {
            return null;
        }
        AnchorUsageRanksAttribute attr = (AnchorUsageRanksAttribute)field.model.getAttribute(IOTConstants.ANCHOR_USAGE_RANKS);
        return attr.getRanks();
    }

    public static boolean isCalloutAccessed(FieldBinding fieldBinding) {
        FieldModel model = fieldBinding.model;
        if (model == null) {
            return false;
        }
        return model._setterCallout != null || model._getterCallout != null;
    }
}

