/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.compiler.Pair;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.MethodSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.RoleFileCache;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.BoundClassesHierarchyAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.RoleBaseBindingsAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.WordValueAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.LiftingEnvironment;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.OTClassScope;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.TThisBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TypeModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.Protections;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.RoleTypeCreator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TSuperHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamModel
extends TypeModel {
    public TypeDeclaration markerInterface;
    private RoleBaseBindingsAttribute roleBaseBindings = null;
    public List<Pair<ReferenceBinding, ReferenceBinding>> ambigousLifting = new ArrayList<Pair<ReferenceBinding, ReferenceBinding>>();
    public FieldDeclaration[] caches = new FieldDeclaration[0];
    private TThisBinding tthis;
    private RoleFileCache knownRoleFiles = null;
    public boolean _blockCatchup = false;
    public boolean _isCopyingLateRole = false;
    public LiftingEnvironment liftingEnv = null;
    private int nextCallinID = 0;

    public TeamModel(TypeDeclaration teamAst) {
        super(teamAst);
        if (teamAst.enclosingType == null) {
            this.addAttribute(WordValueAttribute.compilerVersionAttribute());
        }
        if (Config.clientIsBatchCompiler()) {
            this.knownRoleFiles = new RoleFileCache(teamAst);
        }
    }

    public TeamModel(ReferenceBinding teamBinding) {
        super(teamBinding);
        if (!teamBinding.isSynthInterface()) {
            this.tthis = new TThisBinding(teamBinding);
        }
    }

    @Override
    public void setBinding(ReferenceBinding binding) {
        this._binding = binding;
        binding.setTeamModel(this);
        if (!binding.isSynthInterface()) {
            this.tthis = new TThisBinding(binding);
        }
    }

    public void addCache(FieldDeclaration cache) {
        int len = this.caches.length;
        this.caches = new FieldDeclaration[len + 1];
        System.arraycopy(this.caches, 0, this.caches, 0, len);
        this.caches[len] = cache;
    }

    public Set<ReferenceBinding> getSubBases(RoleModel role, RoleModel[] explicitRoles) {
        HashSet<ReferenceBinding> result = new HashSet<ReferenceBinding>();
        ReferenceBinding baseBinding = role.getBaseTypeBinding();
        ReferenceBinding[] referenceBindingArray = this._binding.memberTypes();
        int n = referenceBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                ReferenceBinding currentRole = referenceBindingArray[n2];
                ReferenceBinding currentBase = currentRole.baseclass();
                if (currentBase != null) {
                    for (Pair<ReferenceBinding, ReferenceBinding> ambig : this.ambigousLifting) {
                        if (!ambig.equals(currentBase, role.getBinding())) {
                            continue;
                        }
                        break block10;
                    }
                    if (!currentRole.isCompatibleWith(role.getBinding())) {
                        if (this.generalizesTo(currentBase, baseBinding, explicitRoles)) {
                            result.add(currentBase);
                        }
                    } else if (currentBase.isCompatibleWith(baseBinding)) {
                        int i = 0;
                        while (i < explicitRoles.length) {
                            if (explicitRoles[i].getBaseTypeBinding() != currentBase) {
                                ++i;
                                continue;
                            }
                            break block10;
                        }
                        result.add(currentBase);
                    }
                }
            }
            ++n2;
        }
        return result;
    }

    private boolean generalizesTo(ReferenceBinding alienBase, ReferenceBinding baseBinding, RoleModel[] excludedRoles) {
        ReferenceBinding currentBase = alienBase;
        while (currentBase != null) {
            RoleModel[] roleModelArray = excludedRoles;
            int n = excludedRoles.length;
            int n2 = 0;
            while (n2 < n) {
                RoleModel explicitRole = roleModelArray[n2];
                if (currentBase == explicitRole.getBaseTypeBinding()) {
                    return false;
                }
                ++n2;
            }
            if ((currentBase = currentBase.superclass()) != baseBinding) continue;
            return true;
        }
        return false;
    }

    public void addBoundClassLink(ReferenceBinding subClass, ReferenceBinding superClass) {
        this.ensureRoleBaseBindingsAttribute();
        BoundClassesHierarchyAttribute attribute = null;
        int i = 0;
        while (i < this._attributes.length) {
            if (this._attributes[i].nameEquals(IOTConstants.BOUND_CLASSES_HIERARCHY)) {
                attribute = (BoundClassesHierarchyAttribute)this._attributes[i];
                break;
            }
            ++i;
        }
        if (attribute == null) {
            attribute = new BoundClassesHierarchyAttribute();
            this.addAttribute(attribute);
        }
        attribute.add(subClass.attributeName(), superClass.attributeName());
    }

    public void addRoleBaseBindingAttribute(char[] roleName, char[] baseName, boolean baseIsInterface) {
        this.ensureRoleBaseBindingsAttribute();
        this.roleBaseBindings.add(roleName, baseName, baseIsInterface);
    }

    private void ensureRoleBaseBindingsAttribute() {
        if (this.roleBaseBindings == null) {
            this.roleBaseBindings = new RoleBaseBindingsAttribute();
            this.addAttribute(this.roleBaseBindings);
        }
    }

    @Override
    public void setMemberState(int state) {
        RoleModel[] roles = this.getRoles(true);
        if (roles != null) {
            int i = 0;
            while (i < roles.length) {
                RoleModel role = roles[i];
                role.setMemberState(state);
                role.setState(state);
                if (role.getBinding() != null && role.getBinding().isTeam()) {
                    TeamModel teamModel = role.getBinding().getTeamModel();
                    teamModel.setState(state);
                    teamModel.setMemberState(state);
                }
                ++i;
            }
        }
    }

    public void setMemberStateShallow(int state) {
        RoleModel[] roles = this.getRoles(true);
        if (roles != null) {
            int i = 0;
            while (i < roles.length) {
                RoleModel role = roles[i];
                role.setMemberState(state);
                role.setState(state);
                ++i;
            }
        }
    }

    public TeamModel getSuperTeam() {
        TypeBinding superBinding = null;
        if (this._ast != null) {
            if (this._ast.superclass != null) {
                superBinding = this._ast.superclass.resolveType(this._ast.scope);
            }
        } else {
            superBinding = this._binding.superclass();
        }
        if (superBinding == null) {
            return null;
        }
        assert (((TypeBinding)superBinding).isClass());
        return superBinding.getTeamModel();
    }

    public RoleModel[] getRoles(boolean includeSynthInterfaces) {
        LinkedList<RoleModel> list;
        block5: {
            block4: {
                list = new LinkedList<RoleModel>();
                if (this._binding == null) break block4;
                ReferenceBinding[] roleBindings = this._binding.memberTypes();
                int i = 0;
                while (i < roleBindings.length) {
                    ReferenceBinding binding = roleBindings[i];
                    if (!binding.isEnum() && (includeSynthInterfaces || binding.isDirectRole()) && binding.roleModel != null) {
                        list.add(binding.roleModel);
                    }
                    ++i;
                }
                break block5;
            }
            TypeDeclaration[] roles = this._ast.memberTypes;
            if (roles == null) break block5;
            int idx = 0;
            while (idx < roles.length) {
                RoleModel roleModel;
                if ((roles[idx].modifiers & 0x4000) == 0 && (includeSynthInterfaces || roles[idx].isSourceRole()) && (roleModel = roles[idx].getRoleModel(this)) != null) {
                    list.add(roleModel);
                }
                ++idx;
            }
        }
        return list.toArray(new RoleModel[list.size()]);
    }

    public int getNumRoles() {
        if (this._binding != null) {
            return this._binding.memberTypes().length;
        }
        if (this._ast.memberTypes == null) {
            return 0;
        }
        return this._ast.memberTypes.length;
    }

    public RoleModel getRoleModelOfThis() {
        if (this._ast != null) {
            return this._ast.getRoleModel();
        }
        return this._binding.roleModel;
    }

    @Override
    public boolean isTeam() {
        return true;
    }

    public static boolean isAnyTeam(ReferenceBinding type) {
        ReferenceBinding classPartBinding;
        if (type.isTeam()) {
            return true;
        }
        if (type.isRole() && (classPartBinding = type.roleModel.getClassPartBinding()) != null) {
            return classPartBinding.isTeam();
        }
        return false;
    }

    public static boolean isAnyTeam(TypeDeclaration typeDecl) {
        TypeDeclaration classPart;
        if (typeDecl.isTeam()) {
            return true;
        }
        if (typeDecl.isRole() && typeDecl.isInterface() && (classPart = typeDecl.getRoleModel().getClassPartAst()) != null) {
            return classPart.isTeam();
        }
        return false;
    }

    @Override
    protected String getKindString() {
        return "Team";
    }

    public TThisBinding getTThis() {
        if (this.tthis == null) {
            throw new InternalCompilerError("no tthis for " + new String(this.getBinding().readableName()));
        }
        return this.tthis;
    }

    public static ReferenceBinding getEnclosingTeam(ReferenceBinding nestedType) {
        ReferenceBinding outer = nestedType.enclosingType();
        while (outer != null) {
            if (outer.isTeam()) {
                return outer;
            }
            outer = outer.enclosingType();
        }
        return null;
    }

    public static TypeDeclaration getOutermostTeam(TypeDeclaration type) {
        if (!type.isTeam()) {
            return TeamModel.getOutermostTeam(type.enclosingType);
        }
        TypeDeclaration result = type;
        while (type != null && type.isTeam()) {
            result = type;
            type = type.enclosingType;
        }
        return result;
    }

    private static ReferenceBinding normalizeTeam(ReferenceBinding teamBinding) {
        if (teamBinding == null) {
            return null;
        }
        if (teamBinding.isRole() && teamBinding.isSynthInterface()) {
            return teamBinding.roleModel.getClassPartBinding();
        }
        return teamBinding;
    }

    public static ReferenceBinding findEnclosingTeamContainingRole(ReferenceBinding site, ReferenceBinding roleType) {
        site = TeamModel.normalizeTeam(site);
        while (site != null) {
            if (TeamModel.isTeamContainingRole(site, roleType)) {
                return site;
            }
            site = site.enclosingType();
        }
        return null;
    }

    public static boolean isTeamContainingRole(ReferenceBinding teamBinding, ReferenceBinding roleBinding) {
        return TeamModel.levelFromEnclosingTeam(teamBinding, roleBinding) != 0;
    }

    public static int levelFromEnclosingTeam(ReferenceBinding teamCandidate, ReferenceBinding roleType) {
        ReferenceBinding member;
        ReferenceBinding outerTeam;
        int l2;
        int l = 1;
        if (teamCandidate == null) {
            return 0;
        }
        if (!(teamCandidate = TeamModel.normalizeTeam(teamCandidate)).isTeam()) {
            return 0;
        }
        if (!roleType.isRole()) {
            return 0;
        }
        if (roleType.isParameterizedType()) {
            roleType = ((ParameterizedTypeBinding)roleType).genericType();
        }
        ReferenceBinding roleOuter = roleType.enclosingType();
        if (teamCandidate.isRole() && (l2 = TeamModel.levelFromEnclosingTeam(outerTeam = teamCandidate.enclosingType(), roleOuter)) > 0) {
            if (l2 == 1) {
                roleOuter = outerTeam.getMemberType(roleOuter.internalName());
            }
            l = l2;
        }
        if ((member = teamCandidate.getMemberType(roleType.internalName())) == null) {
            if (roleOuter.isRole() && (l2 = TeamModel.levelFromEnclosingTeam(teamCandidate, roleOuter)) > 0) {
                return l2 + 1;
            }
            return 0;
        }
        if (TeamModel.areTypesCompatible(teamCandidate, roleOuter)) {
            return l;
        }
        return 0;
    }

    public static boolean areTypesCompatible(ReferenceBinding type1, ReferenceBinding type2) {
        if (type1.isRole() && type2.isRole()) {
            if (!type1.isInterface()) {
                type1 = type1.roleModel.getInterfacePartBinding();
            }
            if (!type2.isInterface()) {
                type2 = type2.roleModel.getInterfacePartBinding();
            }
        }
        return type1.isCompatibleWith(type2);
    }

    public static boolean isComparableToRole(ReferenceBinding expressionType, ReferenceBinding castType) {
        if (!castType.isDirectRole()) {
            return false;
        }
        return castType.getRealType().isCompatibleWith(expressionType.getRealType()) || expressionType.getRealType().isCompatibleWith(castType.getRealType());
    }

    public static boolean areCompatibleEnclosings(ReferenceBinding left, ReferenceBinding right) {
        if (TeamModel.areTypesCompatible(left, right)) {
            return true;
        }
        if (!CharOperation.equals(left.sourceName(), right.sourceName())) {
            return false;
        }
        ReferenceBinding leftEnclosing = left.enclosingType();
        ReferenceBinding rightEnclosing = right.enclosingType();
        if (leftEnclosing == null || rightEnclosing == null) {
            return false;
        }
        if (leftEnclosing.isTeam() && rightEnclosing.isTeam()) {
            return TeamModel.areCompatibleEnclosings(leftEnclosing, rightEnclosing);
        }
        return false;
    }

    public static TypeBinding strengthenRoleType(ReferenceBinding site, TypeBinding roleType) {
        ReferenceBinding enclosingTeam = site;
        if (!(enclosingTeam = TeamModel.normalizeTeam(enclosingTeam)).isTeam()) {
            enclosingTeam = TeamModel.getEnclosingTeam(site);
        }
        if (enclosingTeam == null) {
            return roleType;
        }
        if (roleType.isLocalType()) {
            return roleType;
        }
        int dimensions = roleType.dimensions();
        ReferenceBinding roleRefType = (ReferenceBinding)roleType.leafComponentType();
        ReferenceBinding roleEnclosing = roleRefType.enclosingType();
        if (roleEnclosing.isRole() && roleEnclosing != site) {
            ReferenceBinding strengthenedEnclosing = null;
            if (roleEnclosing.enclosingType() != enclosingTeam.enclosingType()) {
                strengthenedEnclosing = (ReferenceBinding)TeamModel.strengthenRoleType(site, roleEnclosing);
            }
            if (strengthenedEnclosing != null && strengthenedEnclosing != site) {
                return TeamModel.strengthenRoleType(strengthenedEnclosing, roleType);
            }
        }
        if (!roleRefType.isRole() || !TeamModel.areCompatibleEnclosings(enclosingTeam, roleEnclosing)) {
            if (enclosingTeam.isRole()) {
                return TeamModel.strengthenRoleType(enclosingTeam.enclosingType(), roleType);
            }
            return roleType;
        }
        if (roleRefType instanceof RoleTypeBinding) {
            RoleTypeBinding rtb = (RoleTypeBinding)roleRefType;
            if (!(rtb._teamAnchor instanceof TThisBinding)) {
                return roleType;
            }
        }
        if ((roleRefType = enclosingTeam.getMemberType(roleRefType.internalName())) == null) {
            ClassScope scope;
            if (enclosingTeam.isBinaryBinding()) {
                ClassScope scope2;
                ReferenceBinding current = enclosingTeam;
                while (current != null && current.isBinaryBinding()) {
                    current = current.enclosingType();
                }
                if (current != null && (scope2 = ((SourceTypeBinding)current).scope) != null) {
                    ((Scope)scope2).problemReporter().missingRoleInBinaryTeam(roleType.constantPoolName(), enclosingTeam);
                    return null;
                }
            }
            if (Protections.hasClassKindProblem(enclosingTeam)) {
                return roleType;
            }
            if (!enclosingTeam.isBinaryBinding()) {
                scope = ((SourceTypeBinding)enclosingTeam.getRealType()).scope;
                ((Scope)scope).problemReporter().missingCopiedRole(roleType, enclosingTeam);
            } else if (!site.isBinaryBinding()) {
                scope = ((SourceTypeBinding)site.getRealType()).scope;
                ((Scope)scope).problemReporter().missingCopiedRole(roleType, enclosingTeam);
            } else {
                throw new InternalCompilerError("could not find role " + String.valueOf(roleType.constantPoolName()) + " in " + String.valueOf(site.constantPoolName()) + " and could not report regularly");
            }
            return roleType;
        }
        TThisBinding anchor = enclosingTeam.getTeamModel().getTThis();
        if (roleType.isParameterizedType()) {
            ParameterizedTypeBinding ptb = (ParameterizedTypeBinding)roleType;
            ParameterizedTypeBinding parameterized = ptb.environment.createParameterizedType(roleRefType, ptb.arguments, anchor, -1, roleRefType.enclosingType());
            if (dimensions > 0) {
                return ptb.environment.createArrayType(parameterized, dimensions);
            }
            return parameterized;
        }
        return anchor.getRoleTypeBinding(roleRefType, dimensions);
    }

    public static ReferenceBinding strengthenEnclosing(ReferenceBinding site, ReferenceBinding targetEnclosing) {
        ReferenceBinding currentEnclosing = site;
        while (targetEnclosing != currentEnclosing) {
            if (currentEnclosing.isCompatibleWith(targetEnclosing)) {
                return currentEnclosing;
            }
            if ((currentEnclosing = currentEnclosing.enclosingType()) != null) continue;
            throw new InternalCompilerError("Target class for callin binding not found: " + String.valueOf(targetEnclosing.readableName()));
        }
        return targetEnclosing;
    }

    public static ReferenceBinding findMemberTypeInContext(ReferenceBinding site, char[] className) {
        while (site != null) {
            ReferenceBinding roleType = site.getMemberType(className);
            if (roleType != null) {
                return roleType;
            }
            site = site.enclosingType();
        }
        return null;
    }

    public static boolean isMoreSpecificThan(ReferenceBinding type1, ReferenceBinding type2) {
        if (type1.isCompatibleWith(type2)) {
            return true;
        }
        ReferenceBinding enclosingType1 = type1.enclosingType();
        ReferenceBinding enclosingType2 = type2.enclosingType();
        if (enclosingType1 != null && enclosingType2 != null) {
            return TeamModel.isMoreSpecificThan(enclosingType1, enclosingType2);
        }
        return false;
    }

    public static TypeBinding getRoleToLiftTo(Scope scope, TypeBinding provided, TypeBinding required, boolean doAdjust, ASTNode location) {
        ReferenceBinding requiredRef = null;
        if (required.isArrayType() && required.leafComponentType() instanceof ReferenceBinding) {
            requiredRef = (ReferenceBinding)required.leafComponentType();
        } else if (required instanceof ReferenceBinding) {
            requiredRef = (ReferenceBinding)required;
        }
        if (requiredRef != null && requiredRef.isRole()) {
            TeamModel enclosingTeam = requiredRef.enclosingType().getTeamModel();
            if (enclosingTeam != null && !provided.leafComponentType().isBaseType()) {
                for (Pair<ReferenceBinding, ReferenceBinding> ambig : enclosingTeam.ambigousLifting) {
                    if (!ambig.equals((ReferenceBinding)provided.leafComponentType(), requiredRef)) continue;
                    scope.problemReporter().definiteLiftingAmbiguity(provided, required, location);
                    return null;
                }
            }
            requiredRef = (ReferenceBinding)TeamModel.strengthenRoleType(scope.enclosingSourceType(), requiredRef);
            ReferenceBinding foundRole = null;
            if (requiredRef.baseclass() == null) {
                foundRole = TeamModel.adjustRoleToLiftTo(scope, provided, requiredRef, location);
                if (foundRole != null && !doAdjust) {
                    foundRole = requiredRef;
                }
            } else if (!provided.leafComponentType().isBaseType()) {
                ReferenceBinding providedLeaf = (ReferenceBinding)provided.leafComponentType();
                if ((providedLeaf = RoleTypeCreator.maybeInstantiateFromPlayedBy(scope, providedLeaf)).isCompatibleWith(requiredRef.baseclass()) && required.dimensions() == provided.dimensions()) {
                    foundRole = requiredRef;
                }
            }
            if (foundRole != null) {
                if (required.dimensions() == 0) {
                    return foundRole;
                }
                return scope.createArrayType(foundRole, required.dimensions());
            }
        }
        return null;
    }

    private static ReferenceBinding adjustRoleToLiftTo(Scope scope, TypeBinding provided, ReferenceBinding required, ASTNode location) {
        ReferenceBinding mostGeneralFound = null;
        ReferenceBinding mostSpecificFound = null;
        ReferenceBinding enclosingTeam = required.enclosingType();
        ReferenceBinding[] roleTypes = enclosingTeam.memberTypes();
        ReferenceBinding requiredLeaf = (ReferenceBinding)required.leafComponentType();
        requiredLeaf = requiredLeaf.getRealType();
        int i = 0;
        while (i < roleTypes.length) {
            if (!TSuperHelper.isMarkerInterface(roleTypes[i])) {
                RoleModel currentRole = roleTypes[i].roleModel;
                ReferenceBinding currentRoleIfc = currentRole.getInterfacePartBinding();
                ReferenceBinding currentBase = currentRole.getBaseTypeBinding();
                if (mostGeneralFound != currentRoleIfc && currentBase != null && provided.leafComponentType().isCompatibleWith(currentBase) && currentRoleIfc.isCompatibleWith(requiredLeaf)) {
                    if (mostGeneralFound == null) {
                        mostGeneralFound = currentRoleIfc;
                        mostSpecificFound = currentRoleIfc;
                    } else if (mostGeneralFound.isCompatibleWith(currentRoleIfc)) {
                        mostGeneralFound = currentRoleIfc;
                    } else if (currentRoleIfc.isCompatibleWith(mostSpecificFound)) {
                        mostSpecificFound = currentRoleIfc;
                    } else {
                        scope.problemReporter().definiteLiftingAmbiguity(provided, required, location);
                        return null;
                    }
                }
            }
            ++i;
        }
        return mostGeneralFound;
    }

    public void setupRoFiCache(Scope scope, LookupEnvironment environment) {
        if (this.knownRoleFiles != null) {
            this.knownRoleFiles.createTypeAndBinding(scope, environment);
        }
    }

    public static boolean hasRoFiCache(ReferenceBinding receiverType) {
        if (!receiverType.isTeam()) {
            return false;
        }
        TeamModel model = receiverType.getTeamModel();
        if (model.knownRoleFiles == null) {
            return false;
        }
        return model.knownRoleFiles.isValid;
    }

    public void readKnownRoleFiles() {
        if (this.knownRoleFiles != null) {
            this.knownRoleFiles.readKnownRoles();
        }
    }

    public void generateRoFiCache(ClassFile classFile) {
        if (this.knownRoleFiles != null && !Protections.hasClassKindProblem(this._binding)) {
            this.knownRoleFiles.generateCode(classFile);
        }
    }

    public void addKnownRoleFile(char[] name, ReferenceBinding role) {
        if (this.knownRoleFiles != null) {
            this.knownRoleFiles.addRoleFile(name);
        }
        if (this._ast != null && this._ast.scope instanceof OTClassScope) {
            ((OTClassScope)this._ast.scope).recordBaseClassUse(role.baseclass);
        }
    }

    public ReferenceBinding[] getKnownRoles() {
        ReferenceBinding[] members = this._binding.memberTypes();
        if (this.knownRoleFiles == null) {
            return members;
        }
        HashSet<String> roleNames = new HashSet<String>();
        int i = 0;
        while (i < members.length) {
            if (!RoleFileCache.isRoFiCache(members[i])) {
                roleNames.add(new String(members[i].internalName()));
            }
            ++i;
        }
        char[][] roleFileNames = this.knownRoleFiles.getNames();
        int i2 = 0;
        while (i2 < roleFileNames.length) {
            roleNames.add(new String(roleFileNames[i2]));
            ++i2;
        }
        int len = roleNames.size();
        int i3 = 0;
        ReferenceBinding[] result = new ReferenceBinding[len];
        for (String name : roleNames) {
            result[i3++] = this._binding.getMemberType(name.toCharArray());
        }
        return result;
    }

    public TypeBinding getMarkerInterfaceBinding(Scope scope) {
        Object object;
        if (this.markerInterface != null) {
            return this.markerInterface.binding;
        }
        if (this._binding != null && this._binding.superclass() != null) {
            TSuperHelper.addMarkerInterface(this, this._binding.superclass());
            return this.markerInterface.binding;
        }
        PackageBinding pkgBinding = scope.compilationUnitScope().fPackage;
        char[] markerName = "MissingTSuperMarker".toCharArray();
        if (this._binding != null) {
            object = CharOperation.arrayConcat(this._binding.compoundName, markerName);
        } else {
            char[][] cArrayArray = new char[1][];
            object = cArrayArray;
            cArrayArray[0] = markerName;
        }
        Object compoundName = object;
        return scope.compilationUnitScope().environment.createMissingType(pkgBinding, (char[][])compoundName);
    }

    public int getNewCallinId(MethodSpec baseMethodSpec) {
        int callinID;
        baseMethodSpec.callinID = callinID = this.nextCallinID++;
        return callinID;
    }
}

