/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.util;

import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;

public class Sorting {
    public static void sortMemberTypes(SourceTypeBinding enclosing) {
        int len = enclosing.memberTypes.length;
        ReferenceBinding[] unsorted = enclosing.memberTypes;
        ReferenceBinding[] sorted = new ReferenceBinding[len];
        int o = 0;
        int i = 0;
        while (i < len) {
            o = Sorting.sort(enclosing, unsorted, i, sorted, o);
            ++i;
        }
        enclosing.memberTypes = sorted;
    }

    private static int sort(ReferenceBinding enclosing, ReferenceBinding[] input, int i, ReferenceBinding[] output, int o) {
        if (input[i] == null) {
            return o;
        }
        ReferenceBinding superclass = input[i].superclass();
        o = Sorting.sortSuper(enclosing, superclass, input, output, o);
        ReferenceBinding[] referenceBindingArray = input[i].superInterfaces();
        int n = referenceBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReferenceBinding superIfc = referenceBindingArray[n2];
            o = Sorting.sortSuper(enclosing, superIfc, input, output, o);
            ++n2;
        }
        output[o++] = input[i];
        input[i] = null;
        return o;
    }

    private static int sortSuper(ReferenceBinding enclosing, ReferenceBinding superclass, ReferenceBinding[] input, ReferenceBinding[] output, int o) {
        if (superclass != null && superclass.id != 1 && superclass.enclosingType() == enclosing) {
            int j = 0;
            j = 0;
            while (j < input.length) {
                if (input[j] == superclass) break;
                ++j;
            }
            if (j < input.length) {
                o = Sorting.sort(enclosing, input, j, output, o);
            }
        }
        return o;
    }

    public static RoleModel[] sortRoles(RoleModel[] unsorted) {
        int len = unsorted.length;
        RoleModel[] sorted = new RoleModel[len];
        int o = 0;
        int i = 0;
        while (i < len) {
            o = Sorting.sort(unsorted, i, sorted, o);
            ++i;
        }
        return sorted;
    }

    private static int sort(RoleModel[] input, int i, RoleModel[] output, int o) {
        if (input[i] == null || input[i].getBinding() == null) {
            return o;
        }
        ReferenceBinding inBinding = input[i].getBinding();
        ReferenceBinding superclass = inBinding.superclass();
        o = Sorting.sortSuper(superclass, input, output, o);
        ReferenceBinding[] referenceBindingArray = inBinding.superInterfaces();
        int n = referenceBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReferenceBinding superIfc = referenceBindingArray[n2];
            o = Sorting.sortSuper(superIfc, input, output, o);
            ++n2;
        }
        output[o++] = input[i];
        input[i] = null;
        return o;
    }

    private static int sortSuper(ReferenceBinding superclass, RoleModel[] input, RoleModel[] output, int o) {
        if (superclass != null && superclass.id != 1) {
            boolean inScope = false;
            RoleModel[] roleModelArray = input;
            int n = input.length;
            int n2 = 0;
            while (n2 < n) {
                RoleModel rm = roleModelArray[n2];
                if (rm != null && rm.getBinding() == superclass) {
                    inScope = true;
                    break;
                }
                ++n2;
            }
            if (inScope) {
                int j = 0;
                j = 0;
                while (j < input.length) {
                    if (input[j].getBinding() == superclass) break;
                    ++j;
                }
                if (j < input.length) {
                    o = Sorting.sort(input, j, output, o);
                }
            }
        }
        return o;
    }

    public static void sortMemberTypes(TypeDeclaration typeDeclaration) {
        if (typeDeclaration.memberTypes == null) {
            return;
        }
        ReferenceBinding[] bindings = typeDeclaration.binding.memberTypes;
        TypeDeclaration[] unsorted = typeDeclaration.memberTypes;
        TypeDeclaration[] newMembers = new TypeDeclaration[unsorted.length];
        int l = 0;
        int i = 0;
        while (i < bindings.length) {
            block6: {
                ReferenceBinding current = bindings[i];
                if (!current.isBinaryBinding()) {
                    int j = 0;
                    while (j < unsorted.length) {
                        if (unsorted[j].binding == current) {
                            newMembers[l++] = unsorted[j];
                            break block6;
                        }
                        ++j;
                    }
                    throw new InternalCompilerError("Unmatched member type " + String.valueOf(current.readableName()));
                }
            }
            ++i;
        }
        if (l < newMembers.length) {
            throw new InternalCompilerError("Not all member types matched: " + l);
        }
        typeDeclaration.memberTypes = newMembers;
    }
}

