/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.debug.ui.internal.preferences;

import java.util.List;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.preferences.BooleanFieldEditor2;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.objectteams.otdt.debug.ui.OTDebugUIPlugin;
import org.eclipse.objectteams.otdt.debug.ui.internal.preferences.OTDebugPreferences;
import org.eclipse.objectteams.otdt.debug.ui.internal.preferences.OTDebugPreferencesMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.internal.Workbench;

public class OTDebugPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String JAVA_STEP_FILTER_PREFERENCE_PAGE = "org.eclipse.jdt.debug.ui.JavaStepFilterPreferencePage";
    protected boolean _debugFiltersEnabled;
    private Composite _parentComposite;
    private ColorFieldEditor fGeneratedCodeColorFieldEditor;
    private ColorFieldEditor fSpecialCodeColorFieldEditor;
    private BooleanFieldEditor2 fDebugFilter;
    private String[] callinLabels = new String[]{OTDebugPreferencesMessages.OTDebugPreferencePage_callin_step_role_label, OTDebugPreferencesMessages.OTDebugPreferencePage_callin_step_recurse_label, OTDebugPreferencesMessages.OTDebugPreferencePage_callin_step_base_label};

    public OTDebugPreferencePage() {
        super(1);
        this.setTitle(OTDebugPreferencesMessages.OTDebugPreferencePage_title);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this._parentComposite = parent;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return OTDebugUIPlugin.getDefault().getPreferenceStore();
    }

    protected void createFieldEditors() {
        Composite groupAll = new Composite(this.getFieldEditorParent(), 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(10);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        groupAll.setLayout((Layout)layout);
        Group group = new Group(groupAll, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(OTDebugPreferencesMessages.OTDebugPreferencePage_enable_filter_title);
        this.fDebugFilter = new BooleanFieldEditor2("prefs.ot.debugfilters.enabled", OTDebugPreferencesMessages.OTDebugPreferencePage_enableFilter_label, 0, (Composite)group);
        this.addField((FieldEditor)this.fDebugFilter);
        this.fDebugFilter.getChangeControl(groupAll).addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OTDebugPreferencePage.this.setDebugFiltersEnabled(OTDebugPreferencePage.this.fDebugFilter.getBooleanValue());
            }
        });
        group = new Group(groupAll, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(OTDebugPreferencesMessages.OTDebugPreferencePage_stackFrameColoringGroup_label);
        Composite spacer = SWTFactory.createComposite((Composite)group, (int)2, (int)1, (int)768);
        this.fGeneratedCodeColorFieldEditor = new ColorFieldEditor("org.eclipse.objectteams.otdt.debug.ui.OtGeneratedCodeColor", OTDebugPreferencesMessages.OTDebugPreferencePage_colorGeneratedCode_label, spacer);
        this.fGeneratedCodeColorFieldEditor.fillIntoGrid(spacer, 2);
        this.addField((FieldEditor)this.fGeneratedCodeColorFieldEditor);
        this.fSpecialCodeColorFieldEditor = new ColorFieldEditor("org.eclipse.objectteams.otdt.debug.ui.OtSpecialCodeColor", OTDebugPreferencesMessages.OTDebugPreferencePage_colorSpecialCode_label, spacer);
        this.fSpecialCodeColorFieldEditor.fillIntoGrid(spacer, 2);
        this.addField((FieldEditor)this.fSpecialCodeColorFieldEditor);
        group = new Group(groupAll, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(OTDebugPreferencesMessages.OTDebugPreferencePage_callin_stepping_title);
        int i = 0;
        while (i < OTDebugPreferences.CALLIN_STEPPING_TOKENS.length) {
            final String token = OTDebugPreferences.CALLIN_STEPPING_TOKENS[i];
            final BooleanFieldEditor2 editor = new BooleanFieldEditor2("org.eclipse.objectteams.otdt.debug.ui.OtCallinStepping." + token, this.callinLabels[i], 0, (Composite)group);
            this.addField((FieldEditor)editor);
            editor.getChangeControl((Composite)group).addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    OTDebugPreferences.setCallinStepping(token, editor.getBooleanValue());
                }
            });
            ++i;
        }
        Label description = new Label((Composite)group, 16448);
        Font font = description.getFont();
        FontData[] data = font.getFontData();
        data[0].setStyle(2);
        description.setFont(new Font(font.getDevice(), data[0]));
        description.setText(OTDebugPreferencesMessages.OTDebugPreferencePage_callin_stepping_hint);
        description.setLayoutData((Object)new GridData(1, 2, true, false, 0, 1));
    }

    protected void performDefaults() {
        OTDebugPreferences.propagateFilterFlag(this.getPreferenceStore());
        super.performDefaults();
    }

    private void setDebugFiltersEnabled(boolean enable) {
        if (this._debugFiltersEnabled == enable) {
            return;
        }
        this._debugFiltersEnabled = enable;
        OTDebugPreferences.setUseOTStepFilters(enable);
        this.updateStepFilteringPrefPage();
    }

    private void updateStepFilteringPrefPage() {
        List prefs = Workbench.getInstance().getPreferenceManager().getElements(0);
        for (PreferenceNode node : prefs) {
            if (node.getId().indexOf(JAVA_STEP_FILTER_PREFERENCE_PAGE) == -1) continue;
            this.forcePreferencePageRecreation(node);
        }
    }

    private void forcePreferencePageRecreation(PreferenceNode node) {
        IPreferencePage oldPage = node.getPage();
        if (oldPage != null) {
            node.setPage(null);
            node.createPage();
            node.getPage().createControl(this._parentComposite);
            oldPage.dispose();
        }
    }

    public void init(IWorkbench workbench) {
    }
}

