/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.debug.internal;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaBreakpointListener;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.core.model.JDIThisVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.objectteams.otdt.debug.IOTDebugEventListener;
import org.eclipse.objectteams.otdt.debug.OTDebugElementsContainer;
import org.eclipse.objectteams.otdt.debug.OTDebugPlugin;
import org.eclipse.objectteams.otdt.debug.TeamInstance;
import org.eclipse.objectteams.otdt.debug.core.breakpoints.OOTBreakpoints;

public class TeamBreakpointListener
implements IJavaBreakpointListener {
    private static TeamBreakpointListener _singleton;

    public static TeamBreakpointListener getInstance() {
        if (_singleton == null) {
            _singleton = new TeamBreakpointListener();
        }
        return _singleton;
    }

    public int breakpointHit(IJavaThread thread, IJavaBreakpoint breakpoint) {
        OTDebugElementsContainer otDebugElementsContainer;
        block16: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            otDebugElementsContainer = this.getDebugElementsContainer(thread.getLaunch());
                            if (otDebugElementsContainer == null) {
                                return 4;
                            }
                            if (!breakpoint.getMarker().exists()) {
                                return 4;
                            }
                            try {
                                if (!OOTBreakpoints.isOOTConstructorBreakpoint((IBreakpoint)breakpoint)) break block12;
                                JDIThisVariable teamVariable = (JDIThisVariable)thread.findVariable("this");
                                if (otDebugElementsContainer.getTeamInstance((IJavaVariable)teamVariable) == null) {
                                    TeamInstance newTeam = otDebugElementsContainer.addTeamInstance(teamVariable);
                                    this.notifyTeamInstantiation(otDebugElementsContainer, newTeam);
                                }
                                return 2;
                            }
                            catch (Exception ex) {
                                OTDebugPlugin.getExceptionHandler().logException("Teammonitor can't read infos from debugTarget anymore. Disconnected?", (Throwable)ex);
                                return 2;
                            }
                        }
                        if (!OOTBreakpoints.isOOTFinalizeBreakpoint((IBreakpoint)breakpoint)) break block13;
                        IJavaVariable teamVariable = thread.findVariable("this");
                        int idx = otDebugElementsContainer.removeTeamInstance(teamVariable);
                        if (idx != -1) {
                            this.notifyTeamFinalize(otDebugElementsContainer, idx);
                        }
                        return 2;
                    }
                    if (!OOTBreakpoints.isOOTActiveMethodBreakpoint((IBreakpoint)breakpoint)) break block14;
                    IJavaVariable teamVariable = thread.findVariable("this");
                    TeamInstance teamInstance = otDebugElementsContainer.getTeamInstance(teamVariable);
                    IJavaVariable teamActiveThread = thread.findVariable("thread");
                    IValue threadValue = teamActiveThread.getValue();
                    long threadID = ((JDIObjectValue)threadValue).getUniqueId();
                    teamInstance.setActiveForThreadID(threadID);
                    IJavaVariable teamGlobalThread = thread.findVariable("ALL_THREADS");
                    IValue globalThreadValue = teamGlobalThread.getValue();
                    long globalThreadID = ((JDIObjectValue)globalThreadValue).getUniqueId();
                    teamInstance.setGlobalThreadID(globalThreadID);
                    this.notifyActivationState(teamInstance);
                    return 2;
                }
                if (!OOTBreakpoints.isOOTDeactiveMethodBreakpoint((IBreakpoint)breakpoint)) break block15;
                IJavaVariable teamVariable = thread.findVariable("this");
                TeamInstance teamInstance = otDebugElementsContainer.getTeamInstance(teamVariable);
                IJavaVariable teamDeactiveThread = thread.findVariable("thread");
                IValue threadValue = teamDeactiveThread.getValue();
                long threadID = ((JDIObjectValue)threadValue).getUniqueId();
                teamInstance.setInactiveForThreadID(new Long(threadID));
                this.notifyActivationState(teamInstance);
                return 2;
            }
            if (!OOTBreakpoints.isOOTImplicitActiveMethodBreakpoint((IBreakpoint)breakpoint)) break block16;
            IJavaVariable teamVariable = thread.findVariable("this");
            TeamInstance teamInstance = otDebugElementsContainer.getTeamInstance(teamVariable);
            long threadID = ((JDIThread)thread).getUnderlyingThread().uniqueID();
            teamInstance.setImplicitActiveForThreadID(threadID);
            this.notifyActivationState(teamInstance);
            return 2;
        }
        if (OOTBreakpoints.isOOTImplicitDeactiveMethodBreakpoint((IBreakpoint)breakpoint)) {
            IJavaVariable teamVariable = thread.findVariable("this");
            TeamInstance teamInstance = otDebugElementsContainer.getTeamInstance(teamVariable);
            long threadID = ((JDIThread)thread).getUnderlyingThread().uniqueID();
            teamInstance.setImplicitInactiveForThreadID(threadID);
            this.notifyActivationState(teamInstance);
            return 2;
        }
        return 4;
    }

    protected OTDebugElementsContainer getDebugElementsContainer(ILaunch launch) {
        return (OTDebugElementsContainer)launch.getAdapter(OTDebugElementsContainer.class);
    }

    private void notifyTeamInstantiation(OTDebugElementsContainer container, TeamInstance newTeam) {
        IOTDebugEventListener[] iOTDebugEventListenerArray = OTDebugPlugin.getDefault().getOTDebugEventListeners();
        int n = iOTDebugEventListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOTDebugEventListener listener = iOTDebugEventListenerArray[n2];
            listener.teamInstantiated(newTeam);
            ++n2;
        }
    }

    private void notifyTeamFinalize(OTDebugElementsContainer container, int idx) {
        IOTDebugEventListener[] iOTDebugEventListenerArray = OTDebugPlugin.getDefault().getOTDebugEventListeners();
        int n = iOTDebugEventListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOTDebugEventListener listener = iOTDebugEventListenerArray[n2];
            listener.teamDisposed(idx);
            ++n2;
        }
    }

    private void notifyActivationState(TeamInstance teamInstance) {
        IOTDebugEventListener[] iOTDebugEventListenerArray = OTDebugPlugin.getDefault().getOTDebugEventListeners();
        int n = iOTDebugEventListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOTDebugEventListener listener = iOTDebugEventListenerArray[n2];
            listener.activationStateChanged(teamInstance);
            ++n2;
        }
    }

    public void addingBreakpoint(IJavaDebugTarget target, IJavaBreakpoint breakpoint) {
    }

    public void breakpointHasCompilationErrors(IJavaLineBreakpoint breakpoint, Message[] errors) {
    }

    public void breakpointHasRuntimeException(IJavaLineBreakpoint breakpoint, DebugException exception) {
    }

    public void breakpointInstalled(IJavaDebugTarget target, IJavaBreakpoint breakpoint) {
    }

    public void breakpointRemoved(IJavaDebugTarget target, IJavaBreakpoint breakpoint) {
    }

    public int installingBreakpoint(IJavaDebugTarget target, IJavaBreakpoint breakpoint, IJavaType type) {
        return 4;
    }

    public void dispose() {
        _singleton = null;
    }
}

