/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.debug;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIThisVariable;
import org.eclipse.objectteams.otdt.debug.TeamInstance;
import org.eclipse.objectteams.otdt.debug.internal.util.TeamActivationOrderComparator;
import org.eclipse.objectteams.otdt.debug.internal.util.TeamActivationTimeComparator;
import org.eclipse.objectteams.otdt.debug.internal.util.TeamInstantiantionComparator;
import org.eclipse.objectteams.otdt.debug.internal.util.TeamNameComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTDebugElementsContainer
implements IAdaptable {
    private ArrayList<TeamInstance> _teamInstances = new ArrayList();
    private IDebugElement _context;
    private String _sortMode;

    public Object getAdapter(Class adapter) {
        return AdapterManager.getDefault().getAdapter((Object)this, adapter);
    }

    public IDebugElement getContext() {
        return this._context;
    }

    public boolean setContext(IDebugElement context) {
        if (this._context == context) {
            return false;
        }
        this._context = context;
        return true;
    }

    public void dispose() {
        this._teamInstances.clear();
    }

    public TeamInstance addTeamInstance(JDIThisVariable teamVariable) throws DebugException {
        TeamInstance teamInstance = this.getTeamInstance((IJavaVariable)teamVariable);
        if (teamInstance == null) {
            teamInstance = new TeamInstance(teamVariable);
            this._teamInstances.add(teamInstance);
            this.sortTeamInstances();
        }
        return teamInstance;
    }

    public int removeTeamInstance(IJavaVariable teamVariable) {
        int i = 0;
        while (i < this._teamInstances.size()) {
            if (this._teamInstances.get(i).equals(teamVariable)) {
                this._teamInstances.remove(i);
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setSortMode(String sortMode) {
        String oldSortMode = this._sortMode;
        this._sortMode = sortMode;
        if (sortMode != null && !sortMode.equals(oldSortMode)) {
            this.sortTeamInstances();
        }
    }

    private void sortTeamInstances() {
        if (this._sortMode == null) {
            return;
        }
        if (this._sortMode.equals("Teams.by.activationtime")) {
            Collections.sort(this._teamInstances, new TeamActivationTimeComparator());
        }
        if (this._sortMode.equals("Teams.by.activationorder")) {
            Collections.sort(this._teamInstances, new TeamActivationOrderComparator());
        }
        if (this._sortMode.equals("Teams.by.instantiation")) {
            Collections.sort(this._teamInstances, new TeamInstantiantionComparator());
        }
        if (this._sortMode.equals("Teams.by.name")) {
            Collections.sort(this._teamInstances, new TeamNameComparator());
        }
    }

    public boolean hasTeamInstances() {
        return !this._teamInstances.isEmpty();
    }

    public int getChildCount() {
        return this._teamInstances.size();
    }

    public TeamInstance getTeamInstance(IJavaVariable teamVariable) {
        for (TeamInstance teamInstance : this._teamInstances) {
            if (!teamInstance.equals(teamVariable)) continue;
            return teamInstance;
        }
        return null;
    }

    public int getIndexOfTeamInstance(TeamInstance teamInstance) {
        int i = 0;
        while (i < this._teamInstances.size()) {
            if (this._teamInstances.get(i).equals((Object)teamInstance)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ArrayList<TeamInstance> getTeamInstances() {
        return this._teamInstances;
    }

    public IJavaThread getContextThread() {
        if (this._context instanceof IJavaThread) {
            return (IJavaThread)this._context;
        }
        if (this._context instanceof IStackFrame) {
            return (IJavaThread)((IStackFrame)this._context).getThread();
        }
        return null;
    }

    public boolean isSuspended() {
        IJavaThread contextThread = this.getContextThread();
        if (contextThread != null && contextThread.isSuspended()) {
            return true;
        }
        IDebugTarget target = null;
        target = this._context instanceof IDebugTarget ? (IDebugTarget)this._context : this._context.getDebugTarget();
        return target.canResume();
    }
}

