/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.debug;

import java.util.HashMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationMigrationDelegate;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.internal.core.LaunchConfiguration;
import org.eclipse.debug.internal.core.LaunchConfigurationInfo;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

public class OTLaunchConfigMigrationDelegate
implements ILaunchConfigurationMigrationDelegate {
    static final HashMap<String, String> oldToNew = new HashMap();

    static {
        oldToNew.put("org.objectteams.otdt.debug.LaunchConfigurationType", IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        oldToNew.put("org.objectteams.otdt.pde.ui.OTEquinoxLaunchConfigurationType", "org.eclipse.pde.ui.EquinoxLauncher");
        oldToNew.put("org.objectteams.otdt.pde.ui.EclipseApplicationLaunchConfigurationType", "org.eclipse.pde.ui.RuntimeWorkbench");
    }

    public boolean isCandidate(ILaunchConfiguration candidate) throws CoreException {
        String candidateType = candidate.getType().getIdentifier();
        return candidateType.startsWith("org.objectteams.otdt") && oldToNew.containsKey(candidateType);
    }

    public void migrate(final ILaunchConfiguration candidate) throws CoreException {
        final String newId = oldToNew.get(candidate.getType().getIdentifier());
        if (newId == null) {
            return;
        }
        LaunchConfiguration wrapper = new LaunchConfiguration(candidate.getMemento()){

            protected LaunchConfigurationInfo getInfo() throws CoreException {
                return new LaunchConfigurationInfo(){

                    protected ILaunchConfigurationType getType() {
                        return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(newId);
                    }

                    protected TreeMap getAttributes() {
                        try {
                            TreeMap orig = (TreeMap)candidate.getWorkingCopy().getAttributes();
                            orig.put("org.eclipse.objectteams.launch", Boolean.TRUE);
                            return orig;
                        }
                        catch (CoreException coreException) {
                            return new TreeMap();
                        }
                    }
                };
            }
        };
        wrapper.getWorkingCopy().doSave();
    }
}

