/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.debug.core.breakpoints;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OOTBreakpoints {
    public static final String FIELD_THIS = "this";
    public static final String LOCAL_THREAD_ACT_DEACT = "thread";
    public static final String LOCAL_THREAD_IMPLICIT_ACT_DEACT = "currentThread";
    public static final String FIELD_ALL_THREADS = "ALL_THREADS";
    public static final String ATTR_OT_BREAKPOINT = "org.eclipse.objectteams.otdt.debug.TeamBreakpoint";
    public static final String ATTR_OT_BREAKPOINT_CTOR = "org.eclipse.objectteams.otdt.debug.TeamBreakpoint.Constructor";
    public static final String ATTR_OT_BREAKPOINT_FINALIZE = "org.eclipse.objectteams.otdt.debug.TeamBreakpoint.FinalizeMethod";
    public static final String ATTR_OT_BREAKPOINT_ACT = "org.eclipse.objectteams.otdt.debug.TeamBreakpoint.ActivateMethod";
    public static final String ATTR_OT_BREAKPOINT_DEACT = "org.eclipse.objectteams.otdt.debug.TeamBreakpoint.DeactivateMethod";
    public static final String ATTR_OT_BREAKPOINT_IMPLICIT_ACT = "org.eclipse.objectteams.otdt.debug.TeamBreakpoint.ImplicitActivateMethod";
    public static final String ATTR_OT_BREAKPOINT_IMPLICIT_DEACT = "org.eclipse.objectteams.otdt.debug.TeamBreakpoint.ImplicitDeactivateMethod";

    public static int getTeamConstructorLineNumber() {
        return 62;
    }

    public static int getActivateMethodLineNumber() {
        return 164;
    }

    public static int getDeactivateMethodLineNumber() {
        return 195;
    }

    public static int getImplicitActivateMethodLineNumber() {
        return 242;
    }

    public static int getImplicitDeactivateMethodLineNumber() {
        return 277;
    }

    public static int getFinalizeMethodLineNumber() {
        return 486;
    }

    public static Map<String, Boolean> getBreakpointAttributes() {
        HashMap<String, Boolean> attrs = new HashMap<String, Boolean>();
        attrs.put(ATTR_OT_BREAKPOINT, Boolean.TRUE);
        return attrs;
    }

    public static IBreakpoint createOOTConstructorBreakpoint(IType oot) throws CoreException {
        Map<String, Boolean> constructorAttributes = OOTBreakpoints.getBreakpointAttributes();
        constructorAttributes.put(ATTR_OT_BREAKPOINT_CTOR, Boolean.TRUE);
        return OOTBreakpoints.createOOTBreakpoint(oot, OOTBreakpoints.getTeamConstructorLineNumber(), constructorAttributes);
    }

    public static IBreakpoint createOOTFinalizeBreakpoint(IType oot) throws CoreException {
        Map<String, Boolean> finalizeMethodAttributes = OOTBreakpoints.getBreakpointAttributes();
        finalizeMethodAttributes.put(ATTR_OT_BREAKPOINT_FINALIZE, Boolean.TRUE);
        return OOTBreakpoints.createOOTMethodBreakpoint(oot, OOTBreakpoints.getFinalizeMethodLineNumber(), finalizeMethodAttributes);
    }

    public static IBreakpoint createOOTActivateBreakpoint(IType oot) throws CoreException {
        Map<String, Boolean> activateMethodAttributes = OOTBreakpoints.getBreakpointAttributes();
        activateMethodAttributes.put(ATTR_OT_BREAKPOINT_ACT, Boolean.TRUE);
        return OOTBreakpoints.createOOTBreakpoint(oot, OOTBreakpoints.getActivateMethodLineNumber(), activateMethodAttributes);
    }

    public static IBreakpoint createOOTDeactivateBreakpoint(IType oot) throws CoreException {
        Map<String, Boolean> deactivateMethodAttributes = OOTBreakpoints.getBreakpointAttributes();
        deactivateMethodAttributes.put(ATTR_OT_BREAKPOINT_DEACT, Boolean.TRUE);
        return OOTBreakpoints.createOOTBreakpoint(oot, OOTBreakpoints.getDeactivateMethodLineNumber(), deactivateMethodAttributes);
    }

    public static IBreakpoint createOOTImplicitActivateBreakpoint(IType oot) throws CoreException {
        Map<String, Boolean> implicitActivateMethodAttributes = OOTBreakpoints.getBreakpointAttributes();
        implicitActivateMethodAttributes.put(ATTR_OT_BREAKPOINT_IMPLICIT_ACT, Boolean.TRUE);
        return OOTBreakpoints.createOOTBreakpoint(oot, OOTBreakpoints.getImplicitActivateMethodLineNumber(), implicitActivateMethodAttributes);
    }

    public static IBreakpoint createOOTImplicitDeactivateBreakpoint(IType oot) throws CoreException {
        Map<String, Boolean> implicitDeactivateMethodAttributes = OOTBreakpoints.getBreakpointAttributes();
        implicitDeactivateMethodAttributes.put(ATTR_OT_BREAKPOINT_IMPLICIT_DEACT, Boolean.TRUE);
        return OOTBreakpoints.createOOTBreakpoint(oot, OOTBreakpoints.getImplicitDeactivateMethodLineNumber(), implicitDeactivateMethodAttributes);
    }

    public static IBreakpoint createOOTBreakpoint(IType oot, int linenumber, Map attributes) throws CoreException {
        IResource teamResource = oot.getJavaProject().getResource();
        IJavaLineBreakpoint breakpoint = JDIDebugModel.createLineBreakpoint((IResource)teamResource, (String)oot.getFullyQualifiedName(), (int)linenumber, (int)-1, (int)-1, (int)0, (boolean)false, (Map)attributes);
        breakpoint.setPersisted(false);
        return breakpoint;
    }

    public static IBreakpoint createOOTMethodBreakpoint(IType oot, int linenumber, Map attributes) throws CoreException {
        IResource teamResource = oot.getJavaProject().getResource();
        IJavaMethodBreakpoint breakpoint = JDIDebugModel.createMethodBreakpoint((IResource)teamResource, (String)oot.getFullyQualifiedName(), (String)"finalize", (String)"()V", (boolean)true, (boolean)false, (boolean)false, (int)linenumber, (int)-1, (int)-1, (int)0, (boolean)false, (Map)attributes);
        breakpoint.setPersisted(false);
        return breakpoint;
    }

    public static final boolean isOOTBreakpoint(IBreakpoint breakpoint) throws CoreException {
        return breakpoint.getMarker().getAttribute(ATTR_OT_BREAKPOINT) != null;
    }

    public static final boolean isOOTConstructorBreakpoint(IBreakpoint breakpoint) throws CoreException {
        return breakpoint.getMarker().getAttribute(ATTR_OT_BREAKPOINT_CTOR) != null;
    }

    public static final boolean isOOTFinalizeBreakpoint(IBreakpoint breakpoint) throws CoreException {
        return breakpoint.getMarker().getAttribute(ATTR_OT_BREAKPOINT_FINALIZE) != null;
    }

    public static final boolean isOOTActiveMethodBreakpoint(IBreakpoint breakpoint) throws CoreException {
        return breakpoint.getMarker().getAttribute(ATTR_OT_BREAKPOINT_ACT) != null;
    }

    public static final boolean isOOTDeactiveMethodBreakpoint(IBreakpoint breakpoint) throws CoreException {
        return breakpoint.getMarker().getAttribute(ATTR_OT_BREAKPOINT_DEACT) != null;
    }

    public static final boolean isOOTImplicitActiveMethodBreakpoint(IBreakpoint breakpoint) throws CoreException {
        return breakpoint.getMarker().getAttribute(ATTR_OT_BREAKPOINT_IMPLICIT_ACT) != null;
    }

    public static final boolean isOOTImplicitDeactiveMethodBreakpoint(IBreakpoint breakpoint) throws CoreException {
        return breakpoint.getMarker().getAttribute(ATTR_OT_BREAKPOINT_IMPLICIT_DEACT) != null;
    }
}

