/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.refactoring.otrefactorings.extractcallin;

import java.util.List;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.objectteams.otdt.core.IRoleType;
import org.eclipse.objectteams.otdt.internal.refactoring.otrefactorings.extractcallin.ExtractCallinRefactoring;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExtractCallinInputPage
extends UserInputWizardPage {
    private Text fNameField;
    private Combo fTypeCombo;
    private Button fReferenceButton;
    private List<IRoleType> fCandidateRoles;
    private ExtractCallinRefactoring fRefactoring;
    private Group fExtractMode;
    private Button fReplaceRadio;
    private Button fBeforeRadio;
    private Button fAfterRadio;
    private Button fRemove;

    public ExtractCallinInputPage(String name) {
        super(name);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.fRefactoring = (ExtractCallinRefactoring)this.getRefactoring();
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        Label label = new Label(result, 0);
        label.setText("&Role method name:");
        this.fNameField = this.createNameField(result);
        label = new Label(result, 0);
        label.setText("&Target role:");
        Composite composite = new Composite(result, 0);
        this.fCandidateRoles = this.fRefactoring.getCandidateRoles();
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.fTypeCombo = this.createTypeCombo(composite);
        this.fTypeCombo.setLayoutData((Object)new GridData(768));
        for (IRoleType role : this.fCandidateRoles) {
            String comboLabel = role.getFullyQualifiedName('.');
            this.fTypeCombo.add(comboLabel);
        }
        this.fTypeCombo.select(this.fCandidateRoles.size() - 1);
        this.createRadioButtonGroup(result);
        this.fReferenceButton = new Button(result, 32);
        this.fReferenceButton.setEnabled(true);
        this.fReferenceButton.setText("&Delete extracted base method");
        this.fReferenceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExtractCallinInputPage.this.fRefactoring.setDeleteBaseMethod(ExtractCallinInputPage.this.fReferenceButton.getSelection());
            }
        });
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.verticalIndent = 2;
        this.fReferenceButton.setLayoutData((Object)data);
        this.fNameField.setText(this.fRefactoring.getBaseMethod().getElementName());
        this.fTypeCombo.setText(this.fRefactoring.getBaseMethod().getDeclaringType().getFullyQualifiedName());
        this.fNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ExtractCallinInputPage.this.handleInputChanged();
            }
        });
        this.fReferenceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExtractCallinInputPage.this.fRefactoring.setDeleteBaseMethod(ExtractCallinInputPage.this.fReferenceButton.getSelection());
            }
        });
        this.fTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ExtractCallinInputPage.this.handleInputChanged();
            }
        });
        this.fNameField.setFocus();
        this.fNameField.selectAll();
        this.fBeforeRadio.setEnabled(this.fRefactoring.isExtractBeforeAvailable());
        this.fAfterRadio.setEnabled(this.fRefactoring.isExtractAfterAvailable());
        this.handleInputChanged();
        this.fReferenceButton.setSelection(this.fRefactoring.isDeleteBaseMethod());
    }

    private void createRadioButtonGroup(Composite result) {
        this.fExtractMode = new Group(result, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.verticalIndent = 2;
        this.fExtractMode.setLayoutData((Object)data);
        this.fExtractMode.setLayout((Layout)new GridLayout());
        this.fExtractMode.setText("Extract Mode");
        this.fReplaceRadio = new Button((Composite)this.fExtractMode, 16);
        this.fReplaceRadio.setLayoutData((Object)new GridData(768));
        this.fReplaceRadio.setText("R&eplace");
        this.fReplaceRadio.setSelection(true);
        this.fRefactoring.setMappingKind(3);
        this.fReplaceRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (((Button)event.widget).getSelection()) {
                    ExtractCallinInputPage.this.fRefactoring.setMappingKind(3);
                    ExtractCallinInputPage.this.fRemove.setEnabled(true);
                    ExtractCallinInputPage.this.handleInputChanged();
                }
            }
        });
        this.fRemove = new Button((Composite)this.fExtractMode, 32);
        data = new GridData(768);
        data.horizontalIndent = this.convertWidthInCharsToPixels(3);
        this.fRemove.setLayoutData((Object)data);
        this.fRemove.setText("&Copy base method code");
        this.fRemove.setSelection(this.fRefactoring.isCopyBaseMethod());
        this.fRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtractCallinInputPage.this.fRefactoring.setCopyBaseMethod(((Button)e.widget).getSelection());
                ExtractCallinInputPage.this.handleInputChanged();
            }
        });
        this.fBeforeRadio = new Button((Composite)this.fExtractMode, 16);
        this.fBeforeRadio.setLayoutData((Object)new GridData(768));
        this.fBeforeRadio.setText("&Before");
        this.fBeforeRadio.setSelection(false);
        this.fBeforeRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExtractCallinInputPage.this.fRemove.setEnabled(false);
                if (((Button)event.widget).getSelection()) {
                    ExtractCallinInputPage.this.fRefactoring.setMappingKind(1);
                    ExtractCallinInputPage.this.handleInputChanged();
                }
            }
        });
        this.fAfterRadio = new Button((Composite)this.fExtractMode, 16);
        this.fAfterRadio.setLayoutData((Object)new GridData(768));
        this.fAfterRadio.setText("&After");
        this.fAfterRadio.setSelection(false);
        this.fAfterRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExtractCallinInputPage.this.fRemove.setEnabled(false);
                if (((Button)event.widget).getSelection()) {
                    ExtractCallinInputPage.this.fRefactoring.setMappingKind(2);
                    ExtractCallinInputPage.this.handleInputChanged();
                }
            }
        });
    }

    private Text createNameField(Composite result) {
        Text field = new Text(result, 18436);
        field.setLayoutData((Object)new GridData(768));
        return field;
    }

    private Combo createTypeCombo(Composite composite) {
        Combo combo = new Combo(composite, 2060);
        combo.setLayoutData((Object)new GridData(768));
        combo.setVisibleItemCount(4);
        return combo;
    }

    void handleInputChanged() {
        this.fReferenceButton.setEnabled(this.fRefactoring.getMappingKind() != 3);
        this.fRefactoring.setRoleType(this.getSelectedRole());
        RefactoringStatus status = new RefactoringStatus();
        this.fRefactoring.setRoleMethodName(this.fNameField.getText());
        status.merge(this.fRefactoring.checkRoleMethodName());
        this.setPageComplete(!status.hasError());
        int severity = status.getSeverity();
        String message = status.getMessageMatchingSeverity(severity);
        if (severity >= 1) {
            this.setMessage(message, severity);
        } else {
            this.setMessage("", 0);
        }
    }

    public IType getSelectedRole() {
        int index = this.fTypeCombo.getSelectionIndex();
        if (index >= 0) {
            return (IType)this.fCandidateRoles.get(index);
        }
        return null;
    }
}

