/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.refactoring.otrefactorings.inlinecallin;

import java.util.ArrayList;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.util.TableLayoutComposite;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.objectteams.otdt.internal.refactoring.otrefactorings.inlinecallin.CallinBaseMethodInfo;
import org.eclipse.objectteams.otdt.internal.refactoring.otrefactorings.inlinecallin.InlineCallinRefactoring;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class InlineCallinInputPage
extends UserInputWizardPage {
    Text fNameField;
    private CheckboxTableViewer fTableViewer;
    private Label fLabel;
    private Button fReferenceButton;

    public InlineCallinInputPage(String name) {
        super(name);
    }

    public void createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        Label label = new Label(result, 0);
        label.setText("&Inlined method name:");
        this.fNameField = this.createNameField(result);
        this.createMemberTableLabel(result);
        this.createMemberTableComposite(result);
        this.fReferenceButton = new Button(result, 32);
        this.fReferenceButton.setEnabled(false);
        this.fReferenceButton.setText("&Delete role method");
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.verticalIndent = 2;
        this.fReferenceButton.setLayoutData((Object)data);
        final InlineCallinRefactoring refactoring = this.getInlineCallinRefactoring();
        this.fNameField.setText(refactoring.getRoleMethod().getElementName());
        this.fNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                InlineCallinInputPage.this.handleInputChanged();
            }
        });
        this.fReferenceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                refactoring.setDeleteRoleMethod(InlineCallinInputPage.this.fReferenceButton.getSelection());
            }
        });
        this.fNameField.setFocus();
        this.fNameField.selectAll();
        this.handleInputChanged();
        this.fReferenceButton.setSelection(false);
    }

    private Text createNameField(Composite result) {
        Text field = new Text(result, 18436);
        field.setLayoutData((Object)new GridData(768));
        return field;
    }

    private InlineCallinRefactoring getInlineCallinRefactoring() {
        return (InlineCallinRefactoring)this.getRefactoring();
    }

    void handleInputChanged() {
        this.fReferenceButton.setEnabled(this.allBaseMethodSelected());
        RefactoringStatus status = new RefactoringStatus();
        InlineCallinRefactoring refactoring = this.getInlineCallinRefactoring();
        refactoring.setRoleMethodName(this.fNameField.getText());
        status.merge(refactoring.checkRoleMethodName());
        this.setSelectedBaseMethods(refactoring);
        status.merge(refactoring.checkBaseMethods());
        this.setPageComplete(!status.hasError());
        int severity = status.getSeverity();
        String message = status.getMessageMatchingSeverity(severity);
        if (severity >= 1) {
            this.setMessage(message, severity);
        } else {
            this.setMessage("", 0);
        }
    }

    private void setSelectedBaseMethods(InlineCallinRefactoring refactoring) {
        CallinBaseMethodInfo[] baseMethodInfos = this.getTableInput();
        ArrayList<CallinBaseMethodInfo> baseMethods = new ArrayList<CallinBaseMethodInfo>();
        int i = 0;
        while (i < baseMethodInfos.length) {
            if (this.fTableViewer.getChecked((Object)baseMethodInfos[i])) {
                baseMethods.add(baseMethodInfos[i]);
            }
            ++i;
        }
        refactoring.setBaseMethods(baseMethods.toArray(new CallinBaseMethodInfo[baseMethods.size()]));
    }

    private CallinBaseMethodInfo[] getTableInput() {
        return (CallinBaseMethodInfo[])this.fTableViewer.getInput();
    }

    private boolean allBaseMethodSelected() {
        boolean selected = true;
        Object[] baseMethods = (Object[])this.fTableViewer.getInput();
        int i = 0;
        while (i < baseMethods.length) {
            selected = selected && this.fTableViewer.getChecked(baseMethods[i]);
            ++i;
        }
        return selected;
    }

    protected void createMemberTableLabel(Composite parent) {
        this.fLabel = new Label(parent, 0);
        this.fLabel.setText("&Select the bound base methods:");
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.fLabel.setLayoutData((Object)data);
    }

    protected void createMemberTableComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        composite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.createBaseMethodsTable(composite);
    }

    private void createBaseMethodsTable(Composite parent) {
        TableLayoutComposite layouter = new TableLayoutComposite(parent, 0);
        layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(60, true));
        layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
        Table table = new Table((Composite)layouter, 68386);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gd = new GridData(1808);
        gd.heightHint = SWTUtil.getTableHeightHint((Table)table, (int)10);
        gd.widthHint = this.convertWidthInCharsToPixels(30);
        layouter.setLayoutData((Object)gd);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn column0 = new TableColumn(table, 0);
        column0.setText("Base Method");
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText("Callin Kind");
        this.fTableViewer = new CheckboxTableViewer(table);
        this.fTableViewer.setUseHashlookup(true);
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new BaseMethodInfoLabelProvider());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                InlineCallinInputPage.this.handleInputChanged();
            }
        });
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                InlineCallinInputPage.this.updateWizardPage(null, true);
            }
        });
        this.setTableInput();
    }

    private CallinBaseMethodInfo[] getBaseMethodInfos() {
        return this.getInlineCallinRefactoring().getBaseMethodInfos();
    }

    private void setTableInput() {
        this.fTableViewer.setInput((Object)this.getBaseMethodInfos());
    }

    private void updateWizardPage(ISelection selection, boolean displayErrors) {
        this.fTableViewer.refresh();
        if (selection != null) {
            this.fTableViewer.getControl().setFocus();
            this.fTableViewer.setSelection(selection);
        }
    }

    private static class BaseMethodInfoLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final String BEFORE_LABEL = "Before";
        private static final String AFTER_LABEL = "After";
        private static final String REPLACE_LABEL = "Replace";
        private static final int CALLIN_KIND_COLUMN = 1;
        private static final int METHOD_COLUMN = 0;
        private final ILabelProvider fLabelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT | 0x100);

        private BaseMethodInfoLabelProvider() {
        }

        public void dispose() {
            super.dispose();
            this.fLabelProvider.dispose();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            CallinBaseMethodInfo info = (CallinBaseMethodInfo)element;
            switch (columnIndex) {
                case 0: {
                    return this.fLabelProvider.getImage((Object)info.getMethod());
                }
                case 1: {
                    return null;
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            CallinBaseMethodInfo info = (CallinBaseMethodInfo)element;
            switch (columnIndex) {
                case 0: {
                    return this.fLabelProvider.getText((Object)info.getMethod());
                }
                case 1: {
                    return this.createCallinLabel(info.getCallinMapping().getCallinKind());
                }
            }
            return null;
        }

        public String createCallinLabel(int callinKind) {
            switch (callinKind) {
                case 1: {
                    return BEFORE_LABEL;
                }
                case 2: {
                    return AFTER_LABEL;
                }
                case 3: {
                    return REPLACE_LABEL;
                }
            }
            return null;
        }
    }
}

