/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.ui.help.actions;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.objectteams.otdt.ui.IUpdateRulerActionExtender;
import org.eclipse.objectteams.otdt.ui.Messages;
import org.eclipse.objectteams.otdt.ui.help.OTJLDError;
import org.eclipse.objectteams.otdt.ui.help.actions.ShowOTJLDAction;
import org.eclipse.ui.IEditorPart;

public class UpdateRulerAction
implements IUpdateRulerActionExtender {
    public void menuAboutToShow(IMenuManager contextMenu, IDocument document, IEditorPart editor, int line) {
        IAnnotationModel model = JavaUI.getDocumentProvider().getAnnotationModel((Object)editor.getEditorInput());
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Position pos;
            Annotation annot = (Annotation)iter.next();
            if (!this.isOTJProblem(annot) || (pos = model.getPosition(annot)) == null) continue;
            try {
                int startLine = document.getLineOfOffset(pos.getOffset());
                if (startLine != line) continue;
                this.installAction(contextMenu, editor, annot.getText());
            }
            catch (BadLocationException badLocationException) {
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
    }

    private boolean isOTJProblem(Annotation annot) {
        if (!(annot instanceof IJavaAnnotation)) {
            return false;
        }
        if (!((IJavaAnnotation)annot).isProblem()) {
            return false;
        }
        return OTJLDError.isOTJProblem(annot.getText());
    }

    private void installAction(IMenuManager contextMenu, IEditorPart editor, String text) {
        IContributionItem[] iContributionItemArray = contextMenu.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionContributionItem actionItem;
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem && (actionItem = (ActionContributionItem)item).getAction().getText().equals(Messages.UpdateRulerAction_goto_otjld_command_label)) {
                contextMenu.remove((IContributionItem)actionItem);
                break;
            }
            ++n2;
        }
        contextMenu.appendToGroup("additions", ShowOTJLDAction.createAction(editor.getSite(), text));
    }
}

