/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.callinmarkers;

import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.objectteams.otdt.internal.ui.callinmarkers.CallinMarker;
import org.eclipse.objectteams.otdt.ui.OTDTUIPlugin;

public class CallinMarkerRemover {
    public static void removeCallinMarkers(IResource resource) throws CoreException {
        String[] stringArray = new String[]{"org.eclipse.objectteams.otdt.ui.playedByMarker", "org.eclipse.objectteams.otdt.ui.callinMarker", "org.eclipse.objectteams.otdt.ui.calloutMarker"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (resource.exists()) {
                resource.deleteMarkers(id, true, 2);
            }
            ++n2;
        }
    }

    public static void removeCallinMarker(IMember member, IResource resource) {
        if (resource.exists()) {
            try {
                IMarker marker;
                if (member.getElementType() == 9 && (marker = CallinMarkerRemover.getCallinMarker(member, "org.eclipse.objectteams.otdt.ui.callinMarker", resource)) != null) {
                    marker.delete();
                }
                if ((marker = CallinMarkerRemover.getCallinMarker(member, "org.eclipse.objectteams.otdt.ui.calloutMarker", resource)) != null) {
                    marker.delete();
                }
            }
            catch (ResourceException resourceException) {
            }
            catch (CoreException ex) {
                OTDTUIPlugin.getExceptionHandler().logException("Problems removing callin marker", (Throwable)ex);
            }
        }
    }

    private static IMarker getCallinMarker(IMember baseElement, String markerKind, IResource resource) throws JavaModelException, CoreException {
        IMarker[] markers = resource.findMarkers(markerKind, true, 2);
        String methodId = baseElement.getHandleIdentifier();
        int i = 0;
        while (i < markers.length) {
            if (methodId.equals(markers[i].getAttribute("org.eclipse.objectteams.otdt.ui.markerAttr.BaseElement", null))) {
                return markers[i];
            }
            ++i;
        }
        return null;
    }

    public static void removeCallinMarkers(IClassFile element) throws CoreException {
        if (element.exists()) {
            IMarker[] allMarkers;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IMarker[] iMarkerArray = allMarkers = CallinMarker.getAllBindingMarkers((IResource)root);
            int n = allMarkers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                if (JavaCore.isReferencedBy((IJavaElement)element, (IMarker)marker)) {
                    marker.delete();
                }
                ++n2;
            }
        }
    }
}

