/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.objectteams.otdt.ui.ImageConstants;
import org.eclipse.objectteams.otdt.ui.OTDTUIPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImageManager
implements ImageConstants {
    private static final String[] _pluginIcons = new String[]{"calloutbinding_obj.gif", "callinbindingreplace_obj.gif", "callinbindingbefore_obj.gif", "callinbindingafter_obj.gif", "callinmethod_co.gif", "boundrole_co.gif", "guard_obj.gif", "baseguard_obj.gif", "role_obj.png", "role_protected_obj.png", "team_obj.gif", "team_role_obj.gif", "team_role_protected_obj.gif", "role_ovr.png", "team_ovr.gif", "team_role_ovr.gif", "hide_team_package.gif", "wizard/newotjprj_wiz.png", "wizard/newteam_wiz.png", "wizard/newrole_wiz.png"};
    private static ImageManager _singleton;

    protected ImageManager() {
    }

    public static ImageManager getSharedInstance() {
        if (_singleton == null) {
            _singleton = new ImageManager();
        }
        return _singleton;
    }

    public void registerPluginImages(ImageRegistry reg) {
        try {
            String[] pluginIcons = this.pluginIcons();
            URL baseURL = new URL(this.getInstallLocation(), "icons/ot/");
            int idx = 0;
            while (idx < pluginIcons.length) {
                ImageDescriptor descr = ImageDescriptor.createFromURL((URL)new URL(baseURL, pluginIcons[idx]));
                reg.put(pluginIcons[idx], descr);
                ++idx;
            }
        }
        catch (MalformedURLException ex) {
            OTDTUIPlugin.getExceptionHandler().logException((Throwable)ex);
        }
    }

    private URL getInstallLocation() {
        return this.getPlugin().getBundle().getEntry("/");
    }

    protected AbstractUIPlugin getPlugin() {
        return OTDTUIPlugin.getDefault();
    }

    protected String[] pluginIcons() {
        return _pluginIcons;
    }

    public void setActionImageDescriptors(IAction action, String imgName) {
        try {
            URL baseURL = new URL(this.getInstallLocation(), "icons/ot/");
            ImageDescriptor descr = ImageDescriptor.createFromURL((URL)new URL(baseURL, "default/" + imgName));
            action.setImageDescriptor(descr);
            descr = ImageDescriptor.createFromURL((URL)new URL(baseURL, "hover/" + imgName));
            action.setHoverImageDescriptor(descr);
            descr = ImageDescriptor.createFromURL((URL)new URL(baseURL, "disabled/" + imgName));
            action.setDisabledImageDescriptor(descr);
        }
        catch (MalformedURLException ex) {
            OTDTUIPlugin.getExceptionHandler().logException((Throwable)ex);
        }
    }

    public Image get(String imageKey) {
        return this.getPlugin().getImageRegistry().get(imageKey);
    }

    public ImageDescriptor getDescriptor(String imageKey) {
        return this.getPlugin().getImageRegistry().getDescriptor(imageKey);
    }
}

