/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.ui;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class JavaEditorActivationListener
implements IPartListener2,
IWindowListener {
    protected IWorkbenchPart fActiveEditor;
    private IWorkbench fWorkbench;

    protected abstract void activeJavaEditorChanged(IWorkbenchPart var1);

    protected IJavaElement getInputJavaElement(IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)editorInput).getClassFile();
        }
        if (editor instanceof JavaEditor) {
            return JavaPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput);
        }
        return null;
    }

    public void installListener() {
        this.fWorkbench = PlatformUI.getWorkbench();
        this.fWorkbench.addWindowListener((IWindowListener)this);
        IWorkbenchWindow[] windows = this.fWorkbench.getWorkbenchWindows();
        int i = 0;
        int length = windows.length;
        while (i < length) {
            windows[i].getPartService().addPartListener((IPartListener2)this);
            ++i;
        }
    }

    public void uninstallListener() {
        if (this.fWorkbench == null) {
            return;
        }
        this.fWorkbench.removeWindowListener((IWindowListener)this);
        IWorkbenchWindow[] windows = this.fWorkbench.getWorkbenchWindows();
        int i = 0;
        int length = windows.length;
        while (i < length) {
            windows[i].getPartService().removePartListener((IPartListener2)this);
            ++i;
        }
    }

    public void partActivated(IWorkbenchPartReference ref) {
        if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
            this.activeJavaEditorChanged(ref.getPart(true));
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference ref) {
        if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
            this.activeJavaEditorChanged(ref.getPart(true));
        }
    }

    public void partClosed(IWorkbenchPartReference ref) {
        if (this.isActiveEditor(ref)) {
            this.activeJavaEditorChanged(null);
        }
    }

    public void partDeactivated(IWorkbenchPartReference ref) {
    }

    public void partOpened(IWorkbenchPartReference ref) {
        if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
            this.activeJavaEditorChanged(ref.getPart(true));
        }
    }

    public void partHidden(IWorkbenchPartReference ref) {
    }

    public void partVisible(IWorkbenchPartReference ref) {
        if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
            this.activeJavaEditorChanged(ref.getPart(true));
        }
    }

    public void partInputChanged(IWorkbenchPartReference ref) {
    }

    public void windowActivated(IWorkbenchWindow window) {
        IWorkbenchPartReference ref = window.getPartService().getActivePartReference();
        if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
            this.activeJavaEditorChanged(ref.getPart(true));
        }
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        if (this.fActiveEditor != null && this.fActiveEditor.getSite() != null && window == this.fActiveEditor.getSite().getWorkbenchWindow()) {
            this.activeJavaEditorChanged(null);
        }
        window.getPartService().removePartListener((IPartListener2)this);
    }

    public void windowOpened(IWorkbenchWindow window) {
        window.getPartService().addPartListener((IPartListener2)this);
    }

    protected boolean isActiveEditor(IWorkbenchPartReference ref) {
        return ref != null && this.isActiveEditor(ref.getPart(false));
    }

    protected boolean isActiveEditor(IWorkbenchPart part) {
        return part != null && part == this.fActiveEditor;
    }

    protected boolean isJavaEditor(IWorkbenchPartReference ref) {
        if (ref == null) {
            return false;
        }
        String id = ref.getId();
        return "org.eclipse.jdt.ui.ClassFileEditor".equals(id) || "org.eclipse.jdt.ui.CompilationUnitEditor".equals(id);
    }
}

