/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.IRoleFileType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.internal.ui.bindingeditor.BindingEditorDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenBindingEditorHandler
extends AbstractHandler {
    private IOTType currentTeam = null;

    public void setEnabled(Object evaluationContext) {
        ISelection selection = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        this.currentTeam = this.getRootTeam(selection);
        if (this.currentTeam != null) {
            this.setBaseEnabled(true);
        } else {
            this.setBaseEnabled(false);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        new BindingEditorDialog(window.getShell(), (IType)this.currentTeam).open();
        return null;
    }

    protected IOTType getRootTeam(ISelection selection) {
        IOTType selectedTeam = null;
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (!(element instanceof IJavaElement)) {
            return null;
        }
        IJavaElement jElement = (IJavaElement)element;
        ICompilationUnit cu = (ICompilationUnit)jElement.getAncestor(5);
        if (cu == null) {
            return null;
        }
        IType type = cu.findPrimaryType();
        IOTType otType = OTModelManager.getOTElement((IType)type);
        if (otType == null) {
            return null;
        }
        if (otType.isTeam()) {
            selectedTeam = otType;
        } else if (otType instanceof IRoleFileType) {
            selectedTeam = ((IRoleFileType)otType).getTeam();
        }
        return selectedTeam;
    }
}

