/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otequinox.hook;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.objectteams.otequinox.hook.HookConfigurator;
import org.eclipse.objectteams.otequinox.hook.ILogger;
import org.eclipse.objectteams.otequinox.hook.IOTTransformer;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassScanner {
    public static final boolean REPOSITORY_USE_RESOURCE_LOADER = !"off".equals(System.getProperty("otequinox.repository.hook"));
    IOTTransformer transformerService;
    HashMap<String, ArrayList<String>> baseClassNamesByTeam = new HashMap();
    ArrayList<String> allBaseClassNames = new ArrayList();
    ArrayList<String> roleClassNames = new ArrayList();

    public ClassScanner(IOTTransformer transformerService) {
        this.transformerService = transformerService;
    }

    public void readOTAttributes(Bundle bundle, String className, ClassLoader loader) throws ClassFormatError, IOException, ClassNotFoundException {
        URL classFile;
        if (!REPOSITORY_USE_RESOURCE_LOADER) {
            loader = null;
        }
        if ((classFile = bundle.getResource(String.valueOf(className.replace('.', '/')) + ".class")) == null) {
            throw new ClassNotFoundException(className);
        }
        Object token = this.transformerService.readOTAttributes(classFile.openStream(), classFile.getFile(), loader);
        Collection<String> currentBaseNames = this.transformerService.fetchAdaptedBases(token);
        if (currentBaseNames != null) {
            ArrayList<String> basesPerTeam = this.baseClassNamesByTeam.get(className);
            if (basesPerTeam == null) {
                basesPerTeam = new ArrayList();
                this.baseClassNamesByTeam.put(className, basesPerTeam);
            }
            basesPerTeam.addAll(currentBaseNames);
            this.allBaseClassNames.addAll(currentBaseNames);
        }
        this.readMemberTypeAttributes(bundle, className, loader);
    }

    public Collection<String> getCollectedBaseClassNames(String teamName) {
        return this.baseClassNamesByTeam.remove(teamName);
    }

    public Collection<String> getCollectedBaseClassNames() {
        try {
            ArrayList<String> arrayList = this.allBaseClassNames;
            return arrayList;
        }
        finally {
            this.allBaseClassNames = new ArrayList();
        }
    }

    public Collection<String> getCollectedRoleClassNames() {
        return this.roleClassNames;
    }

    private void readMemberTypeAttributes(Bundle bundle, String className, ClassLoader resourceLoader) {
        List<String> roles = this.transformerService.getRolesPerTeam(className);
        if (roles != null) {
            ILogger logger = HookConfigurator.getLogger();
            for (String roleName : roles) {
                logger.log(0, "scanning role " + roleName);
                try {
                    this.roleClassNames.add(roleName);
                    this.readOTAttributes(bundle, roleName, resourceLoader);
                }
                catch (Throwable t) {
                    logger.log(t, "Failed to read OT-Attributes of role " + roleName);
                }
                this.readMemberTypeAttributes(bundle, roleName, resourceLoader);
            }
        }
    }
}

