/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otequinox.internal.hook;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.internal.adaptor.EclipseStorageHook;
import org.eclipse.objectteams.otequinox.hook.AspectPermission;
import org.eclipse.objectteams.otequinox.internal.hook.TransformerHook;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.hooks.StorageHook;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTStorageHook
implements StorageHook {
    private static final String FORCED_EXPORTS_DENIED = "otequinox.forced.exports.denied";
    private static final String FORCED_EXPORTS_GRANTED = "otequinox.forced.exports.granted";
    private static final String FORCED_EXPORTS = "otequinox.forced.exports";
    private static final String EXPORT_PACKAGE = "Export-Package";
    private static final String XFRIENDS = "x-friends:=";
    private static final String KEY = OTStorageHook.class.getName();
    private static final int HASHCODE = KEY.hashCode();
    private static final int STORAGE_VERSION = 1;
    private static HashMap<String, String> grantedForcedExports = null;
    private static HashMap<String, String> deniedForcedExports = null;
    static FrameworkLog fwLog;
    BaseData bundleData;
    EclipseStorageHook manifestProvider;
    TransformerHook transformerHook;

    private static void readForcedExports() {
        deniedForcedExports = new HashMap();
        grantedForcedExports = new HashMap();
        OTStorageHook.readForcedExportsFromProperty(FORCED_EXPORTS_DENIED, AspectPermission.DENY);
        OTStorageHook.readForcedExportsFromProperty(FORCED_EXPORTS_GRANTED, AspectPermission.GRANT);
        OTStorageHook.readForcedExportsFromProperty(FORCED_EXPORTS, AspectPermission.GRANT);
    }

    private static void readForcedExportsFromProperty(String propKey, AspectPermission perm) {
        String value = System.getProperty(propKey);
        if (value != null) {
            if (value.length() > 0 && value.charAt(0) == '@') {
                int pos = 1;
                while (pos < value.length()) {
                    String fileName;
                    int comma = value.indexOf(44, pos);
                    if (comma > -1) {
                        fileName = value.substring(pos, comma);
                        pos = comma + 1;
                    } else {
                        fileName = value.substring(pos);
                        pos = value.length();
                    }
                    OTStorageHook.parseForcedExportsFile(new File(fileName), perm);
                }
            } else {
                OTStorageHook.parseForcedExports(value, perm);
            }
        }
    }

    public static synchronized void parseForcedExportsFile(File file, AspectPermission perm) {
        StringBuffer newVal = new StringBuffer();
        try {
            String line;
            FileInputStream fis = new FileInputStream(file);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF8"));
            boolean afterClosingBrace = false;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                char lastReadChar = line.charAt(line.length() - 1);
                if (afterClosingBrace && lastReadChar != ',') {
                    newVal.append(',');
                }
                afterClosingBrace = lastReadChar == ']';
                newVal.append(line);
            }
            OTStorageHook.parseForcedExports(newVal.toString(), perm);
        }
        catch (IOException e) {
            fwLog.log(new FrameworkLogEntry(OTStorageHook.class.getName(), "failed to read forcedExports file " + file.getName(), 4, (Throwable)e, null));
        }
    }

    private static void parseForcedExports(String value, AspectPermission perm) {
        HashMap<String, String> map = OTStorageHook.getForcedExportsMap(perm);
        if (map == null) {
            return;
        }
        int pos = 0;
        String[] values = new String[2];
        while (true) {
            pos = OTStorageHook.getForcedExportForOneBase(value, pos, values);
            String plugin = values[0];
            String pack = values[1];
            if (map.containsKey(plugin)) {
                String oldPack = map.get(plugin);
                pack = String.valueOf(oldPack) + ',' + pack;
            }
            map.put(plugin, pack);
            if (pos >= value.length()) break;
            if (value.charAt(pos) != ',') {
                OTStorageHook.throwSyntaxError(value, pos, "missing ','");
            }
            ++pos;
        }
    }

    private static int getForcedExportForOneBase(String spec, int start, String[] values) {
        int close;
        int open = spec.indexOf(91, start);
        if (open == -1) {
            OTStorageHook.throwSyntaxError(spec, start, "missing '['");
        }
        if ((close = spec.indexOf(93, start)) == -1) {
            OTStorageHook.throwSyntaxError(spec, open, "missing ']'");
        }
        values[0] = spec.substring(start, open);
        values[1] = spec.substring(open + 1, close);
        return close + 1;
    }

    private static void throwSyntaxError(String spec, int pos, String string) {
        throw new RuntimeException("Illegal syntax in otequinox.forced.exports directive at position " + pos + " (not counting whitespace): " + string + "\n value is:\n" + spec);
    }

    private static HashMap<String, String> getForcedExportsMap(AspectPermission perm) {
        switch (perm) {
            case GRANT: {
                return grantedForcedExports;
            }
            case DENY: {
                return deniedForcedExports;
            }
            case UNDEFINED: {
                return null;
            }
        }
        throw new IncompatibleClassChangeError("enum " + AspectPermission.class.getName() + " has changed unexpectedly.");
    }

    public OTStorageHook(EclipseStorageHook manifestProvider, TransformerHook transformerHook) {
        this.manifestProvider = manifestProvider;
        this.transformerHook = transformerHook;
    }

    public OTStorageHook(BaseData bundleData, EclipseStorageHook manifestProvider, TransformerHook transformerHook) {
        this.bundleData = bundleData;
        this.manifestProvider = manifestProvider;
        this.transformerHook = transformerHook;
        if (fwLog == null && bundleData != null) {
            fwLog = bundleData.getAdaptor().getFrameworkLog();
        }
    }

    public void copy(StorageHook storageHook) {
        OTStorageHook orig = (OTStorageHook)storageHook;
        this.bundleData = orig.bundleData;
        this.manifestProvider = orig.manifestProvider;
    }

    public StorageHook create(BaseData bundledata) throws BundleException {
        return new OTStorageHook(bundledata, this.manifestProvider, this.transformerHook);
    }

    public boolean forgetStartLevelChange(int startlevel) {
        return false;
    }

    public boolean forgetStatusChange(int status) {
        return false;
    }

    public Dictionary<?, ?> getManifest(boolean firstLoad) throws BundleException {
        StorageHook manifestProviderInstance = this.manifestProvider.create(this.bundleData);
        final Dictionary orig = manifestProviderInstance.getManifest(firstLoad);
        this.checkActivationPolicy(orig);
        return new Headers(orig.size()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object get(Object key) {
                Object value = orig.get(key);
                if (!OTStorageHook.EXPORT_PACKAGE.equals(key)) {
                    return value;
                }
                Class<OTStorageHook> clazz = OTStorageHook.class;
                synchronized (OTStorageHook.class) {
                    if (grantedForcedExports == null) {
                        OTStorageHook.readForcedExports();
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    String exports = (String)grantedForcedExports.get(OTStorageHook.this.bundleData.getSymbolicName());
                    if (exports != null) {
                        String packages = (String)orig.get(OTStorageHook.EXPORT_PACKAGE);
                        if (!exports.contains(OTStorageHook.XFRIENDS)) {
                            grantedForcedExports.remove(OTStorageHook.this.bundleData.getSymbolicName());
                            OTStorageHook.logError("config.ini: missing x-friends directive in forced export of " + exports);
                            return packages;
                        }
                        if (packages != null) {
                            return String.valueOf(packages) + ',' + exports;
                        }
                        return exports;
                    }
                    return value;
                }
            }

            public synchronized int size() {
                return orig.size();
            }

            public synchronized Enumeration<?> keys() {
                return orig.keys();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkActivationPolicy(Dictionary<?, ?> orig) {
        orig.keys();
        String value = (String)orig.get("Bundle-ActivationPolicy");
        String value2 = (String)orig.get("Eclipse-LazyStart");
        if (!(value != null && value.trim().startsWith("lazy") || value2 != null && value2.trim().equalsIgnoreCase("true"))) {
            TransformerHook transformerHook = this.transformerHook;
            synchronized (transformerHook) {
                this.transformerHook.pendingNonLazyActivationBundles.add(this.bundleData.getBundle());
            }
        }
    }

    static void logError(String message) {
        fwLog.log(new FrameworkLogEntry(OTStorageHook.class.getName(), message, 4, null, null));
    }

    public int getStorageVersion() {
        return 1;
    }

    public void initialize(Dictionary manifest) throws BundleException {
    }

    public StorageHook load(BaseData bundledata, DataInputStream is) throws IOException {
        return new OTStorageHook(bundledata, this.manifestProvider, this.transformerHook);
    }

    public boolean matchDNChain(String pattern) {
        return false;
    }

    public void save(DataOutputStream os) throws IOException {
    }

    public void validate() throws IllegalArgumentException {
    }

    public Object getKey() {
        return KEY;
    }

    public boolean compare(KeyedElement other) {
        return other.getKey() == KEY;
    }

    public int getKeyHashCode() {
        return HASHCODE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String[]> getForcedExportsByAspect(String aspectBundleId, AspectPermission perm) {
        Class<OTStorageHook> clazz = OTStorageHook.class;
        synchronized (OTStorageHook.class) {
            if (grantedForcedExports == null) {
                OTStorageHook.readForcedExports();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            ArrayList<String[]> result = new ArrayList<String[]>(5);
            HashMap<String, String> map = OTStorageHook.getForcedExportsMap(perm);
            if (map == null) {
                return result;
            }
            block3: for (Map.Entry<String, String> entry : map.entrySet()) {
                String export = entry.getValue();
                int start = 0;
                while (start >= 0 && start < export.length()) {
                    int pos;
                    if (start > 0) {
                        if (export.charAt(start) == ',') {
                            ++start;
                        } else {
                            OTStorageHook.logError("Error parsing forced exports: " + export + ", comma expected at position " + start);
                        }
                    }
                    if ((pos = export.indexOf(";x-friends:=", start)) == -1) continue block3;
                    String packageName = export.substring(start, pos);
                    ArrayList<String> aspectBundles = new ArrayList<String>();
                    start = OTStorageHook.scanAspectBundles(export, pos + XFRIENDS.length() + 1, aspectBundles);
                    for (String aspect : aspectBundles) {
                        if (!aspect.equals(aspectBundleId)) continue;
                        result.add(new String[]{entry.getKey(), packageName});
                    }
                }
            }
            return result;
        }
    }

    private static int scanAspectBundles(String export, int pos, List<String> result) {
        String termChars = ",]";
        if (export.charAt(pos) == '\"') {
            ++pos;
            termChars = "\"";
        }
        int start = pos;
        while (pos < export.length()) {
            char c = export.charAt(pos);
            switch (c) {
                case '\"': 
                case ',': 
                case ']': {
                    String next = export.substring(start, pos);
                    result.add(next);
                    start = pos + 1;
                    if (termChars.indexOf(c) == -1) break;
                    return start;
                }
            }
            ++pos;
        }
        OTStorageHook.logError("Unterminated forced exports: " + export);
        if (pos > start) {
            result.add(export.substring(start));
        }
        return export.length();
    }
}

