/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otequinox.internal.hook;

import java.util.HashSet;
import org.eclipse.objectteams.otequinox.hook.ILogger;
import org.osgi.framework.Bundle;

public class Util {
    public static final int OK = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 4;
    public static int WARN_LEVEL = 1;
    public static boolean PROFILE = false;
    private static long[] profileTimes;
    private static long systemStartTime;
    static HashSet<String> PLATFORM_BUNDLES;

    static {
        String level = System.getProperty("otequinox.debug");
        if (level != null) {
            WARN_LEVEL = (level = level.toUpperCase()).equals("OK") ? 0 : (level.equals("INFO") ? 1 : (level.startsWith("WARN") ? 2 : (level.startsWith("ERR") ? 4 : 0)));
        }
        PROFILE = System.getProperty("otequinox.profile") != null;
        profileTimes = new long[ProfileKind.values().length];
        systemStartTime = System.nanoTime();
        PLATFORM_BUNDLES = null;
    }

    private static void checkInit() {
        if (PLATFORM_BUNDLES == null) {
            PLATFORM_BUNDLES = new HashSet();
            String[] stringArray = new String[]{"org.eclipse.equinox.common", "org.eclipse.update.configurator", "org.eclipse.core.runtime", "org.eclipse.equinox.registry", "org.eclipse.equinox.app", "org.eclipse.equinox.ds", "org.eclipse.equinox.event", "org.eclipse.equinox.util", "org.eclipse.osgi.services", "org.eclipse.core.runtime.compatibility.auth", "org.eclipse.equinox.preferences", "org.eclipse.equinox.simpleconfigurator", "org.eclipse.core.jobs", "org.eclipse.core.runtime.compatibility", "org.eclipse.equinox.p2.core", "org.eclipse.equinox.p2.reconciler.dropins", "org.eclipse.equinox.p2.directorywatcher", "org.eclipse.ecf", "org.eclipse.ecf.identity", "org.eclipse.ecf.filetransfer", "org.eclipse.ecf.provider.filetransfer", "org.eclipse.ecf.provider.filetransfer.httpclient", "org.apache.commons.httpclient"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String bundle = stringArray[n2];
                PLATFORM_BUNDLES.add(bundle);
                ++n2;
            }
        }
    }

    static boolean isPlatformBundle(String bundleName) {
        Util.checkInit();
        return PLATFORM_BUNDLES.contains(bundleName);
    }

    static void reportBundleStateChange(Bundle bundle, int type, ILogger logger) {
        if (WARN_LEVEL == 0) {
            String msg = "";
            switch (type) {
                case 1: {
                    msg = String.valueOf(msg) + "Installing ";
                    break;
                }
                case 2: {
                    msg = String.valueOf(msg) + "Installed  ";
                    break;
                }
                case 4: {
                    msg = String.valueOf(msg) + "Activating ";
                    break;
                }
                case 8: {
                    msg = String.valueOf(msg) + "Activated  ";
                }
            }
            logger.log(0, String.valueOf(msg) + bundle.toString());
        }
    }

    public static void profile(long startTime, ProfileKind kind, String msg, ILogger logger) {
        long now = System.nanoTime();
        long delta = (now - startTime) / (long)Util.getActiveCount();
        int n = kind.ordinal();
        long l = profileTimes[n] + delta;
        profileTimes[n] = l;
        long total = l;
        msg = msg.substring(msg.lastIndexOf(46) + 1);
        logger.doLog(1, "Profile " + kind.name() + ": " + Util.m(delta) + "(" + Util.m(total) + "/" + Util.m(now - systemStartTime) + ") [" + msg + "]");
    }

    private static double m(long l) {
        return (double)l / 1000000.0;
    }

    private static int getActiveCount() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        ThreadGroup parent = group.getParent();
        while (parent != null) {
            group = parent;
            parent = group.getParent();
        }
        return group.activeCount();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ProfileKind {
        BaseTransformation,
        AspectTransformation,
        SuperClassFetching;

    }
}

