/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otequinox;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.objectteams.otequinox.hook.ClassScanner;
import org.eclipse.objectteams.otequinox.hook.HookConfigurator;
import org.eclipse.objectteams.otequinox.hook.IByteCodeAnalyzer;
import org.eclipse.objectteams.otequinox.hook.ILogger;
import org.eclipse.objectteams.otequinox.hook.IOTEquinoxService;
import org.eclipse.objectteams.otequinox.hook.IOTTransformer;
import org.eclipse.objectteams.otequinox.internal.ASMByteCodeAnalyzer;
import org.eclipse.objectteams.otequinox.internal.AspectBinding;
import org.eclipse.objectteams.otequinox.internal.AspectPermissionManager;
import org.eclipse.objectteams.otequinox.internal.MasterTeamLoader;
import org.eclipse.objectteams.otequinox.internal.TransformerServiceDelegate;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformerPlugin
implements BundleActivator,
IOTEquinoxService {
    private static List<String> KNOWN_OTDT_ASPECTS = new ArrayList<String>();
    private static HashMap<String, ArrayList<AspectBinding>> aspectBindingsByBasePlugin;
    private static HashMap<String, ArrayList<AspectBinding>> aspectBindingsByAspectPlugin;
    private static HashMap<String, ArrayList<String>> adaptedBaseClassNames;
    private Set<String> selfAdaptingAspects = new HashSet<String>();
    private AspectPermissionManager permissionManager;
    private static TransformerPlugin instance;
    private ServiceRegistration serviceRegistration;
    private ServiceRegistration serviceRegistration2;
    private IConfigurationElement liftingParticipantConfig;
    private static final String LIFTING_PARTICIPANT_FIELD = "_OT$liftingParticipant";
    private ILogger log;
    private HashMap<Bundle, List<MasterTeamLoader>> masterTeamLoaders = new HashMap();
    private PackageAdmin packageAdmin;
    private List<Object> teamInstances = new ArrayList<Object>();
    public static boolean IS_OTDT;
    public static int WARN_LEVEL;

    static {
        KNOWN_OTDT_ASPECTS.add("org.eclipse.objectteams.otdt.jdt.ui");
        KNOWN_OTDT_ASPECTS.add("org.eclipse.objectteams.otdt.compiler.adaptor");
        KNOWN_OTDT_ASPECTS.add("org.eclipse.objectteams.otdt.refactoring.adaptor");
        KNOWN_OTDT_ASPECTS.add("org.eclipse.objectteams.otdt.pde.ui");
        KNOWN_OTDT_ASPECTS.add("org.eclipse.objectteams.otdt.samples");
        aspectBindingsByBasePlugin = new HashMap();
        aspectBindingsByAspectPlugin = new HashMap();
        adaptedBaseClassNames = new HashMap();
        IS_OTDT = false;
        WARN_LEVEL = 4;
        String level = System.getProperty("otequinox.debug");
        if (level != null) {
            WARN_LEVEL = (level = level.toUpperCase()).equals("OK") ? 0 : (level.equals("INFO") ? 1 : (level.startsWith("WARN") ? 2 : (level.startsWith("ERR") ? 4 : 0)));
        }
    }

    public boolean isOTDT() {
        return IS_OTDT;
    }

    public TransformerPlugin() {
        instance = this;
    }

    public void start(BundleContext context) throws Exception {
        if (!HookConfigurator.OT_EQUINOX_ENABLED) {
            throw new BundleException("Not starting the transformer plugin because OT/Equinox has not been enabled (set system property \"ot.equinox\").");
        }
        this.log = HookConfigurator.getLogger();
        this.log(1, "activating org.eclipse.objectteams.otequinox");
        ServiceReference ref = context.getServiceReference(PackageAdmin.class.getName());
        if (ref != null) {
            this.packageAdmin = (PackageAdmin)context.getService(ref);
        } else {
            this.log(4, "Failed to load PackageAdmin service. Will not be able to handle fragments.");
        }
        this.permissionManager = new AspectPermissionManager(this.log, context.getBundle(), this.packageAdmin);
        this.permissionManager.loadAspectBindingNegotiators(context);
        this.loadAspectBindings();
        this.loadLiftingParticipant();
        this.serviceRegistration = context.registerService(IOTEquinoxService.class.getName(), (Object)this, (Dictionary)new Properties());
        this.serviceRegistration2 = context.registerService(IOTTransformer.class.getName(), (Object)new TransformerServiceDelegate(), (Dictionary)new Properties());
    }

    public void stop(BundleContext context) throws Exception {
        this.serviceRegistration.unregister();
        this.serviceRegistration2.unregister();
    }

    public static TransformerPlugin getDefault() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isWaitingForTeams() {
        HashMap<Object, List<Object>> hashMap = TransformerPlugin.instance.masterTeamLoaders;
        synchronized (hashMap) {
            if (!TransformerPlugin.instance.masterTeamLoaders.isEmpty()) {
                return true;
            }
        }
        hashMap = aspectBindingsByBasePlugin;
        synchronized (hashMap) {
            Iterator<ArrayList<AspectBinding>> iterator = aspectBindingsByBasePlugin.values().iterator();
            block6: while (true) {
                AspectBinding aspectBinding;
                if (!iterator.hasNext()) {
                    return false;
                }
                ArrayList<AspectBinding> aspects = iterator.next();
                Iterator<AspectBinding> iterator2 = aspects.iterator();
                do {
                    if (!iterator2.hasNext()) continue block6;
                    aspectBinding = iterator2.next();
                } while (aspectBinding.activated);
                break;
            }
            return true;
        }
    }

    public boolean isDeniedAspectPlugin(String symbolicName) {
        return this.permissionManager.isDeniedAspectPlugin(symbolicName);
    }

    private void loadAspectBindings() {
        IConfigurationElement[] aspectBindingConfigs = RegistryFactory.getRegistry().getConfigurationElementsFor("org.eclipse.objectteams.otequinox", "aspectBindings");
        int i = 0;
        while (i < aspectBindingConfigs.length) {
            IConfigurationElement currentBindingConfig = aspectBindingConfigs[i];
            String aspectBundleId = currentBindingConfig.getContributor().getName();
            IS_OTDT |= KNOWN_OTDT_ASPECTS.contains(aspectBundleId);
            IConfigurationElement[] basePlugins = currentBindingConfig.getChildren("basePlugin");
            if (basePlugins.length != 1) {
                this.log(4, "aspectBinding of " + aspectBundleId + " must declare exactly one basePlugin");
            } else {
                String baseBundleId = basePlugins[0].getAttribute("id");
                IConfigurationElement[] fragments = basePlugins[0].getChildren("requiredFragment");
                if (fragments == null || this.checkRequiredFragments(aspectBundleId, baseBundleId, fragments)) {
                    AspectBinding binding = new AspectBinding(aspectBundleId, baseBundleId, basePlugins[0].getChildren("forcedExports"));
                    IConfigurationElement[] teams = currentBindingConfig.getChildren("team");
                    binding.initTeams(teams.length);
                    try {
                        int j = 0;
                        while (j < teams.length) {
                            String teamClass;
                            binding.teamClasses[j] = teamClass = teams[j].getAttribute("class");
                            String activation = teams[j].getAttribute("activation");
                            binding.setActivation(j, activation);
                            ++j;
                        }
                        String realBaseBundleId = baseBundleId.toUpperCase().equals("SELF") ? aspectBundleId : baseBundleId;
                        TransformerPlugin.addBindingForBaseBundle(realBaseBundleId, binding);
                        this.addBindingForAspectBundle(aspectBundleId, binding);
                        int j2 = 0;
                        while (j2 < teams.length) {
                            String superTeamName = teams[j2].getAttribute("superclass");
                            if (superTeamName != null) {
                                this.addSubTeam(aspectBundleId, binding.teamClasses[j2], superTeamName);
                            }
                            ++j2;
                        }
                        this.log(1, "registered:\n" + binding);
                    }
                    catch (Throwable t) {
                        this.log(t, "Invalid aspectBinding extension");
                    }
                }
            }
            ++i;
        }
    }

    private boolean checkRequiredFragments(String aspectBundleId, String baseBundleId, IConfigurationElement[] fragments) {
        boolean hasError = false;
        IConfigurationElement[] iConfigurationElementArray = fragments;
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement fragment = iConfigurationElementArray[n2];
            String fragId = fragment.getAttribute("id");
            if (fragId == null) {
                this.log(4, "Mandatory attribute \"id\" missing from element \"requiredFragment\" of aspect binding in " + aspectBundleId);
                return false;
            }
            if (this.packageAdmin == null) {
                this.log(4, "Not checking required fragment " + fragId + " in aspect binding of " + aspectBundleId + ", package admin service not present");
                return false;
            }
            Bundle[] fragmentBundles = this.packageAdmin.getBundles(fragId, null);
            if (fragmentBundles == null || fragmentBundles.length == 0) {
                this.log(4, "Required fragment " + fragId + " not found in aspect binding of " + aspectBundleId);
                hasError = true;
            } else {
                Bundle fragmentBundle = fragmentBundles[0];
                String aspectBindingHint = " (aspect binding of " + aspectBundleId + ")";
                if (this.packageAdmin.getBundleType(fragmentBundle) != 1) {
                    this.log(4, "Required fragment " + fragId + " is not a fragment" + aspectBindingHint);
                    hasError = true;
                } else {
                    Bundle[] hosts = this.packageAdmin.getHosts(fragmentBundle);
                    if (hosts == null || hosts.length == 0) {
                        if (fragmentBundle.getState() < 4) {
                            this.log(4, "Required fragment " + fragId + " is not resolved" + aspectBindingHint);
                            hasError = true;
                        } else {
                            this.log(4, "Required fragment " + fragId + " has no host bundle" + aspectBindingHint);
                            hasError = true;
                        }
                    } else {
                        Bundle host = hosts[0];
                        if (!host.getSymbolicName().equals(baseBundleId)) {
                            this.log(4, "Required fragment " + fragId + " has wrong host " + host.getSymbolicName() + aspectBindingHint);
                            hasError = true;
                        }
                    }
                }
            }
            ++n2;
        }
        return !hasError;
    }

    private static void addBindingForBaseBundle(String baseBundleId, AspectBinding binding) {
        ArrayList<AspectBinding> bindingList = aspectBindingsByBasePlugin.get(baseBundleId);
        if (bindingList == null) {
            bindingList = new ArrayList();
            aspectBindingsByBasePlugin.put(baseBundleId, bindingList);
        }
        bindingList.add(binding);
    }

    private void addBindingForAspectBundle(String aspectBundleId, AspectBinding binding) {
        ArrayList<AspectBinding> bindingList = aspectBindingsByAspectPlugin.get(aspectBundleId);
        if (bindingList == null) {
            bindingList = new ArrayList();
            aspectBindingsByAspectPlugin.put(aspectBundleId, bindingList);
        }
        bindingList.add(binding);
        if (binding.basePlugin.toUpperCase().equals("SELF")) {
            this.selfAdaptingAspects.add(aspectBundleId);
        }
    }

    private void addSubTeam(String aspectBundleId, String subTeamName, String teamName) {
        ArrayList<AspectBinding> bindingList = aspectBindingsByAspectPlugin.get(aspectBundleId);
        if (bindingList == null) {
            Exception e = new Exception("No such aspect binding");
            this.log(e, "Class " + teamName + " not registered (declared to be superclass of team " + subTeamName);
        } else {
            for (AspectBinding binding : bindingList) {
                if (binding.teamClasses == null) continue;
                int i = 0;
                while (i < binding.teamClasses.length) {
                    if (binding.teamClasses[i].equals(teamName)) {
                        if (binding.subTeamClasses[i] == null) {
                            binding.subTeamClasses[i] = new ArrayList<String>();
                        }
                        binding.subTeamClasses[i].add(subTeamName);
                        return;
                    }
                    ++i;
                }
            }
            Exception e = new Exception("No such aspect binding");
            this.log(e, "Class " + teamName + " not registered(2) (declared to be superclass of team " + subTeamName);
        }
    }

    private void loadLiftingParticipant() {
        IConfigurationElement[] liftingParticipantConfigs = RegistryFactory.getRegistry().getConfigurationElementsFor("org.eclipse.objectteams.otequinox", "liftingParticipant");
        if (liftingParticipantConfigs.length != 1) {
            if (liftingParticipantConfigs.length > 1) {
                this.log(4, "Cannot install more than one lifting participant.");
            }
            return;
        }
        this.liftingParticipantConfig = liftingParticipantConfigs[0];
    }

    public void initializeOOTeam(Class<?> ooTeam) {
        if (this.liftingParticipantConfig == null) {
            return;
        }
        try {
            Field participantField = ooTeam.getDeclaredField(LIFTING_PARTICIPANT_FIELD);
            Object participantInstance = this.liftingParticipantConfig.createExecutableExtension("class");
            participantField.set(null, participantInstance);
            this.log(1, "registered lifting participant:\n\t" + participantInstance.getClass().getName());
        }
        catch (Throwable t) {
            this.log(t, "Invalid lifting participant extension");
        }
    }

    public String[] getAdaptedBasePlugins(Bundle aspectBundle) {
        ArrayList<AspectBinding> bindings = aspectBindingsByAspectPlugin.get(aspectBundle.getSymbolicName());
        if (bindings == null) {
            return null;
        }
        String[] basePlugins = new String[bindings.size()];
        int i = 0;
        while (i < basePlugins.length) {
            basePlugins[i] = bindings.get((int)i).basePlugin;
            ++i;
        }
        return basePlugins;
    }

    public boolean isAdaptedBasePlugin(String symbolicName) {
        ArrayList<AspectBinding> list = aspectBindingsByBasePlugin.get(symbolicName);
        return list != null && !list.isEmpty();
    }

    public String[] getAdaptingAspectPlugins(Bundle basePlugin) {
        return this.getAdaptingAspectPlugins(basePlugin.getSymbolicName());
    }

    public String[] getAdaptingAspectPlugins(String basePluginName) {
        ArrayList<AspectBinding> list = aspectBindingsByBasePlugin.get(basePluginName);
        if (list == null) {
            return new String[0];
        }
        String[] aspects = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            aspects[i] = list.get((int)i).aspectPlugin;
            ++i;
        }
        return aspects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeAdaptedBaseClassNames(String aspectBundleName, String teamName, Collection<String> baseClassNames) {
        String basePlugin = null;
        block3: for (AspectBinding aspectBinding : aspectBindingsByAspectPlugin.get(aspectBundleName)) {
            String[] stringArray = aspectBinding.teamClasses;
            int n = aspectBinding.teamClasses.length;
            int n2 = 0;
            while (n2 < n) {
                String aspectTeamClass = stringArray[n2];
                if (aspectTeamClass.equals(teamName)) {
                    basePlugin = aspectBinding.basePlugin;
                    break block3;
                }
                ++n2;
            }
        }
        if (basePlugin == null && this.selfAdaptingAspects.contains(aspectBundleName)) {
            basePlugin = aspectBundleName;
        }
        if (basePlugin == null) {
            this.log(4, "Base plugin for team " + teamName + " from " + aspectBundleName + " not found!");
            return;
        }
        HashMap<String, ArrayList<String>> hashMap = adaptedBaseClassNames;
        synchronized (hashMap) {
            ArrayList<String> baseBundleClassNames = adaptedBaseClassNames.get(basePlugin);
            if (baseBundleClassNames == null) {
                baseBundleClassNames = new ArrayList();
                adaptedBaseClassNames.put(basePlugin, baseBundleClassNames);
            }
            baseBundleClassNames.addAll(baseClassNames);
        }
    }

    public boolean loadTeams(Bundle baseBundle, ClassScanner classScanner) {
        ArrayList<AspectBinding> bindings = aspectBindingsByBasePlugin.get(baseBundle.getSymbolicName());
        return this.delegateToMasterTeamLoader(baseBundle, classScanner, bindings);
    }

    public boolean hasInternalTeams(Bundle bundle) {
        return this.selfAdaptingAspects.contains(bundle.getSymbolicName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadInternalTeams(Bundle bundle, ClassScanner scanner) {
        ArrayList<AspectBinding> selfBindings = new ArrayList<AspectBinding>();
        HashMap<String, ArrayList<AspectBinding>> hashMap = aspectBindingsByAspectPlugin;
        synchronized (hashMap) {
            ArrayList<AspectBinding> bindings;
            block6: {
                bindings = aspectBindingsByAspectPlugin.get(bundle.getSymbolicName());
                if (bindings != null) break block6;
                return false;
            }
            int i = 0;
            while (i < bindings.size()) {
                if (bindings.get((int)i).basePlugin.toUpperCase().equals("SELF")) {
                    selfBindings.add(bindings.remove(i));
                    continue;
                }
                ++i;
            }
        }
        return this.delegateToMasterTeamLoader(bundle, scanner, selfBindings);
    }

    private boolean delegateToMasterTeamLoader(Bundle baseBundle, ClassScanner scanner, ArrayList<AspectBinding> bindings) {
        if (bindings == null || bindings.isEmpty()) {
            return false;
        }
        MasterTeamLoader masterTeamLoader = new MasterTeamLoader(baseBundle);
        boolean success = masterTeamLoader.loadTeams(baseBundle, scanner, bindings);
        if (success) {
            this.addMasterTeamLoader(baseBundle, masterTeamLoader);
        }
        return success;
    }

    public void instantiateTeams(Bundle baseBundle, String triggerClassname) {
        instance.internalInstantiateTeams(baseBundle, triggerClassname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMasterTeamLoader(Bundle baseBundle, MasterTeamLoader masterTeamLoader) {
        HashMap<Bundle, List<MasterTeamLoader>> hashMap = this.masterTeamLoaders;
        synchronized (hashMap) {
            List<MasterTeamLoader> loaders = this.masterTeamLoaders.get(baseBundle);
            if (loaders == null) {
                loaders = new ArrayList<MasterTeamLoader>();
                this.masterTeamLoaders.put(baseBundle, loaders);
            }
            loaders.add(masterTeamLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void internalInstantiateTeams(Bundle baseBundle, String triggerClassname) {
        loaders = null;
        var4_4 /* !! */  = this.masterTeamLoaders;
        synchronized (var4_4 /* !! */ ) {
            loaders = this.masterTeamLoaders.get(baseBundle);
            if (this.masterTeamLoaders.isEmpty() || loaders == null) {
                return;
            }
            var5_5 = TransformerPlugin.aspectBindingsByBasePlugin;
            synchronized (var5_5) {
                aspects = TransformerPlugin.aspectBindingsByBasePlugin.get(baseBundle.getSymbolicName());
                if (aspects != null) {
                    if (this.permissionManager.isReady()) {
                        for (AspectBinding aspectBinding : aspects) {
                            if (this.permissionManager.checkForcedExports(aspectBinding.aspectPlugin, baseBundle.getSymbolicName(), aspectBinding.forcedExports)) continue;
                            return;
                        }
                    } else {
                        this.permissionManager.addForcedExportsObligations(aspects, baseBundle);
                    }
                }
            }
            loaders = new ArrayList<MasterTeamLoader>(loaders);
            this.masterTeamLoaders.remove(baseBundle);
            // MONITOREXIT @DISABLED, blocks:[0, 4] lbl32 : MonitorExitStatement: MONITOREXIT : var4_4 /* !! */ 
            if (true) ** GOTO lbl39
        }
        do {
            newInstances = loaders.remove(0).instantiateLoadedTeams(baseBundle, triggerClassname, this.permissionManager);
            var5_5 = this.teamInstances;
            synchronized (var5_5) {
                this.teamInstances.addAll(newInstances);
            }
lbl39:
            // 2 sources

        } while (!loaders.isEmpty());
        var4_4 /* !! */  = TransformerPlugin.aspectBindingsByBasePlugin;
        synchronized (var4_4 /* !! */ ) {
            aspects = TransformerPlugin.aspectBindingsByBasePlugin.get(baseBundle.getSymbolicName());
            if (aspects != null) {
                for (AspectBinding aspectBinding : aspects) {
                    aspectBinding.activated = true;
                }
            }
        }
    }

    public static synchronized void getTeamInstances(List list) {
        list.addAll(TransformerPlugin.instance.teamInstances);
    }

    public void log(Throwable ex, String msg) {
        msg = "OT/Equinox: " + msg;
        System.err.println(msg);
        ex.printStackTrace();
        this.log.log("org.eclipse.objectteams.otequinox", ex, msg);
    }

    public void log(int status, String msg) {
        if (status >= WARN_LEVEL) {
            this.doLog(status, msg);
        }
    }

    public void doLog(int status, String msg) {
        msg = "OT/Equinox: " + msg;
        this.log.log("org.eclipse.objectteams.otequinox", status, msg);
    }

    public IByteCodeAnalyzer getByteCodeAnalyzer() {
        return new ASMByteCodeAnalyzer();
    }
}

