/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.bytecode;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CallinMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.MethodSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.AbstractAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.ListValueAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.CallinCalloutBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;

public class OTDynCallinBindingsAttribute
extends ListValueAttribute {
    public static final char[] ATTRIBUTE_NAME = "OTDynCallinBindings".toCharArray();
    public static final short STATIC_ROLE_METHOD = 1;
    public static final short INHERITED = 4;
    public static final short COVARIANT_BASE_RETURN = 8;
    private List<Mapping> mappings;
    private TeamModel theTeam;

    OTDynCallinBindingsAttribute(TeamModel theTeam) {
        super(ATTRIBUTE_NAME, -1, -1);
        this.theTeam = theTeam;
        this.theTeam.addAttribute(this);
        this.mappings = new ArrayList<Mapping>();
    }

    public OTDynCallinBindingsAttribute(ClassFileStruct reader, int readOffset, int[] constantPoolOffsets) {
        super(ATTRIBUTE_NAME, -1, -1);
        this._reader = reader;
        this._readOffset = readOffset;
        this._constantPoolOffsets = constantPoolOffsets;
        this._count = this.consumeShort();
        this.mappings = new ArrayList<Mapping>();
        int i = 0;
        while (i < this._count) {
            this.mappings.add(this.readMapping());
            ++i;
        }
    }

    protected int getAttributeSize() {
        int s = 2;
        for (Mapping mapping : this.mappings) {
            s += mapping.getAttributeSize();
        }
        return s;
    }

    void addMappings(char[] baseClassName, CallinMappingDeclaration callinDecl) {
        int flags = 0;
        if (callinDecl.roleMethodSpec.resolvedMethod.isStatic()) {
            flags |= 1;
        }
        if (callinDecl.hasCovariantReturn()) {
            flags |= 8;
        }
        MethodSpec roleSpec = callinDecl.roleMethodSpec;
        MethodSpec[] baseMethodSpecs = callinDecl.getBaseMethodSpecs();
        Mapping mapping = new Mapping(callinDecl.scope.enclosingSourceType().sourceName(), callinDecl.name, roleSpec.selector, roleSpec.signature(), callinDecl.getCallinModifier(), flags, baseClassName, baseMethodSpecs.length);
        int i = 0;
        while (i < baseMethodSpecs.length) {
            MethodSpec baseSpec = baseMethodSpecs[i];
            int baseFlags = 0;
            if (baseSpec.isCallin()) {
                baseFlags |= 2;
            }
            if (baseSpec.isStatic()) {
                baseFlags |= 1;
            }
            mapping.addBaseMethod(i, baseSpec.selector, baseSpec.signature(), baseSpec.getCallinId(this.theTeam), baseFlags, baseSpec.getTranslationFlags());
            ++i;
        }
        mapping.setSMAPinfo(callinDecl);
        this.mappings.add(mapping);
        this._count = this.mappings.size();
    }

    public static void createOrMerge(TeamModel theTeam, char[] baseClassName, CallinMappingDeclaration[] mappingDecls) {
        AbstractAttribute existingAttr = theTeam.getAttribute(ATTRIBUTE_NAME);
        OTDynCallinBindingsAttribute theAttr = existingAttr != null ? (OTDynCallinBindingsAttribute)existingAttr : new OTDynCallinBindingsAttribute(theTeam);
        CallinMappingDeclaration[] callinMappingDeclarationArray = mappingDecls;
        int n = mappingDecls.length;
        int n2 = 0;
        while (n2 < n) {
            CallinMappingDeclaration callinDecl = callinMappingDeclarationArray[n2];
            theAttr.addMappings(baseClassName, callinDecl);
            ++n2;
        }
    }

    String toString(int i) {
        Mapping mapping = this.mappings.get(i);
        StringBuffer buf = new StringBuffer();
        buf.append('\t');
        buf.append(String.valueOf(mapping.callinName));
        buf.append(": ");
        buf.append(String.valueOf(mapping.roleSelector));
        buf.append(String.valueOf(mapping.roleSignature));
        buf.append(" <- ");
        buf.append(String.valueOf(mapping.callinModifier));
        buf.append(' ');
        buf.append(String.valueOf(mapping.baseClassName));
        BaseMethod[] baseMethods = mapping.getBaseMethods();
        int j = 0;
        while (j < baseMethods.length) {
            buf.append("\n\t\t");
            buf.append(String.valueOf(baseMethods[j].baseMethodName));
            buf.append(String.valueOf(baseMethods[j].baseMethodSignature));
            buf.append('{');
            buf.append(baseMethods[j].callinID);
            buf.append('}');
            ++j;
        }
        buf.append('\n');
        return buf.toString();
    }

    public void write(ClassFile classFile) {
        super.write(classFile);
        System.out.println("Wrote " + this);
    }

    void writeElementValue(int i) {
        Mapping mapping = this.mappings.get(i);
        this.writeName(mapping.roleClassName);
        this.writeName(mapping.callinName);
        this.writeName(mapping.roleSelector);
        this.writeName(mapping.roleSignature);
        this.writeName(mapping.callinModifier);
        this.writeByte((byte)mapping.flags);
        this.writeName(mapping.baseClassName);
        this.writeName(mapping.fileName);
        this.writeUnsignedShort(mapping.lineNumber);
        this.writeUnsignedShort(mapping.lineOffset);
        BaseMethod[] baseMethods = mapping.getBaseMethods();
        this.writeUnsignedShort(baseMethods.length);
        int j = 0;
        while (j < baseMethods.length) {
            this.writeName(baseMethods[j].baseMethodName);
            this.writeName(baseMethods[j].baseMethodSignature);
            this.writeInt(baseMethods[j].callinID);
            this.writeByte((byte)baseMethods[j].baseFlags);
            this.writeUnsignedShort(baseMethods[j].translationFlags);
            ++j;
        }
    }

    Mapping readMapping() {
        char[] roleClassName = this.consumeName();
        char[] callinName = this.consumeName();
        char[] roleSelector = this.consumeName();
        char[] roleSignature = this.consumeName();
        char[] callinModifer = this.consumeName();
        int flags = this.consumeByte();
        char[] baseClassName = this.consumeName();
        char[] fileName = this.consumeName();
        int lineNumber = this.consumeShort();
        int lineOffset = this.consumeShort();
        int baseMethodCount = this.consumeShort();
        Mapping result = new Mapping(roleClassName, callinName, roleSelector, roleSignature, callinModifer, flags, baseClassName, baseMethodCount);
        result.setSMAPInfo(fileName, lineNumber, lineOffset);
        int i = 0;
        while (i < baseMethodCount) {
            char[] baseMethodName = this.consumeName();
            char[] baseMethodSignature = this.consumeName();
            int callinID = this.consumeInt();
            int baseFlags = this.consumeByte();
            int translationFlags = this.consumeShort();
            result.addBaseMethod(i, baseMethodName, baseMethodSignature, callinID, baseFlags, translationFlags);
            ++i;
        }
        return result;
    }

    public void evaluate(Binding binding, LookupEnvironment environment, char[][][] missingTypeNames) {
        this.checkBindingMismatch(binding, 32768);
        if (((ReferenceBinding)binding).isTeam()) {
            ((ReferenceBinding)binding).getTeamModel().addAttribute(this);
        }
    }

    public void evaluateLateAttribute(ReferenceBinding teamBinding, int state) {
        if (state != 14) {
            return;
        }
        int i = 0;
        while (i < this.mappings.size()) {
            this.createBinding(teamBinding, this.mappings.get(i));
            ++i;
        }
    }

    private void createBinding(ReferenceBinding teamBinding, Mapping mapping) {
        int closePos;
        ReferenceBinding roleBinding = teamBinding.getMemberType(this.mappings.get((int)0).roleClassName).getRealClass();
        CallinCalloutBinding result = null;
        CallinCalloutBinding[] callinCallouts = roleBinding.callinCallouts;
        if (callinCallouts != null) {
            int i = 0;
            while (i < callinCallouts.length) {
                if (CharOperation.equals(mapping.callinName, callinCallouts[i].name)) {
                    result = callinCallouts[i];
                    result.callinModifier = this.encodeCallinModifier(mapping.callinModifier);
                    break;
                }
                ++i;
            }
        }
        if (result == null) {
            result = new CallinCalloutBinding(roleBinding, mapping.callinName, this.encodeCallinModifier(mapping.callinModifier));
        }
        BaseMethod[] mappingBaseMethods = mapping.baseMethods;
        MethodBinding[] baseMethods = new MethodBinding[mappingBaseMethods.length];
        ReferenceBinding currentType = roleBinding;
        char[] roleSignature = mapping.roleSignature;
        if (result.callinModifier == 120 && (closePos = CharOperation.indexOf(')', roleSignature)) > -1) {
            roleSignature = CharOperation.subarray(roleSignature, 0, closePos + 1);
        }
        block1: while (currentType != null) {
            MethodBinding[] methods = currentType.getMethods(mapping.roleSelector);
            int j = 0;
            while (j < methods.length) {
                if (CharOperation.prefixEquals(roleSignature, methods[j].signature(true))) {
                    result._roleMethodBinding = methods[j];
                    break block1;
                }
                ++j;
            }
            currentType = currentType.superclass();
        }
        if (result._roleMethodBinding == null) {
            throw new InternalCompilerError("role method specified in callin mapping does not exist " + mapping);
        }
        int i = 0;
        while (i < mappingBaseMethods.length) {
            block13: {
                BaseMethod bm = mappingBaseMethods[i];
                currentType = roleBinding.baseclass();
                while (currentType != null) {
                    MethodBinding[] methods = currentType.getMethods(bm.baseMethodName);
                    int j = 0;
                    while (j < methods.length) {
                        if (CharOperation.equals(bm.baseMethodSignature, methods[j].signature())) {
                            baseMethods[i] = methods[j];
                            break block13;
                        }
                        ++j;
                    }
                    currentType = currentType.superclass();
                }
                baseMethods[i] = new ProblemMethodBinding(bm.baseMethodName, null, roleBinding.baseclass(), 1);
            }
            ++i;
        }
        result._baseMethods = baseMethods;
        mapping.binding = result;
        result.copyInheritanceSrc = this.findTSuperBinding(mapping.callinName, roleBinding);
        roleBinding.addCallinCallouts(new CallinCalloutBinding[]{result});
    }

    private CallinCalloutBinding findTSuperBinding(char[] name, ReferenceBinding roleType) {
        ReferenceBinding[] tsuperRoles = roleType.roleModel.getTSuperRoleBindings();
        int i = tsuperRoles.length - 1;
        while (i >= 0) {
            if (tsuperRoles[i].callinCallouts != null) {
                CallinCalloutBinding[] callinCalloutBindingArray = tsuperRoles[i].callinCallouts;
                int n = tsuperRoles[i].callinCallouts.length;
                int n2 = 0;
                while (n2 < n) {
                    CallinCalloutBinding mapping = callinCalloutBindingArray[n2];
                    if (CharOperation.equals(mapping.name, name)) {
                        return mapping.copyInheritanceSrc != null ? mapping.copyInheritanceSrc : mapping;
                    }
                    ++n2;
                }
            }
            --i;
        }
        return null;
    }

    private int encodeCallinModifier(char[] modifierName) {
        if (CharOperation.equals(modifierName, IOTConstants.NAME_REPLACE)) {
            return 120;
        }
        if (CharOperation.equals(modifierName, IOTConstants.NAME_AFTER)) {
            return 119;
        }
        if (CharOperation.equals(modifierName, IOTConstants.NAME_BEFORE)) {
            return 121;
        }
        throw new InternalCompilerError("invalid callin modifier in byte code");
    }

    private class BaseMethod {
        static final int CALLIN = 1;
        static final int STATIC = 2;
        char[] baseMethodName;
        char[] baseMethodSignature;
        int callinID;
        int baseFlags;
        int translationFlags;

        BaseMethod(char[] baseMethodName, char[] baseMethodSignature, int callinID, int baseFlags, int translationFlags) {
            this.baseMethodName = baseMethodName;
            this.baseMethodSignature = baseMethodSignature;
            this.callinID = callinID;
            this.baseFlags = baseFlags;
            this.translationFlags = translationFlags;
        }
    }

    private class Mapping {
        char[] roleClassName;
        char[] callinName;
        char[] roleSelector;
        char[] roleSignature;
        char[] callinModifier;
        char[] baseClassName;
        char[] fileName;
        int flags;
        int lineNumber;
        int lineOffset;
        BaseMethod[] baseMethods;
        public CallinCalloutBinding binding;

        Mapping(char[] roleClassName, char[] callinName, char[] roleSelector, char[] roleSignature, char[] callinModifer, int flags, char[] baseClassName, int baseMethodCount) {
            this.roleClassName = roleClassName;
            this.callinName = callinName;
            this.roleSelector = roleSelector;
            this.roleSignature = roleSignature;
            this.callinModifier = callinModifer;
            this.flags = flags;
            this.baseClassName = baseClassName;
            this.baseMethods = new BaseMethod[baseMethodCount];
        }

        void addBaseMethod(int i, char[] baseMethodName, char[] baseMethodSignature, int callinID, int baseFlags, int translationFlags) {
            this.baseMethods[i] = new BaseMethod(baseMethodName, baseMethodSignature, callinID, baseFlags, translationFlags);
        }

        public BaseMethod[] getBaseMethods() {
            return this.baseMethods;
        }

        public int getAttributeSize() {
            int s = 21;
            int i = 0;
            while (i < this.baseMethods.length) {
                s += 11;
                ++i;
            }
            return s;
        }

        void setSMAPinfo(CallinMappingDeclaration decl) {
            this.fileName = this.getFileName(decl);
            int[] lineEnds = decl.scope.referenceCompilationUnit().compilationResult().getLineSeparatorPositions();
            this.lineNumber = (short)Util.getLineNumber(decl.sourceStart, lineEnds, 0, lineEnds.length - 1);
            short lineEnd = (short)Util.getLineNumber(decl.declarationSourceEnd, lineEnds, 0, lineEnds.length - 1);
            this.lineOffset = (short)(lineEnd - this.lineNumber);
        }

        private char[] getFileName(CallinMappingDeclaration decl) {
            CompilationUnitDeclaration compilationUnit = decl.scope.referenceCompilationUnit();
            char[] fullName = compilationUnit.getFileName();
            char[][] packageName = null;
            if (compilationUnit.currentPackage == null || compilationUnit.currentPackage.tokens.length == 0) {
                int pos = CharOperation.lastIndexOf('/', fullName);
                if (pos == -1) {
                    return fullName;
                }
                return CharOperation.subarray(fullName, pos + 1, -1);
            }
            packageName = compilationUnit.currentPackage.tokens;
            char[][] components = CharOperation.splitOn('/', fullName);
            int pos = CharOperation.lastIndexOf('/', fullName);
            if (pos == -1) {
                return CharOperation.concatWith(packageName, fullName, '/');
            }
            if (components.length <= packageName.length) {
                throw new InternalCompilerError("too few path elements");
            }
            int start = components.length - (packageName.length + 1);
            int end = components.length;
            if (!CharOperation.equals(packageName, CharOperation.subarray(components, start, end - 1))) {
                decl.scope.problemReporter().packageIsNotExpectedPackage(compilationUnit);
            }
            return CharOperation.concatWith(CharOperation.subarray(components, start, end), '/');
        }

        public void setSMAPInfo(char[] fileName, int lineNumber, int lineOffset) {
            this.fileName = fileName;
            this.lineNumber = lineNumber;
            this.lineOffset = lineOffset;
        }
    }
}

