/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.smap;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.SmapStratum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSmapGenerator {
    protected TypeDeclaration _type;
    protected List<SmapStratum> _strata;
    private String _defaultStratum;

    public AbstractSmapGenerator(TypeDeclaration type) {
        this._type = type;
        this._strata = new ArrayList<SmapStratum>();
    }

    public void addStratum(String stratum) {
        this._strata.add(new SmapStratum(stratum));
    }

    public abstract char[] generate();

    public String getSMAP() {
        String generatedFileName = this.getClassFileNameForType(this._type);
        StringBuffer out = new StringBuffer();
        out.append("SMAP\n");
        out.append(String.valueOf(generatedFileName) + "\n");
        if (this._defaultStratum != null) {
            out.append(String.valueOf(this._defaultStratum) + "\n");
        } else {
            out.append("OTJ\n");
        }
        int idx = 0;
        while (idx < this._strata.size()) {
            SmapStratum stratum = this._strata.get(idx);
            if (stratum.hasFileInfos()) {
                stratum.optimize();
                out.append(stratum.getSmapAsString());
            }
            ++idx;
        }
        out.append("*E");
        return out.toString();
    }

    private String getClassFileNameForType(TypeDeclaration type) {
        String generatedFileName = String.valueOf(String.valueOf(type.binding.getRealClass().constantPoolName())) + ".class";
        String[] tmp = generatedFileName.split("/");
        if (tmp.length > 0) {
            return tmp[tmp.length - 1];
        }
        return generatedFileName;
    }

    public List<SmapStratum> getStrata() {
        return this._strata;
    }

    public void setDefaultStratum(String defaultStratum) {
        this._defaultStratum = defaultStratum;
    }
}

