/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.EqualExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.InstanceOfExpression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.ThrowStatement;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.Lowering;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class InsertTypeAdjustmentsVisitor
extends ASTVisitor {
    private boolean disallowLower;

    public void endVisit(Assignment assignment, BlockScope scope) {
        assignment.expression = this.maybeWrap(scope, assignment.expression, assignment.lhs.resolvedType);
    }

    public void endVisit(FieldDeclaration fieldDeclaration, MethodScope scope) {
        this.endVisit((AbstractVariableDeclaration)fieldDeclaration, (BlockScope)scope);
    }

    public void endVisit(LocalDeclaration localDeclaration, BlockScope scope) {
        this.endVisit((AbstractVariableDeclaration)localDeclaration, scope);
    }

    private void endVisit(AbstractVariableDeclaration varDecl, BlockScope scope) {
        boolean oldDisallowLower = this.disallowLower;
        if (CharOperation.prefixEquals("_OT$local$".toCharArray(), varDecl.name)) {
            this.disallowLower = true;
        }
        try {
            if (varDecl.type == null) {
                new InternalCompilerError("varDecl.type is null for " + new String(varDecl.name)).printStackTrace();
                System.err.println(scope.referenceContext());
                return;
            }
            if (scope.isGeneratedScope() && varDecl.initialization instanceof MessageSend && CharOperation.equals(((MessageSend)varDecl.initialization).selector, IOTConstants.GET)) {
                this.disallowLower = true;
            }
            varDecl.initialization = this.maybeWrap(scope, varDecl.initialization, varDecl.type.resolvedType);
        }
        finally {
            this.disallowLower = oldDisallowLower;
        }
    }

    public void endVisit(MessageSend messageSend, BlockScope scope) {
        if (messageSend.arguments != null) {
            boolean saveLower = this.disallowLower;
            if (CharOperation.equals(messageSend.selector, IOTConstants.ADD_ROLE)) {
                this.disallowLower = true;
            }
            TypeBinding[] params = messageSend.binding.parameters;
            int i = 0;
            while (i < messageSend.arguments.length) {
                messageSend.arguments[i] = this.maybeWrap(scope, messageSend.arguments[i], params[i]);
                ++i;
            }
            this.disallowLower = saveLower;
        }
    }

    public void endVisit(FieldReference fieldReference, BlockScope scope) {
        if (fieldReference.binding.declaringClass != null) {
            fieldReference.receiver = this.maybeWrap(scope, fieldReference.receiver, fieldReference.binding.declaringClass);
        }
    }

    public void endVisit(AllocationExpression alloc, BlockScope scope) {
        if (alloc.arguments != null) {
            TypeBinding[] params = alloc.binding.parameters;
            int i = 0;
            while (i < alloc.arguments.length) {
                alloc.arguments[i] = this.maybeWrap(scope, alloc.arguments[i], params[i]);
                ++i;
            }
        }
    }

    public void endVisit(QualifiedAllocationExpression alloc, BlockScope scope) {
        if (alloc.arguments != null) {
            TypeBinding[] params = alloc.binding.parameters;
            int i = 0;
            while (i < alloc.arguments.length) {
                alloc.arguments[i] = this.maybeWrap(scope, alloc.arguments[i], params[i]);
                ++i;
            }
        }
    }

    public void endVisit(ReturnStatement returnStatement, BlockScope scope) {
        MethodBinding methodBinding;
        MethodScope methodScope = scope.methodScope();
        BaseTypeBinding methodType = methodScope.referenceContext instanceof AbstractMethodDeclaration ? ((methodBinding = ((AbstractMethodDeclaration)methodScope.referenceContext).binding) == null ? null : methodBinding.returnType) : TypeBinding.VOID;
        boolean oldDisallow = this.disallowLower;
        if (scope.isGeneratedScope()) {
            AbstractMethodDeclaration mDecl = scope.methodScope().referenceMethod();
            if (mDecl.isMappingWrapper.callout()) {
                this.disallowLower = true;
            }
        }
        try {
            returnStatement.expression = this.maybeWrap(scope, returnStatement.expression, methodType);
        }
        finally {
            this.disallowLower = oldDisallow;
        }
    }

    public void endVisit(EqualExpression eqExpr, BlockScope scope) {
        TypeBinding leftType = eqExpr.left.resolvedType;
        TypeBinding rightType = eqExpr.right.resolvedType;
        Config oldConfig = Config.createOrResetConfig(this);
        try {
            if ((eqExpr.checkCastTypesCompatibility(scope, leftType, rightType, null) || eqExpr.checkCastTypesCompatibility(scope, rightType, leftType, null)) && Config.getLoweringRequired()) {
                scope.problemReporter().illegalImplicitLower(eqExpr, leftType, rightType);
            }
        }
        finally {
            Config.removeOrRestore(oldConfig, this);
        }
    }

    public void endVisit(InstanceOfExpression ioExpr, BlockScope scope) {
        TypeBinding leftType = ioExpr.type.resolvedType;
        TypeBinding rightType = ioExpr.expression.resolvedType;
        Config oldConfig = Config.createOrResetConfig(this);
        try {
            ioExpr.checkCastTypesCompatibility(scope, leftType, rightType, ioExpr.expression);
            if (Config.getLoweringRequired()) {
                scope.problemReporter().illegalImplicitLower(ioExpr, leftType, rightType);
            }
        }
        finally {
            Config.removeOrRestore(oldConfig, this);
        }
    }

    public void endVisit(CastExpression castExpr, BlockScope scope) {
        if (castExpr.isGenerated) {
            return;
        }
        TypeBinding leftType = castExpr.type.resolvedType;
        TypeBinding rightType = castExpr.expression.resolvedType;
        Config oldConfig = Config.createOrResetConfig(this);
        try {
            castExpr.checkCastTypesCompatibility(scope, leftType, rightType, castExpr.expression);
            if (Config.getLoweringRequired()) {
                scope.problemReporter().illegalImplicitLower(castExpr, leftType, rightType);
            }
        }
        finally {
            Config.removeOrRestore(oldConfig, this);
        }
    }

    public void endVisit(ThrowStatement throwStat, BlockScope scope) {
        ReferenceBinding excType = (ReferenceBinding)throwStat.exceptionType;
        ReferenceBinding expectedType = null;
        if (excType.isSynthInterface()) {
            expectedType = excType.roleModel.getClassPartBinding();
        } else if (excType instanceof RoleTypeBinding) {
            expectedType = excType.getRealClass();
        }
        if (expectedType != null) {
            throwStat.exception = this.maybeWrap(scope, throwStat.exception, expectedType);
        }
    }

    private Expression maybeWrap(BlockScope scope, Expression expr, TypeBinding expectedType) {
        Expression newExpr = null;
        if (expr != null) {
            Config oldConfig = Config.createOrResetConfig(this);
            try {
                expr.resolvedType.isCompatibleWith(expectedType);
                ReferenceBinding requiredClass = Config.getCastRequired();
                if (requiredClass != null) {
                    Config.setCastRequired(null);
                    if (requiredClass == SourceTypeBinding.MultipleCasts || !expectedType.isCompatibleWith(requiredClass) || Config.getCastRequired() != null) {
                        throw new InternalCompilerError("incompatible cast requirements?");
                    }
                    AstGenerator gen = new AstGenerator(expr.sourceStart, expr.sourceEnd);
                    newExpr = gen.resolvedCastExpression(expr, expectedType, 1);
                } else if (Config.getLoweringRequired()) {
                    if (this.disallowLower) {
                        if (!this.isGeneratedCodeLoweringConfined(scope, expr.resolvedType, expectedType)) {
                            scope.problemReporter().illegalImplicitLower(expr, expectedType, expr.resolvedType);
                        }
                    } else {
                        Expression teamExpression = null;
                        if (expectedType.isArrayType()) {
                            ReferenceBinding resolvedLeafType = (ReferenceBinding)expr.resolvedType.leafComponentType();
                            ReferenceBinding resolvedTeam = resolvedLeafType.enclosingType();
                            ReferenceBinding currentType = scope.enclosingReceiverType();
                            while (currentType != null && currentType != resolvedTeam) {
                                currentType = currentType.enclosingType();
                            }
                            if ((currentType == null || RoleTypeBinding.isRoleWithExplicitAnchor(resolvedLeafType)) && expr instanceof MessageSend) {
                                Expression receiver = ((MessageSend)expr).receiver;
                                if (TeamModel.isTeamContainingRole((ReferenceBinding)receiver.resolvedType, resolvedLeafType)) {
                                    teamExpression = receiver;
                                }
                            }
                        }
                        newExpr = new Lowering().lowerExpression(scope, expr, expr.resolvedType, expectedType, teamExpression, true);
                    }
                }
            }
            finally {
                Config.removeOrRestore(oldConfig, this);
            }
        }
        if (newExpr != null) {
            return newExpr;
        }
        return expr;
    }

    private boolean isGeneratedCodeLoweringConfined(BlockScope scope, TypeBinding type, TypeBinding expected) {
        if (!scope.isGeneratedScope()) {
            return false;
        }
        if (expected.id != 1) {
            return false;
        }
        return TypeAnalyzer.isConfined(type);
    }
}

