/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer;

import java.util.ArrayList;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AND_AND_Expression;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CallinMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.GuardPredicateDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.MethodSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.CallinCalloutScope;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.SwitchOnBaseTypeGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TSuperHelper;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class PredicateGenerator
extends SwitchOnBaseTypeGenerator {
    private ReferenceBinding _currentRole;
    private CallinMappingDeclaration _callinMapping = null;
    private MethodSpec _baseMethod = null;
    private char[] _resultName = null;
    private char[] _baseVarName = BASE;
    private boolean _processingReplace = false;

    public PredicateGenerator(ReferenceBinding role, boolean processingReplace) {
        this._currentRole = role;
        this._processingReplace = processingReplace;
    }

    public static boolean createBaseArgType(AbstractMethodDeclaration methodDecl, Argument arg) {
        MethodBinding method = methodDecl.binding;
        AstGenerator gen = new AstGenerator(arg.sourceStart, arg.sourceEnd);
        ReferenceBinding roleType = method.declaringClass.isRole() ? method.declaringClass : null;
        ReferenceBinding baseType = null;
        if (roleType == null && method.declaringClass.isTeam()) {
            baseType = methodDecl.scope.getJavaLangObject();
        } else {
            if (roleType == null) {
                methodDecl.scope.problemReporter().abortDueToInternalError("predicate in non-role?");
                return false;
            }
            baseType = roleType.baseclass();
        }
        if (baseType == null) {
            methodDecl.scope.problemReporter().basePredicateInUnboundRole(methodDecl, roleType);
            return false;
        }
        arg.type = gen.baseclassReference(baseType);
        return true;
    }

    public Statement createBasePredicateCheck(CallinMappingDeclaration callinMapping, MethodSpec baseMethod, char[] resultName, AstGenerator gen) {
        ReferenceBinding roleType = callinMapping.scope.enclosingSourceType();
        Statement check = null;
        while (check == null && roleType.isRole()) {
            check = this.internalCreateBasePredicateCheck(roleType, callinMapping, baseMethod, resultName, gen);
            this._baseVarName = _OT_BASE;
            roleType = roleType.enclosingType();
        }
        this._baseVarName = BASE;
        return check;
    }

    char[] baseVarName() {
        return this._baseVarName;
    }

    private Statement internalCreateBasePredicateCheck(ReferenceBinding roleType, CallinMappingDeclaration callinMapping, MethodSpec baseMethod, char[] resultName, AstGenerator gen) {
        CallinCalloutScope scope = callinMapping.scope;
        ReferenceBinding teamType = roleType.enclosingType();
        ReferenceBinding objParam = scope.getJavaLangObject();
        while (roleType.isRole()) {
            char[][] methodNames = this.getBasePredicateNames(roleType, callinMapping);
            TypeBinding[] params = new TypeBinding[]{roleType.baseclass() != null ? roleType.baseclass() : objParam};
            int i = 0;
            while (i < methodNames.length) {
                boolean valid;
                if (this.isBindingPredicateName(methodNames[i])) {
                    valid = true;
                } else {
                    MethodBinding predicateMethod = TypeAnalyzer.findMethod(scope, roleType, methodNames[i], params);
                    valid = predicateMethod.isValidBinding();
                }
                if (valid) {
                    Statement switchStat = null;
                    try {
                        this._callinMapping = callinMapping;
                        this._baseMethod = baseMethod;
                        this._resultName = resultName;
                        switchStat = baseMethod.isStatic() ? this.genSingleBasePredicateCheck(teamType, roleType, gen) : this.createSwitchStatement(teamType, roleType, roleType.roleModel.getSubRoles(), gen);
                    }
                    finally {
                        this._callinMapping = null;
                        this._baseMethod = null;
                        this._resultName = null;
                    }
                    return switchStat;
                }
                ++i;
            }
            roleType = roleType.superclass();
        }
        MethodBinding predicateMethod = TypeAnalyzer.findMethod(scope, teamType, BASE_PREDICATE_PREFIX, new TypeBinding[]{objParam});
        if (predicateMethod.isValidBinding()) {
            return this.genSingleBasePredicateCheck(teamType, null, gen);
        }
        return null;
    }

    private Statement genSingleBasePredicateCheck(ReferenceBinding teamType, ReferenceBinding roleType, AstGenerator gen) {
        Expression[] predicateParameters;
        char[] predicateMethodName = null;
        if (roleType != null) {
            predicateMethodName = this.findBasePredicateName(teamType, roleType, this._callinMapping);
        }
        if (predicateMethodName == null) {
            block0: while (teamType != null) {
                ReferenceBinding currentTeam = teamType;
                while (currentTeam.isTeam()) {
                    MethodBinding[] candidates = teamType.getMethods(BASE_PREDICATE_PREFIX);
                    if (candidates != null && candidates.length == 1) {
                        predicateMethodName = BASE_PREDICATE_PREFIX;
                        break block0;
                    }
                    currentTeam = currentTeam.superclass();
                }
                teamType = teamType.enclosingType();
            }
        }
        if (predicateMethodName == null) {
            return null;
        }
        if (this.isBindingPredicateName(predicateMethodName)) {
            int numResult;
            int n = numResult = this._resultName == null ? 0 : 1;
            if (this._baseMethod.hasSignature) {
                int nBaseArgs = this._baseMethod.parameters.length;
                predicateParameters = new Expression[nBaseArgs + 1 + numResult];
                int i = 0;
                while (i < nBaseArgs) {
                    predicateParameters[i + 1] = gen.singleNameReference(this._baseMethod.arguments[i].name);
                    ++i;
                }
            } else {
                predicateParameters = new Expression[]{this.baseReference(BASE, roleType, gen)};
            }
            if (this._resultName != null && this._baseMethod.hasSignature) {
                predicateParameters[predicateParameters.length - 1] = gen.singleNameReference(this._resultName);
            }
        } else {
            predicateParameters = new Expression[]{this.baseReference(this._baseVarName, roleType, gen)};
        }
        Reference receiver = roleType != null ? gen.qualifiedNameReference(roleType) : gen.thisReference();
        AstGenerator skipGen = new AstGenerator(0x7FFFFFFD, 0);
        return gen.stealthIfNotStatement(gen.messageSend(receiver, predicateMethodName, predicateParameters), this.genVetoStatement(skipGen, skipGen.singleNameReference(BASE)));
    }

    private Expression baseReference(char[] baseVarName, ReferenceBinding roleType, AstGenerator gen) {
        Expression result = gen.singleNameReference(baseVarName);
        if (roleType != null && roleType.baseclass() != this._currentRole.baseclass()) {
            result = gen.castExpression(result, gen.typeReference(roleType.baseclass()), 2);
        }
        return result;
    }

    private Statement genVetoStatement(AstGenerator gen, Expression target) {
        if (this._processingReplace) {
            return gen.throwStatement(gen.allocation(gen.qualifiedTypeReference(ORG_OBJECTTEAMS_LIFTING_VETO), new Expression[]{gen.thisReference(), this._callinMapping.isStaticReplace() ? gen.nullLiteral() : target}));
        }
        return gen.returnStatement(null);
    }

    private boolean isBindingPredicateName(char[] name) {
        return CharOperation.occurencesOf('$', name) == 4;
    }

    private char[] findBasePredicateName(ReferenceBinding teamType, ReferenceBinding roleType, CallinMappingDeclaration callinMapping) {
        MethodBinding[] candidates;
        int i;
        char[][] predicateNames;
        while (roleType.isRole()) {
            predicateNames = this.getBasePredicateNames(roleType, callinMapping);
            i = 0;
            while (i < predicateNames.length) {
                candidates = roleType.getMethods(predicateNames[i]);
                if (candidates != null && candidates.length > 0) {
                    boolean nonTSuperFound = false;
                    int j = 0;
                    while (j < candidates.length) {
                        if (!TSuperHelper.isTSuper(candidates[j])) {
                            if (nonTSuperFound) {
                                throw new InternalCompilerError("More than one type predicate??");
                            }
                            nonTSuperFound = true;
                        }
                        ++j;
                    }
                    if (nonTSuperFound) {
                        return predicateNames[i];
                    }
                }
                ++i;
            }
            roleType = roleType.superclass();
        }
        while (teamType != null) {
            predicateNames = this.getBasePredicateNames(roleType, callinMapping);
            i = 0;
            while (i < predicateNames.length) {
                candidates = roleType.getMethods(predicateNames[i]);
                if (candidates != null && candidates.length == 1) {
                    return predicateNames[i];
                }
                ++i;
            }
            teamType = teamType.enclosingType();
        }
        return null;
    }

    protected Statement createCaseStatement(RoleModel role, AstGenerator gen) {
        Statement predicateCheck;
        TypeDeclaration roleType = role.getClassPartAst();
        if (roleType != null && (predicateCheck = this.genSingleBasePredicateCheck(roleType.enclosingType.binding, roleType.binding, gen)) != null) {
            return gen.block(new Statement[]{predicateCheck});
        }
        return null;
    }

    protected Statement createStatementForAmbiguousBase(AstGenerator gen) {
        return null;
    }

    protected Statement createDefaultStatement(ReferenceBinding staticRoleType, AstGenerator gen) {
        Statement stat;
        if (staticRoleType.isAbstract() && (stat = this.genSingleBasePredicateCheck(staticRoleType.enclosingType(), staticRoleType, gen)) != null) {
            return stat;
        }
        return this.genSingleBasePredicateCheck(staticRoleType.enclosingType(), null, gen);
    }

    public Statement createPredicateCheck(CallinMappingDeclaration mapping, TypeDeclaration roleType, Expression target, Expression[] bindingArgs, Expression[] messageArgs, AstGenerator gen) {
        char[] predicateMethodName = null;
        try {
            this._callinMapping = mapping;
            if (mapping.predicate != null && !mapping.predicate.isBasePredicate) {
                Statement statement = this.genSinglePredicateCheck(mapping.predicate.selector, bindingArgs, target, false, gen);
                return statement;
            }
            TypeBinding[] emptyParamTypes = new TypeBinding[]{};
            Expression[] emptyParamExprs = new Expression[]{};
            predicateMethodName = CharOperation.concatWith(new char[][]{PREDICATE_METHOD_NAME, mapping.roleMethodSpec.selector}, '$');
            MethodBinding predicateMethod = TypeAnalyzer.findMethod(mapping.scope, roleType.binding, predicateMethodName, mapping.roleMethodSpec.parameters);
            if (predicateMethod.isValidBinding()) {
                int requiredArgs = predicateMethod.parameters.length;
                if (messageArgs != null && requiredArgs < messageArgs.length) {
                    Expression[] expressionArray = messageArgs;
                    int n = messageArgs.length - requiredArgs;
                    messageArgs = new Expression[requiredArgs];
                    System.arraycopy(expressionArray, n, messageArgs, 0, requiredArgs);
                }
                Statement statement = this.genSinglePredicateCheck(predicateMethodName, messageArgs, target, false, gen);
                return statement;
            }
            ReferenceBinding currentType = roleType.binding;
            boolean outer = false;
            do {
                if ((predicateMethod = TypeAnalyzer.findMethod(mapping.scope, currentType, PREDICATE_METHOD_NAME, emptyParamTypes)).isValidBinding()) {
                    Statement statement = this.genSinglePredicateCheck(PREDICATE_METHOD_NAME, emptyParamExprs, target, outer, gen);
                    return statement;
                }
                currentType = currentType.enclosingType();
                outer = true;
            } while (currentType != null && currentType.isTeam());
            return null;
        }
        finally {
            this._callinMapping = null;
        }
    }

    private Statement genSinglePredicateCheck(char[] predicateMethodName, Expression[] params, Expression target, boolean outer, AstGenerator gen) {
        AstGenerator skipGen = new AstGenerator(0x7FFFFFFD, 0);
        return gen.stealthIfNotStatement(gen.messageSend(outer ? gen.thisReference() : target, predicateMethodName, params), this.genVetoStatement(skipGen, target.isTypeReference() ? skipGen.nullLiteral() : target));
    }

    public static void linkPredicates(GuardPredicateDeclaration predDecl) {
        Expression callSuperPredicate;
        Expression evalTSuperPredicate;
        if (predDecl.ignoreFurtherInvestigation) {
            return;
        }
        if (predDecl.isCopied) {
            return;
        }
        if (predDecl.statements == null) {
            if (Config.getStrictDiet() || predDecl.scope.classScope().referenceContext.isConverted) {
                return;
            }
            throw new InternalCompilerError("predicate should have statements in this mode");
        }
        ArrayList<Expression> otherPreds = new ArrayList<Expression>();
        AstGenerator gen = new AstGenerator(predDecl.bodyStart, predDecl.bodyEnd);
        Expression callOuterPredicate = PredicateGenerator.getOuterPredicateCheck(predDecl, gen);
        if (callOuterPredicate != null) {
            otherPreds.add(callOuterPredicate);
        }
        if ((evalTSuperPredicate = PredicateGenerator.getTSuperPredicateChecks(predDecl, gen)) != null) {
            otherPreds.add(evalTSuperPredicate);
        }
        if ((callSuperPredicate = PredicateGenerator.getSuperPredicateCheck(predDecl, gen)) != null) {
            otherPreds.add(callSuperPredicate);
        }
        if (otherPreds.size() > 0) {
            ReturnStatement returnStat = predDecl.returnStatement;
            Expression expression = returnStat.expression;
            for (Expression pred : otherPreds) {
                expression = new AND_AND_Expression(expression, pred, 0);
            }
            returnStat.expression = expression;
        }
    }

    private static Expression getOuterPredicateCheck(MethodDeclaration pred, AstGenerator gen) {
        ReferenceBinding site;
        char[] predName = pred.selector;
        boolean isBasePredicate = CharOperation.prefixEquals(BASE_PREDICATE_PREFIX, pred.selector);
        ReferenceBinding currentType = site = pred.binding.declaringClass;
        while (true) {
            char[] outerName = null;
            TypeBinding[] outerParams = null;
            Expression[] outerArgs = null;
            int dollarCount = CharOperation.occurencesOf('$', predName);
            ReferenceBinding declaringClass = currentType;
            if (dollarCount == 4) {
                int dollarPos = CharOperation.lastIndexOf('$', predName);
                dollarPos = CharOperation.lastIndexOf('$', predName, 0, dollarPos - 1);
                outerName = CharOperation.subarray(predName, 0, dollarPos);
                outerParams = PredicateGenerator.getArgTypesFromBindingPredicate(pred);
                outerArgs = PredicateGenerator.makeArgExpressions(pred, outerParams.length, null, gen);
            } else {
                if (dollarCount >= 2) {
                    int dollarPos = CharOperation.lastIndexOf('$', predName);
                    outerName = CharOperation.subarray(predName, 0, dollarPos);
                } else {
                    outerName = predName;
                    declaringClass = currentType.enclosingType();
                    if (declaringClass == null || !declaringClass.isTeam()) {
                        return null;
                    }
                }
                if (isBasePredicate) {
                    outerParams = new TypeBinding[]{pred.binding.parameters[0]};
                    outerArgs = new Expression[]{gen.singleNameReference(BASE)};
                } else {
                    outerParams = Binding.NO_PARAMETERS;
                }
            }
            if (outerName == null) {
                return null;
            }
            MethodBinding outerMethod = TypeAnalyzer.findMethod(pred.scope, declaringClass, outerName, outerParams);
            if (outerMethod.isValidBinding()) {
                return gen.messageSend(PredicateGenerator.genOuterReceiver(outerMethod.declaringClass, site, pred.isStatic(), gen), outerMethod.selector, outerArgs);
            }
            currentType = declaringClass;
            predName = outerName;
        }
    }

    private static TypeBinding[] getArgTypesFromBindingPredicate(MethodDeclaration pred) {
        char[] lastArgName;
        if (pred.arguments != null && pred.arguments.length > 0 && CharOperation.equals(lastArgName = pred.arguments[pred.arguments.length - 1].name, IOTConstants.RESULT)) {
            int len = pred.binding.parameters.length;
            TypeBinding[] filtered = new TypeBinding[len - 1];
            System.arraycopy(pred.binding.parameters, 0, filtered, 0, len - 1);
            return filtered;
        }
        return pred.binding.parameters;
    }

    private static Expression genOuterReceiver(ReferenceBinding receiverType, ReferenceBinding site, boolean staticScope, AstGenerator gen) {
        if (staticScope && receiverType.isRole()) {
            return gen.qualifiedNameReference(receiverType);
        }
        if (receiverType == site) {
            return gen.thisReference();
        }
        return gen.qualifiedThisReference(receiverType);
    }

    private static Expression getTSuperPredicateChecks(MethodDeclaration pred, AstGenerator gen) {
        ReferenceBinding thisType = pred.binding.declaringClass;
        Expression accumulatedResult = null;
        if (thisType.isRole()) {
            ReferenceBinding[] tsuperRoles = thisType.roleModel.getTSuperRoleBindings();
            int i = tsuperRoles.length - 1;
            while (i >= 0) {
                MethodBinding tsuperMethod = TypeAnalyzer.findMethod(pred.scope, tsuperRoles[i], pred.selector, pred.binding.parameters);
                if (tsuperMethod.isValidBinding()) {
                    char[] markerIfcName = TSuperHelper.getTSuperMarkName(tsuperRoles[i].enclosingType());
                    MessageSend current = gen.messageSend(ThisReference.implicitThis(), pred.selector, PredicateGenerator.makeArgExpressions(pred, tsuperMethod.parameters.length, gen.castExpression(gen.nullLiteral(), gen.singleTypeReference(markerIfcName), 2), gen));
                    accumulatedResult = accumulatedResult == null ? current : new AND_AND_Expression(accumulatedResult, current, 0);
                }
                --i;
            }
        }
        return accumulatedResult;
    }

    private static Expression getSuperPredicateCheck(MethodDeclaration pred, AstGenerator gen) {
        MethodBinding superMethod = null;
        ReferenceBinding thisType = pred.binding.declaringClass;
        ReferenceBinding superType = thisType.superclass();
        while (superType != null) {
            superMethod = TypeAnalyzer.findMethod(pred.scope, superType, pred.selector, pred.binding.parameters);
            if (superMethod.isValidBinding()) {
                return gen.messageSend(pred.isStatic() ? gen.qualifiedNameReference(superType) : gen.superReference(), superMethod.selector, PredicateGenerator.makeArgExpressions(pred, superMethod.parameters.length, null, gen));
            }
            superType = superType.superclass();
        }
        return null;
    }

    private static Expression[] makeArgExpressions(MethodDeclaration pred, int parametersLength, Expression markerArg, AstGenerator gen) {
        Expression[] args;
        if (markerArg != null) {
            args = new Expression[parametersLength + 1];
            args[parametersLength] = markerArg;
        } else {
            args = new Expression[parametersLength];
        }
        int i = 0;
        while (i < parametersLength) {
            args[i] = gen.singleNameReference(pred.arguments[i].name);
            ++i;
        }
        return args;
    }

    private char[][] getBasePredicateNames(ReferenceBinding roleType, CallinMappingDeclaration mapping) {
        MethodBinding method;
        ArrayList<char[]> names = new ArrayList<char[]>(3);
        if (mapping.predicate != null && mapping.predicate.isBasePredicate) {
            names.add(mapping.predicate.selector);
        }
        if ((method = mapping.getRoleMethod()) != null) {
            names.add(CharOperation.concatWith(new char[][]{BASE_PREDICATE_PREFIX, method.selector}, '$'));
        }
        if (roleType != null) {
            names.add(BASE_PREDICATE_PREFIX);
        }
        char[][] result = new char[names.size()][];
        names.toArray((T[])result);
        return result;
    }
}

