/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.StackMapFrameCodeStream;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.BaseAllocationExpression;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.BytecodeTransformer;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.Lifting;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TypeModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.InsertTypeAdjustmentsVisitor;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TSuperHelper;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class ConstructorDeclaration
extends AbstractMethodDeclaration {
    public ExplicitConstructorCall constructorCall;
    public TypeParameter[] typeParameters;
    private boolean isCodeAnalyzed = false;
    public boolean needsLifting = false;

    public ConstructorDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
    }

    public void analyseCode(ClassScope classScope, InitializationFlowContext initializerFlowContext, FlowInfo flowInfo) {
        this.analyseCode(classScope, initializerFlowContext, flowInfo, 0);
    }

    public void analyseCode(ClassScope classScope, InitializationFlowContext initializerFlowContext, FlowInfo flowInfo, int initialReachMode) {
        MethodBinding constructorBinding;
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        int nonStaticFieldInfoReachMode = flowInfo.reachMode();
        flowInfo.setReachMode(initialReachMode);
        if (this.isCodeAnalyzed) {
            return;
        }
        this.isCodeAnalyzed = true;
        SourceTypeBinding roleType = this.scope.enclosingSourceType();
        if (this.isCopied) {
            if (MethodModel.callsBaseCtor(this.binding.copyInheritanceSrc)) {
                MethodModel.setCallsBaseCtor(this);
            }
            if (this.arguments == null && !MethodModel.callsBaseCtor(this.binding) && roleType.baseclass() != null) {
                MethodModel.getModel((AbstractMethodDeclaration)this).problemDetail = MethodModel.ProblemDetail.IllegalDefaultCtor;
                this.isGenerated = true;
            }
            return;
        }
        if (this.isGenerated && this.statements == null) {
            return;
        }
        if (roleType.baseclass() != null && this.constructorCall != null) {
            ReferenceBinding createdBase;
            ReferenceBinding requiredBase;
            MethodBinding selfCall = this.constructorCall.binding;
            if (selfCall.declaringClass == this.binding.declaringClass) {
                selfCall.sourceMethod().analyseCode(classScope, initializerFlowContext, flowInfo.copy());
            }
            boolean calledHere = MethodModel.callsBaseCtor(this.binding);
            boolean calledIndirectly = MethodModel.callsBaseCtor(selfCall);
            if (calledIndirectly && (requiredBase = roleType.baseclass()) != (createdBase = selfCall.declaringClass.baseclass())) {
                this.scope.problemReporter().callsCtorWithMismatchingBaseCtor(this.constructorCall, selfCall.declaringClass, requiredBase, createdBase);
            }
            calledIndirectly |= !Lifting.isLiftToConstructor(this.binding, this.binding.declaringClass) && Lifting.isLiftToConstructor(selfCall, selfCall.declaringClass);
            if (Lifting.isLiftToConstructor(this, this.binding.declaringClass)) {
                if (calledHere || calledIndirectly) {
                    this.scope.problemReporter().baseConstructorCallInLiftingConstructor(this);
                }
            } else {
                FieldBinding baseField;
                if (!calledHere && !calledIndirectly) {
                    if (!this.isDefaultConstructor() || roleType.roleModel == null || !roleType.roleModel.hasBaseclassProblem()) {
                        this.scope.problemReporter().missingCallToBaseConstructor(this, this.binding.declaringClass);
                    }
                } else if (calledHere && calledIndirectly) {
                    this.scope.problemReporter().tooManyCallsToBaseConstructor(this.statements[0], this.constructorCall);
                }
                if (!calledHere && (baseField = this.scope.enclosingSourceType().getField(IOTConstants._OT_BASE, true)) != null) {
                    flowInfo.markAsDefinitelyAssigned(baseField);
                }
            }
            if (calledIndirectly) {
                MethodModel.setCallsBaseCtor(this);
            }
        }
        if (!(classScope.referenceContext.isRole() && (!classScope.referenceContext.binding.isAnonymousType() || classScope.referenceContext.isPurelyCopied) || (constructorBinding = this.binding) == null || (this.bits & 0x80) != 0 || constructorBinding.isUsed() || (!constructorBinding.isPrivate() ? !constructorBinding.isOrEnclosedByPrivateType() : (this.binding.declaringClass.tagBits & 0x10000000000000L) == 0L))) {
            MethodBinding methodBinding;
            ReferenceBinding superClass;
            if (this.constructorCall != null && (this.constructorCall.accessMode == 3 || (superClass = constructorBinding.declaringClass.superclass()) != null && (methodBinding = superClass.getExactConstructor(Binding.NO_PARAMETERS)) != null && methodBinding.canBeSeenBy(SuperReference.implicitSuperConstructorCall(), this.scope))) {
                this.scope.problemReporter().unusedPrivateConstructor(this);
            }
        }
        if (this.isRecursive(null)) {
            this.scope.problemReporter().recursiveConstructorInvocation(this.constructorCall);
        }
        try {
            FieldBinding field;
            int size;
            ArrayList computedExceptions;
            ExceptionHandlingFlowContext constructorContext = new ExceptionHandlingFlowContext(initializerFlowContext.parent, this, this.binding.thrownExceptions, initializerFlowContext, this.scope, FlowInfo.DEAD_END);
            initializerFlowContext.checkInitializerExceptions(this.scope, constructorContext, flowInfo);
            if (this.binding.declaringClass.isAnonymousType() && (computedExceptions = constructorContext.extendedExceptions) != null && (size = computedExceptions.size()) > 0) {
                ReferenceBinding[] actuallyThrownExceptions = new ReferenceBinding[size];
                computedExceptions.toArray(actuallyThrownExceptions);
                this.binding.thrownExceptions = actuallyThrownExceptions;
            }
            if (this.arguments != null) {
                int i = 0;
                int count = this.arguments.length;
                while (i < count) {
                    flowInfo.markAsDefinitelyAssigned(this.arguments[i].binding);
                    ++i;
                }
            }
            if (this.constructorCall != null) {
                if (this.constructorCall.accessMode == 3) {
                    FieldBinding[] fields = this.binding.declaringClass.fields();
                    int i = 0;
                    int count = fields.length;
                    while (i < count) {
                        field = fields[i];
                        if (!field.isStatic()) {
                            flowInfo.markAsDefinitelyAssigned(field);
                        }
                        ++i;
                    }
                }
                flowInfo = this.constructorCall.analyseCode(this.scope, constructorContext, flowInfo);
            }
            flowInfo.setReachMode(nonStaticFieldInfoReachMode);
            if (this.statements != null) {
                int complaintLevel = (nonStaticFieldInfoReachMode & 1) == 0 ? 0 : 1;
                int i = 0;
                int count = this.statements.length;
                while (i < count) {
                    Statement stat = this.statements[i];
                    if ((complaintLevel = stat.complainIfUnreachable(flowInfo, this.scope, complaintLevel)) < 2) {
                        flowInfo = stat.analyseCode(this.scope, constructorContext, flowInfo);
                    }
                    ++i;
                }
            }
            if ((flowInfo.tagBits & 1) == 0) {
                this.bits |= 0x40;
            }
            if (this.constructorCall != null && !TSuperHelper.isTSuper(this.binding) && this.constructorCall.accessMode != 4 && this.constructorCall.accessMode != 3) {
                flowInfo = flowInfo.mergedWith(constructorContext.initsOnReturn);
                FieldBinding[] fields = this.binding.declaringClass.fields();
                int i = 0;
                int count = fields.length;
                while (i < count) {
                    field = fields[i];
                    if (!field.isStatic() && field.isFinal() && !flowInfo.isDefinitelyAssigned(fields[i])) {
                        this.scope.problemReporter().uninitializedBlankFinalField(field, (this.bits & 0x80) != 0 ? this.scope.referenceType() : this);
                    }
                    ++i;
                }
            }
            constructorContext.complainIfUnusedExceptionHandlers(this);
            this.scope.checkUnusedParameters(this.binding);
        }
        catch (AbortMethod abortMethod) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        if (this.isRelevantCopied()) {
            new BytecodeTransformer().checkCopyMethodCode(classFile, this);
            if (this.binding.bytecodeMissing) {
                CategorizedProblem[] problems = this.scope.referenceCompilationUnit().compilationResult.getProblems();
                int problemsLength = problems.length;
                CategorizedProblem[] problemsCopy = new CategorizedProblem[problemsLength];
                System.arraycopy(problems, 0, problemsCopy, 0, problemsLength);
                classFile.addProblemConstructor(this, this.binding, problemsCopy);
            }
            return;
        }
        if (this.areStatementsMissing() && (this.bits & 0x80) == 0) {
            this.binding.bytecodeMissing = true;
            return;
        }
        int problemResetPC = 0;
        if (this.ignoreFurtherInvestigation) {
            if (this.binding == null) {
                return;
            }
            CategorizedProblem[] problems = this.scope.referenceCompilationUnit().compilationResult.getProblems();
            int problemsLength = problems.length;
            CategorizedProblem[] problemsCopy = new CategorizedProblem[problemsLength];
            System.arraycopy(problems, 0, problemsCopy, 0, problemsLength);
            classFile.addProblemConstructor(this, this.binding, problemsCopy);
            this.binding.bytecodeMissing = true;
            return;
        }
        boolean restart = false;
        boolean abort = false;
        do {
            try {
                problemResetPC = classFile.contentsOffset;
                this.internalGenerateCode(classScope, classFile);
                restart = false;
            }
            catch (AbortMethod e) {
                if (e.compilationResult == CodeStream.RESTART_IN_WIDE_MODE) {
                    if (!restart) {
                        classFile.contentsOffset = problemResetPC;
                        --classFile.methodCount;
                        classFile.codeStream.resetInWideMode();
                        restart = true;
                        continue;
                    }
                    restart = false;
                    abort = true;
                    continue;
                }
                if (e.compilationResult == CodeStream.RESTART_CODE_GEN_FOR_UNUSED_LOCALS_MODE) {
                    classFile.contentsOffset = problemResetPC;
                    --classFile.methodCount;
                    classFile.codeStream.resetForCodeGenUnusedLocals();
                    restart = true;
                    continue;
                }
                restart = false;
                abort = true;
            }
        } while (restart);
        if (abort) {
            CategorizedProblem[] problems = this.scope.referenceCompilationUnit().compilationResult.getAllProblems();
            int problemsLength = problems.length;
            CategorizedProblem[] problemsCopy = new CategorizedProblem[problemsLength];
            System.arraycopy(problems, 0, problemsCopy, 0, problemsLength);
            classFile.addProblemConstructor(this, this.binding, problemsCopy, problemResetPC);
        }
    }

    public void generateSyntheticFieldInitializationsIfNecessary(MethodScope methodScope, CodeStream codeStream, ReferenceBinding declaringClass) {
        SyntheticArgumentBinding syntheticArg;
        SyntheticArgumentBinding[] syntheticArgs = declaringClass.valueParamSynthArgs();
        int i = 0;
        int max = syntheticArgs == null ? 0 : syntheticArgs.length;
        while (i < max) {
            SyntheticArgumentBinding syntheticArg2 = syntheticArgs[i];
            if (syntheticArg2.matchingField != null) {
                codeStream.aload_0();
                codeStream.load(syntheticArg2);
                codeStream.fieldAccess((byte)-75, syntheticArg2.matchingField, declaringClass);
            }
            ++i;
        }
        if (!declaringClass.isNestedType()) {
            return;
        }
        NestedTypeBinding nestedType = (NestedTypeBinding)declaringClass;
        syntheticArgs = nestedType.syntheticEnclosingInstances();
        int i2 = 0;
        int max2 = syntheticArgs == null ? 0 : syntheticArgs.length;
        while (i2 < max2) {
            syntheticArg = syntheticArgs[i2];
            if (syntheticArg.matchingField != null) {
                codeStream.aload_0();
                codeStream.load(syntheticArg);
                codeStream.fieldAccess((byte)-75, syntheticArg.matchingField, null);
            }
            ++i2;
        }
        syntheticArgs = nestedType.syntheticOuterLocalVariables();
        i2 = 0;
        max2 = syntheticArgs == null ? 0 : syntheticArgs.length;
        while (i2 < max2) {
            syntheticArg = syntheticArgs[i2];
            if (syntheticArg.matchingField != null) {
                codeStream.aload_0();
                codeStream.load(syntheticArg);
                codeStream.fieldAccess((byte)-75, syntheticArg.matchingField, null);
            }
            ++i2;
        }
    }

    private void internalGenerateCode(ClassScope classScope, ClassFile classFile) {
        classFile.generateMethodInfoHeader(this.binding);
        int methodAttributeOffset = classFile.contentsOffset;
        int attributeNumber = classFile.generateMethodInfoAttributes(this.binding);
        if (this.model != null) {
            attributeNumber += this.model.writeAttributes(classFile);
        }
        if (!this.binding.isNative() && !this.binding.isAbstract()) {
            int max;
            boolean needFieldInitializations;
            CodeStream codeStream;
            int codeAttributeOffset;
            TypeDeclaration declaringType;
            block33: {
                boolean preInitSyntheticFields;
                declaringType = classScope.referenceContext;
                codeAttributeOffset = classFile.contentsOffset;
                classFile.generateCodeAttributeHeader();
                codeStream = classFile.codeStream;
                codeStream.reset(this, classFile);
                ReferenceBinding declaringClass = this.binding.declaringClass;
                int enumOffset = declaringClass.isEnum() ? 2 : 0;
                int argSlotSize = 1 + enumOffset;
                if (declaringClass.isNestedType()) {
                    this.scope.extraSyntheticArguments = declaringClass.syntheticOuterLocalVariables();
                    this.scope.computeLocalVariablePositions(declaringClass.getEnclosingInstancesSlotSize() + 1 + enumOffset, codeStream);
                    argSlotSize += declaringClass.getEnclosingInstancesSlotSize();
                    argSlotSize += declaringClass.getOuterLocalVariablesSlotSize();
                } else {
                    SyntheticArgumentBinding[] syntheticArguments = declaringClass.valueParamSynthArgs();
                    argSlotSize += syntheticArguments.length;
                    this.scope.computeLocalVariablePositions(1 + enumOffset + syntheticArguments.length, codeStream);
                }
                if (this.arguments != null) {
                    int i = 0;
                    int max2 = this.arguments.length;
                    while (i < max2) {
                        LocalVariableBinding argBinding = this.arguments[i].binding;
                        codeStream.addVisibleLocalVariable(argBinding);
                        argBinding.recordInitializationStartPC(0);
                        switch (argBinding.type.id) {
                            case 7: 
                            case 8: {
                                argSlotSize += 2;
                                break;
                            }
                            default: {
                                ++argSlotSize;
                            }
                        }
                        ++i;
                    }
                }
                MethodScope initializerScope = declaringType.initializerScope;
                initializerScope.computeLocalVariablePositions(argSlotSize, codeStream);
                boolean bl = needFieldInitializations = this.constructorCall == null || this.constructorCall.accessMode != 3;
                if (this.constructorCall != null) {
                    needFieldInitializations &= this.constructorCall.accessMode != 4;
                }
                if (!needFieldInitializations && this.constructorCall != null && this.constructorCall.binding.model != null && this.constructorCall.binding.model.liftedParams != null) {
                    needFieldInitializations = true;
                }
                if (needFieldInitializations && TypeAnalyzer.isTopConfined(this.scope.enclosingReceiverType())) {
                    needFieldInitializations = false;
                }
                boolean bl2 = preInitSyntheticFields = this.scope.compilerOptions().targetJDK >= 0x300000L;
                if (needFieldInitializations && preInitSyntheticFields) {
                    this.generateSyntheticFieldInitializationsIfNecessary(this.scope, codeStream, declaringClass);
                }
                if (this.constructorCall != null) {
                    this.constructorCall.generateCode(this.scope, codeStream);
                }
                if (needFieldInitializations) {
                    if (!preInitSyntheticFields) {
                        this.generateSyntheticFieldInitializationsIfNecessary(this.scope, codeStream, declaringClass);
                    }
                    if (!declaringType.isRole() || declaringClass.enclosingType() != null && declaringClass.enclosingType().id == 65) {
                        if (declaringType.fields != null) {
                            int i = 0;
                            max = declaringType.fields.length;
                            while (i < max) {
                                FieldDeclaration fieldDecl = declaringType.fields[i];
                                if (!fieldDecl.isStatic()) {
                                    fieldDecl.generateCode(initializerScope, codeStream);
                                }
                                ++i;
                            }
                        }
                    } else if (!Lifting.isLiftingCtor(this.binding)) {
                        MethodBinding[] initMethods = declaringType.binding.getMethods(IOTConstants.INIT_METHOD_NAME);
                        if (initMethods.length >= 1) {
                            int argCount = TSuperHelper.isTSuper(this.binding) ? 1 : 0;
                            int i = 0;
                            while (i < initMethods.length) {
                                if (initMethods[i].parameters.length == argCount) {
                                    codeStream.aload_0();
                                    codeStream.invoke((byte)-74, initMethods[i], declaringType.binding);
                                    break block33;
                                }
                                ++i;
                            }
                        }
                        assert (TypeModel.isIgnoreFurtherInvestigation(classScope.referenceContext) || (declaringClass.tagBits & 0x800000000000000L) != 0L || declaringClass.isTeam());
                    }
                }
            }
            if (this.statements != null) {
                int i = 0;
                max = this.statements.length;
                while (i < max) {
                    this.statements[i].generateCode(this.scope, codeStream);
                    ++i;
                }
            }
            if (this.ignoreFurtherInvestigation) {
                throw new AbortMethod(this.scope.referenceCompilationUnit().compilationResult, null);
            }
            if ((this.bits & 0x40) != 0) {
                codeStream.return_();
            }
            codeStream.exitUserScope(this.scope);
            codeStream.recordPositionsFrom(0, this.bodyEnd);
            try {
                classFile.completeCodeAttribute(codeAttributeOffset);
            }
            catch (NegativeArraySizeException negativeArraySizeException) {
                throw new AbortMethod(this.scope.referenceCompilationUnit().compilationResult, null);
            }
            this.maybeRecordByteCode(classFile, methodAttributeOffset - 6);
            ++attributeNumber;
            if (codeStream instanceof StackMapFrameCodeStream && needFieldInitializations && declaringType.fields != null) {
                ((StackMapFrameCodeStream)codeStream).resetSecretLocals();
            }
        }
        classFile.completeMethodInfo(this.binding, methodAttributeOffset, attributeNumber);
    }

    public void maybeRecordByteCode(ClassFile classFile, int methodAttributeOffset) {
        RoleModel.maybeRecordByteCode(this, classFile, methodAttributeOffset);
        if (this.binding.declaringClass.isTeam()) {
            MethodModel methodModel = MethodModel.getModel(this);
            methodModel.recordByteCode(classFile, methodAttributeOffset);
        }
    }

    public boolean isConstructor() {
        return true;
    }

    public boolean isDefaultConstructor() {
        return (this.bits & 0x80) != 0;
    }

    public boolean isInitializationMethod() {
        return true;
    }

    public boolean isRecursive(ArrayList visited) {
        if (this.binding == null || this.constructorCall == null || this.constructorCall.binding == null || this.constructorCall.isSuperAccess() || this.constructorCall.isTsuperAccess() || !this.constructorCall.binding.isValidBinding()) {
            return false;
        }
        ConstructorDeclaration targetConstructor = (ConstructorDeclaration)this.scope.referenceType().declarationOf(this.constructorCall.binding.original());
        if (this == targetConstructor) {
            return true;
        }
        if (visited == null) {
            visited = new ArrayList<ConstructorDeclaration>(1);
        } else {
            int index = visited.indexOf(this);
            if (index >= 0) {
                return index == 0;
            }
        }
        visited.add(this);
        return targetConstructor.isRecursive(visited);
    }

    public void parseStatements(Parser parser, CompilationUnitDeclaration unit) {
        if ((this.bits & 0x80) != 0 && this.constructorCall == null) {
            this.constructorCall = SuperReference.implicitSuperConstructorCall();
            this.constructorCall.sourceStart = this.sourceStart;
            this.constructorCall.sourceEnd = this.sourceEnd;
            return;
        }
        if (this.isCopied || this.isGenerated) {
            return;
        }
        parser.parse(this, unit, false);
    }

    void createExceptionStatements() {
        AstGenerator gen = new AstGenerator(this.sourceStart, this.sourceEnd);
        this.constructorCall = gen.explicitConstructorCall(2);
        this.statements = new Statement[]{gen.throwStatement(gen.allocation(gen.qualifiedTypeReference(IOTConstants.ILLEGAL_ROLE_CREATION_EXCEPTION), null))};
        this.hasParsedStatements = true;
        this.isCopied = false;
        this.resolve(this.scope.classScope());
    }

    public StringBuffer printBody(int indent, StringBuffer output) {
        output.append(" {");
        if (this.constructorCall != null) {
            output.append('\n');
            this.constructorCall.printStatement(indent, output);
        }
        if (this.statements != null) {
            int i = 0;
            while (i < this.statements.length) {
                output.append('\n');
                this.statements[i].printStatement(indent, output);
                ++i;
            }
        } else if (this.isCopied && this.statements == null) {
            output.append("\n");
            ConstructorDeclaration.printIndent(indent == 0 ? 0 : indent - 1, output);
            output.append("     /* CopyInheritance */");
        }
        output.append('\n');
        ConstructorDeclaration.printIndent(indent == 0 ? 0 : indent - 1, output).append('}');
        return output;
    }

    public void resolveJavadoc() {
        if (this.binding == null || this.javadoc != null) {
            super.resolveJavadoc();
        } else if ((this.bits & 0x80) == 0 && this.binding.declaringClass != null && !this.binding.declaringClass.isLocalType()) {
            int javadocVisibility = this.binding.modifiers & 7;
            ClassScope classScope = this.scope.classScope();
            ProblemReporter reporter = this.scope.problemReporter();
            int severity = reporter.computeSeverity(-1610612250);
            if (severity != 256) {
                if (classScope != null) {
                    javadocVisibility = Util.computeOuterMostVisibility(classScope.referenceType(), javadocVisibility);
                }
                int javadocModifiers = this.binding.modifiers & 0xFFFFFFF8 | javadocVisibility;
                reporter.javadocMissing(this.sourceStart, this.sourceEnd, severity, javadocModifiers);
            }
        }
    }

    public void resolveStatements() {
        SourceTypeBinding sourceType = this.scope.enclosingSourceType();
        if (!CharOperation.equals(sourceType.sourceName, this.selector)) {
            this.scope.problemReporter().missingReturnType(this);
        }
        if (this.isCopied) {
            return;
        }
        if (this.typeParameters != null) {
            int i = 0;
            int length = this.typeParameters.length;
            while (i < length) {
                this.typeParameters[i].resolve(this.scope);
                ++i;
            }
        }
        if (this.binding != null && !this.binding.isPrivate()) {
            sourceType.tagBits |= 0x10000000000000L;
        }
        if (this.constructorCall != null) {
            if (sourceType.id == 1 && this.constructorCall.accessMode != 3) {
                if (this.constructorCall.accessMode == 2) {
                    this.scope.problemReporter().cannotUseSuperInJavaLangObject(this.constructorCall);
                }
                this.constructorCall = null;
            } else {
                if (this.statements != null && this.statements.length > 0 && this.statements[0] instanceof BaseAllocationExpression) {
                    ((BaseAllocationExpression)this.statements[0]).checkGenerate(this.scope);
                }
                Config oldConfig = Config.createOrResetConfig(this);
                try {
                    this.constructorCall.resolve(this.scope);
                    if (Config.requireTypeAdjustment() && !this.scope.problemReporter().referenceContext.hasErrors()) {
                        this.constructorCall.traverse(new InsertTypeAdjustmentsVisitor(), this.scope);
                    }
                }
                finally {
                    Config.removeOrRestore(oldConfig, this);
                }
            }
        }
        if ((this.modifiers & 0x1000000) != 0) {
            this.scope.problemReporter().methodNeedBody(this);
        }
        super.resolveStatements();
    }

    public void traverse(ASTVisitor visitor, ClassScope classScope) {
        if (visitor.visit(this, classScope)) {
            int i;
            if (this.javadoc != null) {
                this.javadoc.traverse(visitor, this.scope);
            }
            if (this.annotations != null) {
                int annotationsLength = this.annotations.length;
                i = 0;
                while (i < annotationsLength) {
                    this.annotations[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.typeParameters != null) {
                int typeParametersLength = this.typeParameters.length;
                i = 0;
                while (i < typeParametersLength) {
                    this.typeParameters[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.arguments != null) {
                int argumentLength = this.arguments.length;
                i = 0;
                while (i < argumentLength) {
                    this.arguments[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.thrownExceptions != null) {
                int thrownExceptionsLength = this.thrownExceptions.length;
                i = 0;
                while (i < thrownExceptionsLength) {
                    this.thrownExceptions[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.constructorCall != null) {
                this.constructorCall.traverse(visitor, this.scope);
            }
            if (this.statements != null) {
                int statementsLength = this.statements.length;
                i = 0;
                while (i < statementsLength) {
                    this.statements[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, classScope);
    }

    public TypeParameter[] typeParameters() {
        return this.typeParameters;
    }
}

