/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.WordValueAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.CallinCalloutBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.SyntheticOTMethodBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.mappings.CallinImplementorDyn;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.MethodSignatureEnhancer;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.RoleTypeCreator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TSuperHelper;

public class SyntheticBaseCallSurrogate
extends SyntheticOTMethodBinding {
    private static final char[] _OT = "_OT".toCharArray();
    private TypeBinding errorType;
    private ReferenceBinding stringType;

    public SyntheticBaseCallSurrogate(MethodBinding callinMethod, SourceTypeBinding declaringClass) {
        super(declaringClass, 4100, callinMethod.selector, callinMethod.parameters, callinMethod.returnType);
        this.selector = SyntheticBaseCallSurrogate.genSurrogateName(callinMethod.selector, callinMethod.declaringClass.sourceName(), callinMethod.isStatic());
        if (!callinMethod.isStatic() && callinMethod.isCallin()) {
            this.parameters = SyntheticBaseCallSurrogate.addIsSuperAccessArg(this.parameters);
        }
        this.purpose = 5;
        this.targetMethod = callinMethod;
        TypeBinding origReturnType = MethodModel.getReturnType(callinMethod);
        MethodModel.saveReturnType(this, origReturnType);
        ClassScope scope = declaringClass.scope;
        this.errorType = scope.getType(IOTConstants.OTRE_INTERNAL_ERROR, 5);
        this.stringType = scope.getJavaLangString();
        SyntheticMethodBinding[] knownAccessMethods = declaringClass.syntheticMethods();
        this.index = knownAccessMethods == null ? 0 : knownAccessMethods.length;
    }

    public void generateInstructions(CodeStream codeStream) {
        codeStream.new_(this.errorType);
        codeStream.dup();
        codeStream.ldc("Binding error: base-call impossible!");
        MethodBinding ctorBinding = ((ReferenceBinding)this.errorType).getExactConstructor(new TypeBinding[]{this.stringType});
        codeStream.invoke((byte)-73, ctorBinding, this.errorType);
        codeStream.athrow();
        codeStream.aconst_null();
        codeStream.areturn();
    }

    public static boolean isCallinMethodBoundIn(MethodBinding callinMethod, ReferenceBinding roleClass) {
        if (callinMethod.declaringClass != roleClass && (callinMethod = roleClass.getExactMethod(callinMethod.selector, callinMethod.parameters, null)) == null) {
            return false;
        }
        if (roleClass.callinCallouts != null) {
            CallinCalloutBinding[] callinCalloutBindingArray = roleClass.callinCallouts;
            int n = roleClass.callinCallouts.length;
            int n2 = 0;
            while (n2 < n) {
                CallinCalloutBinding mapping = callinCalloutBindingArray[n2];
                if (mapping._roleMethodBinding == callinMethod) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isBindingForCallinMethodInherited(MethodBinding callinMethod) {
        declaringClass = callinMethod.declaringClass;
        if (!SyntheticBaseCallSurrogate.isCallinMethodBoundIn(callinMethod, declaringClass)) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (!SyntheticBaseCallSurrogate.isCallinMethodBoundIn(callinMethod, declaringClass)) continue;
            return true;
lbl6:
            // 2 sources

            ** while ((declaringClass = declaringClass.superclass()) != null)
        }
lbl7:
        // 1 sources

        return false;
    }

    public static void addFakedBaseCallSurrogates(SourceTypeBinding type) {
        if (type.methods() == null) {
            return;
        }
        if (CallinImplementorDyn.DYNAMIC_WEAVING) {
            return;
        }
        MethodBinding[] methodBindingArray = type.methods();
        int n = methodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodBinding method = methodBindingArray[n2];
            if (method.isCallin() && method.returnType != null) {
                SyntheticBaseCallSurrogate.getBaseCallSurrogate(method, type.roleModel, type.scope.environment());
            }
            ++n2;
        }
    }

    public static MethodBinding getBaseCallSurrogate(MethodBinding callinMethod, RoleModel clazz, LookupEnvironment environment) {
        block14: {
            block13: {
                if (!TSuperHelper.isTSuper(callinMethod)) break block13;
                return null;
            }
            if (!SyntheticBaseCallSurrogate.isBindingForCallinMethodInherited(callinMethod)) break block14;
            return null;
        }
        try {
            MethodBinding result = null;
            ReferenceBinding roleType = callinMethod.declaringClass;
            ReferenceBinding teamType = roleType.enclosingType();
            ReferenceBinding declaringClass = callinMethod.isStatic() ? teamType : roleType;
            char[] roleName = roleType.sourceName();
            char[] selector = SyntheticBaseCallSurrogate.genSurrogateName(callinMethod.selector, roleName, callinMethod.isStatic());
            TypeBinding returnType = MethodSignatureEnhancer.getGeneralizedReturnType(callinMethod.returnType, environment);
            TypeBinding[] baseCallParameters = callinMethod.parameters;
            if (!callinMethod.isStatic()) {
                baseCallParameters = SyntheticBaseCallSurrogate.addIsSuperAccessArg(baseCallParameters);
            }
            MethodBinding[] methodBindingArray = declaringClass.getMethods(selector);
            int n = methodBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                block15: {
                    MethodBinding candidate = methodBindingArray[n2];
                    if (candidate.parameters.length == baseCallParameters.length) {
                        int i = 0;
                        while (i < baseCallParameters.length) {
                            if (SyntheticBaseCallSurrogate.areTypesEqual(baseCallParameters[i].erasure(), candidate.parameters[i])) {
                                ++i;
                                continue;
                            }
                            break block15;
                        }
                        result = candidate;
                        break;
                    }
                }
                ++n2;
            }
            if (result == null) {
                result = declaringClass.isBinaryBinding() ? new MethodBinding(1, selector, returnType, baseCallParameters, null, declaringClass) : ((SourceTypeBinding)declaringClass).addSyntheticBaseCallSurrogate(callinMethod);
                MethodModel.getModel((MethodBinding)result)._fakeKind = MethodModel.FakeKind.BASECALL_SURROGATE;
                RoleTypeCreator.wrapTypesInMethodBindingSignature(result, environment);
                result.modifiers &= 0xFDFFFFFF;
                declaringClass.addMethod(result);
            }
            MethodModel.getModel(callinMethod).setBaseCallSurrogate(result);
            return result;
        }
        catch (RuntimeException ex) {
            if (clazz != null && clazz.isIncompatibleCompilerVersion()) {
                String version = WordValueAttribute.getBytecodeVersionString(clazz._compilerVersion);
                String errorMessage = "Byte code for class " + String.valueOf(clazz.getBinding().readableName()) + " has incompatible version " + version;
                try {
                    Config.getLookupEnvironment().problemReporter.abortDueToInternalError(errorMessage);
                }
                catch (Config.NotConfiguredException e) {
                    throw new AbortCompilation(false, e);
                }
                return null;
            }
            throw ex;
        }
    }

    static boolean areTypesEqual(TypeBinding one, TypeBinding two) {
        if (one == two) {
            return true;
        }
        ReferenceBinding enclosingOne = one.enclosingType();
        if (enclosingOne == null) {
            return false;
        }
        ReferenceBinding enclosingTwo = two.enclosingType();
        if (enclosingTwo == null) {
            return false;
        }
        if (!SyntheticBaseCallSurrogate.areTypesEqual(enclosingOne, enclosingTwo)) {
            return false;
        }
        return CharOperation.equals(one.sourceName(), two.sourceName());
    }

    static TypeBinding[] addIsSuperAccessArg(TypeBinding[] baseCallParameters) {
        int len = baseCallParameters.length;
        TypeBinding[] newParams = new TypeBinding[len + 1];
        System.arraycopy(baseCallParameters, 0, newParams, 0, MethodSignatureEnhancer.ENHANCING_ARG_LEN);
        newParams[MethodSignatureEnhancer.ENHANCING_ARG_LEN] = TypeBinding.BOOLEAN;
        System.arraycopy(baseCallParameters, MethodSignatureEnhancer.ENHANCING_ARG_LEN, newParams, MethodSignatureEnhancer.ENHANCING_ARG_LEN + 1, len - MethodSignatureEnhancer.ENHANCING_ARG_LEN);
        return newParams;
    }

    public static char[] genSurrogateName(char[] methodName, char[] roleName, boolean isStatic) {
        if (isStatic) {
            return CharOperation.concatWith(new char[][]{_OT, roleName, methodName, "base".toCharArray()}, '$');
        }
        return CharOperation.concatWith(new char[][]{_OT, methodName, "base".toCharArray()}, '$');
    }

    public static boolean isBaseCallSurrogateName(char[] name) {
        char[][] split = CharOperation.splitOn('$', name);
        if (split.length < 3) {
            return false;
        }
        return CharOperation.equals(split[0], _OT) && CharOperation.equals(split[split.length - 1], IOTConstants.BASE);
    }

    public static char[] stripBaseCallName(char[] selector) {
        if (CharOperation.occurencesOf('$', selector) == 2) {
            char[][] tokens = CharOperation.splitOn('$', selector);
            selector = tokens[1];
        }
        return selector;
    }
}

