/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer;

import java.util.HashSet;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.EqualExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.LiftingEnvironment;
import org.eclipse.objectteams.otdt.internal.core.compiler.mappings.CallinImplementorDyn;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstClone;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstConverter;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstEdit;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class ReflectionGenerator
implements IOTConstants,
ClassFileConstants {
    private static final char[] HAS_ROLE = "hasRole".toCharArray();
    private static final char[] GET_ROLE = "getRole".toCharArray();
    private static final char[] GET_ALL_ROLES = "getAllRoles".toCharArray();
    public static final char[] UNREGISTER_ROLE = "unregisterRole".toCharArray();
    private static final char[] T = "T".toCharArray();
    private static final char[] CLASS_ARG = "class_arg".toCharArray();
    private static final char[][] ILLEGAL_ARGUMENT_EXCEPTION = new char[][]{"java".toCharArray(), "lang".toCharArray(), "IllegalArgumentException".toCharArray()};
    private static final char[] FIRST_RESULT = "first_result".toCharArray();
    private static final char[] FIRST_NAME = "first_name".toCharArray();
    private static final char[] FIRST_CACHE = "first_cache".toCharArray();
    private static final char[] FOUND_BASE = "found_base".toCharArray();
    private static final char[] BASE_OBJ = "base_obj".toCharArray();
    private static final char[] IS_INSTANCE = "isInstance".toCharArray();
    private static final char[] GET_NAME = "getName".toCharArray();
    private static final char[][] ARRAY = CharOperation.splitOn('.', "java.lang.reflect.Array".toCharArray());
    private static final char[] NEW_INSTANCE = "newInstance".toCharArray();
    private static final char[] TO_ARRAY = "toArray".toCharArray();
    private static final char[] ADD_ALL = "addAll".toCharArray();
    private static final char[] ADD = "add".toCharArray();
    private static final char[] SIZE = "size".toCharArray();
    private static final char[] VALUES = "values".toCharArray();
    private static final char[] REMOVE = "remove".toCharArray();
    private static final char[] SUBSTRING = "substring".toCharArray();
    private static final char[] ENDS_WITH = "endsWith".toCharArray();

    public static void createRoleQueryMethods(TypeDeclaration teamDecl) {
        boolean needsAllMethods;
        TypeReference roleArrayTypeRef;
        TypeReference roleTypeRef;
        QualifiedTypeReference wildcardCollectionRef;
        QualifiedTypeReference objectCollectionRef;
        ArrayBinding objectArrayBinding;
        AstGenerator gen;
        long sourceLevel = teamDecl.scope.compilerOptions().sourceLevel;
        AstGenerator gen2 = gen = new AstGenerator(sourceLevel, teamDecl.sourceStart, teamDecl.sourceEnd);
        if (sourceLevel >= 0x310000L) {
            gen2 = new AstGenerator(teamDecl.sourceStart, teamDecl.sourceEnd);
            gen2.shiftPosition();
        }
        BaseTypeBinding booleanBinding = TypeBinding.BOOLEAN;
        ReferenceBinding objectBinding = teamDecl.scope.getJavaLangObject();
        ReferenceBinding classBinding = teamDecl.scope.getJavaLangClass();
        ReferenceBinding stringBinding = teamDecl.scope.getJavaLangString();
        TypeBinding hashMapBinding = teamDecl.scope.getType(WEAK_HASH_MAP, 3);
        try {
            objectArrayBinding = Config.getLookupEnvironment().createArrayType(objectBinding, 1);
        }
        catch (Config.NotConfiguredException e) {
            e.logWarning("Not creating reflective methods");
            return;
        }
        if (sourceLevel >= 0x310000L) {
            objectCollectionRef = gen.parameterizedQualifiedTypeReference(COLLECTION, new TypeBinding[]{objectBinding});
            wildcardCollectionRef = gen.parameterizedQualifiedTypeReference(COLLECTION, new TypeReference[]{new Wildcard(0)});
            roleTypeRef = gen.singleTypeReference(T);
            roleArrayTypeRef = gen.arrayTypeReference(T, 1);
        } else {
            objectCollectionRef = gen.qualifiedTypeReference(COLLECTION);
            wildcardCollectionRef = gen.qualifiedTypeReference(COLLECTION);
            roleTypeRef = gen.typeReference(objectBinding);
            roleArrayTypeRef = gen.typeReference(objectArrayBinding);
        }
        MethodDeclaration hasRole1 = ReflectionGenerator.findOrGeneratePublicMethod(teamDecl, booleanBinding, HAS_ROLE, new Argument[]{gen.argument(_OT_BASE_ARG, gen.singleTypeReference(objectBinding))}, gen);
        MethodDeclaration hasRole2 = ReflectionGenerator.findOrGeneratePublicMethod(teamDecl, booleanBinding, HAS_ROLE, new Argument[]{gen.argument(_OT_BASE_ARG, gen.singleTypeReference(objectBinding)), gen.argument(CLASS_ARG, gen.qualifiedTypeReference(classBinding.compoundName))}, gen);
        MethodDeclaration getRole1 = ReflectionGenerator.findOrGeneratePublicMethod(teamDecl, objectBinding, GET_ROLE, new Argument[]{gen2.argument(_OT_BASE_ARG, gen.singleTypeReference(objectBinding))}, gen2);
        if (sourceLevel >= 0x310000L) {
            getRole1.annotations = new Annotation[]{gen2.singleStringsMemberAnnotation(TypeConstants.JAVA_LANG_SUPPRESSWARNINGS, new char[][]{"all".toCharArray()})};
        }
        MethodDeclaration getRole2 = ReflectionGenerator.findOrGeneratePublicMethod(teamDecl, roleTypeRef, GET_ROLE, new Argument[]{gen.argument(_OT_BASE_ARG, gen.singleTypeReference(objectBinding)), gen.argument(CLASS_ARG, gen.parameterizedQualifiedTypeReference(classBinding.compoundName, new TypeReference[]{gen.singleTypeReference(T)}))}, gen);
        if (sourceLevel >= 0x310000L) {
            getRole2.typeParameters = new TypeParameter[]{gen.unboundedTypeParameter(T)};
        }
        MethodDeclaration getARoles1 = ReflectionGenerator.findOrGeneratePublicMethod(teamDecl, objectArrayBinding, GET_ALL_ROLES, null, gen);
        MethodDeclaration getARoles2 = ReflectionGenerator.findOrGeneratePublicMethod(teamDecl, roleArrayTypeRef, GET_ALL_ROLES, new Argument[]{gen.argument(CLASS_ARG, gen.parameterizedQualifiedTypeReference(classBinding.compoundName, new TypeReference[]{gen.singleTypeReference(T)}))}, gen);
        if (sourceLevel >= 0x310000L) {
            getARoles2.typeParameters = new TypeParameter[]{gen.unboundedTypeParameter(T)};
        }
        MethodDeclaration unregRole1 = ReflectionGenerator.findOrGeneratePublicMethod(teamDecl, TypeBinding.VOID, UNREGISTER_ROLE, new Argument[]{gen.argument(_OT_ROLE_ARG, gen.singleTypeReference(objectBinding))}, gen2);
        if (sourceLevel >= 0x310000L) {
            unregRole1.annotations = new Annotation[]{gen2.singleStringsMemberAnnotation(TypeConstants.JAVA_LANG_SUPPRESSWARNINGS, new char[][]{"all".toCharArray()})};
        }
        MethodDeclaration unregRole2 = ReflectionGenerator.findOrGeneratePublicMethod(teamDecl, TypeBinding.VOID, UNREGISTER_ROLE, new Argument[]{gen.argument(_OT_ROLE_ARG, gen.singleTypeReference(objectBinding)), gen.argument(CLASS_ARG, gen.qualifiedTypeReference(classBinding.compoundName))}, gen);
        RoleModel[] roles = teamDecl.getTeamModel().getRoles(false);
        int h1 = 0;
        int g1 = 0;
        int ga = 0;
        int g2 = 0;
        int m2 = 0;
        int u1 = 0;
        int u2 = 0;
        Statement[] hasStats1 = new Statement[roles.length];
        Statement[] hasStats2 = new Statement[roles.length];
        Statement[] getStats1 = new Statement[roles.length + 2];
        Statement[] getStats2 = new Statement[roles.length];
        Statement[] getAStats1 = new Statement[roles.length + 1];
        Statement[] getAStats2 = new Statement[roles.length + 2];
        Statement[] unregStats1 = new Statement[roles.length + 3];
        Statement[] unregStats2 = new Statement[roles.length];
        getStats1[g1++] = gen.localVariable(FIRST_RESULT, objectBinding, (Expression)gen.nullLiteral());
        getStats1[g1++] = gen.localVariable(FIRST_NAME, stringBinding, (Expression)gen.nullLiteral());
        getAStats1[ga++] = gen.localVariable(FIRST_RESULT, objectCollectionRef, ReflectionGenerator.createMTList(gen, objectBinding));
        getAStats2[g2++] = gen.localVariable(VALUES, wildcardCollectionRef, (Expression)gen.nullLiteral());
        unregStats1[u1++] = gen2.localVariable(FIRST_NAME, stringBinding, (Expression)gen2.nullLiteral());
        unregStats1[u1++] = gen2.localVariable(FIRST_CACHE, hashMapBinding.erasure(), (Expression)gen2.nullLiteral());
        unregStats1[u1++] = gen2.localVariable(FOUND_BASE, objectBinding, (Expression)gen2.nullLiteral());
        HashSet<String> processedCaches = new HashSet<String>();
        int i = 0;
        while (i < roles.length) {
            char[] cacheName;
            RoleModel boundRootRole;
            if (!(roles[i].isSynthInterface() || TypeAnalyzer.isTopConfined(roles[i].getBinding()) || roles[i].isIgnoreFurtherInvestigation() || (boundRootRole = roles[i].getBoundRootRole()) != null && boundRootRole.isIgnoreFurtherInvestigation() || (cacheName = LiftingEnvironment.getCacheName(boundRootRole)) == null)) {
                String cacheString = new String(cacheName);
                ReferenceBinding roleType = roles[i].getInterfacePartBinding();
                if (!processedCaches.contains(cacheString)) {
                    processedCaches.add(cacheString);
                    hasStats1[h1++] = ReflectionGenerator.createIfContainsTrue(cacheName, gen);
                    getStats1[g1++] = ReflectionGenerator.createIfContainsGet(cacheName, gen2, g1 == 3);
                    getAStats1[ga++] = ReflectionGenerator.createAddAll(cacheName, gen);
                    unregStats1[u1++] = ReflectionGenerator.createRememberIfContains(roleType, cacheName, gen2, u1 == 4);
                }
                hasStats2[m2] = ReflectionGenerator.createIfTypeEqualAndContains(roleType, cacheName, gen, objectBinding);
                getStats2[m2++] = ReflectionGenerator.createIfTypeEqualAndGet(roleType, cacheName, gen);
                getAStats2[g2++] = ReflectionGenerator.createIfTypeEqualFetchValues(roleType, cacheName, gen);
                unregStats2[u2++] = ReflectionGenerator.createRemove(roleType, cacheName, gen);
            }
            ++i;
        }
        getAStats2[g2++] = g2 > 1 ? ReflectionGenerator.createFilterValues(gen) : ReflectionGenerator.createThrowNoSuchRole(gen);
        boolean bl = needsAllMethods = !TypeAnalyzer.isOrgObjectteamsTeam(teamDecl.binding) && !teamDecl.binding.superclass().isTeam();
        if (h1 > 0 || needsAllMethods) {
            Statement[] statementArray = hasStats1;
            hasStats1 = new Statement[h1 + 1];
            System.arraycopy(statementArray, 0, hasStats1, 0, h1);
            Statement[] statementArray2 = getStats1;
            getStats1 = new Statement[g1 + 1];
            System.arraycopy(statementArray2, 0, getStats1, 0, g1);
            Statement[] statementArray3 = getAStats1;
            getAStats1 = new Statement[ga + 1];
            System.arraycopy(statementArray3, 0, getAStats1, 0, ga);
            Statement[] statementArray4 = unregStats1;
            unregStats1 = new Statement[u1 > 3 ? u1 + 1 : u1];
            System.arraycopy(statementArray4, 0, unregStats1, 0, u1);
            hasStats1[h1] = gen.returnStatement(gen.booleanLiteral(false));
            getStats1[g1] = gen.returnStatement(gen.singleNameReference(FIRST_RESULT));
            getAStats1[ga] = gen.returnStatement(gen.messageSend(gen.singleNameReference(FIRST_RESULT), TO_ARRAY, null));
            if (u1 > 3) {
                unregStats1[u1] = ReflectionGenerator.createRemoveIfFound(gen2);
            }
            hasRole1.setStatements(hasStats1);
            getRole1.setStatements(getStats1);
            getARoles1.setStatements(getAStats1);
            unregRole1.setStatements(unregStats1);
            ReflectionGenerator.checkedAddMethod(teamDecl, hasRole1);
            ReflectionGenerator.checkedAddMethod(teamDecl, getRole1);
            ReflectionGenerator.checkedAddMethod(teamDecl, getARoles1);
            ReflectionGenerator.checkedAddMethod(teamDecl, unregRole1);
        }
        if (m2 > 0 || needsAllMethods) {
            Statement[] statementArray = hasStats2;
            hasStats2 = new Statement[m2 + 1];
            System.arraycopy(statementArray, 0, hasStats2, 0, m2);
            Statement[] statementArray5 = getStats2;
            getStats2 = new Statement[m2 + 1];
            System.arraycopy(statementArray5, 0, getStats2, 0, m2);
            Statement[] statementArray6 = unregStats2;
            unregStats2 = new Statement[u2 + 1];
            System.arraycopy(statementArray6, 0, unregStats2, 0, u2);
            hasStats2[m2] = ReflectionGenerator.createThrowNoSuchRole(gen);
            getStats2[m2] = ReflectionGenerator.createThrowNoSuchRole(gen);
            unregStats2[u2] = ReflectionGenerator.createThrowNoSuchRole(gen);
            hasRole2.setStatements(hasStats2);
            getRole2.setStatements(getStats2);
            unregRole2.setStatements(unregStats2);
            ReflectionGenerator.checkedAddMethod(teamDecl, hasRole2);
            ReflectionGenerator.checkedAddMethod(teamDecl, getRole2);
            ReflectionGenerator.checkedAddMethod(teamDecl, unregRole2);
        }
        if (g2 > 2 || needsAllMethods) {
            Statement[] statementArray = getAStats2;
            getAStats2 = new Statement[g2];
            System.arraycopy(statementArray, 0, getAStats2, 0, g2);
            getARoles2.setStatements(getAStats2);
            ReflectionGenerator.checkedAddMethod(teamDecl, getARoles2);
        }
    }

    private static Expression createMTList(AstGenerator gen, TypeBinding elemBinding) {
        return gen.allocation(gen.sourceLevel >= 0x310000L ? gen.parameterizedQualifiedTypeReference(ARRAY_LIST, new TypeBinding[]{elemBinding}) : gen.qualifiedTypeReference(ARRAY_LIST), null);
    }

    private static Statement createIfContainsTrue(char[] cacheName, AstGenerator gen) {
        return gen.ifStatement(gen.messageSend(gen.fieldReference(gen.thisReference(), cacheName), CONTAINS_KEY, new Expression[]{gen.singleNameReference(_OT_BASE_ARG)}), gen.block(new Statement[]{gen.returnStatement(gen.booleanLiteral(true))}));
    }

    private static Statement createAddAll(char[] cacheName, AstGenerator gen) {
        return gen.messageSend(gen.singleNameReference(FIRST_RESULT), ADD_ALL, new Expression[]{gen.messageSend(gen.fieldReference(gen.thisReference(), cacheName), VALUES, null)});
    }

    private static Statement createIfContainsGet(char[] cacheName, AstGenerator gen, boolean isFirstStat) {
        Block innerThen = gen.block(new Statement[]{gen.assignment(gen.singleNameReference(FIRST_RESULT), gen.messageSend(gen.fieldReference(gen.thisReference(), cacheName), GET, new Expression[]{gen.singleNameReference(_OT_BASE_ARG)})), gen.assignment(gen.singleNameReference(FIRST_NAME), gen.stringLiteral(cacheName))});
        return gen.ifStatement(gen.messageSend(gen.fieldReference(gen.thisReference(), cacheName), CONTAINS_KEY, new Expression[]{gen.singleNameReference(_OT_BASE_ARG)}), isFirstStat ? innerThen : gen.block(new Statement[]{gen.ifStatement((Expression)new EqualExpression(gen.singleNameReference(FIRST_RESULT), gen.nullLiteral(), 18), innerThen, gen.block(new Statement[]{ReflectionGenerator.createThrowDuplicate(cacheName, gen)}))}));
    }

    private static Statement createRememberIfContains(ReferenceBinding roleType, char[] cacheName, AstGenerator gen, boolean isFirstStat) {
        Block innerThen = gen.block(new Statement[]{gen.assignment(gen.singleNameReference(FIRST_CACHE), gen.fieldReference(gen.thisReference(), cacheName)), gen.assignment(gen.singleNameReference(FIRST_NAME), gen.stringLiteral(cacheName))});
        return gen.ifStatement(gen.instanceOfExpression(gen.singleNameReference(_OT_ROLE_ARG), gen.typeReference(roleType)), gen.block(new Statement[]{gen.assignment(gen.singleNameReference(FOUND_BASE), gen.messageSend(gen.castExpression(gen.singleNameReference(_OT_ROLE_ARG), gen.singleTypeReference(roleType), 2), _OT_GETBASE, new Expression[0])), gen.ifStatement(gen.messageSend(gen.fieldReference(gen.thisReference(), cacheName), CONTAINS_KEY, new Expression[]{gen.singleNameReference(FOUND_BASE)}), isFirstStat ? innerThen : gen.block(new Statement[]{gen.ifStatement((Expression)new EqualExpression(gen.singleNameReference(FIRST_CACHE), gen.nullLiteral(), 18), innerThen, gen.block(new Statement[]{ReflectionGenerator.createThrowDuplicate(cacheName, gen)}))}))}));
    }

    private static Statement createRemoveIfFound(AstGenerator gen) {
        return gen.ifStatement((Expression)new EqualExpression(gen.singleNameReference(FIRST_CACHE), gen.nullLiteral(), 18), gen.block(null), gen.block(new Statement[]{gen.messageSend(gen.singleNameReference(FIRST_CACHE), REMOVE, new Expression[]{gen.singleNameReference(FOUND_BASE)}), CallinImplementorDyn.DYNAMIC_WEAVING ? gen.messageSend(gen.castExpression(gen.singleNameReference(FOUND_BASE), gen.qualifiedTypeReference(ORG_OBJECTTEAMS_IBOUNDBASE), 2), ADD_REMOVE_ROLE, new Expression[]{gen.singleNameReference(_OT_ROLE_ARG), gen.booleanLiteral(false)}) : gen.messageSend(gen.castExpression(gen.singleNameReference(FOUND_BASE), gen.qualifiedTypeReference(ORG_OBJECTTEAMS_IBOUNDBASE), 2), REMOVE_ROLE, new Expression[]{gen.singleNameReference(_OT_ROLE_ARG)})}));
    }

    private static Statement createIfTypeEqualAndContains(ReferenceBinding roleType, char[] cacheName, AstGenerator gen, TypeBinding objectBinding) {
        return gen.ifStatement(new EqualExpression(gen.singleNameReference(CLASS_ARG), gen.classLiteralAccess(gen.singleTypeReference(roleType)), 18), gen.block(new Statement[]{gen.ifStatement((Expression)gen.messageSend(gen.messageSend(gen.singleNameReference(CLASS_ARG), GET_NAME, new Expression[0]), ENDS_WITH, new Expression[]{gen.stringLiteral(CharOperation.concat(OT_DELIM_NAME, CharOperation.subarray(cacheName, CACHE_PREFIX.length, -1)))}), gen.block(new Statement[]{gen.returnStatement(gen.messageSend(gen.fieldReference(gen.thisReference(), cacheName), CONTAINS_KEY, new Expression[]{gen.singleNameReference(_OT_BASE_ARG)}))}), gen.block(new Statement[]{gen.returnStatement(gen.messageSend(gen.singleNameReference(CLASS_ARG), IS_INSTANCE, new Expression[]{gen.messageSend(gen.fieldReference(gen.thisReference(), cacheName), GET, new Expression[]{gen.singleNameReference(_OT_BASE_ARG)}, objectBinding)}))}))}));
    }

    private static Statement createIfTypeEqualAndGet(ReferenceBinding roleType, char[] cacheName, AstGenerator gen) {
        Expression messageSendGet = gen.messageSend(gen.fieldReference(gen.thisReference(), cacheName), GET, new Expression[]{gen.singleNameReference(_OT_BASE_ARG)});
        if (gen.sourceLevel >= 0x310000L) {
            messageSendGet = gen.castExpression(messageSendGet, gen.singleNameReference(T), 2);
        }
        return gen.ifStatement(new EqualExpression(gen.singleNameReference(CLASS_ARG), gen.classLiteralAccess(gen.singleTypeReference(roleType)), 18), gen.block(new Statement[]{gen.returnStatement(messageSendGet)}));
    }

    private static Statement createIfTypeEqualFetchValues(ReferenceBinding roleType, char[] cacheName, AstGenerator gen) {
        return gen.ifStatement(new EqualExpression(gen.castExpression(gen.singleNameReference(CLASS_ARG), gen.singleNameReference(OBJECT), 2), gen.castExpression(gen.classLiteralAccess(gen.singleTypeReference(roleType)), gen.singleNameReference(OBJECT), 2), 18), gen.block(new Statement[]{gen.assignment(gen.singleNameReference(VALUES), gen.messageSend(gen.fieldReference(gen.thisReference(), cacheName), VALUES, null))}));
    }

    private static Statement createFilterValues(AstGenerator gen) {
        QualifiedTypeReference arrayList = gen.parameterizedQualifiedTypeReference(ARRAY_LIST, new TypeReference[]{gen.singleTypeReference(OBJECT)});
        char[] loopVariable = "o".toCharArray();
        return gen.block(new Statement[]{gen.ifStatement(gen.nullCheck(gen.singleNameReference(VALUES)), ReflectionGenerator.createThrowNoSuchRole(gen)), gen.localVariable(RESULT, arrayList, (Expression)gen.allocation(AstClone.copyTypeReference(arrayList), new Expression[]{gen.messageSend(gen.singleNameReference(VALUES), SIZE, null)})), gen.foreach(gen.localVariable(loopVariable, OBJECT, null), gen.singleNameReference(VALUES), gen.ifStatement(gen.messageSend(gen.singleNameReference(CLASS_ARG), IS_INSTANCE, new Expression[]{gen.singleNameReference(loopVariable)}), gen.messageSend(gen.singleNameReference(RESULT), ADD, new Expression[]{gen.singleNameReference(loopVariable)}))), gen.returnStatement(gen.messageSend(gen.singleNameReference(RESULT), TO_ARRAY, new Expression[]{gen.castExpression(gen.messageSend(gen.qualifiedNameReference(ARRAY), NEW_INSTANCE, new Expression[]{gen.singleNameReference(CLASS_ARG), gen.messageSend(gen.singleNameReference(RESULT), SIZE, null)}), gen.sourceLevel >= 0x310000L ? gen.arrayTypeReference(T, 1) : gen.arrayTypeReference(OBJECT, 1), 2)}))});
    }

    private static Statement createRemove(ReferenceBinding roleType, char[] cacheName, AstGenerator gen) {
        return gen.ifStatement(new EqualExpression(gen.singleNameReference(CLASS_ARG), gen.classLiteralAccess(gen.singleTypeReference(roleType)), 18), gen.block(new Statement[]{gen.localVariable(BASE_OBJ, gen.qualifiedTypeReference(ORG_OBJECTTEAMS_IBOUNDBASE), (Expression)gen.messageSend(gen.castExpression(gen.singleNameReference(_OT_ROLE_ARG), gen.singleTypeReference(roleType), 2), _OT_GETBASE, new Expression[0])), gen.messageSend(gen.fieldReference(gen.thisReference(), cacheName), REMOVE, new Expression[]{gen.singleNameReference(BASE_OBJ)}), CallinImplementorDyn.DYNAMIC_WEAVING ? gen.messageSend(gen.castExpression(gen.singleNameReference(BASE_OBJ), gen.qualifiedTypeReference(ORG_OBJECTTEAMS_IBOUNDBASE), 2), ADD_REMOVE_ROLE, new Expression[]{gen.singleNameReference(_OT_ROLE_ARG), gen.booleanLiteral(false)}) : gen.messageSend(gen.castExpression(gen.singleNameReference(BASE_OBJ), gen.qualifiedTypeReference(ORG_OBJECTTEAMS_IBOUNDBASE), 2), REMOVE_ROLE, new Expression[]{gen.singleNameReference(_OT_ROLE_ARG)}), gen.returnStatement(null)}));
    }

    private static Statement createThrowNoSuchRole(AstGenerator gen) {
        return gen.throwStatement(gen.allocation(gen.qualifiedTypeReference(ILLEGAL_ARGUMENT_EXCEPTION), new Expression[]{new BinaryExpression(gen.stringLiteral("No such bound role type in this team: ".toCharArray()), gen.messageSend(gen.singleNameReference(CLASS_ARG), GET_NAME, new Expression[0]), 14)}));
    }

    private static Statement createThrowDuplicate(char[] secondName, AstGenerator gen) {
        return gen.throwStatement(gen.allocation(gen.qualifiedTypeReference(ORG_OBJECTTEAMS_DUPLICATE_ROLE), new Expression[]{gen.messageSend(gen.singleNameReference(FIRST_NAME), SUBSTRING, new Expression[]{gen.intLiteral(CACHE_PREFIX.length)}), gen.stringLiteral(CharOperation.subarray(secondName, CACHE_PREFIX.length, -1))}));
    }

    private static MethodDeclaration findOrGeneratePublicMethod(TypeDeclaration teamDecl, TypeBinding returnType, char[] methodName, Argument[] arguments, AstGenerator gen) {
        MethodDeclaration foundMethod = AstConverter.findAndAdjustCopiedMethod(teamDecl, methodName, arguments);
        if (foundMethod != null) {
            return foundMethod;
        }
        return gen.method(teamDecl.compilationResult, 1, returnType, methodName, arguments);
    }

    private static MethodDeclaration findOrGeneratePublicMethod(TypeDeclaration teamDecl, TypeReference returnType, char[] methodName, Argument[] arguments, AstGenerator gen) {
        MethodDeclaration foundMethod = AstConverter.findAndAdjustCopiedMethod(teamDecl, methodName, arguments);
        if (foundMethod != null) {
            return foundMethod;
        }
        return gen.method(teamDecl.compilationResult, 1, returnType, methodName, arguments);
    }

    private static void checkedAddMethod(TypeDeclaration teamDecl, MethodDeclaration methodDecl) {
        AbstractMethodDeclaration foundMethod = TypeAnalyzer.findMethodDecl(teamDecl, methodDecl.selector, methodDecl.arguments == null ? 0 : methodDecl.arguments.length);
        if (foundMethod == methodDecl) {
            return;
        }
        AstEdit.addGeneratedMethod(teamDecl, methodDecl);
    }

    public static boolean isReflectionMethod(MethodBinding method) {
        int nParams = method.parameters.length;
        if (CharOperation.equals(method.selector, HAS_ROLE)) {
            return nParams == 1 || nParams == 2;
        }
        if (CharOperation.equals(method.selector, GET_ROLE)) {
            return nParams == 1 || nParams == 2;
        }
        if (CharOperation.equals(method.selector, GET_ALL_ROLES)) {
            return nParams == 0 || nParams == 1;
        }
        if (CharOperation.equals(method.selector, UNREGISTER_ROLE)) {
            return nParams == 1 || nParams == 2;
        }
        return false;
    }
}

