/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core;

import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.util.WeakHashSet;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.internal.core.OTTypeMapping;

public class OTModel {
    private static OTModel _singleton;
    private OTTypeMapping _data = new OTTypeMapping();
    private WeakHashSet _unopenedTypes = new WeakHashSet();

    protected OTModel() {
    }

    public static OTModel getSharedInstance() {
        if (_singleton == null) {
            _singleton = new OTModel();
        }
        return _singleton;
    }

    public static void dispose() {
        _singleton = null;
    }

    public void addUnopenedType(IType type) {
        this._unopenedTypes.add(type);
    }

    public void addOTElement(IOTType otType) {
        if (otType != null) {
            this._data.put((IType)otType.getCorrespondingJavaElement(), otType);
        }
    }

    public boolean hasOTElementFor(IType type) {
        return this._data.contains(type);
    }

    public IOTType getOTElement(IType type) {
        IOTType result = this._data.get(type);
        if (result != null) {
            return result;
        }
        if (type != null && type.isBinary() && this._unopenedTypes.contains(type)) {
            this._unopenedTypes.remove(type);
            try {
                return OTModelManager.getSharedInstance().addType(type, type.getFlags(), null, null, false);
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    public void removeOTElement(IType type, boolean hasChanged) {
        if (type != null && this._data.contains(type)) {
            if (hasChanged) {
                this._data.removeChangedElement(type);
            } else {
                this._data.remove(type);
            }
        }
    }
}

