/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.util;

import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.TypeParameterElementInfo;
import org.eclipse.objectteams.otdt.core.IMethodSpec;

public class MethodData
implements IMethodSpec {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private String selector;
    private String[] argumentsTypes;
    private String[] argumentsNames;
    private String returnType;
    static final ITypeParameter[] NO_TYPE_PARAMETERS = new ITypeParameter[0];
    public ITypeParameter[] typeParameters = NO_TYPE_PARAMETERS;
    private boolean isDeclaration = false;
    private boolean covariantReturn = false;
    private int sourceStart;
    private int sourceEnd;

    public MethodData(String selector, String[] types, String[] names, String returnType, boolean isDeclaration) {
        this.selector = selector;
        if (this.selector == null) {
            this.selector = "";
        }
        this.argumentsTypes = types;
        this.argumentsNames = names;
        this.returnType = returnType;
        assert (types != null) : "Long method spec must have types";
        if (names == null) {
            this.argumentsNames = EMPTY_STRING_ARRAY;
        }
        this.isDeclaration = isDeclaration;
    }

    public MethodData(String selector, String[] types, String[] names, String returnType, boolean isDeclaration, boolean covariantReturn) {
        this(selector, types, names, returnType, isDeclaration);
        this.covariantReturn = covariantReturn;
    }

    public MethodData(String selector, boolean isDeclaration) {
        this.selector = selector;
        this.returnType = null;
        this.argumentsTypes = EMPTY_STRING_ARRAY;
        this.argumentsNames = EMPTY_STRING_ARRAY;
        this.isDeclaration = isDeclaration;
    }

    public MethodData(String selector, String signature) {
        signature = signature.replace('/', '.');
        this.selector = selector;
        this.argumentsTypes = Signature.getParameterTypes(signature);
        this.returnType = Signature.getReturnType(signature);
        this.argumentsNames = EMPTY_STRING_ARRAY;
    }

    public MethodData(String selector, String signature, boolean covariantReturn) {
        this(selector, signature);
        this.covariantReturn = covariantReturn;
    }

    public boolean hasSignature() {
        return this.argumentsTypes != EMPTY_STRING_ARRAY;
    }

    public String[] getArgumentTypes() {
        return this.argumentsTypes;
    }

    public String[] getArgumentNames() {
        return this.argumentsNames;
    }

    public String getSelector() {
        return this.selector;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getSignature() {
        return Signature.createMethodSignature(this.argumentsTypes, this.returnType);
    }

    public boolean isDeclaration() {
        return this.isDeclaration;
    }

    public boolean hasCovariantReturn() {
        return this.covariantReturn;
    }

    public char[][][] getTypeParameterBounds() {
        int length = this.typeParameters.length;
        char[][][] typeParameterBounds = new char[length][][];
        int i = 0;
        while (i < length) {
            try {
                TypeParameterElementInfo info = (TypeParameterElementInfo)((JavaElement)((Object)this.typeParameters[i])).getElementInfo();
                typeParameterBounds[i] = info.bounds;
            }
            catch (JavaModelException javaModelException) {}
            ++i;
        }
        return typeParameterBounds;
    }

    public char[][] getTypeParameterNames() {
        int length = this.typeParameters.length;
        if (length == 0) {
            return CharOperation.NO_CHAR_CHAR;
        }
        char[][] typeParameterNames = new char[length][];
        int i = 0;
        while (i < length) {
            typeParameterNames[i] = this.typeParameters[i].getElementName().toCharArray();
            ++i;
        }
        return typeParameterNames;
    }

    public String toString() {
        String signature = String.valueOf(this.selector) + "(";
        if (this.argumentsTypes != null) {
            int idx = 0;
            while (idx < this.argumentsTypes.length) {
                signature = String.valueOf(signature) + (idx == 0 ? "" : ", ") + Signature.getSimpleName(Signature.toString(this.argumentsTypes[idx]));
                ++idx;
            }
        }
        signature = String.valueOf(signature) + ")";
        return signature;
    }

    public int getSourceStart() {
        return this.sourceStart;
    }

    public int getSourceEnd() {
        return this.sourceEnd;
    }
}

