/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core;

import java.util.LinkedList;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.objectteams.otdt.core.ICallinMapping;
import org.eclipse.objectteams.otdt.core.IMethodSpec;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.IRoleType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.core.TypeHelper;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.MethodMapping;
import org.eclipse.objectteams.otdt.internal.core.OTJavaElement;
import org.eclipse.objectteams.otdt.internal.core.ResolvedCallinMapping;
import org.eclipse.objectteams.otdt.internal.core.util.MethodData;

public class CallinMapping
extends MethodMapping
implements ICallinMapping {
    private int _callinKind;
    private MethodData[] _baseMethodHandles;
    private String _name;

    public CallinMapping(int declarationSourceStart, int sourceStart, int sourceEnd, int declarationSourceEnd, IRoleType parent, IMethod corrJavaMeth, char[] name, int callinKind, MethodData roleMethodHandle, MethodData[] baseMethodHandles, boolean hasSignature) {
        this(declarationSourceStart, sourceStart, sourceEnd, declarationSourceEnd, parent, corrJavaMeth, name, callinKind, roleMethodHandle, baseMethodHandles, hasSignature, true);
    }

    protected CallinMapping(int declarationSourceStart, int sourceStart, int sourceEnd, int declarationSourceEnd, IRoleType parent, IMethod corrJavaMeth, char[] name, int callinKind, MethodData roleMethodHandle, MethodData[] baseMethodHandles, boolean hasSignature, boolean addAsChild) {
        super(declarationSourceStart, sourceStart, sourceEnd, declarationSourceEnd, 102, corrJavaMeth, parent, roleMethodHandle, hasSignature, addAsChild);
        this._name = new String(name);
        this._callinKind = callinKind;
        this._baseMethodHandles = baseMethodHandles;
    }

    protected void getNameForHandle(StringBuffer buff) {
        JavaElement.escapeMementoName(buff, this._name);
        buff.append('`');
    }

    protected char getMappingKindChar() {
        switch (this._callinKind) {
            case 2: {
                return 'a';
            }
            case 1: {
                return 'b';
            }
            case 3: {
                return 'r';
            }
        }
        throw new InternalCompilerError("Unexpected callin kind");
    }

    protected void getBaseMethodsForHandle(StringBuffer buff) {
        MethodData[] methodDataArray = this._baseMethodHandles;
        int n = this._baseMethodHandles.length;
        int n2 = 0;
        while (n2 < n) {
            MethodData baseMethod = methodDataArray[n2];
            this.getMethodForHandle(baseMethod, buff);
            ++n2;
        }
    }

    protected String getSourceName() {
        if (this.hasName()) {
            return this._name;
        }
        return super.getSourceName();
    }

    public String getElementName() {
        ITypeParameter[] typeParameters;
        StringBuffer name = new StringBuffer(super.getElementName());
        name.append(" <- ");
        if (this._baseMethodHandles.length > 1) {
            name.append("{");
        }
        int idx = 0;
        while (idx < this._baseMethodHandles.length) {
            if (idx != 0) {
                name.append(",");
            }
            if (this.hasSignature()) {
                name.append(this._baseMethodHandles[idx].toString());
            } else {
                name.append(this._baseMethodHandles[idx].getSelector());
            }
            ++idx;
        }
        if (this._baseMethodHandles.length > 1) {
            name.append("}");
        }
        if ((typeParameters = this.getRoleMethodHandle().typeParameters).length > 0) {
            name.append(" <");
            int i = 0;
            while (i < typeParameters.length) {
                name.append(typeParameters[i].getElementName());
                if (i + 1 < typeParameters.length) {
                    name.append(", ");
                }
                ++i;
            }
            name.append(">");
        }
        return name.toString();
    }

    public boolean hasName() {
        return this._name != null && !this._name.startsWith("<");
    }

    public String getName() {
        return this._name;
    }

    public int getMappingKind() {
        return 102;
    }

    public int getCallinKind() {
        return this._callinKind;
    }

    public boolean hasCovariantReturn() {
        if (this._baseMethodHandles != null) {
            MethodData[] methodDataArray = this._baseMethodHandles;
            int n = this._baseMethodHandles.length;
            int n2 = 0;
            while (n2 < n) {
                MethodData baseMethod = methodDataArray[n2];
                if (baseMethod.hasCovariantReturn()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public IMethod[] getBoundBaseMethods() throws JavaModelException {
        return this.findBaseMethods();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CallinMapping)) {
            return false;
        }
        CallinMapping other = (CallinMapping)obj;
        if (this._name.charAt(0) != '<' && other._name.charAt(0) != '<' && !this._name.equals(other._name)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this._name.equals(other._name)) {
            return true;
        }
        return this._callinKind == other._callinKind;
    }

    public String toString() {
        return "callin " + super.toString();
    }

    private IMethod[] findBaseMethods() throws JavaModelException {
        IOTType otType;
        IType baseClass = ((IRoleType)this.getParent()).getBaseClass();
        IType[] typeParents = TypeHelper.getSuperTypes(baseClass);
        if (OTModelManager.hasOTElementFor(baseClass) && (otType = OTModelManager.getOTElement(baseClass)).isRole()) {
            IType[] implicitSupers = TypeHelper.getImplicitSuperTypes((IRoleType)otType);
            int len1 = typeParents.length;
            int len2 = implicitSupers.length;
            IType[] iTypeArray = typeParents;
            typeParents = new IType[len1 + len2];
            System.arraycopy(iTypeArray, 0, typeParents, 0, len1);
            System.arraycopy(implicitSupers, 0, typeParents, len1, len2);
        }
        LinkedList<IMethod> baseMethods = new LinkedList<IMethod>();
        int idx = 0;
        while (idx < this._baseMethodHandles.length) {
            IMethod baseMethod = this.findMethod(typeParents, this._baseMethodHandles[idx]);
            if (baseMethod != null) {
                baseMethods.add(baseMethod);
            }
            ++idx;
        }
        return baseMethods.toArray(new IMethod[baseMethods.size()]);
    }

    public IMethodSpec[] getBaseMethodHandles() {
        return this._baseMethodHandles;
    }

    public static int convertModelToTerminalToken(int icallinmappingKind) {
        switch (icallinmappingKind) {
            case 1: {
                return 122;
            }
            case 2: {
                return 119;
            }
        }
        return 121;
    }

    public static int convertTerminalTokenToModel(int terminalTokensCallinKind) {
        switch (terminalTokensCallinKind) {
            case 122: {
                return 1;
            }
            case 119: {
                return 2;
            }
        }
        return 3;
    }

    public OTJavaElement resolved(char[] uniqueKey) {
        ResolvedCallinMapping resolvedHandle = new ResolvedCallinMapping(this.getDeclarationSourceStart(), this.getSourceStart(), this.getSourceEnd(), this.getDeclarationSourceEnd(), (IRoleType)this.getParent(), this.getIMethod(), this._name.toCharArray(), this._callinKind, this.getRoleMethodHandle(), this._baseMethodHandles, this.hasSignature(), new String(uniqueKey));
        return resolvedHandle;
    }
}

