/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.lifting;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.EqualExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.StateMemento;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.Lifting;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.RoleHierarchieAnalyzer;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.TreeNode;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.SourcePosition;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.StepOverSourcePosition;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.ReflectionGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.RoleMigrationImplementor;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.SerializationGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.StandardElementGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.TeamMethodGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstConverter;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstEdit;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.Protections;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class LiftingEnvironment {
    private ProblemReporter _problemReporter;
    private TypeDeclaration _teamType;
    private TreeNode[] _roles;
    private TreeNode[] _boundRootRoles;
    private HashMap<RoleModel, RoleModel[]> _caseObjects = new HashMap();

    public LiftingEnvironment(TypeDeclaration teamType) {
        this.init(teamType);
    }

    public void init(TypeDeclaration teamType) {
        this._problemReporter = teamType.scope.problemReporter();
        this._teamType = teamType;
        this._roles = this.getRoles();
        this.connectHierarchy(this._roles);
        this._boundRootRoles = LiftingEnvironment.filterBoundRootNodes(this._roles);
    }

    public void createRoleBaseLinkage(RoleModel lateRole, boolean needMethodBodies) {
        if (lateRole != null && lateRole.isSynthInterface()) {
            return;
        }
        TreeNode[] boundRoles = this.getBoundRoles();
        if (boundRoles == null || boundRoles.length == 0) {
            return;
        }
        Lifting lifting = new Lifting();
        int i = 0;
        while (i < boundRoles.length) {
            TreeNode currentNode = boundRoles[i];
            RoleModel currentRole = currentNode.getTreeObject();
            if (lateRole == null || currentRole == lateRole) {
                this._caseObjects.put(currentRole, this.createOneRoleBaseLinkage(lifting, currentNode, needMethodBodies));
                if (lateRole != null) {
                    return;
                }
            }
            ++i;
        }
        if (lateRole != null && !lateRole.hasBaseclassProblem()) {
            throw new InternalCompilerError("late role not found in boundRoles: " + new String(lateRole.getBinding().internalName()));
        }
    }

    public void createLiftingInfrastructure(RoleModel lateRole, boolean needMethodBodies) {
        TreeNode[] boundRoles = this.getBoundRoles();
        if (boundRoles == null || boundRoles.length == 0) {
            if (lateRole == null && needMethodBodies && !TypeAnalyzer.isOrgObjectteamsTeam(this._teamType.binding) && !Protections.hasClassKindProblem(this._teamType.binding)) {
                ReflectionGenerator.createRoleQueryMethods(this._teamType);
            }
            return;
        }
        if (lateRole == null) {
            TeamMethodGenerator.addFakedTeamRegistrationMethods(this._teamType.binding);
        }
        Lifting lifting = new Lifting();
        int i = 0;
        while (i < boundRoles.length) {
            RoleModel[] cases;
            if ((lateRole == null || boundRoles[i].getTreeObject() == lateRole) && (cases = this._caseObjects.get(boundRoles[i].getTreeObject())) != null) {
                lifting.createLiftToMethod(this._teamType, boundRoles[i], cases);
            }
            ++i;
        }
        TreeNode node = null;
        int i2 = 0;
        while (i2 < boundRoles.length) {
            if (lateRole == boundRoles[i2].getTreeObject()) {
                node = boundRoles[i2];
                break;
            }
            ++i2;
        }
        if (lateRole == null) {
            this.generateRoleCaches(this._teamType);
            if (needMethodBodies && !Protections.hasClassKindProblem(this._teamType.binding)) {
                ReflectionGenerator.createRoleQueryMethods(this._teamType);
            }
        } else if (node != null && node.getTopmostBoundParent(true) == node) {
            LiftingEnvironment.generateRoleCache(this._teamType, lateRole);
        }
    }

    private RoleModel[] createOneRoleBaseLinkage(Lifting lifting, TreeNode node, boolean needMethodBodies) {
        RoleModel[] result = null;
        RoleModel roleModel = node.getTreeObject();
        if (roleModel.hasBaseclassProblem()) {
            return null;
        }
        TypeDeclaration roleType = roleModel.getAst();
        if (roleType != null && roleType.isRoleFile() && roleType.compilationUnit != null) {
            needMethodBodies = roleType.compilationUnit.parseMethodBodies;
        }
        if (roleModel.getBaseTypeBinding() == null && roleType == null) {
            this._problemReporter.staleSubRole(roleModel.getBinding(), roleModel.getBinding().superclass());
        }
        roleModel.getTeamModel().addRoleBaseBindingAttribute(roleModel.getBinding().attributeName(), roleModel.getBaseclassAttributename(false), roleModel.getBaseTypeBinding().isInterface());
        if (needMethodBodies) {
            RoleHierarchieAnalyzer analyzer = new RoleHierarchieAnalyzer(this._teamType, this._problemReporter);
            if (!roleModel.getBinding().isHierarchyInconsistent()) {
                result = analyzer.analyze(node);
            }
        }
        if (!roleModel.getBinding().isBinaryBinding()) {
            if (roleType != null && !roleModel.getBinding().isSynthInterface()) {
                StandardElementGenerator.generatePlayedByElements(roleType.getRoleModel(), node.getBoundParent(false));
                lifting.createLiftToConstructorDeclaration(node, needMethodBodies);
                AstEdit.removeDefaultConstructor(roleType);
                RoleMigrationImplementor.checkAddMigrateToBaseMethod(roleType, node);
            }
        } else if (!roleModel.getBinding().isInterface()) {
            LiftingEnvironment.setBoundRootRole(node);
        }
        return result;
    }

    private static void setBoundRootRole(TreeNode roleNode) {
        RoleModel boundRootRoleModel = roleNode.getTopmostBoundParent(true).getTreeObject();
        if (boundRootRoleModel != null) {
            roleNode.getTreeObject()._boundRootRole = boundRootRoleModel;
        }
    }

    public static char[] getCacheName(RoleModel boundRootRole) {
        if (boundRootRole == null) {
            return null;
        }
        return CharOperation.concat(IOTConstants.CACHE_PREFIX, boundRootRole.getBinding().sourceName());
    }

    private void generateRoleCaches(TypeDeclaration teamType) {
        if (this._boundRootRoles == null || this._boundRootRoles.length == 0) {
            return;
        }
        int i = 0;
        while (i < this._boundRootRoles.length) {
            LiftingEnvironment.generateRoleCache(teamType, this._boundRootRoles[i].getTreeObject());
            ++i;
        }
        LiftingEnvironment.generateInitCaches(teamType);
    }

    private static void generateRoleCache(TypeDeclaration teamDecl, RoleModel boundRootRole) {
        int sEnd;
        int sStart;
        char[] cacheName = LiftingEnvironment.getCacheName(boundRootRole);
        FieldBinding foundField = TypeAnalyzer.findField(teamDecl.binding, cacheName, false, false, 13);
        if (foundField != null) {
            return;
        }
        TypeDeclaration rootAst = boundRootRole.getAst();
        if (rootAst != null) {
            sStart = rootAst.sourceStart;
            sEnd = rootAst.sourceEnd;
        } else {
            sStart = teamDecl.sourceStart;
            sEnd = teamDecl.sourceEnd;
        }
        boolean usingRawType = boundRootRole.getBaseTypeBinding().isParameterizedType();
        AstGenerator gen = new AstGenerator(sStart, sEnd);
        if (usingRawType) {
            gen.shiftPosition();
        }
        QualifiedTypeReference fieldTypeRef = gen.getCacheTypeReference(teamDecl.scope, boundRootRole);
        FieldDeclaration field = gen.field(4225, fieldTypeRef, cacheName, null);
        if (usingRawType) {
            field.annotations = new Annotation[]{gen.singleStringsMemberAnnotation(TypeConstants.JAVA_LANG_SUPPRESSWARNINGS, new char[][]{"rawtypes".toCharArray()})};
        }
        AstEdit.addField(teamDecl, field, true, false);
        teamDecl.getTeamModel().addCache(field);
    }

    private static MethodDeclaration generateInitCaches(TypeDeclaration teamType) {
        MethodDeclaration initMethod = AstConverter.findAndAdjustCopiedMethod(teamType, IOTConstants.OT_INIT_CACHES, null);
        if (initMethod == null) {
            AbstractMethodDeclaration methodIfcPart;
            TypeDeclaration ifcPart;
            AstGenerator gen = new AstGenerator(teamType.sourceStart, teamType.sourceEnd);
            gen.shiftPosition();
            initMethod = gen.method(teamType.compilationResult, 2, TypeBinding.BOOLEAN, IOTConstants.OT_INIT_CACHES, null);
            initMethod.statements = new Statement[0];
            initMethod.annotations = new Annotation[]{gen.singleStringsMemberAnnotation(TypeConstants.JAVA_LANG_SUPPRESSWARNINGS, new char[][]{"all".toCharArray()})};
            AstEdit.addMethod(teamType, initMethod);
            initMethod.modifiers |= 0x8000000;
            if (teamType.isRole() && (ifcPart = teamType.getRoleModel().getInterfaceAst()) != teamType && (methodIfcPart = TypeAnalyzer.findMethodDecl(ifcPart, IOTConstants.OT_INIT_CACHES, 0)) == null) {
                methodIfcPart = AstConverter.genRoleIfcMethod(teamType.enclosingType, initMethod);
                AstEdit.addMethod(ifcPart, methodIfcPart);
            }
            SerializationGenerator.generateRestoreMethods(teamType, gen);
        }
        return initMethod;
    }

    public static void fillGeneratedMethods(TypeDeclaration teamType) {
        LiftingEnvironment.fillInitCaches(teamType, teamType.getTeamModel().caches);
    }

    private static void fillInitCaches(TypeDeclaration teamType, FieldDeclaration[] caches) {
        AbstractMethodDeclaration initMethod = TypeAnalyzer.findMethodDecl(teamType, IOTConstants.OT_INIT_CACHES, 0);
        if (initMethod == null) {
            if (teamType.getTeamModel().caches.length == 0) {
                return;
            }
            initMethod = LiftingEnvironment.generateInitCaches(teamType);
        }
        AstGenerator gen = new AstGenerator(initMethod);
        Statement[] statements = new Statement[caches.length + 1];
        int i = 0;
        while (i < caches.length) {
            TypeReference cacheTypeRef = caches[i].type;
            if (caches[i].type.resolvedType instanceof ParameterizedTypeBinding) {
                ParameterizedTypeBinding oldBinding = (ParameterizedTypeBinding)cacheTypeRef.resolvedType;
                if (oldBinding.arguments.length == 2) {
                    ReferenceBinding roleBinding = (ReferenceBinding)oldBinding.arguments[1];
                    cacheTypeRef = gen.getCacheTypeReference(teamType.scope, roleBinding.roleModel);
                }
            }
            statements[i] = gen.ifStatement(new EqualExpression(gen.singleNameReference(caches[i].name), gen.nullLiteral(), 18), gen.block(new Statement[]{gen.assignment(gen.singleNameReference(caches[i].name), gen.allocation(cacheTypeRef, new Expression[0]))}));
            ++i;
        }
        statements[caches.length] = gen.returnStatement(gen.booleanLiteral(true));
        initMethod.setStatements(statements);
        SerializationGenerator.fillRestoreRole(teamType, caches);
        SourcePosition savePos = gen.getSourcePosition();
        try {
            gen.setSourcePosition(new StepOverSourcePosition());
            ThisReference thisReference = gen.thisReference();
            thisReference.resolvedType = teamType.binding.getRealClass();
            thisReference.constant = Constant.NotAConstant;
            FieldDeclaration trigger = gen.field(4098, gen.singleTypeReference("boolean".toCharArray()), IOTConstants.CACHE_INIT_TRIGGERER, gen.messageSend(thisReference, IOTConstants.OT_INIT_CACHES, new Expression[0]));
            AstEdit.addField(teamType, trigger, true, false);
            trigger.binding.modifiers |= 0x8000000;
            if (StateMemento.hasMethodResolveStarted(teamType.binding)) {
                initMethod.resolve(teamType.scope);
                trigger.resolve(teamType.initializerScope);
            }
        }
        finally {
            gen.setSourcePosition(savePos);
        }
    }

    private TreeNode[] getBoundRoles() {
        TreeNode[] allRoles = this._roles;
        if (allRoles == null || allRoles.length == 0) {
            return null;
        }
        Vector<TreeNode> boundRoles = new Vector<TreeNode>(0, 1);
        int i = 0;
        while (i < allRoles.length) {
            TreeNode node = allRoles[i];
            RoleModel roleModel = node.getTreeObject();
            if (roleModel.isBound() && !roleModel.hasBaseclassProblem()) {
                boundRoles.add(node);
            }
            ++i;
        }
        if (boundRoles.size() == 0) {
            return null;
        }
        return boundRoles.toArray(new TreeNode[boundRoles.size()]);
    }

    private void connectHierarchy(TreeNode[] roles) {
        TeamModel teamModel = this._teamType.getTeamModel();
        HashSet<ReferenceBinding> baseTypes = new HashSet<ReferenceBinding>();
        int i = 0;
        while (i < roles.length) {
            TreeNode parentNode = roles[i];
            int j = 0;
            while (j < roles.length) {
                if (i != j) {
                    TreeNode childNode = roles[j];
                    if (parentNode.getTreeObject().isSuperTypeOf(childNode.getTreeObject())) {
                        parentNode.add(childNode);
                        teamModel.addBoundClassLink(childNode.getTreeObject().getBinding(), parentNode.getTreeObject().getBinding());
                    }
                }
                ++j;
            }
            ReferenceBinding parentBase = parentNode.getTreeObject().getBaseTypeBinding();
            if (parentBase != null) {
                baseTypes.add(parentBase);
            }
            ++i;
        }
        block2: for (ReferenceBinding childBase : baseTypes) {
            ReferenceBinding currentBase = childBase.superclass();
            while (currentBase != null) {
                if (baseTypes.contains(currentBase)) {
                    teamModel.addBoundClassLink(childBase, currentBase);
                    continue block2;
                }
                currentBase = currentBase.superclass();
            }
        }
    }

    private TreeNode[] getRoles() {
        ReferenceBinding[] roles = this._teamType.binding.memberTypes;
        TreeNode[] treeNodes = new TreeNode[roles.length];
        int count = 0;
        int j = 0;
        while (j < roles.length) {
            ReferenceBinding role = roles[j];
            if (!role.isEnum() && !role.roleModel.isSynthInterface()) {
                RoleModel roleModel = role.roleModel;
                TreeNode treeNode = new TreeNode(roleModel);
                treeNodes[count++] = treeNode;
            }
            ++j;
        }
        TreeNode[] treeRoles = new TreeNode[count];
        System.arraycopy(treeNodes, 0, treeRoles, 0, count);
        return treeRoles;
    }

    private static TreeNode[] filterBoundRootNodes(TreeNode[] treeNodes) {
        TreeNode[] liftingTypeTrees = new TreeNode[treeNodes.length];
        int count = 0;
        int i = 0;
        while (i < treeNodes.length) {
            TreeNode node = treeNodes[i];
            if (node.getTreeObject().isBound() && !node.hasBoundParent(true) && !node.getTreeObject().hasBaseclassProblem()) {
                liftingTypeTrees[count++] = node;
            }
            ++i;
        }
        TreeNode[] rootNodeTrees = new TreeNode[count];
        System.arraycopy(liftingTypeTrees, 0, rootNodeTrees, 0, count);
        return rootNodeTrees;
    }

    public String toString() {
        String str = "";
        if (this._boundRootRoles == null) {
            return str;
        }
        str = String.valueOf(str) + "RootRolesHierarchy:\n";
        int i = 0;
        while (i < this._boundRootRoles.length) {
            TreeNode roleNode = this._boundRootRoles[i];
            str = String.valueOf(str) + "RootRole:\n";
            str = String.valueOf(str) + roleNode.toString(1);
            ++i;
        }
        str = String.valueOf(str) + "\n";
        return str;
    }
}

